/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;

public abstract class IteratingFolderReader<T, ItemReader extends IIteratingChemObjectReader>
extends DefaultIteratingChemObjectReader {
    protected File[] files;
    protected int index = -1;
    protected ItemReader reader;

    public IteratingFolderReader(File[] fileArray) {
        this.setFiles(fileArray);
    }

    public IResourceFormat getFormat() {
        return null;
    }

    public void close() throws IOException {
        this.closeItemReader(this.reader);
    }

    protected abstract ItemReader getItemReader(int var1) throws Exception;

    protected void closeItemReader(ItemReader ItemReader) throws IOException {
        if (ItemReader != null) {
            ItemReader.close();
            ItemReader = null;
        }
    }

    public Object next() {
        if (this.reader != null) {
            return this.reader.next();
        }
        return null;
    }

    public boolean hasNext() {
        if (this.files != null && this.files.length > 0) {
            boolean bl;
            if (this.reader != null && (bl = this.reader.hasNext())) {
                return bl;
            }
            while (true) {
                try {
                    do {
                        this.closeItemReader(this.reader);
                        this.reader = this.getNextReader();
                        if (this.reader != null) continue;
                        return false;
                    } while (!this.reader.hasNext());
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    protected ItemReader getNextReader() throws Exception {
        ++this.index;
        if (this.index < this.files.length) {
            return this.getItemReader(this.index);
        }
        return null;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
        this.index = fileArray != null && fileArray.length > 0 ? -1 : -1;
        this.reader = null;
    }

    public String toString() {
        return "Reads set of files";
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public void setReader(InputStream inputStream) throws CDKException {
        throw new CDKException("Not implemented");
    }
}

