/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.SmartsConst;
import java.util.Stack;

public class SmartsLogicalExpression {
    Stack<Integer> operations = new Stack();
    Stack<Boolean> arguments = new Stack();

    public boolean getValue() {
        while (!this.operations.empty()) {
            this.doStackOperation();
        }
        return this.arguments.pop();
    }

    public void addLogOperation(int op) {
        boolean StackHighPriority = true;
        while (!this.operations.empty() && StackHighPriority) {
            StackHighPriority = this.doPriorityOperation(op);
        }
        this.operations.push(new Integer(op));
    }

    public void addArgument(boolean arg) {
        this.arguments.push(new Boolean(arg));
    }

    void doNOT() {
        boolean arg = this.arguments.pop();
        this.arguments.push(new Boolean(!arg));
    }

    void doAND() {
        boolean arg1 = this.arguments.pop();
        boolean arg2 = this.arguments.pop();
        this.arguments.push(new Boolean(arg1 && arg2));
    }

    void doOR() {
        boolean arg1 = this.arguments.pop();
        boolean arg2 = this.arguments.pop();
        this.arguments.push(new Boolean(arg1 || arg2));
    }

    boolean doPriorityOperation(int op) {
        int top = this.operations.peek();
        if (SmartsConst.priority[top][op] < 0) {
            return false;
        }
        this.operations.pop();
        switch (top) {
            case 0: {
                this.doNOT();
                break;
            }
            case 1: 
            case 3: {
                this.doAND();
                break;
            }
            case 2: {
                this.doOR();
            }
        }
        return true;
    }

    void doStackOperation() {
        int top = this.operations.pop();
        switch (top) {
            case 0: {
                this.doNOT();
                break;
            }
            case 1: 
            case 3: {
                this.doAND();
                break;
            }
            case 2: {
                this.doOR();
            }
        }
    }
}

