# -*- coding: utf-8 -*-
#
# Molecule documentation build configuration file, created by
# sphinx-quickstart on Sat Oct 17 16:07:47 2015.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
"""Documentation Configuration."""

import datetime
from typing import List

import molecule

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.coverage",
    "sphinx.ext.doctest",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "notfound.extension",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = [".templates"]

# The suffix of source filenames.
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Molecule"
author = "Red Hat Inc"
copyright = f" {datetime.date.today().year}, {author}"

github_url = "https://github.com"
github_repo_org = "ansible"
github_repo_name = "molecule"
github_repo_slug = f"{github_repo_org}/{github_repo_name}"
github_repo_url = f"{github_url}/{github_repo_slug}"

extlinks = {
    "issue": (f"{github_repo_url}/issues/%s", "#%s"),
    "pr": (f"{github_repo_url}/pull/%s", "PR #%s"),
    "commit": (f"{github_repo_url}/commit/%s", "%s"),
}

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = molecule.__version__
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
today_fmt = "%B %d, %Y"

# List of documents that shouldn't be included in the build.
# unused_docs = []

# List of directories, relative to source directories, that shouldn't be
# searched for source files.
# exclude_dirs = []

# A list of glob-style patterns that should be excluded when looking
# for source files.
# OBSOLETE - removing this - dharmabumstead 2018-02-06
# exclude_patterns = ['modules']

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "ansible"

highlight_language = "YAML+Jinja"

# Substitutions, variables, entities, & shortcuts for text which do not need to link to anything.
# For titles which should be a link, use the intersphinx anchors set at the index, chapter, and section levels, such as  qi_start_:
# |br| is useful for formatting fields inside of tables
# |_| is a nonbreaking space; similarly useful inside of tables
rst_epilog = """
.. |br| raw:: html

   <br>
.. |_| unicode:: 0xA0
    :trim:
"""


# Options for HTML output
# -----------------------

html_theme = "sphinx_ansible_theme"

html_show_sphinx = False
html_favicon = "_static/images/favicon.ico"

html_theme_options = {
    "collapse_navigation": False,
    "analytics_id": "UA-128382387-1",
    "style_nav_header_background": "#5bbdbf",
    "style_external_links": True,
    # 'canonical_url': "https://docs.ansible.com/ansible/latest/",
    "vcs_pageview_mode": "edit",
    "navigation_depth": 3,
    "topbar_links": {
        "AnsibleFest": "https://www.ansible.com/ansiblefest",
        "Products": "https://www.ansible.com/tower",
        "Community": "https://www.ansible.com/community",
        "Webinars & Training": "https://www.ansible.com/webinars-training",
        "Blog": "https://www.ansible.com/blog",
    },
}

html_context = {
    "display_github": "True",
    "github_user": "ansible-community",
    "github_repo": "molecule",
    "github_version": "main/docs/",
    "current_version": version,
    "latest_version": "latest",
    # list specifically out of order to make latest work
    "available_versions": ("latest",),
}

# Add extra CSS styles to the resulting HTML pages
# html_css_files = [
#     'css/color-scheme.css',
# ]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = f"{project} Documentation"

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = "Documentation"

# The name of an image file (within the static path) to place at the top of
# the sidebar.
# html_logo =
# html_logo = "_static/images/logo_big.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_static/images/favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = "%b %d, %Y"

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_use_modindex = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
html_copy_source = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = 'https://docs.ansible.com/ansible/latest'

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = "Poseidodoc"

# Configuration for sphinx-notfound-pages
# with no 'notfound_template' and no 'notfound_context' set,
# the extension builds 404.rst into a location-agnostic 404 page
#
# default is `en` - using this for the sub-site:
notfound_default_language = "ansible"
# default is `latest`:
# setting explicitly - docsite serves up /ansible/latest/404.html
# so keep this set to `latest` even on the `devel` branch
# then no maintenance is needed when we branch a new stable_x.x
notfound_default_version = "latest"
# makes default setting explicit:
notfound_no_urls_prefix = False

autoclass_content = "both"

intersphinx_mapping = {
    "ansible": ("https://docs.ansible.com/ansible/latest/", None),
    "jinja2": ("https://jinja.palletsprojects.com/", None),
    "pip": ("https://pip.pypa.io/en/latest/", None),
    "python": ("https://docs.python.org/3", None),
    "testinfra": ("https://testinfra.readthedocs.io/en/latest/", None),
    "virtualenv": ("https://virtualenv.pypa.io/en/latest/", None),
    "yamllint": ("https://yamllint.readthedocs.io/en/latest/", None),
}
intersphinx_disabled_reftypes: List[str] = []

linkcheck_workers = 25
# linkcheck_anchors = False
