"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmtpCredentialsProvider = void 0;
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
class SmtpCredentialsProvider extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.serviceToken = new cr.Provider(this, 'SmtpCredentialsProvider', {
            onEventHandler: new lambda.Function(this, 'SmtpCredentialsFunction', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../function')),
                runtime: lambda.Runtime.PYTHON_3_8,
                handler: 'handler.on_event',
                initialPolicy: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['iam:CreateAccessKey'],
                        resources: [props.userArn],
                    }),
                ],
            }),
            logRetention: logs.RetentionDays.ONE_DAY,
        }).serviceToken;
    }
}
exports.SmtpCredentialsProvider = SmtpCredentialsProvider;
//# sourceMappingURL=data:application/json;base64,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