"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleAction = exports.RuleActionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "RuleActionProperty", { enumerable: true, get: function () { return iot_generated_1.RosRuleAction; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::RuleAction`
 */
class RuleAction extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::RuleAction`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRuleAction = new iot_generated_1.RosRuleAction(this, id, {
            errorActionFlag: props.errorActionFlag,
            type: props.type,
            configuration: props.configuration,
            iotInstanceId: props.iotInstanceId,
            ruleId: props.ruleId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRuleAction;
        this.attrActionId = rosRuleAction.attrActionId;
    }
}
exports.RuleAction = RuleAction;
//# sourceMappingURL=data:application/json;base64,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