# MathCrypto

MathCrypto is a library of useful funtions used in cryptography. Do not use this library for improving the security of your application, it is not safe or powerful enough to provide that.

Available functions include:

- Multiplicative group operations
  - Generate a group from modulus including group elements and generators
  - Get inverse element any element of the group
  - Get element order of any element in group
- Math functions
  - Number primality checks
    - Classic number modulus check
    - Fermat's primality test
  - Euler's Totient function (Phi)
  - Euclidean algorithm (GCD)
  - Simple number factorization
  - Chinese Remainder Theorem
  - Extended Euclidean Algorithm

Functions from this library can be used to solve recreational mathematics, cryptographic and programming problems.

## Installation

MathCrypto is avalaible through Python Package Index ([PyPI](https://pypi.python.org/pypi)) using [pip](https://pip.pypa.io). :

```console
foo@bar:~$ python3 -m pip install --upgrade mathcrypto
```

To uninstall using [pip](https://pip.pypa.io). :

```console
foo@bar:~$ python3 -m pip uninstall mathcrypto
```

## Documentation

You can read the full documentation [here](https://mathcrypto.readthedocs.io/en/latest/).

## Development

Source code repository is available on [GitHub](https://github.com/Czechbol/mathcrypto). Feel free to contribute. [Bug reports](https://github.com/Czechbol/mathcrypto/issues) and suggestions are welcome.

## License

mathcrypto is licensed under the [MIT License](https://github.com/Czechbol/mathcrypto/blob/main/LICENSE).
