<img align="right" src="https://assinews-assinformdalcine.netdna-ssl.com/wp-content/uploads/2017/02/facileit.png" alt="mypy logo" width="180"/>
</br>
<img align="left" src=https://img.shields.io/badge/pylint-9.88-green alt="my_badge" width="80px" />
</br>


# Facile GitLab Helper

This library provides help to microservices inside gitLab C.I pipelines, integrating different repositories within different pipelines and projects.

## Getting Started

Open the terminal and install the given library:

```python
pip install facile-gitlab-trigger
```

Execute the command below to make sure the library has been installed correctly:

```python
facile-trigger --help
```

The list of commands below should be displayed:

```shell
usage: facile-trigger -a GITLAB_API_TOKEN [-h GIT_LAB_HOST] [--help] [-t TARGET_BRANCH] -p PROJECT_ID -b
                      REF_NAME -f YAML_FILE

Gilab trigger helper

optional arguments:
  -a GITLAB_API_TOKEN, --api-token GITLAB_API_TOKEN
                        personal access token (not required when running detached)
  -h GIT_LAB_HOST, --host GIT_LAB_HOST
  --help                show this help message and exit
  -t TARGET_BRANCH, --target-ref TARGET_BRANCH
                        target ref (branch, tag, commit)
  -p PROJECT_ID, --project-id PROJECT_ID
                        repository id found on settings
  -b REF_NAME, --branch-merged REF_NAME
                        filled by git COMMIT_REF_NAME
  -f YAML_FILE, --yaml-file YAML_FILE
                        filled by git COMMIT_REF_NAME
```

## Usage

Running a pipeline with Facile GitLab Helper requires only few steps.
Use the arguments below in order to run a pipeline:

##### Branch Title

This argument can be dynamically filled using gitlab variables, like $CI_COMMIT_TITLE. In this case, Facile GitLab Helper will get the string provided by the given variable and will match it with the running rules lists - which are stored in the .yaml file. So, tests will run a specific path, based on the ID provided in the string. E.g. let's say our variable "$CI_COMMIT_TITLE" contains "PROJECT_NAME", tests will only run the specific path to the project, accordingly with the running rules lists.

##### Project ID

It's the ID shown on gitLab Project Root>>Settings>>Geral.

##### API Key

This can be generated by going on user Profile >> Access Tokens >> Add a personal access token. Use the generated value for this argument.

##### Gitlab Host Domain

Here goes the gitlab domain: "https://gitlab.domain_name/". For example, facile.it domain would be "https://gitlab.facile.it/".

##### Target Branch

This should be the branch we want the tests to run against. It could be "master", "develop" and so on.

##### Create lambdatest tunnel

As capability is also possibile to create tunnel running test against lambdatest cloud, this feature by the default will be always false but once a tunnel is needed to ben run from the trigger just passt to the flag "-u True" then a tunnel will be created and attached to the given automation session

##### Yaml File

This should be the .yaml file (or files) which provides the rules based on the "ID"s:

```yaml
projects:
    paytv:
        project_id: PAYTVCA
        path: Tests/pay_tv_online.robot Tests/pay_tv_tradizionale.robot
        where: desktop
        browser: chrome
        version: "79.0"
        platform: "Windows 10"
    noleggio_mobile_Huawei_Pro: 
        project_id: NOLEGGIOCA
        path: Tests/noleggio_responsive.robot
        where: mobile
        device: "Huawei P20 Pro"
        browser: chrome
        platform: Android
        version: "9"....
```

For instance, if the branch title contains "NTL", test automation will run the test path Tests/noleggio.robot if it contains "ABC", then Tests/abc.robot will run. So, -f should be the path to where you created your .yaml rules file.
Below you can find an example of a full command to run a pipeline:

```shell
facile-trigger -b <branch_title> -p <project_id> -a <api_key> -h <gitlab_host_domain> -t <target_branch> -f <yaml_file>
```

After that terminal will display the project name, status and the pipeline link triggered

```diff
+ projectName is running on https://gitlab.facile.it/qa/new-business-group/nattp/pipelines/164014
```

Once it get failed terminal will display the given pipeline weblink which can be checked for further information as shown bellow:

```diff
- projectName is failed please check on https://gitlab.facile.it/qa/new-business-group/nattp/pipelines/164014
```

##### Running simple static projects

You may also run simple static projects where the capabilities will be specified directly in the gitLab c.i file as shown below:

```yaml
job_with_capabilities:
  <<: *test_robotframework
  variables:
    WHERE: "desktop"
    TestType: "desktop"
    BROWSER: "Chrome"
    VERSION: "83.0"
    TESTS: "test.robot"
    PLATFORM: "Windows 10"
```

This kind of project approach happens when the repository holds single product tests where is not necessary sort of logic behind the scenes which. Running those kind of projects the command is:

```shell
facile-trigger -b <branch_title> -p <project_id> -a <api_key> -h <gitlab_host_domain> -t <target_branch> -k True
```

Above as you can see the flag "-k" was used which means that automation will run "by project" in another words, capabilities will be simply defined in the gitlab.yml file.

##### Env url to run automation

It's also possible to specify the end point where the automation will run as shown below:

```shell
facile-trigger -b <branch_title> -p <project_id> -a <api_key> -h <gitlab_host_domain> -t <target_branch> -f <yaml_file> -u True -e <my_end_point>
```

Notice that to use the URL in the target repository is necessary to use "START_URL" which will be the variable that will receive the url specified in the given commando above.

##### Extra feature tunnel creation

Currently, facile_gitlab_trigger also holds a super nice capability which creates a tunnel for the automation. This capability currently works only on facile.it bundle environment as we use "lambdatest" as test automation device cloud. By the default the given flag is "False" where once the feature is not needed then will be ignored by the library. To leave the trigger create the tunnel for your test just use the flag -u = True as shown below:

```shell
facile-trigger -b <branch_title> -p <project_id> -a <api_key> -h <gitlab_host_domain> -t <target_branch> -f <yaml_file> -u True
```

Remember that this feature do not work for "static" projects where the capabilities are defined in the gitLab yml c.i. In the case the project by itself create its own tunnel to start the test automation.