#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['simpleindex']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['packaging-dists', 'pydantic', 'starlette', 'toml', 'uvicorn']

extras_require = \
{'test': ['mousebender', 'pytest', 'pytest-asyncio', 'pytest-httpx']}

entry_points = \
{'console_scripts': ['simpleindex = simpleindex.__main__:main'],
 'simpleindex.routes': ['http = simpleindex.routes:HTTPRoute',
                        'path = simpleindex.routes:PathRoute']}

setup(name='simpleindex',
      version='0.2.0',
      description='PEP 503 Simple Repository index by declaring routing rules.',
      author='Tzu-ping Chung',
      author_email='uranusjr@gmail.com',
      url='https://github.com/uranusjr/simpleindex',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
