"""
Test of inpoly.py
"""
import pytest as pytest

from pyhaloxml.misc import points_in_polygons


@pytest.fixture
def polygons():
    return [
        [
            (41025.0, 15022.0),
            (41026.0, 15021.0),
            (41033.0, 15021.0),
            (41036.0, 15024.0),
            (41036.0, 15028.0),
            (41030.0, 15034.0),
            (41032.0, 15037.0),
            (41032.0, 15039.0),
            (41031.0, 15040.0),
            (41022.0, 15040.0),
            (41019.0, 15037.0),
            (41021.0, 15034.0),
            (41021.0, 15026.0),
            (41024.0, 15023.0),
            (41025.0, 15022.0),
            (41025.0, 15022.0),
        ],
        [
            (48835.0, 12049.0),
            (48836.0, 12047.0),
            (48845.0, 12047.0),
            (48846.0, 12049.0),
            (48846.0, 12053.0),
            (48847.0, 12054.0),
            (48849.0, 12054.0),
            (48852.0, 12057.0),
            (48850.0, 12059.0),
            (48850.0, 12061.0),
            (48845.0, 12066.0),
            (48843.0, 12066.0),
            (48835.0, 12059.0),
            (48835.0, 12057.0),
            (48833.0, 12055.0),
            (48833.0, 12051.0),
            (48834.0, 12050.0),
            (48835.0, 12049.0),
            (48835.0, 12049.0),
        ],
        [
            (49525.0, 11392.0),
            (49525.0, 11390.0),
            (49526.0, 11389.0),
            (49528.0, 11391.0),
            (49530.0, 11391.0),
            (49540.0, 11400.0),
            (49540.0, 11402.0),
            (49537.0, 11405.0),
            (49533.0, 11405.0),
            (49530.0, 11403.0),
            (49524.0, 11403.0),
            (49522.0, 11405.0),
            (49519.0, 11402.0),
            (49521.0, 11400.0),
            (49521.0, 11396.0),
            (49524.0, 11393.0),
            (49525.0, 11392.0),
            (49525.0, 11392.0),
        ],
        [
            (46925.0, 13006.0),
            (46926.0, 13005.0),
            (46938.0, 13005.0),
            (46941.0, 13008.0),
            (46941.0, 13010.0),
            (46940.0, 13011.0),
            (46938.0, 13011.0),
            (46932.0, 13017.0),
            (46926.0, 13017.0),
            (46922.0, 13013.0),
            (46918.0, 13013.0),
            (46916.0, 13012.0),
            (46916.0, 13010.0),
            (46918.0, 13009.0),
            (46920.0, 13009.0),
            (46922.0, 13007.0),
            (46924.0, 13007.0),
            (46925.0, 13006.0),
            (46925.0, 13006.0),
        ],
    ]


@pytest.fixture
def points():
    return [(41025.0, 15025.0), (41022, 15037.0), (49525.0, 11396.0)]


def test_pointsinpolygons(polygons, points):
    assert points_in_polygons(points, polygons) == [0, 0, 2]
