"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTableAttribute = void 0;
const appscaling = require("@aws-cdk/aws-applicationautoscaling");
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // eslint-disable-next-line max-len
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,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