
# RobotCode - Language Support for Robot Framework in Visual Studio Code

[![VS Marketplace](https://img.shields.io/visual-studio-marketplace/v/d-biehl.robotcode?style=flat&label=VS%20Marketplace&logo=visual-studio-code)](https://marketplace.visualstudio.com/items?itemName=d-biehl.robotcode)
[![Installs](https://img.shields.io/visual-studio-marketplace/i/d-biehl.robotcode?style=flat)](https://marketplace.visualstudio.com/items?itemName=d-biehl.robotcode)
[![Build Status](https://img.shields.io/github/actions/workflow/status/robotcodedev/robotcode/build-test-package-publish.yml?branch=main&style=flat&logo=github)](https://github.com/robotcodedev/robotcode/actions?query=workflow:build_test_package_publish)
[![License](https://img.shields.io/github/license/robotcodedev/robotcode?style=flat&logo=apache)](https://github.com/robotcodedev/robotcode/blob/master/LICENSE)

[![PyPI - Version](https://img.shields.io/pypi/v/robotcode.svg?style=flat)](https://pypi.org/project/robotcode)
[![Python Version](https://img.shields.io/pypi/pyversions/robotcode.svg?style=flat)](https://pypi.org/project/robotcode)
[![Downloads](https://img.shields.io/pypi/dm/robotcode.svg?style=flat&label=downloads)](https://pypi.org/project/robotcode)

---

**RobotCode** is a Visual Studio Code extension that enhances your workflow with [Robot Framework](https://robotframework.org/). It offers features like code completion, debugging, test discovery and execution, refactoring, and more!

## Key Features

- **Code Editing**: Enjoy code auto-completion, navigation, syntax checking, and more.
- **Command Line Tools**: A wide array of tools to assist in setting up and managing Robot Framework environments.
- **Code Formatting**: Format your code using Robot Framework’s built-in tools like `robot.tidy` or [Robotidy](https://robotidy.readthedocs.io/).
- **Test Running and Debugging**: Run and debug Robot Framework test cases directly within VS Code.
- **Multi-root Workspace Support**: Manage multiple Robot Framework projects with different Python environments simultaneously.
- **Code Analysis with Robocop**: Install [Robocop](https://robocop.readthedocs.io/) for additional code analysis.

## Requirements

- Python 3.8 or newer
- Robot Framework 4.1 or newer
- Visual Studio Code 1.86 or newer

## Getting Started

1. Install the [RobotCode extension](https://marketplace.visualstudio.com/items?itemName=d-biehl.robotcode) from the Visual Studio Marketplace.
2. Configure your Robot Framework environment with the command-line tools provided by the extension.
3. Start writing and running your Robot Framework tests!

For a more detailed guide, check out the [Let's get started](https://robotcode.io/02_get_started/) Guide on the [RobotCode](https://robotcode.io) website.

## Extensions

RobotCode automatically installs the [Python](https://marketplace.visualstudio.com/items?itemName=ms-python.python) and the [Python Debugger](https://marketplace.visualstudio.com/items?itemName=ms-python.debugpy) extension. Additional extensions may be required depending on your project needs.

## Documentation

For more details on installation, setup, and usage, refer to the [official RobotCode documentation](https://robotcode.io).

## License

This project is licensed under the [Apache 2.0 License](https://spdx.org/licenses/Apache-2.0.html).
