#!/usr/bin/env python3
# Part of TotalDepth: Petrophysical data processing and presentation.
# Copyright (C) 2011-2021 Paul Ross
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Paul Ross: apaulross@gmail.com
"""
Created on Jan 12, 2012

@author: paulross
"""
import typing

__author__ = 'Paul Ross'
__date__ = '2011-08-03'
__version__ = '0.1.0'
__rights__ = 'Copyright (c) 2012 Paul Ross.'

# Gathered from a set of LAS files:
#    Files:           22,563
#   Errors:               80
# Critical:                1
# Files OK:           22,482
#    Bytes:   34,671,225,513 (33065.1 Mb)

#: Descriptions for each Parameter mnemonic.
PARAMETER_MNEM_DESCRIPTION = {
    b"A": "A",
    b"A1T1": "Stab Counts Temperature Correction Coefficient",
    b"A1T2": "Stab Counts Temperature Correction Coefficient",
    b"A1T3": "Stab Counts Temperature Correction Coefficient",
    b"A2EX": "Hals-B A2 Extended (Groningen Effect)",
    b"ACCC": "Accelerometer Coefficients",
    b"ACCM": "Accelerometer Month Of Calibration",
    b"ACCN": "Accelerometer Serial Number",
    b"ACCT": "Accelerometer Type (Manufacturer Code)",
    b"ACCY": "Y Axis Accelerometer",
    b"ACPP": "Accelerometer Prom Presence",
    b"AD": "Is Hole Air Drilled?",
    b"AECS": "Auto Electronic Calibration Switch",
    b"AFMO": "Accelerometer Filtering Mode",
    b"AFS": "Auto Frequency Switch",
    b"AGOS": "Hals-Gpit Offset",
    b"AMD": "Azimuth Of Maximum Deviation",
    b"AMNS": "Min Ampl 100% Bond",
    b"AMXS": "Max Ampl 0% Bond",
    b"ANML": "Nml 'A'",
    b"APD": "Elevation Of Depth Reference (Lmf) Above Permanent Datum",
    b"API": "Api Number",
    b"APIN": "Api Serial Number",
    b"APN": "Acq Prog Name",
    b"APV": "Acq Prog Vers",
    b"ARCH": "Tlog Constant - 16 - Archie A, Tlog Constant - 17 - Archie M",
    b"ART": "Accelerometer Reference Temperature",
    b"ARTM": "Arrival Time",
    b"ATIM": "Accumtime",
    b"AUTO": "Tlog Constant - 33 - Auto Cali Corr",
    b"AV": "Max Annular Velocity",
    b"AVMX": "Max Ann Veloc",
    b"AZIF": "Azm, Final",
    b"B0FS": "Static B Field Converted From The Larmor Frequency",
    b"BAP": "Gl Elev Onshore",
    b"BARI": "Barite Corr",
    b"BASE": "Equipment Base Location",
    b"BCOK": "Compute Bcas Results?",
    b"BDEP": "Depth Of Before Calibration",
    b"BG": "Gas Formation Volume Factor, Bg",
    b"BHAT": "Bha Type",
    b"BHB1": "Borehole Rec; Bit 1",
    b"BHB2": "Borehole Rec; Bit 2",
    b"BHB3": "Borehole Rec; Bit 3",
    b"BHB4": "Borehole Rec; Bit 4",
    b"BHCC": "Hals Borehole Correction",
    b"BHF": "Borehole Fluid",
    b"BHF1": "Borehole Rec; From 1",
    b"BHF2": "Borehole Rec; From 2",
    b"BHF3": "Borehole Rec; From 3",
    b"BHF4": "Borehole Rec; From 4",
    b"BHFL": "Borehole Fluid Type",
    b"BHIS": "Brief History",
    b"BHO1": "Borehole Rec; To 1",
    b"BHO2": "Borehole Rec; To 2",
    b"BHO3": "Borehole Rec; To 3",
    b"BHO4": "Borehole Rec; To 4",
    b"BHS": "Bore Hole Status",
    b"BHT": "Bottom Hole Temperature",
    b"BHT_": "Tlog Constant - 13 - Bht",
    b"BH_S": "Tlog Constant - 27 - Bh Salinity(Ppm)",
    b"BILI": "Bond Index Level For Zone Isolation",
    b"BISS": "Bond Index Source Selection For Biql",
    b"BIT": "Bit Size",
    b"BIT_": "Tlog Constant - 24 - Bit Size (In)",
    b"BLAB": "Begin Log Date",
    b"BLI": "Bottom Log Interval",
    b"BNML": "Nml 'B'",
    b"BO": "Oil Formation Volume Factor, Bo",
    b"BPP": "Bubble Point Pressure",
    b"BPT": "Bubble Point Temperature",
    b"BREV": "Rev Bit Total",
    b"BRMP": "Bromidepresent",
    b"BROT": "Build Rotating",
    b"BS": "Bit Size",
    b"BS1": "Bit Size",
    b"BS2": "Bit Size2",
    b"BS3": "Bit Size3",
    b"BSAL": "Borehole Salinity",
    b"BSCO": "Borehole Salinity Correction Option",
    b"BSD": "Bit Size Depth 1",
    b"BSD1": "Bit Depth1",
    b"BSD2": "Bit Depth2",
    b"BSD3": "Bit Depth3",
    b"BSDF": "Bit Size Depth From",
    b"BSDP": "Depth Of Bit Size",
    b"BSDT": "Bit Size Depth To",
    b"BSZ": "Bit Size",
    b"BT": "Bit Type",
    b"BTPL": "Bit Press Loss",
    b"BW": "Water Formation Volume Factor, Bw",
    b"CABU": "Customer Abuse",
    b"CADD": "Cement Additives",
    b"CADJ": "Dens Cali Adjustment",
    b"CADT": "Casing Depth To",
    b"CALI": "Caliper",
    b"CASB": "Casing Bottom",
    b"CASD": "Casing Diameter",
    b"CASG": "Casing Grade",
    b"CASL": "Casing Logger",
    b"CASN": "Casing String Number",
    b"CAST": "Casing Thickness",
    b"CASX": "Casing Type",
    b"CB": "Use Calibration Blocks?",
    b"CBD": "Casing - Driller",
    b"CBD1": "Casing-Driller",
    b"CBD2": "Casing Depth2",
    b"CBD3": "Casing Depth3, Csg 3 Drill Dep",
    b"CBDR": "Casing Bottom - Driller",
    b"CBL": "Casing - Logger",
    b"CBL1": "Casing-Logger",
    b"CBLO": "Casing Bottom - Logger",
    b"CBRA": "Cbl Lqc Reference Amplitude In Free Pipe",
    b"CCCO": "Casing & Cement Thickness Correction Option",
    b"CCLO": "Ccl Offset",
    b"CCS": "Cement Cmpr Strength",
    b"CD": "Casing Depth Logger",
    b"CDD": "Casing Depth-Driller",
    b"CDEN": "Cement Density",
    b"CDF": "Calibrated Downhole Force",
    b"CDL": "Casing Depth-Logger",
    b"CDP": "Casing Depth",
    b"CDS": "Casingstartdep",
    b"CDS1": "Casingstartdep1",
    b"CDS2": "Casingstartdep2",
    b"CDS3": "Casingstartdep3",
    b"CDTS": "C-Delta-T Shale",
    b"CEXP": "(Mifa-Nd) Coloration Exponent",
    b"CGEO": "Customer Geo",
    b"CGRD": "Casing Grade",
    b"CI": "Amount Of Chlorides",
    b"CJT": "Cement Job Type",
    b"CL": "Amount Of Chlorides",
    b"CLAB": "County",
    b"CLIM": "Caliper Bad Hole Limit",
    b"CLNT": "Client Code",
    b"CLOK": "Process Caliper Outputs?",
    b"CMCF": "Cbl Cement Type Compensation Factor",
    b"CMT1": "Comment 1",
    b"CMT2": "Comment 2",
    b"CMT3": "Comment 3",
    b"CMT4": "Comment 4",
    b"CN": "Company Name",
    b"CN1": "Company Name Line 1",
    b"CNL_": "Tlog Constant - 64 - Cnl Matrix, Tlog Constant - 68 - Cnl Shale, Tlog Constant - 72 - Cnl Fluid",
    b"COMM": "Run Comments 1",
    b"COMP": "Company",
    b"CONT": "Continent",
    b"COUN": "County",
    b"CS": "Casing Size",
    b"CS1": "Casing Od1",
    b"CS2": "Casing Od2",
    b"CS3": "Casing Od3, Casing Size, Csg 3 Size",
    b"CSBL": "Csb Dip Number Of Levels",
    b"CSD": "Casing Depth",
    b"CSDE": "Casing Density",
    b"CSFN": "Casing Function",
    b"CSGD": "Casing Bottom (Driller)",
    b"CSGL": "Casing Bottom (Logger)",
    b"CSGS": "Casing Size",
    b"CSGT": "Casing Type",
    b"CSGW": "Casing Weight",
    b"CSID": "Casing Inner Diameter",
    b"CSIZ": "Current Casing Size",
    b"CSOD": "Casing Od",
    b"CSS": "Casing Size",
    b"CSUP": "Casing Stick Up Gl",
    b"CSW": "Casing Weight",
    b"CSW1": "Casing Weight1",
    b"CSW2": "Casing Weight2",
    b"CSW3": "Casing Weight3",
    b"CSWT": "Casing Weight",
    b"CTD1": "Casing Driller 1",
    b"CTF1": "Casing & Tubing Rec; From 1",
    b"CTF2": "Casing & Tubing Rec; From 2",
    b"CTF3": "Casing & Tubing Rec; From 3",
    b"CTHI": "Casing Thickness",
    b"CTL1": "Casing Logger 1",
    b"CTO1": "Casing & Tubing Rec; To 1",
    b"CTO2": "Casing & Tubing Rec; To 2",
    b"CTO3": "Casing Depth To",
    b"CTO4": "Casing Depth To",
    b"CTOP": "Estimated Cement Top, Estim. Cement Top",
    b"CTRY": "Country",
    b"CTS1": "Casing & Tubing Rec; Size 1",
    b"CTS2": "Casing & Tubing Rec; Size 2",
    b"CTS3": "Casing & Tubing Rec; Size 3",
    b"CV": "Max Critical Velocity",
    b"CVEL": "Cable Velocity",
    b"CVEY": "Conveyance",
    b"CVMX": "Max Crit Veloc",
    b"CW": "Casing Weight",
    b"CW1": "Casing Weight",
    b"CWE1": "Casing Weight",
    b"CWEI": "Casing Weight",
    b"CWLO": "Cement Water Loss",
    b"CWT": "Casing Weight",
    b"CWT1": "Casing Weight",
    b"CWT2": "Casing Weight",
    b"CWT3": "Casing Weight",
    b"CWT4": "Casing Weight",
    b"D/W": "Drill Or Wipe",
    b"DAPD": "Feet Above Permanent Datum",
    b"DAQ": "Daq Signature",
    b"DATE": "Log Date",
    b"DAY": "Day",
    b"DCE": "Datecircendt",
    b"DCOM": "Drilling Company",
    b"DCS": "Datecircendt",
    b"DD": "Depth Driller",
    b"DD1": "Direct Drillr 1",
    b"DD2": "Direct Drillr 2",
    b"DD3": "Direct Drillr 3",
    b"DDFL": "Uphole Stacking",
    b"DDLG": "Digital Telemetry Module Downlink Gain",
    b"DDLS": "Digital Telemetry Module Downlink Shape",
    b"DDPL": "(Mrpq-Xd) Pretest Drawdown Pressure Limit",
    b"DDRF": "Drilling Depth Reference",
    b"DDSV": "Dd Service",
    b"DEFF": "% Det Eff",
    b"DEN": "Compensated Density",
    b"DEOK": "Process Dsn Evr?",
    b"DERF": "Elevation Of Drilling Depth Reference",
    b"DEVI": "Deviation",
    b"DF": "Derek Floor",
    b"DFD": "Drilling Fluid Density",
    b"DFL": "Drilling Fluid Loss",
    b"DFPH": "Drilling Fluid Ph",
    b"DFR": "Drilling Fluid Resistivity",
    b"DFS": "Full Scale Data",
    b"DFT": "Type Of Fluid In Hole",
    b"DFV": "Drilling Fluid Viscosity",
    b"DGBY": "Digitized By",
    b"DHC": "Density Hole Correction",
    b"DHOP": "Diameter & Eccentering Used In Hals Borehole Corrections",
    b"DICO": "Digitizing Company",
    b"DIFF": "None",
    b"DIPR": "Magnetic Dip",
    b"DIST": "District",
    b"DL": "Depth Logger",
    b"DLAB": "Logstartdatet",
    b"DLHS": "Hole Diameter Source For Sobs Channel",
    b"DLLM": "Den Porosity Limit, Min Det.",
    b"DLRX": "Dogleg Rot Max",
    b"DLSO": "Dogleg Oriented",
    b"DLSP": "Drill/Wipe Stop",
    b"DLSR": "Depth Log Sample Rate",
    b"DLST": "Drill/Wipe Start",
    b"DLSX": "Dogleg Str Max",
    b"DMA": "Formation Density Matrix",
    b"DMF": "Drilling Measured From",
    b"DNOK": "Process Density?",
    b"DNSO": "Dsn Standoff - 0.25 In (6.35 Mm) Recommended",
    b"DNTP": "Temperature Correction Type",
    b"DO": "Depth Offset For Playback",
    b"DPAD": "Disabled Pad",
    b"DPPM": "Density Porosity Processing Mode",
    b"DPRF": "Depth Reference",
    b"DPRS": "Sandstone Density Por.",
    b"DPTM": "Departure Time",
    b"DRDP": "Driller'S Depth",
    b"DREF": "Depth Reference",
    b"DRET": "Drill End Time",
    b"DRST": "Drill Start Tim",
    b"DRUL": "Drho Bad Hole Limit",
    b"DSEC": "Ild Sonde Error",
    b"DSSN": "(Wsdwell) Depth System Serial Number",
    b"DTD": "Driller Depth",
    b"DTF": "Delta-T Fluid",
    b"DTFL": "Delta T Fluid",
    b"DTIM": "Time Drilling",
    b"DTM": "Delta T Long Compressional",
    b"DTMA": "Delta -T Matrix",
    b"DTMT": "Delta T Matrix",
    b"DTSH": "Delta -T Shale",
    b"DTWN": "Disable Temperature Warning",
    b"DT_F": "Tlog Constant - 71 - Dt Fluid",
    b"DT_M": "Tlog Constant - 63 - Dt Matrix, Tlog Constant - 73 - Dt Matrix Shale",
    b"DT_S": "Tlog Constant - 67 - Dt Shale",
    b"DULG": "Digital Telemetry Cartridge Uplink Gain",
    b"DULM": "Digital Telemetry Cartridge Uplink Mode",
    b"DULR": "Digital Telemetry Cartridge Uplink Rate",
    b"DWIS": "(Mifa-Nd) Dye Working Ionic Strength",
    b"DWPC": "Dipole Waveform Polarity Convention",
    b"E": "E (Stretch Coefficient Of The Cable)",
    b"E12": "None",
    b"ED": "East Departure",
    b"EDDT": "End Of Run Date",
    b"EDEP": "End Depth",
    b"EDF": "Df",
    b"EDR": "Elevation Of Depth Reference",
    b"EFN2": "Engfirstname2",
    b"EGFN": "Engfirstname",
    b"EGL": "Gl",
    b"EGLN": "Englastname",
    b"EKB": "Kb",
    b"ELCO": "Electron Cutoff",
    b"ELEV": "Elevation Df",
    b"ELN2": "Englastname2",
    b"ELRA": "Electrical Radius",
    b"ELV": "Elevation",
    b"ELZ": "Elevation Log Zero",
    b"EMT": "Meas. Temp.",
    b"ENDT": "Lwd End Date",
    b"ENG": "Recording Engineer",
    b"ENG1": "Engineer 1",
    b"ENG2": "Engineer 2",
    b"ENG3": "Engineer 3",
    b"ENG4": "Engineer 4",
    b"ENGI": "Recorded By",
    b"ENVI": "Acquisition Environment",
    b"EPD": "Elevation",
    b"EPHV": "Ecs High Voltage Manual Setting",
    b"EPSC": "Ecs Pulse Shape Compensation Manual Setting",
    b"EQID": "Equipment Id",
    b"EREF": "Elevation Of Depth Reference",
    b"ERT": "Rotary Table Elevation",
    b"ETEM": "Hilt External Temperature",
    b"ETIM": "Elapsed Time",
    b"ETIP": "(Wlsurvey) Elevation Of The Tip Above Msl",
    b"EUN": "None",
    b"EWD": "Wd Elevation",
    b"FAPD": "Feet Above Perm. Datum",
    b"FATT": "Acoustic Attenuation Due To Fluid",
    b"FCAL": "Flag, Caliper Present",
    b"FCD": "Future Casing Diam",
    b"FCF": "Cbl Fluid Compensation Factor",
    b"FD": "Fluid Density",
    b"FDEN": "Fluid Density",
    b"FEPT": "Flag, Ept Present",
    b"FETN": "Fe Type Name",
    b"FEXP": "Form Factor Exponent",
    b"FHIS": "Full History",
    b"FIID": "File Type Identifier",
    b"FILE": "File Type",
    b"FL": "Mud Fluid Loss Rate",
    b"FL1": "Locationline1",
    b"FL2": "Field Locn. Line 2",
    b"FL3": "Locationline3",
    b"FLD": "Field",
    b"FLDT": "Flag, Ldt Present",
    b"FLEV": "Fluid Level",
    b"FLHI": "Semblance Filter High Pass Value?",
    b"FLLO": "Semblance Filter Low Pass Value?",
    b"FLOI": "Flow In",
    b"FLON": "Flow In Min",
    b"FLOS": "Fluid Loss",
    b"FLOX": "Flow In Max",
    b"FLTP": "Fluid Type",
    b"FLVL": "Fluid Level",
    b"FMS": "Flag, Ept Matrix Source",
    b"FMTP": "Formation Type",
    b"FM_S": "Tlog Constant - 26 - Fm Salinity(Ppm)",
    b"FN": "Field Name",
    b"FNAM": "Formation",
    b"FNML": "Flag, Nml Present",
    b"FNUM": "Form Factor Numerator",
    b"FPER": "Flag, Nml Permeability Eq.",
    b"FPH": "Fuild Ph",
    b"FPHI": "Form Factor Porosity Source",
    b"FR": "Flow Rate",
    b"FRTC": "Flag, Rt Tornado Chart Corr.",
    b"FRXO": "Flag, Rxo Device Present",
    b"FSAL": "Formation Salinity",
    b"FSCO": "Formation Salinity Correction Option",
    b"FSON": "Flag, Sonic Present",
    b"FSOP": "Fishing Op",
    b"FSP": "Flag, Straighten Sp Baseline",
    b"FST": "Filtrate Sample Temperature",
    b"FT": "Fluid Type",
    b"FTOR": "Fluidtypeorion",
    b"FTYP": "Fluid Type",
    b"FV": "Fluid Viscosity",
    b"GCEN": "Gr Centralize Flag",
    b"GCLF": "Germany Coal-Like Formation Option",
    b"GCSE": "Generalized Caliper Selection",
    b"GDCL": "Clean Grain Density",
    b"GDEV": "Hgns Hole Deviation From Gravity",
    b"GDSH": "Grain Density Shale Value",
    b"GEOK": "Process Gamma Ray Evr?",
    b"GGRA": "Gas Gravity",
    b"GGRD": "Geothermal Gradient",
    b"GL": "Ground Elevation",
    b"GLM": "Gpit Logging Mode",
    b"GOBO": "Good Bond",
    b"GOR": "(Mifa-Nd) Gas Oil Ratio, (Mifa-Nd) (0.3S) Gas Oil Ratio",
    b"GRCC": "Hals Groningen Correction",
    b"GRCL": "Gr Clean Matrix Value",
    b"GROK": "Process Gamma Ray?",
    b"GRSE": "Generalized Mud Resistivity Selection",
    b"GRSH": "Gr Shale Value",
    b"GRSO": "Gamma Tool Standoff",
    b"GR_F": "Tlog Constant - 69 - Gr Fluid",
    b"GR_M": "Tlog Constant - 61 - Gr Matrix",
    b"GR_S": "Tlog Constant - 65 - Gr Shale",
    b"GTM": "Gpit Telemetry Mode",
    b"GTSE": "General.Temp Select",
    b"GULM": "Gr Upper Limit, Mineral Det.",
    b"GVFD": "Gravity Field",
    b"H2SP": "H2S Present",
    b"HART": "Accelerometer Reference Temperature",
    b"HDAT": "Horiz Datum",
    b"HETF": "Het Filter",
    b"HFAW": "Hilt Auto Write Telemetry",
    b"HFLO": "High Flow",
    b"HID1": "Header Identifer",
    b"HID2": "Header Identifer",
    b"HID3": "Header Identifer",
    b"HID4": "Header Identifer",
    b"HID5": "Header Identifer",
    b"HID6": "N/A",
    b"HID7": "N/A",
    b"HIDE": "Header Identifier",
    b"HIFF": "Hydrogen Index Of Formation Fluid",
    b"HISC": "Hgns Centered/Eccentered",
    b"HLAC": "Hals-B Loop A Coefficient",
    b"HLD": "Header Legal Disclaimer",
    b"HLMO": "Hals Logging Mode",
    b"HMSO": "Hals Mechanical Standoff",
    b"HOLE": "Hole Name",
    b"HORI": "Horizontal Units",
    b"HPRE": "High Pressure",
    b"HPUW": "Power Up Status Words",
    b"HRED": "Hilt Activate Data Reduction",
    b"HRFA": "Hilt Telemetry Read Max Depth",
    b"HRFI": "Hilt Telemetry Read Min Depth",
    b"HRFM": "Hilt Telemetry Read Max Frames",
    b"HRUN": "Hals-B Record Uncalibrated Channels",
    b"HSCM": "Hilt Speed Correction Mode",
    b"HSCO": "Hole Size Correction Option",
    b"HSIS": "Hilt Shale Indicator Selection",
    b"HSP": "Highsalpresent",
    b"HSSO": "Hrdd Nuclear Source Strength Option",
    b"HSTI": "Sti Uses Hilt Acceleration",
    b"HTEM": "Htc Temperature",
    b"HTES": "Cable Head Tension Source",
    b"HVCS": "Integrated Hole Volume Caliper Selection",
    b"HYDO": "Hydro Offset",
    b"HYDP": "(Mrsr-Na) Hydrostatic Pressure",
    b"IBG": "/Gas Formation Volume Factor, 1/Bg",
    b"ICMO": "Inclinometry Computation Mode",
    b"ICOD": "Ahv Casing Od",
    b"IDVN": "Ideal Wis Version",
    b"IFIN": "Inc, Final",
    b"IHVC": "Integrated Hole Volume Control",
    b"ILL1": "Instrumentation Logo Line 1",
    b"ILL2": "Instrumentation Logo Line 2",
    b"IMAX": "Inc Max",
    b"IMIN": "Inc Min",
    b"IMND": "Inc Min Depth",
    b"IMXD": "Inc Max Depth",
    b"INCE": "Inclination At End Of Well",
    b"INCS": "Inclination At Start Of Well",
    b"INT": "Correlation Interval",
    b"IQVR": "Wliq Version",
    b"ISTP": "Is Tool Pusher",
    b"ITTS": "Integrated Transit Time Source",
    b"JARR": "Jarring",
    b"JETA": "Job Events Auto Save",
    b"JOBN": "Job Ticket Numb",
    b"KB": "Elevation Of Kelly Bushing",
    b"KFAC": "Hals K Factor Option",
    b"KGDS": "Flag, Grain Den As Shale Ind",
    b"KGR": "Flag, Gr As Shale Ind.",
    b"KGRS": "Flag, Gr As Shale Ind.",
    b"KNPS": "Flag, Nphi As Shale Ind.",
    b"KPER": "Potassium Concentration",
    b"KPN": "Flag, Nphi As Shale Ind.",
    b"KRH": "Flag, Grain Den As Shale Ind",
    b"KSP": "Flag, Sp As Shale Ind.",
    b"KSPS": "Flag, Sp As Shale Ind.",
    b"LADJ": "Ll3 Adjustment",
    b"LAT": "Latitude North (Kgs,Leo3.6)",
    b"LATD": "Latitude (N=+ S=- )",
    b"LATI": "Latitude",
    b"LBFR": "Trigger For Maxis First Reading Label",
    b"LCC": "Logging Company Id",
    b"LCL": "Logging Cable Length",
    b"LCMT": "Lead Cement Type",
    b"LCN": "Logging Cable Name (Type)",
    b"LCNM": "Logging Company Name",
    b"LCSN": "Logging Cable Serial Number",
    b"LCVO": "Lead Cement Volume",
    b"LD": "Logged Direction",
    b"LEAS": "Lease Name",
    b"LETM": "Log End Time",
    b"LFR": "Log First Reading",
    b"LGN1": "Hals-B Mode 1 Loop Gain",
    b"LGN2": "Hals-B Mode 2 Loop Gain",
    b"LGN3": "Hals-B Mode 3 Loop Gain",
    b"LLAB": "Section Label",
    b"LLDR": "Ll3 Drift",
    b"LLR": "Log Last Reading",
    b"LMF": "Log Measured From",
    b"LNAM": "Name",
    b"LOC": "Location",
    b"LOGT": "Log Type",
    b"LOGU": "Logging Unit",
    b"LON": "Longitude West (Kgs, Leo3.6)",
    b"LOND": "Longitude (E=+ W=-)",
    b"LONG": "Longitude",
    b"LOP1": "Hals-B Mode 1 Loop Mode",
    b"LOP2": "Hals-B Mode 2 Loop Mode",
    b"LOP3": "Hals-B Mode 3 Loop Mode",
    b"LOST": "Lost Rig Time",
    b"LOTD": "Logger Td",
    b"LR": "Last Reading",
    b"LRT": "Logged Reprocessed Time",
    b"LSEC": "Ll3 Sonde Error",
    b"LSRV": "Nameofservice",
    b"LSTM": "Log Start Time",
    b"LSWB": "Flag, Limit Swb",
    b"LT": "Logged Type",
    b"LTD": "Logger Depth",
    b"LTH": "Neutron Porosity Curve Select",
    b"LTYP": "Logdatatype",
    b"LUL": "Loggingunitloc",
    b"LUN": "Logging Unit Number",
    b"LVER": "Sw Logged Version",
    b"LVSN": "Log Version",
    b"LWVN": "Lwd Tool Version",
    b"M": "None",
    b"MADJ": "Ilm Adjustment",
    b"MAGM": "Magnetometer Month Of Calibration",
    b"MAGN": "Magnetic Declination",
    b"MAGT": "Magnetometer Type (Manufacturer Code)",
    b"MAGY": "Y Magnetometer",
    b"MAPP": "Magnetometer Prom Presence",
    b"MATR": "Neutron Matrix",
    b"MATT": "Maximum Attenuation",
    b"MB00": "Mud Depth - Run 00",
    b"MB01": "Mud Depth - Run 01",
    b"MB02": "Mud Depth - Run 02",
    b"MB03": "Mud Depth - Run 03",
    b"MB04": "Mud Depth - Run 04",
    b"MB05": "Mud Depth - Run 05",
    b"MB06": "Mud Depth - Run 06",
    b"MB07": "Mud Depth - Run 07",
    b"MBA1": "Hals-B Mode 1 Manual Bucking Attenuation",
    b"MBA2": "Hals-B Mode 2 Manual Bucking Attenuation",
    b"MBA3": "Hals-B Mode 3 Manual Bucking Attenuation",
    b"MBOK": "Compute Bcas Results?",
    b"MCCF": "Map Cement Type Compensation Factor",
    b"MCCO": "Mud Cake Correction Option",
    b"MCI": "Minimum Cemented Interval For Isolation",
    b"MCOR": "Mud Correction",
    b"MCRS": "Resistivity Mud Cake",
    b"MCSR": "Rmc Source",
    b"MCSS": "Mud Cake Sample Source",
    b"MCST": "Mud Cake Sample Temperature",
    b"MCTP": "Temperature Mud Cake",
    b"MD": "Mud Density",
    b"MD00": "Mud Type - Run 00",
    b"MD01": "Mud Type - Run 01",
    b"MD02": "Mud Type - Run 02",
    b"MD03": "Mud Type - Run 03",
    b"MD04": "Mud Type - Run 04",
    b"MD05": "Mud Type - Run 05",
    b"MD06": "Mud Type - Run 06",
    b"MD07": "Mud Type - Run 07",
    b"MDCL": "Mud Chlorides",
    b"MDCP": "Magnetic Declination",
    b"MDEC": "Magnetic Decl",
    b"MDEN": "Density Matrix",
    b"MDES": "Mud Desc",
    b"MDET": "Flag, Min. Det. Coal Or Salt",
    b"MDIP": "Magnetic Dip",
    b"MDMN": "Dens Mud Min",
    b"MDMX": "Dens Mud Max",
    b"MDN": "Muddensity",
    b"MDPH": "Mud Ph",
    b"MDTP": "Weighted Mud Correction Type?",
    b"MDWT": "Borehole Fluid Weight",
    b"ME00": "Density - Run 00",
    b"ME01": "Density - Run 01",
    b"ME02": "Density - Run 02",
    b"ME03": "Density - Run 03",
    b"ME04": "Density - Run 04",
    b"ME05": "Density - Run 05",
    b"ME06": "Density - Run 06",
    b"ME07": "Density - Run 07",
    b"MEAN": "Tlog Constant - 14 - Mean Surf Temp",
    b"MEAS": "Measurement Reference",
    b"MF00": "Viscosity - Run 00",
    b"MF01": "Viscosity - Run 01",
    b"MF02": "Viscosity - Run 02",
    b"MF03": "Viscosity - Run 03",
    b"MF04": "Viscosity - Run 04",
    b"MF05": "Viscosity - Run 05",
    b"MF06": "Viscosity - Run 06",
    b"MF07": "Viscosity - Run 07",
    b"MFIN": "Flow In, Magnetic Field Intensity",
    b"MFL": "Mud Fluid Loss",
    b"MFRS": "Resistivity Mud Filtrate",
    b"MFSF": "Magnetic Field Scale Factor",
    b"MFSS": "Mud Filtrate Sample Source",
    b"MFST": "Rmf Temperature",
    b"MFT": "Meas. Temp.",
    b"MFTP": "Temperature Mud Filtrate",
    b"MG00": "Ph - Run 00",
    b"MG01": "Ph - Run 01",
    b"MG02": "Ph - Run 02",
    b"MG03": "Ph - Run 03",
    b"MG04": "Ph - Run 04",
    b"MG05": "Ph - Run 05",
    b"MG06": "Ph - Run 06",
    b"MG07": "Ph - Run 07",
    b"MGMC": "Magnetometer Coefficients",
    b"MH00": "Salinity - Run 00",
    b"MH01": "Salinity - Run 01",
    b"MH02": "Salinity - Run 02",
    b"MH03": "Salinity - Run 03",
    b"MH04": "Salinity - Run 04",
    b"MH05": "Salinity - Run 05",
    b"MH06": "Salinity - Run 06",
    b"MH07": "Salinity - Run 07",
    b"MHC0": "Mcfl B0 Contrast Correction Coefficient",
    b"MHC1": "Mcfl B1 Contrast Correction Coefficient",
    b"MHCC": "Mcfl High Contrast Correction Switch",
    b"MHD": "Maximum Hole Deviat",
    b"MI02": "Rm - Run 02",
    b"MI03": "Rm - Run 03",
    b"MI04": "Rm - Run 04",
    b"MI07": "Rm - Run 07",
    b"MINC": "Magnetic Field Inclination",
    b"MIT2": "Temp Of Rm - Run 2",
    b"MIT3": "Temp Of Rm - Run 3",
    b"MIT4": "Temp Of Rm - Run 4",
    b"MIT7": "Temp Of Rm - Run 7",
    b"MJ02": "Rmf - Run 02",
    b"MJ03": "Rmf - Run 03",
    b"MJ04": "Rmf - Run 04",
    b"MJ07": "Rmf - Run 07",
    b"MJT2": "Temp Of Rmf - Run 2",
    b"MJT3": "Temp Of Rmf - Run 3",
    b"MJT4": "Temp Of Rmf - Run 4",
    b"MJT7": "Temp Of Rmf - Run 7",
    b"MK00": "Max Rec Temp - Run 00",
    b"MK01": "Max Rec Temp - Run 01",
    b"MK02": "Max Rec Temp - Run 02",
    b"MK03": "Max Rec Temp - Run 03",
    b"MK04": "Max Rec Temp - Run 04",
    b"MK05": "Max Rec Temp - Run 05",
    b"MK06": "Max Rec Temp - Run 06",
    b"MK07": "Max Rec Temp - Run 07",
    b"ML02": "Rm @ Max Temp - Run 02",
    b"ML03": "Rm @ Max Temp - Run 03",
    b"ML04": "Rm @ Max Temp - Run 04",
    b"ML07": "Rm @ Max Temp - Run 07",
    b"MLM": "Mest Logging Mode",
    b"MLOK": "Process Microlog Outputs?",
    b"MM00": "Fluid Loss - Run 00",
    b"MM01": "Fluid Loss - Run 01",
    b"MM02": "Fluid Loss - Run 02",
    b"MM03": "Fluid Loss - Run 03",
    b"MM04": "Fluid Loss - Run 04",
    b"MM05": "Fluid Loss - Run 05",
    b"MM06": "Fluid Loss - Run 06",
    b"MM07": "Fluid Loss - Run 07",
    b"MMDU": "Magnetic Mark Depth Units",
    b"MMSA": "Map Minimum Sonic Amplitude",
    b"MN03": "Rmc -Run 03",
    b"MN04": "Rmc -Run 04",
    b"MNI": "Minimum Inclination",
    b"MNID": "Minimum Inclination Depth",
    b"MNSO": "Minimum Tool Standoff",
    b"MONT": "Month",
    b"MP": "Drill Measured From",
    b"MPH": "Mud Ph",
    b"MPOF": "Mcfl Processing Operation Mode",
    b"MRS": "Mud Resistivity",
    b"MRT": "Maximum Recorded Temperature",
    b"MRT1": "Maximum Recorded Temperature 1",
    b"MRT2": "Maximum Recorded Temperature 2",
    b"MRT3": "Maximum Recorded Temperature 3",
    b"MRTD": "Depth Of Max Temp",
    b"MRTE": "Magneto Reference Temperature",
    b"MSA": "Minimum Sonic Amplitude",
    b"MSEC": "Ilm Sonde Error",
    b"MSND": "Run Mud Sand %",
    b"MSOL": "Run Mud Solids%",
    b"MSS": "Mud Sample Source",
    b"MST": "Mud Sample Temperature",
    b"MT": "Borehole Mud Type",
    b"MTD": "Max Temp Depth",
    b"MTIM": "Time Of Magnetometer Calibration",
    b"MTP": "Mud Temperature",
    b"MTT": "Maxtensiontime",
    b"MUD": "Mud Type",
    b"MUDD": "Mud Density",
    b"MUDS": "Mud Sample Source",
    b"MUDV": "Mud Viscosity",
    b"MUD_": "Tlog Constant - 25 - Mud Weight(#/Gl)",
    b"MVIS": "Mud Viscosity",
    b"MW": "Mud Weight",
    b"MWCO": "Mud Weight Correction Option",
    b"MWOD": "Mwd Tool Od",
    b"MWSI": "Serv Intrp, Mwd",
    b"MWVN": "Mwd Tool Version",
    b"MXI": "Maximum Inclination",
    b"MXID": "Maximum Inclination Depth",
    b"MXTD": "Maxtensiondepth",
    b"MXTN": "Max Tension",
    b"NAAC": "Hrdd Aps Activation Correction",
    b"NADJ": "Neutron Adjustment",
    b"NATI": "Nation",
    b"NCHC": "Cased Corr - Neutron",
    b"NCOR": "Neutron Env. Corr.",
    b"NDTC": "Hrdd Dead Time Correction",
    b"NGAI": "Neutron Gain Factor",
    b"NIAV": "Hrdd Density/Pe Algorithm Version",
    b"NINT": "Number Of Interpolation",
    b"NLIM": "Neutron Porosity (Limestone Matrix)",
    b"NLIT": "Neutron Lithology",
    b"NLS": "Nominal Logging Speed",
    b"NMT": "Hilt Nuclear Mud Type",
    b"NPCL": "Clean Matrix Neut. Porosity",
    b"NPRM": "Hrdd Processing Mode",
    b"NPSH": "Neutron Porosity Shale Value",
    b"NPUC": "Hrdd Pile-Up Correction",
    b"NSAR": "Hrdd Depth Sampling Rate",
    b"NTCO": "Hrdd Temperature Correction Option",
    b"NULL": "Null Value",
    b"NWF": "Number Of Waveforms",
    b"NWT": "Number Of Wait Times",
    b"O": "Tlog Constant - 30 - O.D. Casing(In)",
    b"OBM": "Oil Based Mud, Oil Based Mud System?",
    b"ODEN": "Oil Density",
    b"OFFE": "Upper Depth Offset (East Of Origin)",
    b"OFFN": "Upper Depth Offset (North Of Origin)",
    b"OPER": "Operator'S Code",
    b"OPMD": "Operation Mode",
    b"OPRT": "N/A",
    b"ORIG": "Origin Of Data",
    b"OS1": "Other Services Line 1",
    b"OS2": "Other Services Line 2",
    b"OS3": "Other Services Line 3",
    b"OS4": "Other Services Line 4",
    b"OS5": "Other Services Line 5",
    b"OS6": "Other Services Ln 6",
    b"OSR1": "Other Services",
    b"OSR2": "Other Services",
    b"OSR3": "Other Services",
    b"OTIM": "Time Operating",
    b"OWR": "Water Ratio",
    b"PADT": "Presentation Allow Disallow Threshold",
    b"PANA": "Processing Analyst",
    b"PASS": "Main, Repeat 1, Repeat 2, Etc",
    b"PBFL": "Borehole Input Filtr",
    b"PCON": "Processing Contractor",
    b"PD": "Permanent Datum",
    b"PDAT": "Permanent Datum",
    b"PDEV": "Elevation Permanent Data",
    b"PFRC": "Frequency",
    b"PFS": "Permeability Formula Switch",
    b"PGAT": "Fixed Gate",
    b"PH": "Mud Ph",
    b"PKEN": "Neutrons Enabled",
    b"PKOF": "Stop Neutrons",
    b"PKON": "Start Neutrons",
    b"PMAX": "Press Op, Max",
    b"PMLO": "High Voltage Control",
    b"PMST": "Aacp Spike Max Time",
    b"PNUM": "Num Of Servo Pulses",
    b"PO": "Percentage Oil",
    b"POUT": "Output Matrix Porosities",
    b"PP": "Playback Processing",
    b"PPSS": "Predefined Parameter Set Selection",
    b"PPT": "Predicted Pipe Time",
    b"PROJ": "Project",
    b"PROV": "Province",
    b"PRPL": "Aacp Replenisher",
    b"PSFL": "Servo Input Filter",
    b"PTCO": "Pressure/Temperature Correction Option",
    b"PTNO": "Pretest Number",
    b"PTVO": "(Mrpq-Xd) Requested Pretest Volume",
    b"PTYP": "Pad Type - Medium Extended Coverage Or High Resolution",
    b"PT_V": "Polarization Times",
    b"PUFE": "Processed Using First Echo",
    b"PV": "Plastic Viscosity",
    b"PVER": "Program Version",
    b"Pass": "Pass Index",
    b"QGCA": "(Mrsr-Na) Quartz Gauge Pressure Correction Applied Option",
    b"R001": "Remarks - Line 001",
    b"R002": "Remarks - Line 002",
    b"R003": "Remarks - Line 003",
    b"R004": "Remarks - Line 004",
    b"R005": "Remarks - Line 005",
    b"R006": "Remarks - Line 006",
    b"R007": "Remarks - Line 007",
    b"R008": "Remarks - Line 008",
    b"R009": "Remarks - Line 009",
    b"R010": "Remarks - Line 010",
    b"R011": "Remarks - Line 011",
    b"R012": "Remarks - Line 012",
    b"R013": "Remarks - Line 013",
    b"R014": "Remarks - Line 014",
    b"R015": "Remarks - Line 015",
    b"R016": "Remarks - Line 016",
    b"R017": "Remarks - Line 017",
    b"R018": "Remarks - Line 018",
    b"R019": "Remarks - Line 019",
    b"R020": "Remarks - Line 020",
    b"R021": "Remarks - Line 021",
    b"R022": "Remarks - Line 022",
    b"R023": "Remarks - Line 023",
    b"R024": "Remarks - Line 024",
    b"R025": "Remarks - Line 025",
    b"R026": "Remarks - Line 026",
    b"R027": "Remarks - Line 027",
    b"R032": "Remarks - Line 032",
    b"R034": "Remarks - Line 034",
    b"R035": "Remarks - Line 035",
    b"R036": "Remarks - Line 036",
    b"R038": "Remarks - Line 038",
    b"R040": "Remarks - Line 040",
    b"R042": "Remarks - Line 042",
    b"R044": "Remarks - Line 044",
    b"R046": "Remarks - Line 046",
    b"R048": "Remarks - Line 048",
    b"R049": "Remarks - Line 049",
    b"R050": "Remarks - Line 050",
    b"R052": "Remarks - Line 052",
    b"R053": "Remarks - Line 053",
    b"R054": "Remarks - Line 054",
    b"R060": "Remarks - Line 060",
    b"R061": "Remarks - Line 061",
    b"R065": "Remarks - Line 065",
    b"R1": "Remarks Line 1",
    b"R10": "Remark Line 10",
    b"R11": "Remark Line 11",
    b"R12": "Remark Line 12",
    b"R13": "Remark Line 13",
    b"R14": "Remark Line 14",
    b"R15": "Remark Line 15",
    b"R16": "Remark Line 16",
    b"R17": "Remark Line 17",
    b"R2": "Remarks Line 2",
    b"R3": "Remarks Line 3",
    b"R4": "Remarks Line 4",
    b"R5": "Remarks Line 5",
    b"R6": "Remark Line 6",
    b"R7": "Remark Line 7",
    b"R8": "Remark Line 8",
    b"R9": "Remark Line 9",
    b"RA00": "Run Number 00",
    b"RA01": "Run Number 01",
    b"RA02": "Run Number 02",
    b"RA03": "Run Number 03",
    b"RA04": "Run Number 04",
    b"RA05": "Run Number 05",
    b"RA06": "Run Number 06",
    b"RA07": "Run Number 07",
    b"RADJ": "Rhoc Adjustment",
    b"RANG": "Range",
    b"RB00": "Start Date - Run 00",
    b"RB01": "Start Date - Run 01",
    b"RB02": "Start Date - Run 02",
    b"RB03": "Start Date - Run 03",
    b"RB04": "Start Date - Run 04",
    b"RB05": "Start Date - Run 05",
    b"RB06": "Start Date - Run 06",
    b"RB07": "Start Date - Run 07",
    b"RBHT": "Mud Resistivity @ Borehole Temperature",
    b"RBS": "Resistivity Button Selection",
    b"RC00": "Start Time - Run 00",
    b"RC01": "Start Time - Run 01",
    b"RC02": "Start Time - Run 02",
    b"RC03": "Start Time - Run 03",
    b"RC04": "Start Time - Run 04",
    b"RC05": "Start Time - Run 05",
    b"RC06": "Start Time - Run 06",
    b"RC07": "Start Time - Run 07",
    b"RD00": "End Date - Run 00",
    b"RD01": "End Date - Run 01",
    b"RD02": "End Date - Run 02",
    b"RD03": "End Date - Run 03",
    b"RD04": "End Date - Run 04",
    b"RD05": "End Date - Run 05",
    b"RD06": "End Date - Run 06",
    b"RD07": "End Date - Run 07",
    b"RE00": "End Time - Run 00",
    b"RE01": "End Time - Run 01",
    b"RE02": "End Time - Run 02",
    b"RE03": "End Time - Run 03",
    b"RE04": "End Time - Run 04",
    b"RE05": "End Time - Run 05",
    b"RE06": "End Time - Run 06",
    b"RE07": "End Time - Run 07",
    b"RECB": "Recorded By",
    b"REFD": "N/A",
    b"REFL": "N/A",
    b"RF00": "Depth In - Run 00",
    b"RF01": "Depth In - Run 01",
    b"RF02": "Depth In - Run 02",
    b"RF03": "Depth In - Run 03",
    b"RF04": "Depth In - Run 04",
    b"RF05": "Depth In - Run 05",
    b"RF06": "Depth In - Run 06",
    b"RF07": "Depth In - Run 07",
    b"RFIL": "(Mrpq-Xd) Resistivity Filter",
    b"RG00": "Depth Out - Run 00",
    b"RG01": "Depth Out - Run 01",
    b"RG02": "Depth Out - Run 02",
    b"RG03": "Depth Out - Run 03",
    b"RG04": "Depth Out - Run 04",
    b"RG05": "Depth Out - Run 05",
    b"RG06": "Depth Out - Run 06",
    b"RG07": "Depth Out - Run 07",
    b"RG21": "Rhomat Min 1-2 Min Model",
    b"RG22": "Rhomat Min 2-2 Min Model",
    b"RG23": "Rhomat Min 3-2 Min Model",
    b"RG31": "Rhomat Min 1-3 Min Model",
    b"RG32": "Rhomat Min 2-3 Min Model",
    b"RG33": "Rhomat Min 3-3 Min Model",
    b"RGE": "Range",
    b"RH00": "Log Top - Run 00",
    b"RH01": "Log Top - Run 01",
    b"RH02": "Log Top - Run 02",
    b"RH03": "Log Top - Run 03",
    b"RH04": "Log Top - Run 04",
    b"RH05": "Log Top - Run 05",
    b"RH06": "Log Top - Run 06",
    b"RH07": "Log Top - Run 07",
    b"RHO_": "Tlog Constant - 62 - Rho Matrix, Tlog Constant - 66 - Rho Shale, Tlog Constant - 70 - Rho Fluid",
    b"RI00": "Log Bottom - Run 00",
    b"RI01": "Log Bottom - Run 01",
    b"RI02": "Log Bottom - Run 02",
    b"RI03": "Log Bottom - Run 03",
    b"RI04": "Log Bottom - Run 04",
    b"RI05": "Log Bottom - Run 05",
    b"RI06": "Log Bottom - Run 06",
    b"RI07": "Log Bottom - Run 07",
    b"RIAV": "Mcfl Resistivity Algorithm Version",
    b"RIG": "Rig Name",
    b"RIGN": "Rig Number",
    b"RJ00": "Hole Size - Run 00",
    b"RJ01": "Hole Size - Run 01",
    b"RJ02": "Hole Size - Run 02",
    b"RJ03": "Hole Size - Run 03",
    b"RJ04": "Hole Size - Run 04",
    b"RJ05": "Hole Size - Run 05",
    b"RJ06": "Hole Size - Run 06",
    b"RJ07": "Hole Size - Run 07",
    b"RKB": "Kb Elevation",
    b"RLAB": "Range Label",
    b"RLDT": "Reference Log Date (Dd-Mmm-Yyyy)",
    b"RLNM": "Reference Log Name",
    b"RLRN": "Reference Log Run Number",
    b"RM": "Mud Resistivity",
    b"RMB": "Rm. At Bht",
    b"RMBH": "Rm At Bht",
    b"RMBT": "Rm At Bottom Hole Temp.",
    b"RMC": "Mud Cake Resistivity",
    b"RMCB": "Rmc @ Bht",
    b"RMCM": "Mud Cake Resistivity Measured",
    b"RMCS": "Mud Cake Resistivity",
    b"RMCT": "Mud Cake Sample Temperature",
    b"RMC_": "Tlog Constant - 5 - Rmc",
    b"RMF": "Mud Filtrate Resistivity",
    b"RMFB": "Rmf @ Bht",
    b"RMFM": "Mud Filtrate Resistivity Measured",
    b"RMFS": "Mud Filtrate Resistivity",
    b"RMFT": "Mud Filtrate Sample Temperature",
    b"RMF_": "Tlog Constant - 9 - Rmf",
    b"RMIN": "Smoothed Ddsr-M5 Min Rpm (Sperry)",
    b"RMM": "Mud Resistivity Measured",
    b"RMMT": "Rm @ Max Temp",
    b"RMOP": "Rmud Source",
    b"RMS": "Mud Resitivity",
    b"RMT": "Mud Sample Temperature",
    b"RMTC": "Mc Temp @ Surface",
    b"RMTF": "Mf Temp @ Surface",
    b"RMUD": "Rmud",
    b"RM__": "Tlog Constant - 7 - Rm",
    b"RNID": "Run Id",
    b"ROPA": "Avg Rate Of Penetration",
    b"ROPN": "Rop Min",
    b"ROPX": "Rop Max",
    b"RPMA": "Rpm Surface Avg",
    b"RPMN": "Rpm Surface Min",
    b"RPMX": "Rpm Surface Max",
    b"RRUN": "Rig Run Number",
    b"RTIM": "Time Reaming",
    b"RTLF": "Flag, Rt Limit",
    b"RTOK": "Process Acrt?",
    b"RTRE": "Hals Resistivity Threshold",
    b"RU00": "Engineer #1 - Run 00",
    b"RU01": "Engineer #1 - Run 01",
    b"RU02": "Engineer #1 - Run 02",
    b"RU03": "Engineer #1 - Run 03",
    b"RU04": "Engineer #1 - Run 04",
    b"RU05": "Engineer #1 - Run 05",
    b"RU06": "Engineer #1 - Run 06",
    b"RU07": "Engineer #1 - Run 07",
    b"RULB": "Rig Up Length At Bottom",
    b"RULS": "Rig Up Length At Surface",
    b"RUN": "Run Number",
    b"RUN1": "Run Number",
    b"RUN2": "Run Identification Mnemonic For Run #2",
    b"RUN3": "Run Identification Mnemonic For Run #3",
    b"RUND": "Run Date",
    b"RUNS": "Number Of Runs",
    b"RV01": "Engineer #2 - Run 01",
    b"RV02": "Engineer #2 - Run 02",
    b"RV03": "Engineer #2 - Run 03",
    b"RV04": "Engineer #2 - Run 04",
    b"RV05": "Engineer #2 - Run 05",
    b"RV06": "Engineer #2 - Run 06",
    b"RV07": "Engineer #2 - Run 07",
    b"RW": "Resistivity Of Connate Water",
    b"RW02": "Engineer #3 - Run 02",
    b"RW03": "Engineer #3 - Run 03",
    b"RW07": "Engineer #3 - Run 07",
    b"RWB": "Rwb Bound Water Resistivity",
    b"RWF": "Rwf Free Water Restivity",
    b"RW__": "Tlog Constant - 11 - Rw",
    b"RXDO": "Receiver Depth Offset",
    b"RXR": "None",
    b"RXRB": "Receiver Relative Bearing",
    b"R_SH": "Tlog Constant - 19 - R Shale",
    b"Rmf": "Mud Filtrate Resistivity",
    b"RmfT": "Mud Filtrate Temperature",
    b"SAL": "Salinity",
    b"SALI": "Borehole Salinity",
    b"SANG": "Correlation Search Angle",
    b"SAT_": "Tlog Constant - 18 - Sat Exp (N)",
    b"SAZI": "Azm, Start",
    b"SBOA": "Search Band Offset",
    b"SBR": "Sbr",
    b"SBRC": "Sbr Correction",
    b"SBUT": "Dip Set Of Buttons",
    b"SBWA": "Search Band Width",
    b"SC1": "Log Scale 1",
    b"SC2": "Log Scale 2",
    b"SCAL": "Swn Caliper",
    b"SCDP": "Surface Casing Depth",
    b"SCT1": "Startdaterun1",
    b"SD1B": "Bs Pulse Processing Filter Temperature Coefficient",
    b"SD1L": "Ls Pulse Processing Filter Temperature Coefficient",
    b"SD1S": "Ss Pulse Processing Filter Temperature Coefficient",
    b"SDAT": "Standoff Data Source",
    b"SDDT": "Start Of Run Date",
    b"SDEP": "Start Depth",
    b"SDFA": "Side-By-Side Distance Factor",
    b"SEC": "Section",
    b"SECT": "Section",
    b"SER": "System Serial Number",
    b"SET": "None",
    b"SFT": "Mean Annual Surf Temp",
    b"SGOR": "Solution Gas Oil Ratio",
    b"SHCO": "View More Correction Options",
    b"SHT": "Surface Hole Temp",
    b"SIDD": "Serv Intrp, Dd",
    b"SINC": "Inc, Start",
    b"SIS": "Flag, Min Prop<X> Shale Ind.",
    b"SL": "Surface Location",
    b"SLAB": "State/Province Label",
    b"SLLA": "Slowness Lower Limit",
    b"SNBS": "Hrgd Bs Serial Number",
    b"SNLS": "Hrgd Ls Serial Number",
    b"SNSS": "Hrgd Ss Serial Number",
    b"SO": "Stand Off",
    b"SOCN": "Standoff Distance",
    b"SOCO": "Standoff Correction Option",
    b"SOFF": "Standoff",
    b"SOLD": "% Solids",
    b"SON": "Job Number",
    b"SPAN": "Dip Spanning",
    b"SPCL": "Sp Clean Matrix Value",
    b"SPCO": "Hals-B Special Power Connection",
    b"SPDR": "Sp Drift",
    b"SPEE": "Simulated Logging Speed",
    b"SPEQ": "Acoustic Porosity Equation",
    b"SPFG": "Flag, Sp Comp.",
    b"SPFS": "Sonic Porosity Formula",
    b"SPNV": "Sp Next Value",
    b"SPPA": "Srf Pumprs 2Hz",
    b"SPPN": "Spp Min",
    b"SPPX": "Spp Max",
    b"SPSH": "Sp Shale Value",
    b"SPSO": "Sonic Porosity Source",
    b"SPUD": "Spud Date",
    b"SPVN": "Spm Version",
    b"SPVT": "Sdlt Pad Temperature Valid?",
    b"SRMC": "Mrsr Quartz Gauge Nc Signal Component",
    b"SRMF": "Source Rmf",
    b"SRVC": "Service Company",
    b"SSCD": "Sensor Sensitivity Correction Master Calibration Date",
    b"SSCF": "Sensor Sensitivity Correction Factor",
    b"SSCR": "Sensor Sensitivity Correction Factor Low Frequency To High Frequency Ratio",
    b"SSCT": "Sensor Sensitivity Correction Date And Time",
    b"SSHB": "Bs Barium Meas High Energy Temperature Shift",
    b"SSHL": "Ls Barium Meas High Energy Temperature Shift",
    b"SSHS": "Ss Barium Meas High Energy Temperature Shift",
    b"SSLB": "Bs Barium Meas Low Energy Temperature Shift",
    b"SSLL": "Ls Barium Meas Low Energy Temperature Shift",
    b"SSLS": "Ss Barium Meas Low Energy Temperature Shift",
    b"SSTA": "Slowness Step",
    b"ST": "Surface Temperature",
    b"STAN": "Tlog Constant - 28 - Standoff (Il), Tlog Constant - 29 - Standoff (Neut)",
    b"STAT": "State",
    b"STDA": "Structural Dip Azimuth",
    b"STDF": "Sensor Time Delay Factor",
    b"STDI": "Structural Dip Angle",
    b"STDT": "Start Date",
    b"STEM": "Surface Temperature",
    b"STEP": "Step",
    b"STIM": "Start Time",
    b"STKT": "Sti Stuck Threshold",
    b"STUS": "Status",
    b"SULA": "Slowness Upper Limit",
    b"SURV": "Survey Type",
    b"SVCN": "Service Name",
    b"SVCS": "Services",
    b"SVER": "Sperry Version",
    b"SWAN": "Sheave Wheel Angle",
    b"Scal": "None",
    b"T/D": "T/D Activity",
    b"T180": "Time Width For 180 Degree Pulse",
    b"T2C1": "T2 Cutoff 1",
    b"T2C2": "T2 Cutoff 2",
    b"T2C3": "T2 Cutoff 3",
    b"T2C4": "T2 Cutoff 4",
    b"T2C5": "T2 Cutoff 5",
    b"T2C6": "T2 Cutoff 6",
    b"T2C7": "T2 Cutoff 7",
    b"T2MF": "T2 Mud Filtrate",
    b"T90": "Time Width For 90 Degree Pulse",
    b"TA1B": "Bs Stab Counts Measurement Temperature",
    b"TA1L": "Ls Stab Counts Measurement Temperature",
    b"TA1S": "Ss Stab Counts Measurement Temperature",
    b"TCA": "Tail Cement Additives",
    b"TCDE": "Tail Cement Density",
    b"TCE": "Time Circ End",
    b"TCOR": "Hals Tlc Correction",
    b"TCP": "Time Between 90X, 180Y Pulses",
    b"TCS": "Time Ciculation Ended",
    b"TCS1": "Time Circulation Stopped",
    b"TCTY": "Tail Cement Type",
    b"TCV": "Tail Cement Volume",
    b"TCWL": "Tail Cement Water Loss",
    b"TD": "Total Depth",
    b"TDAT": "Tot Depth Attmp",
    b"TDCE": "Time Circ End",
    b"TDD": "Td (Driller)",
    b"TDDF": "Trip For Dd",
    b"TDEL": "Difference Between Start Of Echo And Tcp",
    b"TDEP": "-Inch Frame Depth",
    b"TDL": "Td (Logger)",
    b"TDLG": "Tot Depth Loggd",
    b"TDS": "Time Drilling Stopped",
    b"TD__": "Tlog Constant - 20 - Td",
    b"TEMP": "Temperature",
    b"TF": "Type Fluid In Hole",
    b"TFA": "Bit Tfa",
    b"TFF": "Trip For Fail",
    b"TGAT": "Integrator Window Width",
    b"TGRD": "Temperature Gradiant",
    b"TIMC": "Time Circulation Ended",
    b"TIMD": "Date/Time Logger Tagged Bottom",
    b"TIME": "Time",
    b"TIML": "Time Logger At Bottom",
    b"TITL": "Lwd Service",
    b"TLA2": "Time Logging On Bottom 2",
    b"TLAB": "Logstarttimet",
    b"TLAS": "N/A",
    b"TLI": "Top Log Interval",
    b"TLLA": "Time Lower Limit",
    b"TMAX": "Max Recorder Temperature",
    b"TMPC": "Temperature Correction Type",
    b"TMRI": "Telemetry Error Msg Report Interval (For Scp)",
    b"TMUC": "Type Of Mud",
    b"TNOC": "Time Circulation Stopped",
    b"TOD": "Tool Nominal Od",
    b"TOOL": "Tool Serial Number",
    b"TOWN": "Township",
    b"TPM1": "Ept Sand Matrix Tpl",
    b"TPM2": "Ept Dolomite Matrix Tpl",
    b"TPM3": "Ept Lime Matrix Tpl",
    b"TPOS": "Tool Position",
    b"TQAA": "Torque Abs Avg",
    b"TQAN": "Torque Abs Min",
    b"TQAX": "Torque Abs Max",
    b"TREF": "Reference Tension Of The Cable",
    b"TRIP": "Trip Number",
    b"TRM": "Temperature Of Mud",
    b"TRMC": "Tlog Constant - 6 - Trmc",
    b"TRMF": "Tlog Constant - 10 - Trmf",
    b"TRM_": "Tlog Constant - 8 - Trm",
    b"TRRT": "Turn Rotating",
    b"TRUK": "Truck Calibration Number",
    b"TRW": "Tlog Constant - 12 - Trw",
    b"TRW_": "Tlog Constant - 12 - Trw",
    b"TSC": "Time Since Circulation",
    b"TSEC": "Tscd Enable Corrected Depth Computation",
    b"TSHB": "Bs Barium Meas Temperature",
    b"TSHL": "Ls Barium Meas Temperature",
    b"TSHS": "Ss Barium Meas Temperature",
    b"TSRI": "Telemetry Status Report Interval (For Io Mon)",
    b"TSTA": "Time Step",
    b"TSTG": "Title Service Mnemonic",
    b"TSTR": "Title Service Mnemonic",
    b"TTC": "Compressional Traveltime",
    b"TTFF": "Fast Formation Tt",
    b"TTL1": "Header Title Line 1",
    b"TTL2": "Header Title Line 2",
    b"TTL3": "Header Title Line 3",
    b"TTMX": "Max Tool Temp",
    b"TULA": "Time Upper Limit",
    b"TVD": "Tvd Flag",
    b"TVDS": "Tvdss Correctn",
    b"TVDs": "Tvdss",
    b"TWIA": "Integration Time Window",
    b"TWP": "Township",
    b"TWS": "Temperature Of Connate Water Sample",
    b"TX1": "Transmitter Id For Data Channel 1",
    b"TX10": "Transmitter Id For Data Channel 10",
    b"TX11": "Transmitter Id For Data Channel 11",
    b"TX12": "Transmitter Id For Data Channel 12",
    b"TX2": "Transmitter Id For Data Channel 2",
    b"TX3": "Transmitter Id For Data Channel 3",
    b"TX4": "Transmitter Id For Data Channel 4",
    b"TX5": "Transmitter Id For Data Channel 5",
    b"TX6": "Transmitter Id For Data Channel 6",
    b"TX7": "Transmitter Id For Data Channel 7",
    b"TX8": "Transmitter Id For Data Channel 8",
    b"TX9": "Transmitter Id For Data Channel 9",
    b"TXDO": "Transmitter Depth Offset",
    b"TYPE": "Tlog Constant - 32 - Type Of Mud",
    b"Tot": "Tot Depth Loggd",
    b"UBS": "Use Bit Size Instead Of Caliper For All Applications.",
    b"UD37": "Potassium (Mg/L)",
    b"UF": "U Fluid",
    b"ULOG": "Logging Objective",
    b"UM21": "U Matrix Min 1-2 Min Model",
    b"UM22": "U Matrix Min 2-2 Min Model",
    b"UM23": "U Matrix Min 3-2 Min Model",
    b"UM31": "U Matrix Min 1-3 Min Model",
    b"UM32": "U Matrix Min 2-3 Min Model",
    b"UM33": "U Matrix Min 3-3 Min Model",
    b"UNIT": "Equipment Id",
    b"UTVD": "Use Tvd For Gradient Corrections?",
    b"UWI": "Unique Well Id",
    b"UWID": "Unique Well Identification Number",
    b"VCEM": "Cumulated Cement Volume",
    b"VERS": "Cwls Log Ascii Standard - Version 2.0",
    b"VERT": "Vertical Units",
    b"VHOL": "Cumulated Hole Volume",
    b"VISC": "Viscosity",
    b"VISS": "Viscosityselect",
    b"VS": "Viscosity",
    b"VS01": "Virtual Str1 Sn",
    b"VS02": "Virtual Str2 Sn",
    b"VS03": "Virtual Str3 Sn",
    b"VS04": "Virtual Str4 Sn",
    b"VS05": "Virtual Str5 Sn",
    b"Vert": "Vertical Sec",
    b"WBMN": "Wob Min",
    b"WCEQ": "Witm-Cts Equalizer Setting",
    b"WDMS": "Wd Elev",
    b"WECL": "Well Class",
    b"WELL": "Well",
    b"WET": "Wet Hole Flag",
    b"WHP": "N/A",
    b"WID": "None",
    b"WIT": "Witnessed By",
    b"WIT2": "Witness 2",
    b"WIT3": "Witness 3",
    b"WITN": "Witness",
    b"WL": "Water Level",
    b"WMUD": "Drilling Mud Density",
    b"WN": "Well Name",
    b"WOBA": "Wob Avg",
    b"WOBX": "Wob Max",
    b"WSS": "Source Of Sample",
    b"WSTA": "Well Status",
    b"WT": "Tlog Constant - 31 - Wt. Casing(#/Ft)",
    b"WTMT": "Ecs Weight Spectrum Desired Acquisition Time",
    b"WT_V": "Acquisition Wait Times",
    b"X": "X Or East-West Coordinate",
    b"XFHA": "Filter High Cutoff",
    b"XFLA": "Filter Low Cutoff",
    b"XGAI": "Gain",
    b"XMOD": "Emex Mode",
    b"XOFF": "Offset",
    b"XVOL": "Emex Voltage",
    b"XXXX": "Missing",
    b"Y": "Y Or North South Coordinate",
    b"YEAR": "Year",
    b"YP": "Yield Point",
    b"ZCAM": "Hals-B Calibration Mode",
    b"ZCMT": "Acoustic Impedance Of Cement",
    b"ZFAC": "Hals-B Fixed Acquisition Chain",
    b"ZFCN": "Hals-B Fixed Channel Number",
    b"ZFGN": "Hals-B Fixed Vga Gain",
    b"ZRCS": "Tool Zero Reference Check At Surface",
}

CURVE_MNEM_DESCRIPTIONS = {
    b"$^": "None",
    b"%": "11, 12",
    b"12V1": "None",
    b"15M1": "None",
    b"15V1": "None",
    b"15VS": "9",
    b"15VT": "6",
    b"16in": "16In Normal",
    b"1LD": "Dual Induction Laterolog",
    b"25VT": "7",
    b"28V1": "None",
    b"2IRP": "21",
    b"2IXP": "23",
    b"3RD": "3Rd Curve Resistivty",
    b"50V": "V Supply",
    b"5V1": "None",
    b"64in": "64In Normal",
    b"A10H": "Arc Attenuation Resistivity 10-In. At 2 Mhz",
    b"A16H": "(Rm) (Arc[1]) (6In) Attenuation Resistivity 16 Inch Spacing At 2 Mhz, Environmentally Corrected, Arc Attenuation Resistivity 16-In. At 2 Mhz",
    b"A16L": "Arc Attenuation Resistivity 16-In. At 400 Khz",
    b"A19": "None",
    b"A22H": "(Rm) (Arc[1]) (6In) Attenuation Resistivity 22 Inch Spacing At 2 Mhz, Environmentally Corrected",
    b"A22L": "Arc Attenuation Resistivity 22-In. At 400 Khz",
    b"A28H": "Arc Attenuation Resistivity 28-In. At 2 Mhz",
    b"A28L": "Arc Attenuation Resistivity 28-In. At 400 Khz",
    b"A34H": "Arc Attenuation Resistivity 34-In. At 2 Mhz",
    b"A34L": "Arc Attenuation Resistivity 34-In. At 400 Khz",
    b"A40H": "Arc Attenuation Resistivity 40-In. At 2 Mhz",
    b"A40L": "Arc Attenuation Resistivity 40-In. At 400 Khz",
    b"AAN1": "None",
    b"AAVG": "Avg Energy",
    b"AAZD": "Apparent Azimuth",
    b"ABBQ": "Smoothed At Bit Gamma Bottom Quadrant (Sperry)",
    b"ABFR": "Array Induction Quality Control Borehole Formation Ratio",
    b"ABGB": "Smoothed Azimuthal At Bit Gamma Ray - Bottom Quadrant (Sperry)",
    b"ABGC": "Smoothed Azimuthal At Bit Gamma Ray - Combined (Sperry)",
    b"ABGL": "Smoothed Azimuthal At Bit Gamma Ray - Left Quadrant(Sperry)",
    b"ABGR": "Smoothed Azimuthal At Bit Gamma Ray - Right Quadrant (Sperry)",
    b"ABGT": "Smoothed Azimuthal At Bit Gamma Ray - Top Quadrant (Sperry)",
    b"ABHV": "Annular Volume",
    b"ABLQ": "Smoothed At Bit Gamma Left Quadrant (Sperry)",
    b"ABRQ": "Smoothed At Bit Gamma Right Quadrant (Sperry)",
    b"ABS": "None",
    b"ABSP": "Absolute Pressure In Housing",
    b"ABTQ": "Smoothed At Bit Gamma Top Quadrant (Sperry)",
    b"AC": "Acoustic Travel Time",
    b"AC01": "Ac01",
    b"AC02": "Ac02",
    b"AC03": "Ac03",
    b"AC04": "Ac04",
    b"AC1": "Ac1",
    b"AC2": "Ac2",
    b"AC3": "Ac3",
    b"AC4": "Ac4",
    b"AC5": "Ac5",
    b"ACAL": "Smoothed Processed Caliper (Sperry)",
    b"ACCQ": "Acc Qual",
    b"ACCV": "Accumulated Vol",
    b"ACCX": "X Axis Accelerometer",
    b"ACCY": "Y Axis Accelerometer",
    b"ACCZ": "Z Axis Accelerometer",
    b"ACER": "Aacp Errors Index",
    b"ACES": "Array Induction Computed Effective Standoff",
    b"ACGR": "Gamma Ray",
    b"ACHD": "Acoustic Caliper Hole Diameter",
    b"ACL": "None",
    b"ACP": "None",
    b"ACPE": "Aacp Error",
    b"ACQ": "Acoustic Quality Indicator, Acq",
    b"ACQ1": "Acq1",
    b"ACQ2": "Acq2",
    b"ACSP": "Spontaneous Potential",
    b"ACTC": "Sonic Interval Transit Time (Compensated)",
    b"ACTE": "(Edtc-B) Accelerometer Temperature",
    b"ACTN": "????????",
    b"AD01": "Smoothed Azimuthal Bulk Density - Bin 1 (Sperry)",
    b"AD02": "Smoothed Azimuthal Bulk Density - Bin 2 (Sperry)",
    b"AD03": "Smoothed Azimuthal Bulk Density - Bin 3 (Sperry)",
    b"AD04": "Smoothed Azimuthal Bulk Density - Bin 4 (Sperry)",
    b"AD05": "Smoothed Azimuthal Bulk Density - Bin 5 (Sperry)",
    b"AD06": "Smoothed Azimuthal Bulk Density - Bin 6 (Sperry)",
    b"AD07": "Smoothed Azimuthal Bulk Density - Bin 7 (Sperry)",
    b"AD08": "Smoothed Azimuthal Bulk Density - Bin 8 (Sperry)",
    b"AD09": "Smoothed Azimuthal Bulk Density - Bin 09 (Sperry)",
    b"AD10": "Smoothed Azimuthal Bulk Density - Bin 10 (Sperry)",
    b"AD11": "Smoothed Azimuthal Bulk Density - Bin 11 (Sperry)",
    b"AD12": "Smoothed Azimuthal Bulk Density - Bin 12 (Sperry)",
    b"AD13": "Smoothed Azimuthal Bulk Density - Bin 13 (Sperry)",
    b"AD14": "Smoothed Azimuthal Bulk Density - Bin 14 (Sperry)",
    b"AD15": "Smoothed Azimuthal Bulk Density - Bin 15 (Sperry)",
    b"AD16": "Smoothed Azimuthal Bulk Density - Bin 16 (Sperry)",
    b"ADBQ": "Smoothed Azimuthal Bulk Density - Bottom Quadrant (Sperry)",
    b"ADDD": "Adr Data Density",
    b"ADES": "Array Induction Diagnostic Executive Summary",
    b"ADIA": "(Rm) (Adn[1]) (6In) Average Borehole Diameter",
    b"ADJS": "Adjusted Sonic Travel Time",
    b"ADLQ": "Smoothed Azimuthal Bulk Density - Left Quadrant (Sperry)",
    b"ADRQ": "Smoothed Azimuthal Bulk Density - Right Quadrant (Sperry)",
    b"ADTQ": "Smoothed Azimuthal Bulk Density - Top Quadrant (Sperry)",
    b"ADXT": "Adr Formation Exp Time",
    b"AE10": "Array Induction Resistivity Environmentally Compensated Log Processing Ae10",
    b"AE20": "Array Induction Resistivity Environmentally Compensated Log Processing Ae20",
    b"AE30": "Array Induction Resistivity Environmentally Compensated Log Processing Ae30",
    b"AE60": "Array Induction Resistivity Environmentally Compensated Log Processing Ae60",
    b"AE90": "Array Induction Resistivity Environmentally Compensated Log Processing Ae90",
    b"AECF": "Array Induction Environmentally Compensated Log Processing Chart Flag",
    b"AECW": "Array Induction Environmentally Compensated Log Processing Combined Weights",
    b"AEHF": "Array Induction Environmentally Compensated Log Processing Hole Flag",
    b"AEMF": "Array Induction Environmentally Compensated Log Processing Magnetic Mud Flag",
    b"AERS": "Array Induction Environmentally Compensated Log Processing Resolution Flag",
    b"AF10": "Array Induction Four Foot Resistivity A10",
    b"AF20": "Array Induction Four Foot Resistivity A20",
    b"AF30": "Array Induction Four Foot Resistivity A30",
    b"AF60": "Array Induction Four Foot Resistivity A60",
    b"AF90": "Array Induction Four Foot Resistivity A90",
    b"AFCD": "None",
    b"AFCO": "Array Induction Four Foot Conductivity",
    b"AFD1": "Array Induction Four Foot Inner Diameter Of Invasion",
    b"AFD2": "Array Induction Four Foot Outer Diameter Of Invasion",
    b"AFOO": "Array Induction Four Foot Curves Out Of Order Flag",
    b"AFRD": "Afr Deep Resistivity",
    b"AFRM": "Afr Medium Resistivity",
    b"AFRS": "Afr Shallow Resistivity",
    b"AFRT": "Array Induction Four Foot Rt",
    b"AFRX": "Array Induction Four Foot Rxo",
    b"AFVM": "Array Induction Four Foot Volume Mud Filtrate",
    b"AFXT": "Afr Form Exp Time",
    b"AGRA": "Smoothed Azimuthal Gamma Detector A (Sperry)",
    b"AGRB": "Smoothed Azimuthal Gamma Detector B (Sperry)",
    b"AGRT": "Smoothed Azimuthal Gamma Ray Combined (Sperry)",
    b"AGTM": "Arc Gamma Ray Time After Bit",
    b"AGV1": "None",
    b"AH30": "None",
    b"AH90": "None",
    b"AHMF": "Array Induction Mud Resistivity Fully Calibrated",
    b"AHV": "Ahv Inc",
    b"AHV1": "Annular Volume",
    b"AHVM": "Annular Borehole Volume",
    b"AHVT": "Annular Volume",
    b"AI": "Acoustic Impedance Log [(M/S X G/Cc)/1000]",
    b"AIAV": "Acoustic Impedance Average",
    b"AIBD": "Array Induction Input Borehole Diameter To Ait Processing",
    b"AIBH": "Maximum Theoretical Acoustic Impedance Of Mud",
    b"AIBL": "Minimum Theoretical Acoustic Impedance Of Mud",
    b"AIMN": "Acoustic Impedance Minimum",
    b"AIMP": "Acoustic Impedance",
    b"AIMR": "Array Induction Input Borehole Mud Resistivity To Ait Processing",
    b"AIMX": "Acoustic Impedance Maximum",
    b"AIPD": "13",
    b"AIPN": "12",
    b"AJAM": "(Rt) (Tele675-Iwob) (1) Number Of Anti-Jams Detected",
    b"ALAT": "Alat",
    b"ALT": "Alt",
    b"AM16": "None",
    b"AM3F": "Amplitude 3Ft",
    b"AM5F": "Amplitude 5Ft",
    b"AMAT": "Amat",
    b"AMAX": "Max Energy",
    b"AMCR": "Americium",
    b"AMF": "Array Induction Mud Resistivity Fully Calibrated",
    b"AMIN": "Min Energy",
    b"AMP": "Pipe Amplitude",
    b"AMP1": "Sector #1",
    b"AMP2": "Sector #2",
    b"AMP3": "Cbl 3' Amplitude",
    b"AMP4": "Sector #4",
    b"AMP5": "Cbl 5' Amplitude",
    b"AMP6": "Sector #6",
    b"AMP7": "Sector #7",
    b"AMP8": "Sector #8",
    b"AMPL": "Bhtv Amplitude Array (Alt)",
    b"AMTE": "13",
    b"ANHY": "Lithology (Resampled From 2 Ft Data Step)",
    b"ANIS": "Anisotropy",
    b"ANOR": "Acceleration Computed Norm",
    b"ANSO": "Permeability Anisotropy",
    b"AO10": "Array Induction One Foot Resistivity A10",
    b"AO16": "None",
    b"AO19": "None",
    b"AO20": "Array Induction One Foot Resistivity A20",
    b"AO30": "Array Induction One Foot Resistivity A30",
    b"AO60": "Array Induction One Foot Resistivity A60",
    b"AO90": "Array Induction One Foot Resistivity A90",
    b"AOD1": "Array Induction One Foot Inner Diameter Of Invasion",
    b"AOD2": "Array Induction One Foot Outer Diameter Of Invasion",
    b"AOOO": "Array Induction One Foot Curves Out Of Order Flag",
    b"AORT": "Array Induction One Foot Rt",
    b"AORX": "Array Induction One Foot Rxo",
    b"AOVM": "Array Induction One Foot Volume Mud Filtrate",
    b"AP01": "Smoothed Azimuthal Pe - Bin 1 (Sperry)",
    b"AP02": "Smoothed Azimuthal Pe - Bin 2 (Sperry)",
    b"AP03": "Smoothed Azimuthal Pe - Bin 3 (Sperry)",
    b"AP04": "Smoothed Azimuthal Pe - Bin 4 (Sperry)",
    b"AP05": "Smoothed Azimuthal Pe - Bin 5 (Sperry)",
    b"AP06": "Smoothed Azimuthal Pe - Bin 6 (Sperry)",
    b"AP07": "Smoothed Azimuthal Pe - Bin 7 (Sperry)",
    b"AP08": "Smoothed Azimuthal Pe - Bin 8 (Sperry)",
    b"AP09": "Smoothed Azimuthal Pe - Bin 09 (Sperry)",
    b"AP10": "Smoothed Azimuthal Pe - Bin 10 (Sperry)",
    b"AP11": "Smoothed Azimuthal Pe - Bin 11 (Sperry)",
    b"AP12": "Smoothed Azimuthal Pe - Bin 12 (Sperry)",
    b"AP13": "Smoothed Azimuthal Pe - Bin 13 (Sperry)",
    b"AP14": "Smoothed Azimuthal Pe - Bin 14 (Sperry)",
    b"AP15": "Smoothed Azimuthal Pe - Bin 15 (Sperry)",
    b"AP16": "Smoothed Azimuthal Pe - Bin 16 (Sperry)",
    b"APCT": "None",
    b"APDC": "Aps Near/Array Corrected Dolomite Porosity",
    b"APGC": "Cb Hydraulic System Pressure",
    b"APHI": "None",
    b"APLC": "Aps Near/Array Corrected Limestone Porosity",
    b"APLU": "Aps Near/Array Uncorrected Limestone Porosity",
    b"APLW": "None",
    b"APPC": "Smoothed Processed Caliper (Sperry)",
    b"APQK": "Kb Quartzdyne Gauge Pressure",
    b"APQL": "Lb Quartzdyne Gauge Pressure",
    b"APSC": "Aps Near/Array Corrected Sandstone Porosity",
    b"APTC": "None",
    b"APUW": "None",
    b"AR01": "Smoothed Azimuthal Delta Rho - Bin 1 (Sperry)",
    b"AR02": "Smoothed Azimuthal Delta Rho - Bin 2 (Sperry)",
    b"AR03": "Smoothed Azimuthal Delta Rho - Bin 3 (Sperry)",
    b"AR04": "Smoothed Azimuthal Delta Rho - Bin 4 (Sperry)",
    b"AR05": "Smoothed Azimuthal Delta Rho - Bin 5 (Sperry)",
    b"AR06": "Smoothed Azimuthal Delta Rho - Bin 6 (Sperry)",
    b"AR07": "Smoothed Azimuthal Delta Rho - Bin 7 (Sperry)",
    b"AR08": "Smoothed Azimuthal Delta Rho - Bin 8 (Sperry)",
    b"AR09": "Smoothed Azimuthal Delta Rho - Bin 09 (Sperry)",
    b"AR10": "Smoothed Azimuthal Delta Rho - Bin 10 (Sperry)",
    b"AR11": "Smoothed Azimuthal Delta Rho - Bin 11 (Sperry)",
    b"AR12": "Smoothed Azimuthal Delta Rho - Bin 12 (Sperry)",
    b"AR13": "Smoothed Azimuthal Delta Rho - Bin 13 (Sperry)",
    b"AR14": "Smoothed Azimuthal Delta Rho - Bin 14 (Sperry)",
    b"AR15": "Smoothed Azimuthal Delta Rho - Bin 15 (Sperry)",
    b"AR16": "Smoothed Azimuthal Delta Rho - Bin 16 (Sperry)",
    b"ARBQ": "Smoothed Azimuthal Delta Rho - Bottom Quadrant (Sperry)",
    b"AREA": "Area Of Borehole, None",
    b"ARLQ": "Smoothed Azimuthal Delta Rho - Left Quadrant (Sperry)",
    b"ARRQ": "Smoothed Azimuthal Delta Rho - Right Quadrant (Sperry)",
    b"ARTQ": "Smoothed Azimuthal Delta Rho - Top Quadrant (Sperry)",
    b"ASCA": "Array Induction Sp To Armor Calibrated",
    b"ASFI": "Array Induction Sp Filtered",
    b"AT10": "Array Induction Two Foot Resistivity A10",
    b"AT20": "Array Induction Two Foot Resistivity A20",
    b"AT30": "Array Induction Two Foot Resistivity A30",
    b"AT60": "Array Induction Two Foot Resistivity A60",
    b"AT90": "Array Induction Two Foot Resistivity A90",
    b"ATAV": "Average Attenuation",
    b"ATC1": "Attenuation Pad 1",
    b"ATC2": "Attenuation Pad 2",
    b"ATC3": "Attenuation Pad 3",
    b"ATC4": "Attenuation Pad 4",
    b"ATC5": "Attenuation Pad 5",
    b"ATC6": "Attenuation Pad 6",
    b"ATCA": "Array Induction Array Temperature Calibrated",
    b"ATCE": "Array Induction Cartridge Electronics Temperature",
    b"ATCO": "Array Induction Two Foot Conductivity",
    b"ATD1": "Array Induction Two Foot Inner Diameter Of Invasion(D1)",
    b"ATD2": "Array Induction Two Foot Outer Diameter Of Invasion (D2)",
    b"ATIM": "Accumtime",
    b"ATMN": "Attenuation Minimum",
    b"ATMP": "Arc Annular Temperature",
    b"ATMX": "Attenuation Maximum",
    b"ATOM": "Array Induction Tool Mode",
    b"ATOO": "Array Induction Two Foot Curves Out Of Order Flag",
    b"ATR": "Cdr Attenuation Resistivity",
    b"ATRD": "Attenuation Resistivity Down",
    b"ATRT": "Array Induction Two Foot Rt",
    b"ATRU": "Attenuation Resistivity Up",
    b"ATRX": "Array Induction Two Foot Rxo",
    b"ATSE": "Array Induction Sonde Electronics Temperature",
    b"ATT3": "Cbl 3' Attenuation",
    b"ATTE": "Attenuation Coefficient",
    b"ATTN": "Attenuation",
    b"ATVM": "Array Induction Two Foot Volume Mud Filtrate",
    b"AUX2": "Cartridge Temp",
    b"AUXF": "11",
    b"AUXP": "Auxiliary Pressure, Bit Load",
    b"AV": "Max Annular Velocity",
    b"AVG": "5",
    b"AVGV": "Average Sonic Velocity, Average Seismic Velocity",
    b"AVIR": "Average Radius",
    b"AVMA": "Normalized Average Map Amplitude",
    b"AVOL": "Annular Volume",
    b"AVSS": "None",
    b"AVTX": "None",
    b"AVZ": "Average Impedance",
    b"AWAV": "Amplitude Of Wave Average",
    b"AWMN": "Amplitude Of Wave Minimum",
    b"AWMX": "Amplitude Of Wave Maximum",
    b"AX": "X Acceleration",
    b"AXLE": "Axial Co-Ordinate (East)",
    b"AXLN": "Axial Co-Ordinate (North)",
    b"AY": "Y Acceleration",
    b"AZ": "Z Acceleration",
    b"AZ2": "Azimuth Of Reference Pad (2Nd Orientation Tool)",
    b"AZC": "N/A",
    b"AZD": "N/A",
    b"AZI": "Azimuth",
    b"AZI1": "Pad1 Azimuth",
    b"AZIC": "None",
    b"AZID": "Borehole Azimuth",
    b"AZIM": "Measured Azimuth",
    b"AZIP": "None",
    b"AZM": "Survey Azimuth",
    b"AZMH": "Azimuth",
    b"AZOD": "Azimuth Of Reference Pad",
    b"AZST": "Azimuth Of Reference Pad For Star",
    b"Azi": "Survey Azimuth",
    b"B1TR": "Mrps 1 Resistivity Cell Temperature",
    b"B1TV": "Mrps 1 Strain Gauge Temperature",
    b"BA11": "Calibrated Data Button A11",
    b"BA12": "Calibrated Data Button A12",
    b"BA13": "Calibrated Data Button A13",
    b"BA14": "Calibrated Data Button A14",
    b"BA15": "Calibrated Data Button A15",
    b"BA16": "Calibrated Data Button A16",
    b"BA17": "Calibrated Data Button A17",
    b"BA18": "Calibrated Data Button A18",
    b"BA21": "Calibrated Data Button A21",
    b"BA22": "Calibrated Data Button A22",
    b"BA23": "Calibrated Data Button A23",
    b"BA24": "Calibrated Data Button A24",
    b"BA25": "Calibrated Data Button A25",
    b"BA26": "Calibrated Data Button A26",
    b"BA27": "Calibrated Data Button A27",
    b"BA28": "Calibrated Data Button A28",
    b"BAC1": "Mrps 1 Acquisition Command Echo",
    b"BACK": "11",
    b"BAS1": "Resbaseline",
    b"BASE": "Baselinerho",
    b"BATC": "Smoothed Bi-Modal Acoustic Compressional Slowness (Sperry)",
    b"BATS": "Smoothed Bi-Modal Acoustic Shear Slowness(Sperry Drilling Services), Smoothed Bi-Modal Acoustic Shear Slowness",
    b"BAZI": "Borehole Azimuth (Mag.)",
    b"BB11": "Calibrated Data Button B11",
    b"BB12": "Calibrated Data Button B12",
    b"BB13": "Calibrated Data Button B13",
    b"BB14": "Calibrated Data Button B14",
    b"BB15": "Calibrated Data Button B15",
    b"BB16": "Calibrated Data Button B16",
    b"BB17": "Calibrated Data Button B17",
    b"BB18": "Calibrated Data Button B18",
    b"BB21": "Calibrated Data Button B21",
    b"BB22": "Calibrated Data Button B22",
    b"BB23": "Calibrated Data Button B23",
    b"BB24": "Calibrated Data Button B24",
    b"BB25": "Calibrated Data Button B25",
    b"BB26": "Calibrated Data Button B26",
    b"BB27": "Calibrated Data Button B27",
    b"BB28": "Calibrated Data Button B28",
    b"BBP1": "Mrps 1 Quartz Gauge Nb_Prime Signal Component",
    b"BBRG": "Borehole Polar Co-Ordinate (Bearing)",
    b"BC11": "Calibrated Data Button C11",
    b"BC12": "Calibrated Data Button C12",
    b"BC13": "Calibrated Data Button C13",
    b"BC14": "Calibrated Data Button C14",
    b"BC15": "Calibrated Data Button C15",
    b"BC16": "Calibrated Data Button C16",
    b"BC17": "Calibrated Data Button C17",
    b"BC18": "Calibrated Data Button C18",
    b"BC21": "Calibrated Data Button C21",
    b"BC22": "Calibrated Data Button C22",
    b"BC23": "Calibrated Data Button C23",
    b"BC24": "Calibrated Data Button C24",
    b"BC25": "Calibrated Data Button C25",
    b"BC26": "Calibrated Data Button C26",
    b"BC27": "Calibrated Data Button C27",
    b"BC28": "Calibrated Data Button C28",
    b"BCNF": "Compensated Neutron Far Detector",
    b"BCNN": "Compensated Neutron Near Detector",
    b"BCP1": "Mrps 1 Quartz Gauge Nc_Prime Signal Component",
    b"BD": "Bulk Density",
    b"BD11": "Calibrated Data Button D11",
    b"BD12": "Calibrated Data Button D12",
    b"BD13": "Calibrated Data Button D13",
    b"BD14": "Calibrated Data Button D14",
    b"BD15": "Calibrated Data Button D15",
    b"BD16": "Calibrated Data Button D16",
    b"BD17": "Calibrated Data Button D17",
    b"BD18": "Calibrated Data Button D18",
    b"BD21": "Calibrated Data Button D21",
    b"BD22": "Calibrated Data Button D22",
    b"BD23": "Calibrated Data Button D23",
    b"BD24": "Calibrated Data Button D24",
    b"BD25": "Calibrated Data Button D25",
    b"BD26": "Calibrated Data Button D26",
    b"BD27": "Calibrated Data Button D27",
    b"BD28": "Calibrated Data Button D28",
    b"BDAV": "Average Deep Button Resistivity",
    b"BDIM": "Bulk Density Data Point Indicator",
    b"BDQC": "None",
    b"BDTI": "Job Onbottom Time 2Hz",
    b"BENT": "Lithology (Resampled From 2 Ft Data Step)",
    b"BFHI": "(Borehole) (6In) Borehole Fluid Hydrogen Index",
    b"BFR1": "Mrps 1 Flowline Fluid Resistivity",
    b"BFV": "Bound Fluid Volume",
    b"BGCG": "Abg Combined Gamma Ray",
    b"BGF": "Background Far",
    b"BGN": "Bgd Near",
    b"BH": "Block Height (Sperry)",
    b"BHD": "(Rt) (Drilling_Surface) Borehole Depth",
    b"BHP1": "Mrps 1 Hydraulic Pressure",
    b"BHPR": "Borehole Pressure",
    b"BHRM": "(Borehole) Borehole Mud Resistivity",
    b"BHT": "Bottom Hole Temperature",
    b"BHV": "Bhv",
    b"BHV1": "Borehole Volume",
    b"BHVM": "Borehole Volume",
    b"BHVT": "Borehole Volume",
    b"BI": "Bond Index",
    b"BILI": "Bond Index Level For Zone Isolation, (Mast-B) (6In) Bond Index Level For Zone Isolation",
    b"BIT": "Bit Size",
    b"BIT1": "None",
    b"BLK": "Block Position (Sperry)",
    b"BLKA": "(Rt) (Drilling_Surface) Block Acceleration",
    b"BLKP": "(Rt) (Drilling_Surface) Height Of Block Above Rig Floor",
    b"BLOC": "Block Position (Geoserices)",
    b"BMAV": "Average Medium Button Resistivity",
    b"BMB1": "Mrps 1 Quartz Gauge Nb Signal Component",
    b"BMC1": "Mrps 1 Quartz Gauge Nc Signal Component",
    b"BMIN": "Micro Inverse",
    b"BMK": "(Mast-B) (6In) Bulk Modulus - K",
    b"BMNO": "Micro Normal",
    b"BONB": "On Bottom Stat (1=Off,0=On) 2Hz",
    b"BOXY": "Boxy",
    b"BPC1": "Mrps 1 Quartz Gauge Pressure Compensation",
    b"BPHI": "Best Thermal Neutron Porosity, Average",
    b"BPOS": "Block Position 2Hz",
    b"BQP1": "Mrps 1 Quartz Gauge Pressure",
    b"BQT1": "Mrps 1 Quartz Gauge Temperature",
    b"BR": "Build Rate",
    b"BRAD": "Borehole Polar Co-Ordinate (Radius)",
    b"BRCR": "Break Core Position",
    b"BRDC": "Brd (Cps)",
    b"BREC": "Lithology (Resampled From 2 Ft Data Step)",
    b"BRF1": "Mrps 1 Flowline Resistivity Frequency",
    b"BRG1": "Maximum Error Co-Ordinate (Bearing)",
    b"BRG2": "Maximum Error Co-Ordinate (Bearing)",
    b"BRG3": "Typical Error Co-Ordinate (Bearing)",
    b"BRG4": "Typical Error Co-Ordinate (Bearing)",
    b"BRH1": "Mrps 1 Raw Hydraulic Pressure",
    b"BRQ1": "Mrps 1 Raw Quartz Gauge Pressure",
    b"BRR1": "Mrps 1 Raw Flowline Resistivity",
    b"BRS1": "Mrps 1 Raw Strain Gauge Pressure",
    b"BS": "Bit Size",
    b"BSAV": "Average Shallow Button Resistivity",
    b"BSC1": "Mrps 1 Solenoid Command Echo",
    b"BSCN": "Nphi Boresize Cor",
    b"BSD1": "Hrdd Backscatter Pulse Processing Filter Coefficient",
    b"BSDT": "None",
    b"BSF1": "Mrps 1 Strain Gauge Frequency",
    b"BSG1": "Mrps 1 Strain Gauge Pressure",
    b"BSS1": "Mrps 1 Solenoid Status",
    b"BSW1": "Mrps 1 Status Word",
    b"BSZ": "Bit Size",
    b"BT": "Bit Type",
    b"BTC": "Total Magnetic Field Calc",
    b"BTCS": "Compressional Slowness",
    b"BTI1": "None",
    b"BTIM": "None",
    b"BTLT": "Borehole Tilt",
    b"BTM": "Total Magnetic Field Meas",
    b"BTMP": "Borehole Temp",
    b"BUQC": "Build-Up Quality Curve",
    b"BVEL": "Block Velocity 2Hz",
    b"BVOL": "Borehole Volume",
    b"BVTX": "None",
    b"BVW": "None",
    b"BVWI": "22",
    b"BVWR": "23",
    b"BVWT": "Bulk Volume Water",
    b"BWAV": "Surface Wob Avg",
    b"BX": "Magnetic Field X Meas.",
    b"BXM": "Magnetic Field X Meas.",
    b"BY": "Magnetic Field Y Meas.",
    b"BYM": "Magnetic Field Y Meas.",
    b"BZ": "Magnetic Field Z Meas.",
    b"BZC": "Magnetic Field Z Calc.",
    b"BZM": "Magnetic Field Z Meas.",
    b"Bear": "Bearing (Degrees)",
    b"Bit": "Bit Size",
    b"Blk": "Block Position (Sperry)",
    b"Bloc": "Block Position",
    b"Boxy": "Survey Boxy",
    b"Bx": "Survey Bx",
    b"By": "Survey By",
    b"Bz": "Survey Bz",
    b"C02": "C02",
    b"C1": "Caliper 1",
    b"C13": "Caliper Arms 1 & 3",
    b"C14": "C14",
    b"C2": "Caliper 2",
    b"C24": "Caliper Arms 2 & 4",
    b"C25": "C25",
    b"C3": "None",
    b"C36": "C36",
    b"C4": "None",
    b"C44": "Elastic Stress Coeff C44",
    b"C5": "None",
    b"C55": "Elastic Stress Coeff C55",
    b"C66": "Elastic Stress Coeff C66",
    b"CADF": "Microlog Caliper",
    b"CAL": "Caliper",
    b"CAL1": "Cal1",
    b"CAL2": "Cal2",
    b"CAL3": "Cal3",
    b"CAL4": "Cal4",
    b"CAL5": "Cal5",
    b"CAL6": "Cal6",
    b"CAL7": "Cal6, Cal7",
    b"CAL8": "Caliper Radius 8, Cal8",
    b"CAL9": "Cal9",
    b"CALA": "Caliper From 3104 Or 1233 With Other Calipers In String, Caliper",
    b"CALC": "Calcium Capture",
    b"CALD": "Litho Caliper (Diameter)",
    b"CALE": ", None",
    b"CALF": "None",
    b"CALI": "Caliper",
    b"CALL": "Lower Lock Arm Caliper",
    b"CALM": "Micro Spherically Focused Tool (Mst-Da) Caliper (Diameter)",
    b"CALN": "Compensated Neutron Caliper (Diameter)",
    b"CALS": "Sonic Caliper",
    b"CALW": "Average Diameter From All Pad Pairs",
    b"CALX": "Upper Diametric Caliper (Cal1-5)",
    b"CALY": "Y-Axis Cal",
    b"CAP": "Capacitance",
    b"CAP1": "Capacitance1",
    b"CAP2": "Capacitance2",
    b"CAPD": "Density Caliper",
    b"CAV": "Check Level Based Average Velocity Log",
    b"CBA": "Gembarium",
    b"CBD": "Casing - Driller",
    b"CBF1": "Cmr Bound Fluid Volume For T2 Cutoff 1",
    b"CBF2": "Cmr Bound Fluid Volume For T2 Cutoff 2",
    b"CBF3": "Cmr Bound Fluid Volume For T2 Cutoff 3",
    b"CBF4": "Cmr Bound Fluid Volume For T2 Cutoff 4",
    b"CBF5": "Cmr Bound Fluid Volume For T2 Cutoff 5",
    b"CBF6": "Cmr Bound Fluid Volume For T2 Cutoff 6",
    b"CBF7": "Cmr Bound Fluid Volume For T2 Cutoff 7",
    b"CBFS": "None",
    b"CBL": "Cement Bond Log",
    b"CBL5": "None",
    b"CBLF": "None",
    b"CBP1": "Cmr Bin Porosity 1",
    b"CBP2": "Cmr Bin Porosity 2",
    b"CBP3": "Cmr Bin Porosity 3",
    b"CBP4": "Cmr Bin Porosity 4",
    b"CBP5": "Cmr Bin Porosity 5",
    b"CBP6": "Cmr Bin Porosity 6",
    b"CBP7": "Cmr Bin Porosity 7",
    b"CBP8": "Cmr Bin Porosity 8",
    b"CBSL": "None",
    b"CBT1": "T1 Cutoff For Bound Por.",
    b"CBT2": "T2 Cutoff For Bound Por.",
    b"CBVI": "Mrilt2Pirrct",
    b"CC1": "Comp. Semblance 0 ( Rec#1 - Rec#2 )",
    b"CC2": "Comp. Semblance 1 ( Rec#2 - Rec#3 )",
    b"CC3": "Comp. Semblance 2 ( Rec#3 - Rec#4 )",
    b"CCA": "Gemcalcium",
    b"CCA1": "None",
    b"CCAC": "Gemcacorrected",
    b"CCHL": "Gemchlorine",
    b"CCL": "Casing Collar Locator",
    b"CCLD": "Ccl Discriminated Amplitude",
    b"CCLG": "Casing Collar Locator",
    b"CCLU": "Casing Collar Locator Ultrasonic",
    b"CCRE": "8, 3",
    b"CCS2": "Confined Compressive Strength At Confining Pressure 2",
    b"CCS3": "Confined Compressive Strength At Confining Pressure 3",
    b"CCS4": "Confined Compressive Strength At Confining Pressure 4",
    b"CCS5": "Confined Compressive Strength At Confining Pressure 5",
    b"CCSW": "None",
    b"CD": "Compensated Density",
    b"CDE1": "None",
    b"CDF": "Calibrated Downhole Force",
    b"CDH": "Hals Computed Hole Diameter",
    b"CDL": "Density Porosity",
    b"CDPH": "Deep Phase Conductivity From 2 Mhz Freq",
    b"CDTF": "Compensated Sonic Delta Time (Us/Foot)",
    b"CF90": "In Conductivity 4Ft Res",
    b"CFDP": "None",
    b"CFE": "Gemiron",
    b"CFEC": "Corrected Far Epithermal Neutron",
    b"CFF1": "Cmr Free Fluid For T2 Cutoff 1",
    b"CFF2": "Cmr Free Fluid For T2 Cutoff 2",
    b"CFF3": "Cmr Free Fluid For T2 Cutoff 3",
    b"CFF4": "Cmr Free Fluid For T2 Cutoff 4",
    b"CFF5": "Cmr Free Fluid For T2 Cutoff 5",
    b"CFF6": "Cmr Free Fluid For T2 Cutoff 6",
    b"CFF7": "Cmr Free Fluid For T2 Cutoff 7",
    b"CFGR": "(Edtc-B) (6In) Gamma Ray Correction Coefficient",
    b"CFTC": "Corrected Far Thermal Counts",
    b"CFVL": "Memorized Fluid Acoustic Slowness",
    b"CGD": "Gemgadolinium",
    b"CGDC": "Gemgdcorrected",
    b"CGK1": "None",
    b"CGR": "Ngs Computed Gamma-Ray (Thorium + Potassium), Computed Gamma Ray From Thorium, Uranium, And Potassium",
    b"CGX1": "None",
    b"CGXT": "Mcg External Temperature",
    b"CGY1": "None",
    b"CGZ1": "None",
    b"CH": "Gemhydrogen",
    b"CHAD": "Characteristic Caliper Diameter",
    b"CHDE": "1",
    b"CHI": "Goodness Of Fit Of Each Echo Data Packet",
    b"CHI1": "Detector 1 Chi-Squared",
    b"CHI2": "Detector 2 Chi-Squared",
    b"CHIR": "None",
    b"CHIS": "Chisquareelefit",
    b"CHR1": "Label Peak Coherence, Receiver Array - Lower Dipole, Peak Coherence, Receiver Array - Lower Dipole",
    b"CHR2": "Peak Coherence, Receiver Array - Upper Dipole",
    b"CHR3": "Label Peak Coherence, Receiver Array - Monopole Stoneley",
    b"CHRA": "Coherence At Compressional Peak For The Receiver Array",
    b"CHRP": "Label Peak Coherence, Receiver Array, Compressional - Monopole P&S",
    b"CHRS": "Label Peak Coherence, Receiver Array, Shear - Monopole P&S",
    b"CHT": "Cable Head Tension",
    b"CHT1": "Label Peak Coherence, Transmitter Array - Lower Dipole",
    b"CHT2": "Label Peak Coherence, Transmitter Array - Upper Dipole",
    b"CHT3": "Label Peak Coherence, Transmitter Array - Monopole Stoneley",
    b"CHTA": "Coherence At Compressional Peak For The Transmitter Array",
    b"CHTF": "Cable Head Tension",
    b"CHTP": "Label Peak Coherence, Transmitter Array, Compressional - Monopole P&S",
    b"CHTS": "Label Peak Coherence, Transmitter Array, Shear - Monopole P&S",
    b"CHV": "Cablehead Voltage",
    b"CHVS": "None",
    b"CI": "Swdp Crossover Indicator",
    b"CIDP": "16",
    b"CIL1": "Cil1",
    b"CILD": "None",
    b"CILM": "Dil Medium Conductivity",
    b"CIMP": "17",
    b"CIV": "Check Level Based Interval Velocity Log",
    b"CK": "Gempotassium",
    b"CKC": "Gemkcorrected",
    b"CL": "Amount Of Chlorides",
    b"CL15": "Adn Ultrasonic Caliper Along Axis 1 And 5",
    b"CL37": "Adn Ultrasonic Caliper Along Axis 3 And 7",
    b"CL3A": "None",
    b"CLDC": "Density Caliper",
    b"CLF": "8, None",
    b"CLL3": "Dil Shallow Conductivity",
    b"CLLD": "None",
    b"CLOS": "8",
    b"CMCU": "Coring Motor Current",
    b"CMDV": "Coring Motor Downhole Voltage",
    b"CMFF": "Cmr Free Fluid",
    b"CMG": "Gemmagnesium",
    b"CMGC": "Gemmgcorrected",
    b"CMLP": "Coring Motor Linear Position",
    b"CMN": "Gemmanganese",
    b"CMNC": "Gemmncorrected",
    b"CMPR": "Coring Motor Pressure",
    b"CMRP": "Cmr Porosity",
    b"CMT1": "T1 Cutoff For Cbw Por.",
    b"CMT2": "T2 Cutoff For Cbw Por.",
    b"CMV": "Cablehead Motor Voltage",
    b"CN": "Compensated Neutron",
    b"CN01": "Cn01",
    b"CN02": "Cn02",
    b"CN03": "Cn03",
    b"CN1": "Cn1",
    b"CN2": "Cn2",
    b"CNA": "Gemsodium",
    b"CNAD": "Cn Anhydritic Dolomite Porosity",
    b"CNC": "Corrected Neutron Porosity From Cn",
    b"CNC1": "Cnc1",
    b"CNC2": "Cnc2",
    b"CNCD": "Borehole Size Corrected Dolomite Compensated Neu Porosity",
    b"CNCF": "Field Normalized Compensated Neutron Porosity",
    b"CNCL": "Borehole Size Corrected Limestone Compensated Neu Porosity",
    b"CNDL": "None",
    b"CNEC": "Corrected Near Epithermal Counts",
    b"CNL": "Cnl, Compensated Neutron Porosity",
    b"CNLN": "Cnln",
    b"CNLS": "None",
    b"CNPH": "None",
    b"CNS": "Neutron Porosity",
    b"CNSS": "None",
    b"CNST": "None",
    b"CNS]": "None",
    b"CNTC": "Corrected Near Thermal Counts",
    b"CO2": "Carbon Dioxide",
    b"CO2R": "(Mifa-Nd) (0.3S) Ratio Of Co2 Partial Density To Partial Density Of Hydrocarbon + Co2, (Mifa-Nd) Ratio Of Co2 Partial Density To Partial Density Of Hydrocarbon + Co2",
    b"CO90": "In Conductivity 1Ft Res",
    b"COAL": "Coal, Lithology, Lithology (Resampled From 2 Ft Data Step), % Lithology (Resampled From 2 Ft Data Step) **Merged**, Lithology (Resampled From 2 Ft Data Step) **Merged**",
    b"COEF": "Smoothed Geopilots Rpm Variation Coefficient (Sperry)",
    b"COF2": "Smoothness",
    b"COF3": "Model Constraint",
    b"COF4": "Delta-Rho",
    b"COMB": "Bat Processed_Combined Shear_Insite Read, Bat Processed_Combshearuncert_Insite Read",
    b"COMP": "Den Compensation",
    b"CON": "Connection 1=Conn 3= Csng Pt 4=Trip",
    b"COND": "Cond",
    b"CONG": "Lithology",
    b"CORC": "None",
    b"CORE": "Intervals (Resampled From 2 Ft Data Step)",
    b"CORM": "Densitycorrneg",
    b"CORP": "Densitycorrpos",
    b"CORR": "Bat Processed_Corr Interface_Insite Read, Bat Processed_Corr Int Uncert_Insite Read, Correlation Log",
    b"CORS": "Core Switch Status",
    b"COUN": "Compensated Neutron Porosity From Lsn And Ssn",
    b"CP": "Closing Pressure",
    b"CPD": "None",
    b"CPG": "Closure Stress Gradient",
    b"CPHI": "None",
    b"CPHU": "12",
    b"CPON": "10",
    b"CPR1": "Corrected Pr1",
    b"CPR2": "Corrected Pr2",
    b"CPRE": "None",
    b"CPTE": "11",
    b"CPTH": "13",
    b"CPTP": "Corrected Ptpr",
    b"CPTV": "Cumulative Pump-Through Volume",
    b"CQ": "14",
    b"CRB1": "None",
    b"CRC1": "Borehole Corrected Conductivity 1 (Real)",
    b"CRC2": "Borehole Corrected Conductivity 2 (Real)",
    b"CRC3": "Borehole Corrected Conductivity 3 (Real)",
    b"CRC4": "Borehole Corrected Conductivity 4 (Real)",
    b"CRC5": "Borehole Corrected Conductivity 5 (Real)",
    b"CRC6": "Borehole Corrected Conductivity 6 (Real)",
    b"CRC7": "Borehole Corrected Conductivity 7 (Real)",
    b"CRPM": "Collar Rotational Speed",
    b"CRSX": "Core Switch Position",
    b"CRT": "Correction",
    b"CRV": "Check Level Based Rms Velocity Log",
    b"CS": "Cable Speed",
    b"CSGP": "3",
    b"CSGW": "Casing Size",
    b"CSHO": "22",
    b"CSI": "Gemsilicon",
    b"CSIC": "Gemsicorrected",
    b"CSUC": "Gemsucorrected",
    b"CSUL": "Gemsulphur",
    b"CT": "True Formation Conductivity",
    b"CT90": "In Conductivity 2Ft Res",
    b"CT91": "In Conductivity 2Ft Res",
    b"CTAF": "Array Ind. Four Cond Ct",
    b"CTAO": "Array Ind. One Cond Ct",
    b"CTAS": "Array Ind. Six Cond Ct",
    b"CTE1": "None",
    b"CTEM": "Cartridge Temperature",
    b"CTF": "Selected Cont Fit",
    b"CTH": "Array Ind Hi Cond Ct",
    b"CTI": "Gemtitanium",
    b"CTIC": "Gemticorrected",
    b"CTO": "Array Ind One Cond Ct",
    b"CTSB": "Ctsb Errors",
    b"CTT1": "None",
    b"CUPE": "None",
    b"CURV": "Sample No., Depth (M), Uncalibrated Acoustic Log (Us/M), Calibrated Acoustic Log (Us/M)",
    b"CUST": "Custom Data",
    b"CUT": "Cut",
    b"CV": "Max Critical Velocity",
    b"CVEL": "Cable Velocity",
    b"CVOL": "Cement Volume",
    b"CW1": "Casing Weight",
    b"CXC1": "Borehole Corrected Conductivity 1 (Imag)",
    b"CXC2": "Borehole Corrected Conductivity 2 (Imag)",
    b"CXC3": "Borehole Corrected Conductivity 3 (Imag)",
    b"CXC4": "Borehole Corrected Conductivity 4 (Imag)",
    b"CXC5": "Borehole Corrected Conductivity 5 (Imag)",
    b"CXC6": "Borehole Corrected Conductivity 6 (Imag)",
    b"CXC7": "Borehole Corrected Conductivity 7 (Imag)",
    b"CXO": "Flushed Zone Conductivity",
    b"CYQ": "Cycle Quality",
    b"CZMD": "Acoustic Impedance Of Mud",
    b"Cal": "Caliper",
    b"Clay": "Lithology (Resampled From 2 Ft Data Step), % Lithology (Resampled From 2 Ft Data Step)",
    b"D/W": "Drill Or Wipe",
    b"D1": "None",
    b"D2": "None",
    b"D3": "None",
    b"DAL": "Dryrockalwf",
    b"DALP": "None",
    b"DATA": "14",
    b"DATE": "None",
    b"DATN": "Discriminated Attenuation",
    b"DAZ": "Deviation Azimuth",
    b"DAZ2": "Deviation Azimuth (Second Orientation Tool)",
    b"DAZC": "N/A",
    b"DAZD": "N/A",
    b"DAZW": "Deviation Azimuth For Wgi",
    b"DB1": "Dip Button 1",
    b"DB1A": "Dip Button 1A",
    b"DB2": "Dip Button 2",
    b"DB2A": "Dip Button 2A",
    b"DB3": "Dip Button 3",
    b"DB3A": "Dip Button 3A",
    b"DB4": "Dip Button 4",
    b"DB4A": "Dip Button 4A",
    b"DBCA": "None",
    b"DBHC": "Density Borehole Correction",
    b"DBI": "Discriminated Bond Index",
    b"DBTM": "Bit Depth",
    b"DCA": "Dryrockcawf",
    b"DCAL": "None",
    b"DCAV": "Density Caliper, Average",
    b"DCBL": "Discriminated Synthetic Cbl",
    b"DCHO": "Density Caliper, Horizontal",
    b"DCID": "3",
    b"DCIM": "4",
    b"DCMS": "Dc Motor Status",
    b"DCMV": "Dc Motor Voltage",
    b"DCNT": "Data Count",
    b"DCOR": "Density Correction",
    b"DCRN": "Near Density Counts",
    b"DCSI": "(Mast-B) (2In) Sonic Waveform Data Copy Indicator",
    b"DCUR": "Dark Current",
    b"DCVE": "Density Caliper, Vertical",
    b"DDA": "Differential Dip Azimuth",
    b"DDAX": "Ddsr-Dgr Average X",
    b"DDAY": "Ddsr-Dgr Average Y",
    b"DDAZ": "Ddsr-Dgr Average Z",
    b"DDDA": "Ddsr-Dgr Delta Average",
    b"DDIP": "Differential Dip Angle",
    b"DDLL": "Deep Laterolog",
    b"DDOL": "Dry Weight % Dolomite",
    b"DDPX": "Ddsr-Dgr Peak X",
    b"DDPY": "Ddsr-Dgr Peak Y",
    b"DDPZ": "Ddsr-Dgr Peak Z",
    b"DDQR": "7",
    b"DDV": "Drawdown Volume",
    b"DEAD": "Oil Show (Resampled From 2 Ft Data Step)",
    b"DECL": "10",
    b"DECS": "11",
    b"DELI": "11",
    b"DELT": "None",
    b"DEN": "Compensated Density",
    b"DEN1": "Den1",
    b"DEN2": "Den2",
    b"DEN3": "Den3",
    b"DENS": "Average Mud Density In (Bhi)",
    b"DEP": "Depth",
    b"DEP1": "None",
    b"DEPC": "Corrected Depth",
    b"DEPT": "Depth",
    b"DEQF": "7",
    b"DERS": "12",
    b"DEV": "Deviation",
    b"DEV2": "Deviation (2Nd Orientation Tool)",
    b"DEVC": "N/A",
    b"DEVD": "N/A",
    b"DEVI": "Deviation",
    b"DEVS": "None",
    b"DEVW": "Deviation At Wgi Position",
    b"DF": "Uncalibrated Downhole Force",
    b"DFD": "Drilling Fluid Density",
    b"DFE": "Dryrockfewf",
    b"DFI": "None",
    b"DFL": "Digitialy Focused Laterolog",
    b"DFPH": "Drilling Fluid Ph",
    b"DFS": "Full Scale Data",
    b"DFT": "Type Of Fluid In Hole",
    b"DFV": "Drilling Fluid Viscosity",
    b"DGA": "None",
    b"DGD": "Dryrockgdwf",
    b"DGK1": "None",
    b"DGR": "Dgr Combined Gamma Ray",
    b"DGRC": "Dgr Combined Gamma Ray",
    b"DGV1": "None",
    b"DGX1": "None",
    b"DGY1": "None",
    b"DGZ1": "None",
    b"DHAP": "Downhole Annulus Pressure",
    b"DHAT": "(Rm) (Arc[1]) (6In) Downhole Annulus Temperature, Downhole Annulus Temperature",
    b"DHC": "N/A",
    b"DHTN": "Ch Tension",
    b"DHVF": "None",
    b"DI": "Deep Induction",
    b"DI0": "None",
    b"DI26": "Imager Diameter 2 - 6",
    b"DI48": "Imager Diameter 4 - 8",
    b"DI90": "None",
    b"DIFF": "None",
    b"DIHV": "13",
    b"DILL": "Dry Weight % Illite",
    b"DIND": "None",
    b"DIP1": "Pad 1 Average Data Of Buttons 11, 12, 13, 14",
    b"DIP2": "Pad 2 Average Data Of Buttons 11, 12, 13, 14",
    b"DIP3": "Pad 3 Average Data Of Buttons 11, 12, 13, 14",
    b"DIP4": "Pad 4 Average Data Of Buttons 11, 12, 13, 14",
    b"DIP5": "Pad 5 Average Data Of Buttons 11, 12, 13, 14",
    b"DIP6": "Pad 6 Average Data Of Buttons 11, 12, 13, 14",
    b"DIPC": "None",
    b"DIPI": "Formation Dip Computed From Images.",
    b"DIPQ": "Dip Quality",
    b"DIPS": "Dip Status As Defined By The Image Interpreter.",
    b"DIRS": "Bat Processed_Dirshearslownss_Insite Read, Bat Processed_Dirshear Uncert_Insite Read",
    b"DI_2": "Diameter Of Invasion 2Ft Vertical Resolution",
    b"DI_4": "Depth Of Invasion 4Ft Vertical Resolution, Diameter Of Invasion 4Ft Vertical Resolution",
    b"DK": "Dryrockkwf",
    b"DK1": "None",
    b"DLCL": "Caliper",
    b"DLCS": "None",
    b"DLDC": "Density Correction",
    b"DLDN": "Bulk Density",
    b"DLDP": "Logged By Ha On 940812. Digitized By Ha On 940912., Logged By Ha On 920919. Digitized By Ha On 921009., Logged By Sc On 930221. Digitized By Sc On 930311., Logged By Sc On 870216. Digitized By Ad On 870313., Logged By Sc On 930312. Digitized By Sc On 930415., Logged By Ha On 920908. Digitized By Ha On 930204., Logged By Sc On 920213. Digitized By Sc On 920304., Logged By Ha On 921222. Digitized By Ha On 940118.",
    b"DLGR": "Gamma Ray",
    b"DLIM": "Denphilime",
    b"DLOD": "Cable Head Tension, None",
    b"DLPE": "Photo-Electric Effect",
    b"DLS": "Dog-Leg Severity",
    b"DLT": "None",
    b"DLTN": "????????",
    b"DMEA": "Hole Depth",
    b"DMG": "Dryrockmgwf",
    b"DMN": "Dryrockmnwf",
    b"DMRP": "Density - Magnetic Resonance Porosity",
    b"DMV": "15",
    b"DNPH": "Delta Thermal Neutron Porosity",
    b"DO": "None",
    b"DOL": "Lithology (Resampled From 2 Ft Data Step)",
    b"DOLO": "Dolomite Volume",
    b"DP": "Lithology Density Porosity",
    b"DPAP": "Apparent Dip Magnitude",
    b"DPAZ": "True Dip Azimuth",
    b"DPE": "Pecorr",
    b"DPE1": "Dpe1",
    b"DPGN": "Delta Pressure Gradient For Noninvaded Formations",
    b"DPH1": "Dph1",
    b"DPH2": "Dph2",
    b"DPH8": "Hrdd High Resolution Density Porosity",
    b"DPHD": "Denphidolo",
    b"DPHI": "Density Porosity",
    b"DPHL": "Density Limestone Porosity",
    b"DPHS": "Denphisand",
    b"DPHZ": "Hrdd Standard Resolution Density Porosity",
    b"DPL": "None",
    b"DPL1": "5",
    b"DPL2": "6",
    b"DPLS": "Lithology Density Porosity (Matrix Density 2.71 G/Cc)",
    b"DPO": "Lds Density Porosity",
    b"DPO1": "Dpo1",
    b"DPOR": "None",
    b"DPRD": "Dolomite Density Por.",
    b"DPRL": "Limestone Density Por.",
    b"DPRS": "Sandstone Density Por.",
    b"DPSM": "Dpsm[0]",
    b"DPSS": "Lithology Density Porosity (Matrix Density 2.65 G/Cc)",
    b"DPSX": "Dpsx[0]",
    b"DPSY": "Dpsy[0]",
    b"DPTH": "Depth",
    b"DPTR": "Dip Trend, True Dip Magnitude",
    b"DPX": "Lithology Density Porosity (High Resolution Filter)",
    b"DPYR": "Dry Weight % Pyrite",
    b"DRH": "Lds Bulk Density Correction",
    b"DRH1": "Drh1",
    b"DRH2": "Densitycorrnevr, Drh2",
    b"DRH3": "Densitycorrevr",
    b"DRHB": "Bulk Density Correction, Bottom",
    b"DRHL": "Bulk Density Correction, Left",
    b"DRHO": "Densitycorr",
    b"DRHR": "Bulk Density Correction, Right",
    b"DRHU": "Bulk Density Correction, Up",
    b"DRLL": "1",
    b"DROH": "None",
    b"DRTA": "Depth Derivative Of Raw Talp",
    b"DSG": "None",
    b"DSI": "Dryrocksiwf",
    b"DSLL": "Shallow Laterolog",
    b"DSO8": "Hrdd High Resolution Density Standoff",
    b"DSOZ": "Hrdd Standard Resolution Density Standoff",
    b"DST": "Intervals (Resampled From 2 Ft Data Step)",
    b"DSUL": "Dryrocksuwf",
    b"DT": "None",
    b"DT01": "Dt01",
    b"DT1": "Delta-T Shear - Lower Dipole",
    b"DT1R": "Delta-T Shear, Receiver Array - Lower Dipole",
    b"DT1T": "Delta-T Shear, Transmitter Array - Lower Dipole",
    b"DT2": "Delta-T Shear - Upper Dipole",
    b"DT24": "Slowness Over 24-Inch Interval",
    b"DT2R": "Delta-T Shear, Receiver Array - Upper Dipole",
    b"DT2T": "Delta-T Shear, Transmitter Array - Upper Dipole",
    b"DT31": "Single Transmitter Delta T (3-1)",
    b"DT35": "-5' Compensated Sonic",
    b"DT3R": "Delta-T Stoneley, Receiver Array - Monopole Stoneley",
    b"DT3T": "Delta-T Stoneley, Transmitter Array - Monopole Stoneley",
    b"DT42": "Single Transmitter Delta T (4-2)",
    b"DT46": "-6' Compensated Sonic",
    b"DT4P": "Delta-T Compressional - Monopole P&S",
    b"DT4S": "Delta-T Shear - Monopole P&S",
    b"DT5": "Delta-T Compressional, Ddbhc - Fmd",
    b"DT57": "Depth Derived Delta T 5Ft - 7Ft",
    b"DTBC": "Delta-T Compressional Borehole Compensated (Depth Derived)",
    b"DTC": "Compressional",
    b"DTC1": "-5 Ft Compensated Sonic, Dtc1",
    b"DTCC": "Alhi Corrected Compressional Slowness",
    b"DTCF": "Dtcf",
    b"DTCM": "Delta T Compensated",
    b"DTCO": "Delta-T Compressional",
    b"DTCP": "Predicted Compressional Slowness, Smoothed Bat Processed Compressional Slowness (Sperry), Smoothed Compressional Slowness (Sperry)",
    b"DTD": "None",
    b"DTDL": "N/A",
    b"DTE1": "Dte1",
    b"DTEM": "14",
    b"DTEN": "Delta Tension",
    b"DTFS": "Fast Shear Dt",
    b"DTHC": "Delta T High Res. Compensated",
    b"DTHM": "Delta-T High Frequency - Memory",
    b"DTHX": "Delta-T High Frequency",
    b"DTI": "Dryrocktiwf",
    b"DTIM": "Smoothed Bat Processed Interface Mode Slowness (Sperry)",
    b"DTL": "Delta T Long Spacing",
    b"DTLF": "Sonic Long Travel Time",
    b"DTLM": "Delta-T Low Frequency - Memory",
    b"DTLN": "Sonic Transit Time",
    b"DTLX": "Delta-T Low Frequency",
    b"DTM": "Delta T Long Compressional",
    b"DTMD": "Delta-T Mud",
    b"DTMN": "Minimal Slowness",
    b"DTMP": "Delta Temperature",
    b"DTMX": "Maximal Slowness",
    b"DTP": "None",
    b"DTPM": "Delta T Compressional, Delta-T - Compressional",
    b"DTQC": "Values Changed Using Text_Edit",
    b"DTRA": "Delta-T Compressional From Receiver Array",
    b"DTRP": "Delta-T Compressional, Receiver Array - Monopole P&S",
    b"DTRR": "Deep True Resolution Resistivity",
    b"DTRS": "Delta-T Shear, Receiver Array - Monopole P&S",
    b"DTS": "Dts",
    b"DTSC": "None",
    b"DTSD": "Shear Wave Slowness From Dipole Pick",
    b"DTSE": "Predicted Shear Slowness",
    b"DTSF": "Dtsf",
    b"DTSM": "Delta-T Shear",
    b"DTSP": "Smoothed Bat Processed Shear Slowness (Sperry)",
    b"DTSS": "Slow Shear Dt",
    b"DTST": "Delta-T Stoneley - Monopole Stoneley",
    b"DTSX": "Shear Slowness Xx, Dipole Shear Xx Slowness, Dtsx",
    b"DTSY": "Shear Slowness Yy",
    b"DTTA": "Delta-T Compressional From Transmitter Array",
    b"DTTP": "Delta-T Compressional, Transmitter Array - Monopole P&S",
    b"DTTS": "Delta-T Shear, Transmitter Array - Monopole P&S",
    b"DTXX": "Wave Xx Flexural",
    b"DTYY": "Wave Yyflexural",
    b"DT_1": "6",
    b"DT_U": "None",
    b"DUNI": "None",
    b"DV0": "None",
    b"DV1": "None",
    b"DV90": "None",
    b"DVIS": "Dead Oil Viscosity",
    b"DVP1": "Mrps 1 Probe Depth",
    b"DWAL": "Dry Weight Fraction Pseudo Aluminum",
    b"DWCA": "Dry Weight Fraction Calcium",
    b"DWFE": "Dry Weight Fraction Iron + 0.14 Aluminum",
    b"DWGD": "Dry Weight Fraction Gadolinium",
    b"DWPQ": "Dry Weight % Quartz",
    b"DWSI": "Dry Weight Fraction Silicon",
    b"DWSU": "Dry Weight Fraction Sulfur",
    b"DWTI": "Dry Weight Fraction Titanium",
    b"DX1": "None",
    b"DXC": "Corrected Drilling Exponent",
    b"DXDT": "Dipxdeltat",
    b"DXT2": "Z Accelerometer (Fast) Time",
    b"DXTM": "Dxtm",
    b"DY1": "None",
    b"DYDT": "Dipydeltat",
    b"DZ1": "None",
    b"DZER": "Zero Data",
    b"Dept": "Ground Surface",
    b"Dr": "1",
    b"Dril": "Bit Hours",
    b"Dxc": "Drilling Exponent",
    b"E-WD": "E-W Departure (Metres)",
    b"E/W": "E/W Departure, Departure East/West, E/W",
    b"EADI": "None",
    b"EAPW": "Ept Attenuation Plane Wave Equivalent",
    b"EAST": "Easting",
    b"EATT": "Ept Log Attenuation, Eatt",
    b"EB1": "Mrsc 1 Error Band",
    b"EB2": "Mrsc 2 Error Band",
    b"EB3": "Mrsc 3 Error Band",
    b"ECC": "Eccentricity, Hals Computed Eccentering",
    b"ECCE": "Amplitude Of Eccentering",
    b"ECD": "Equivalent Circulating Density",
    b"ECGR": "Gamma-Ray",
    b"ECLP": "Pressure Emergency Close Reservoir",
    b"ECST": "Ecs Temperature",
    b"ED": "East Departure",
    b"EDD1": "Edd1",
    b"EDD2": "Edd2",
    b"EDD3": "Edd3",
    b"EDD4": "Edd4",
    b"EDD5": "Edd5",
    b"EDD6": "Edd6",
    b"EDDT": "End Of Run Date",
    b"EDLI": "Denphilimeevr",
    b"EDP": "Ewr Deep Phase Res",
    b"EDPD": "Denphidoloevr",
    b"EDPE": "13",
    b"EDPH": "Denphievr, Evr Density Porosity",
    b"EDPS": "Denphisandevr",
    b"EGR": "Egr",
    b"EHD1": "(Ppc-B[1]) (6In) Enhanced Hole Diameter 1 (Ellipse-Based Algorithm)",
    b"EHD2": "(Ppc-B[1]) (6In) Enhanced Hole Diameter 2 (Ellipse-Based Algorithm)",
    b"EHGR": "Hires Gamma-Ray",
    b"EHM8": "Confidence On High Resolution Mudcake Thickness",
    b"EHMR": "Confidence On Mudcake Thickness",
    b"EHMZ": "Confidence On Standard Resolution Mudcake Thickness",
    b"EI": "Emex Current",
    b"ELEV": "None",
    b"EMC2": "Ecs Marquardt Chi-Squared",
    b"EMMR": "Real Part Phasor Voltage",
    b"EMMX": "Imaginary Part Phasor Voltage",
    b"EMU": "N/A",
    b"EMW": "Pwd Equivalent Mud Weight (Sperry)",
    b"ENGI": "Recorded By",
    b"ENLI": "Neuporlimeevr",
    b"ENPD": "Neupordoloevr",
    b"ENPH": "Epithermal Neutronporosity",
    b"ENPS": "Neuporsandevr",
    b"ENRA": "None",
    b"EOFF": "29, 41, None",
    b"EPDC": "Electromagnetic Propagation Dielectric Constant",
    b"EPE": "Peevr, Evr Photo-Electric Factor",
    b"EPE8": "Confidence On High Resolution Formation Photoelectric Factor",
    b"EPEZ": "Confidence On Standard Resolution Formation Photoelectric Factor",
    b"EPHI": "Effective Porosity (External Source)",
    b"EPOR": "7",
    b"EPR": "None",
    b"EPSD": "17",
    b"EPTF": "None",
    b"EPTW": "None",
    b"ERAV": "External Radii Average",
    b"ERD1": "Erd1",
    b"ERD2": "Erd2",
    b"ERD3": "Erd3",
    b"ERD4": "Erd4",
    b"ERD5": "Erd5",
    b"ERD6": "Erd6",
    b"ERE1": "Est Resistivity",
    b"ERES": "Est Resistivity",
    b"ERHO": "Densityevr",
    b"ERMC": "Confidence On Standoff Zone Resistivity",
    b"ERO8": "Confidence On High Resolution Formation Density",
    b"EROZ": "Confidence On Standard Resolution Formation Density",
    b"ERPO": "Errpotassium",
    b"ERTC": "Errorgammakt",
    b"ERTH": "Errthorium",
    b"ERTO": "Errorgammatotal",
    b"ERUR": "Erruranium",
    b"ERXO": "Confidence On Invaded Zone Resistivity",
    b"ESAT": "Ecs Spectrum Acquisition Time",
    b"ESD": "(Rt) (Arc[1]) (6In) Equivalent Static Density",
    b"ESDT": "Ecs Dead Time Count Rate",
    b"ESTF": "None",
    b"ETH1": "C2 Out",
    b"ETIM": "Elapsed Time",
    b"EULC": "Feul_C",
    b"EV": "(Fbst-B) (0.1In) Emex Voltage",
    b"EVEN": "Oil Show (Resampled From 2 Ft Data Step)",
    b"EW": "Departure East/West",
    b"EWDD": "Ewr Data Density",
    b"EWVS": "Ewr Vertical Section",
    b"EWXT": "Ewr Formation Exp Time",
    b"EX": "9",
    b"EY": "10",
    b"F1": "Far 1",
    b"F16": "10",
    b"F1B1": "F1B1",
    b"F2B1": "F2B1",
    b"F3B1": "F3B1",
    b"F4B1": "F4B1",
    b"F5": "8",
    b"F5B1": "F5B1",
    b"F6B1": "F6B1",
    b"F9": "9",
    b"FANG": "Fang1",
    b"FAR": "10",
    b"FB1": "Fb1",
    b"FB10": "Fb10",
    b"FB2": "Fb2",
    b"FB3": "Fb3",
    b"FB4": "Fb4",
    b"FB5": "Fb5",
    b"FB6": "Fb6",
    b"FB7": "Fb7",
    b"FB8": "Fb8",
    b"FB9": "Fb9",
    b"FB91": "Fb91",
    b"FB92": "Fb92",
    b"FB93": "Fb93",
    b"FB94": "Fb94",
    b"FB95": "Fb95",
    b"FB96": "Fb96",
    b"FBAC": "12",
    b"FBCR": "(Fbst-E) (0.1In) Correlation Resistance",
    b"FBGA": "(Fbst-B) (0.1In) Electronic Gain",
    b"FCAX": "High Resolution X Acceleration",
    b"FCAY": "High Resolution Y Acceleration",
    b"FCAZ": "High Resolution Z Acceleration",
    b"FCBL": "None",
    b"FCCL": "(Cal-Ya) (1In) Casing Collar Pip",
    b"FCCP": "Mfc Caliper",
    b"FCD": "Future Casing Diameter",
    b"FCD1": "Fcd1",
    b"FCD2": "Fcd2",
    b"FCD3": "Fcd3",
    b"FCNL": "None",
    b"FCOL": "(Mifa-Nd) (0.3S) Fluid Coloration, (Mifa-Nd) Fluid Coloration",
    b"FCPS": "Dsn Far Counts",
    b"FDC": "Fdc, Compensated Formation Density Porosity",
    b"FDEC": "Fardensitycorr",
    b"FDEP": "22",
    b"FDSN": "Dsn Far Counts",
    b"FE": "None",
    b"FEFC": "Shallow Fe (Phase Corr.)",
    b"FEFE": "Shallow Fe",
    b"FEP1": "None",
    b"FEP2": "None",
    b"FERR": "Fitting Error",
    b"FET": "Awr Formation Exposure Time",
    b"FF": "Formation Factor, (Borehole) (6In) Formation Factor",
    b"FFDC": "None",
    b"FFLS": "None",
    b"FFP": "Formation Factor Plot",
    b"FFSS": "None",
    b"FFV": "(Cmrt-B) (7.5In) Free Fluid Volume",
    b"FGHA": "P Fast Gas Hydrcbn",
    b"FHPG": "3",
    b"FHPS": "Fps Hyd Press",
    b"FINC": "Magnetic Field Inclination",
    b"FLAG": "Smoothed Bat Processed Shear Flag (Sperry)",
    b"FLI0": "(Mifa-Nd) Fluorescence Intensity 0, (Mifa-Nd) (0.3S) Fluorescence Intensity 0",
    b"FLI1": "(Mifa-Nd) Fluorescence Intensity 1, (Mifa-Nd) (0.3S) Fluorescence Intensity 1",
    b"FLOW": "Smoothed Total Flow In (Sperry)",
    b"FLR": "(Mifa-Nd) (0.3S) Fluorescence Reflection, (Mifa-Nd) Fluorescence Reflection",
    b"FLS": "None",
    b"FLSA": "Flag For Low Sonic Amplitude, (Mast-B) (6In) Flag For Low Sonic Amplitude",
    b"FLT1": "Flow Temp Diff",
    b"FLT2": "Fluid Temp Diff",
    b"FLTM": "Fluid Temperature",
    b"FLU": "Fluoresence",
    b"FMAG": "None",
    b"FNOB": "Far Borehole Pop",
    b"FNOF": "Far Formation Pop",
    b"FNOR": "Magnetic Field Computed Norm",
    b"FOR1": "None",
    b"FORM": "Litholog",
    b"FPAD": "Packer Extend Pressure",
    b"FPRE": "Formation Press",
    b"FR": "Shallow-Focussed Resistivity",
    b"FRAM": "None",
    b"FRAT": "(Mifa-Nd) (0.3S) Fluorescence Ratio, (Mifa-Nd) Fluorescence Ratio",
    b"FRSA": "Rpm Surface Avg",
    b"FS1": "Fs1",
    b"FS10": "Fs10",
    b"FS2": "Fs2",
    b"FS3": "Fs3",
    b"FS4": "Fs4",
    b"FS5": "Fs5",
    b"FS6": "Fs6",
    b"FS7": "Fs7",
    b"FS8": "Fs8",
    b"FS9": "Fs9",
    b"FS91": "Fs91",
    b"FS92": "Fs92",
    b"FS93": "Fs93",
    b"FS94": "Fs94",
    b"FS95": "Fs95",
    b"FS96": "Fs96",
    b"FSIG": "Formation Sigma",
    b"FSPA": "Spp Avg",
    b"FSS": "None",
    b"FSTP": "Neutron Log, Corrected For Temp, Form Sal, Pressure. (Sperry)",
    b"FTAA": "Torque Abs Avg",
    b"FTAU": "14",
    b"FTD": "21",
    b"FTDT": "21",
    b"FTIM": "Fast Channels Acquisition Time",
    b"FTVP": "14",
    b"FTVZ": "15",
    b"FVD": "None",
    b"FVR": "None",
    b"FVU": "None",
    b"FX": "Magnetometer X-Axis",
    b"FY": "Magnetometer Y-Axis",
    b"FY2W": "Factor From Yield To Weight",
    b"FZ": "Magnetometer Z-Axis",
    b"Flow": "Mud Flow In",
    b"G/R": "None",
    b"G1": "Gamma Api",
    b"GAIN": "Gain Or Loss",
    b"GAMM": "Gamma, Gamma_Ray",
    b"GAPI": "Gr",
    b"GAS": "% = 100 Units Wits From Totco.",
    b"GASS": "Total Gas Sensor",
    b"GAT": "Accelerometer Temperature",
    b"GAUR": "None",
    b"GCF1": "Detector 1 Gain Correction Factor",
    b"GCF2": "Detector 2 Gain Correction Factor",
    b"GCFF": "Gaincorrfactor",
    b"GCGR": "Uranium Stripped Gamma",
    b"GCSL": "Mcl C. Collar Locator",
    b"GD": "7",
    b"GDEV": "Hgns Hole Deviation From Gravity",
    b"GDX1": "None",
    b"GDY1": "None",
    b"GDZ1": "None",
    b"GFX1": "None",
    b"GFY1": "None",
    b"GFZ1": "None",
    b"GG": "N/A",
    b"GGCE": "Mcg Bh Corrected Gamma",
    b"GGCF": "Gemgaincorrfact",
    b"GGME": "Borehole Corr. Mgs Gamma",
    b"GHC": "Gemhybridcarbon",
    b"GHD": "Borehole Diameter, (Borehole) (6In) Borehole Diameter",
    b"GHID": "(Borehole) (6In) Generalized Hole Inside Diameter",
    b"GHO": "Gemhybridoxygen",
    b"GK1": "Gamma Ray",
    b"GKCL": "Gamma Kcl",
    b"GKUT": "Gamma Kut",
    b"GL": "Guard",
    b"GMSG": "Msg Gate Center",
    b"GMT": "Magnetometer Temperature",
    b"GOBO": "Good Bond",
    b"GOCF": "Gemoffscorrfact",
    b"GOR": "(Mifa-Nd) Gas Oil Ratio, (Mifa-Nd) (0.3S) Gas Oil Ratio",
    b"GOXY": "Goxy",
    b"GR": "Gamma Ray",
    b"GR01": "Gr01",
    b"GR02": "Gr02",
    b"GR03": "Gr03",
    b"GR04": "Gr04",
    b"GR05": "Gr05",
    b"GR06": "Gr06",
    b"GR07": "Gr07",
    b"GR1": "Gr1",
    b"GR11": "Gr11",
    b"GR12": "Gr12",
    b"GR2": "Gr2",
    b"GR21": "Gr21",
    b"GR3": "Gr3",
    b"GR4": "Gr4",
    b"GR5": "Gr5",
    b"GR6": "Gr6",
    b"GR7": "Gr7",
    b"GRAN": "Lithology",
    b"GRB": "Curve # 15",
    b"GRBX": "None",
    b"GRC": "Gamma Api Corrected",
    b"GRCA": "Awr Calibrated Gamma",
    b"GRCF": "None",
    b"GRCO": "Natural Gamma Corrected",
    b"GRD": "None",
    b"GRDF": "Gemresodegrfact",
    b"GRDI": "Dis Gamma Ray",
    b"GRE": "4",
    b"GREV": "Gamma Evr",
    b"GREZ": "Global Reconstruction Error - Standard Resolution",
    b"GRF": "N/A",
    b"GRGC": "Gamma Ray",
    b"GRGM": "Mgs Gamma Ray",
    b"GRHV": "Gamma Ray High Voltage",
    b"GRIM": "Gamma Ray Data Point Indicator",
    b"GRK": "Gamma Potassium",
    b"GRKC": "2",
    b"GRKT": "Gamma Kt",
    b"GRM1": "Mwd Gr(Tm) 2Hz",
    b"GRMA": "Gamma Ray, Average",
    b"GRML": "Curve # 21",
    b"GRP": "Gamma Ray - Api Units",
    b"GRPD": "Pns Gamma Ray",
    b"GRPM": "Smoothed Geopilot Revolutions Per Minute (Sperry)",
    b"GRPO": "Potassium Gamma",
    b"GRR": "None",
    b"GRS": "None, Gamma-Ray Uranium Free",
    b"GRSG": "Sgs Gamma Ray",
    b"GRSL": "Gamma Ray From 1329 Spectrum",
    b"GRSX": "6",
    b"GRTC": "Gammakt",
    b"GRTH": "Thorium Gamma",
    b"GRTO": "Gammatotal",
    b"GRUR": "Uranium Gamma",
    b"GRVS": "Pcg Vertical Section",
    b"GRX": "Gamma Ray (High Resolution) - Api Units",
    b"GRX1": "None",
    b"GRY1": "None",
    b"GRZ1": "None",
    b"GR_1": "8",
    b"GR_2": "9",
    b"GR_C": "None",
    b"GR_K": "Potassium Weight Fraction",
    b"GR_M": "Gamma Ray (Slb-Wl To 1800M,Slb-Lwd 1800M To Td)",
    b"GR_N": "2",
    b"GR_R": "11, 12,",
    b"GR_U": "Uranium Concentration",
    b"GSF": "19",
    b"GSGC": "Sgs Bh Corrected Gamma",
    b"GSGR": "Gamma Ray",
    b"GSK": "????????",
    b"GST": "????????",
    b"GSTH": "Thorium",
    b"GSTK": "????????",
    b"GSUR": "Uranium",
    b"GSX1": "None",
    b"GSXT": "Mgs External Temperature",
    b"GSY1": "None",
    b"GSZ1": "None",
    b"GTEM": "Generalized Borehole Temperature",
    b"GUAD": "None",
    b"GUAR": "Guard, Guard Log",
    b"GURD": "None",
    b"GWR": "Bc1 Intvl Gc Gwr",
    b"GX": "Gravity X",
    b"GY": "Gravity Y",
    b"GYP": "Lithology (Resampled From 2 Ft Data Step)",
    b"GZ": "Gravity Z",
    b"Gas": "Total Gas Units (1% Methane=100 Chart Divisions), None, Total Gas, Gas Wits From Totco",
    b"Goxy": "Survey Goxy",
    b"Gx": "Survey Gx",
    b"Gy": "Survey Gy",
    b"Gz": "Survey Gz",
    b"H2S": "Average H2S Sensor 1, Lag H2S Mud Avg",
    b"HAFF": "(Mifa-Nd) Highly Absorbing Fluid Flag, (Mifa-Nd) (0.3S) Highly Absorbing Fluid Flag",
    b"HALC": "Aps High Resolution Near/Array Corrected Limestone Porosity",
    b"HALP": "None",
    b"HARD": "Hardness",
    b"HART": "Hals Computed True Resistivity",
    b"HAZ": "Z-Axis Acceleration",
    b"HAZI": "Hole Azimuth",
    b"HBHK": "Hngs Borehole Potassium Concentration",
    b"HCAF": "(Mifa-Nd) Hydrocarbon Composition Algorithm Flag, (Mifa-Nd) (0.3S) Hydrocarbon Composition Algorithm Flag",
    b"HCAL": "Hrcc Cal. Caliper",
    b"HCAW": "(Mifa-Nd) Hydrocarbon Composition Algorithm Weight, (Mifa-Nd) (0.3S) Hydrocarbon Composition Algorithm Weight",
    b"HCFT": "Hires Corrected Far Thermal Count Rate Sc",
    b"HCGR": "Hngs Computed Gamma Ray",
    b"HCNT": "Hires Corrected Near Thermal Count Rate Sc",
    b"HCQI": "(Mifa-Nd) Hydrocarbon Quality Indicator, (Mifa-Nd) (0.3S) Hydrocarbon Quality Indicator",
    b"HD": "Hole Diameter",
    b"HDA": "Hole Deviation Azimuth",
    b"HDAR": "Hole Diameter From Area",
    b"HDBQ": "Smoothed Azimuthal Bulk Density - Bottom Quadrant (Sperry)",
    b"HDC1": "Mrhy 1 Duty Cycle",
    b"HDCN": "High Res Deep Conductivity, Hri Deep Conductivity",
    b"HDEN": "Vectar Processed Density",
    b"HDEP": "Hole Depth",
    b"HDEV": "Hole Deviation",
    b"HDI": "Hals Computed Diameter Of Invasion",
    b"HDIA": "Hole Diameter",
    b"HDLQ": "Smoothed Azimuthal Bulk Density - Left Quadrant (Sperry)",
    b"HDPH": "Hires Density Porosity",
    b"HDRA": "Hrdd Density Correction",
    b"HDRB": "Difference Between Bulk Density (Rhoz) And Apparent Density From Back Scatter Monosensor Inversion (Rhba)",
    b"HDRH": "Hires Bulk Density Corr.",
    b"HDRQ": "Smoothed Azimuthal Bulk Density - Right Quadrant (Sperry)",
    b"HDRS": "High Res Deep Resistivity",
    b"HDRT": "Hires Depth Derivative Of Raw Htal",
    b"HDRX": "Mcfl B0 Correction Factor",
    b"HDTH": "Hole Depth 2Hz",
    b"HDTQ": "Smoothed Azimuthal Bulk Density - Top Quadrant (Sperry)",
    b"HEHV": "Helium High Voltage",
    b"HESC": "Hesc",
    b"HET": "Electronic Temperature",
    b"HET1": "Mrhy 1 Elapsed Pumping Time",
    b"HEXR": "(Mifa-Nd) Ratio Of C6+ Partial Density To Partial Density Of Hydrocarbon + Co2, (Mifa-Nd) (0.3S) Ratio Of C6+ Partial Density To Partial Density Of Hydrocarbon + Co2",
    b"HFK": "Hngs Formation Potassium Concentration",
    b"HGR": "High Resolution Gamma Ray",
    b"HHP1": "Mrhy 1 Hydraulic Pressure",
    b"HHPS": "Hps Hyd Press",
    b"HI": "Hydrogen Index",
    b"HIG": "Estimated Hi Of Gas",
    b"HKLA": "(Rt) (Drilling_Surface) Average Hookload",
    b"HKLD": "Measured Hookload 2Hz",
    b"HKLI": "Hookload",
    b"HLAZ": "7",
    b"HLDU": "Hals Uncorrected Laterolog Deep Resistivity",
    b"HLGU": "Hals Uncorrected Laterolog Groningen Resistivity",
    b"HLLD": "Hals Laterolog Deep Resistivity",
    b"HLLE": "Hals Electrical Standoff",
    b"HLLG": "Hals Laterolog Groningen Resistivity",
    b"HLLS": "Hals Laterolog Shallow Resistivity",
    b"HLSU": "Hals Uncorrected Laterolog Shallow Resistivity",
    b"HMC1": "Mrhy 1 Motor Current",
    b"HMCN": "6, Hmcn",
    b"HMCU": "Hydraulic Motor Current",
    b"HMDV": "Hydraulic Motor Downhole Voltage",
    b"HMIN": "Mcfl Micro Inverse Resistivity",
    b"HMNO": "Mcfl Micro Normal Resistivity",
    b"HMOB": "Horizontal Mobility",
    b"HMRS": "High Res Medium Resistivity",
    b"HMS1": "Mrhy 1 Motor Speed",
    b"HNPO": "High Resolution Enhanced Thermal Neutron Porosity In Selected Lithology",
    b"HO": "8, 22",
    b"HOL1": "Mrhy 1 Oil Level",
    b"HORD": "Horizontal Hole Diameter",
    b"HPEF": "Hires Photoelectric Factor",
    b"HPF": "9",
    b"HPGD": "10",
    b"HPGP": "11",
    b"HPOS": "Hook Position",
    b"HPPR": "Hydraulic Pump Pressure",
    b"HPR1": "Mrhy 1 Raw Hydraulic Pressure",
    b"HPRA": "Hrdd Photoelectric Factor Correction",
    b"HPRE": "Press Hydraulic",
    b"HPT": "13",
    b"HPV1": "Mrhy 1 Hydraulic Pump Output Volume",
    b"HRD1": "Hrd1, Long Space Counts (140-200 Kev)",
    b"HRD2": "Hrd2, Long Space Counts (200-540 Kev)",
    b"HRD3": "Hrd3",
    b"HRD4": "Hrd4",
    b"HRDC": "Hrd (Cps)",
    b"HRDU": "Hals Uncorrected High Resolution Deep Resistivity",
    b"HREU": "Hals Uncorrected High Resolution Electrical Standoff",
    b"HRHO": "Hires Bulk Density",
    b"HRI": "Hydrocarbon Resistivity Index",
    b"HRLD": "Hals High Resolution Deep Resistivity",
    b"HRLE": "Hals High Resolution Electrical Standoff",
    b"HRLS": "Hals High Resolution Shallow Resistivity",
    b"HRM": "Hals Mud Resistivity",
    b"HRMD": "Hals Deep Based Mud Resistivity",
    b"HRSU": "Hals Uncorrected High Resolution Shallow Resistivity",
    b"HS": "Hydrocarbon Fluorescence",
    b"HS31": "Mrhy 1 Solenoid 3 Status",
    b"HSGR": "Hngs Standard Gamma Ray",
    b"HSIG": "Aps High Resolution Formation Capture Cross-Section",
    b"HSO": "Hals Sonde Computed Standoff",
    b"HSO1": "Mrhy 1 Solenoid Status",
    b"HTAL": "Hires Thermal Alpha Factor",
    b"HTEM": "Htc Temperature",
    b"HTEN": "9",
    b"HTHO": "Hngs Formation Thorium Concentration",
    b"HTNP": "Hires Thermal Neutron Porosity",
    b"HTPR": "Hngs Thorium/Potassium Ratio",
    b"HTSG": "Sgs Eht 2",
    b"HTUR": "Hngs Thorium/Uranium Ratio",
    b"HUPR": "Hngs Uranium/Potassium Ratio",
    b"HURA": "Hngs Formation Uranium Concentration",
    b"HV": "Head Voltage",
    b"HVFB": "High Voltage Feedback",
    b"HVOL": "Hole Volume",
    b"HVTD": "22",
    b"HYPB": "Hydraulic Power Pressure",
    b"HYPR": "Hydrostatic Pr",
    b"IAP1": "Azimuth Of Reference",
    b"IAZI": "Borehole Azimuth (Mag.)",
    b"IAZT": "Borehole Azimuth (True)",
    b"IBRT": "Gst Bit Resistivity, Real Time",
    b"IC4": "Iso-Butane From Gas Chromatograph (Bhi-Sdl Ic4)",
    b"IC5": "Iso Pentane From Gas Chromatograph (Bhi-Sdl Ic5)",
    b"ICA": "Geminelcalcium",
    b"ICV": "Integrated Cement Volume",
    b"ID00": "None",
    b"ID90": "None",
    b"IDAV": "None",
    b"IDDR": "Image Derived Density Correction",
    b"IDDS": "None",
    b"IDFL": "Logged By Ha On 920908. Digitized By Ha On 930204.",
    b"IDGR": "Gamma Ray",
    b"IDID": "Deep Induction",
    b"IDIM": "Medium Induction",
    b"IDL3": "Focussed Resistivity",
    b"IDLL": "Focussed Resistivity",
    b"IDMV": "None",
    b"IDPE": "Image Derived Photoelectric Factor",
    b"IDPH": "Induction Deep Phasor Resistivity",
    b"IDQF": "5",
    b"IDRO": "Image Derived Density",
    b"IDSF": "Logged By Sc On 930221. Digitized By Sc On 930311., Logged By Sc On 870216. Digitized By Sc On 870714.",
    b"IDSP": "Spontaneous Potential",
    b"IDTN": "????????",
    b"IDUV": "None",
    b"IDWD": "Borehole Depth As Measured By The Idw (Integrated Depth Wheel)",
    b"IECX": "Mie Caliper X",
    b"IECY": "Mie Caliper Y",
    b"IFBA": "14",
    b"IFE": "Geminelairon",
    b"IFRE": "13",
    b"IGAV": "Gst Gamma Ray, Real Time",
    b"IGNE": "Lithology (Resampled From 2 Ft Data Step)",
    b"IHV": "Integrated Hole Volume",
    b"IIRD": "20",
    b"IIRM": "22",
    b"IIXD": "21",
    b"IIXM": "23",
    b"ILD": "Deep Induction Resistivity",
    b"ILD1": "Ild1",
    b"ILD2": "Ild2",
    b"ILD4": "Induction Deep Resistivity Four Foot",
    b"ILDU": "None",
    b"ILLI": "Illite Volume",
    b"ILM": "Phased Medium Induction Resistivity",
    b"ILM1": "Ilm1",
    b"ILM2": "Ilm2",
    b"ILM4": "Induction Medium Resistivity Four Foot",
    b"ILS": "None",
    b"IMAM": "None",
    b"IMAV": "None",
    b"IMAX": "Mie Accelerometer X",
    b"IMAY": "Mie Accelerometer Y",
    b"IMEA": "18",
    b"IMGX": "Mie Magnetometer X",
    b"IMGY": "Mie Magnetometer Y",
    b"IMGZ": "Mie Magnetometer Z",
    b"IMPH": "Induction Medium Phasor Resistivity",
    b"IMQF": "6",
    b"IMUV": "None",
    b"INC": "Inclination",
    b"INCL": "(Wlworkflow) Hole Inclination",
    b"INCP": "None",
    b"IND": "Induction",
    b"INDB": "5",
    b"INRT": "Gst Arc Resistivity, Real Time",
    b"INT": "Bat Processed_Int Mode Uncert_Insite Read",
    b"INTG": "Integrater",
    b"INTM": "Bat Processed_Intmode Slownss_Insite Read",
    b"INTT": "Interval Transit Time",
    b"INTV": "Average Interval Sonic Velocity, Average Interval Velocity",
    b"IOS": "None",
    b"IPBA": "15",
    b"IPGR": "Logged By Sc On 920213. Digitized By Sc On 920304.",
    b"IPID": "Logged By Sc On 920213. Digitized By Sc On 920303., Logged By Sc On 870216. Digitized By Sc On 870714.",
    b"IPIM": "Logged By Sc On 920213. Digitized By Sc On 920303., Logged By Sc On 870216. Digitized By Sc On 870714.",
    b"IPOR": "Integrated Porosity, (Cmrt-B) (7.5In) Integrated Porosity",
    b"IPSD": "19",
    b"IPSF": "Logged By Sc On 920213. Digitized By Sc On 920304.",
    b"IPSP": "Logged By Sc On 920213. Digitized By Sc On 920304.",
    b"IPTN": "Logged By Sc On 920213. Digitized By Sc On 920304.",
    b"IRAV": "Internal Radius Averaged Value",
    b"IRDA": "22",
    b"IRDN": "12",
    b"IRDP": "11",
    b"IRDZ": "10",
    b"IRHO": "None",
    b"IRMA": "20",
    b"IRMN": "Internal Radius Minimum Value",
    b"IRMP": "19",
    b"IRMX": "Internal Radius Maximum Value",
    b"IRMZ": "18",
    b"ISI": "Geminelsilicon",
    b"ITLT": "Borehole Tilt",
    b"ITMP": "Instrtemp",
    b"ITT": "None",
    b"ITT1": "Itttotal",
    b"ITTC": "Itt From Calibrated Sonic Log (Ms Below Srd)",
    b"ITTI": "Ittinc",
    b"ITTT": "Itttotal",
    b"IWF1": "3",
    b"IWF2": "4",
    b"IXDN": "16",
    b"IXDP": "15",
    b"IXDZ": "14",
    b"IXID": "Deep Induction",
    b"IXMN": "2",
    b"IXMP": "23",
    b"IXMZ": "22",
    b"Inc": "Inclination, Survey Inclination",
    b"K": "Potassium Content",
    b"KA": "8",
    b"KAAV": "9",
    b"KAL": "Gemk-Alintefer",
    b"KC": "Potassium Content, Borehole Corrected",
    b"KCA": "Gemk-Caintefer",
    b"KF1": "5",
    b"KF2": "6",
    b"KF3": "7",
    b"KFE": "Gemk-Feintefer",
    b"KFRA": "13",
    b"KFSI": "12",
    b"KGD": "Gemk-Gdintefer",
    b"KHC": "Hydrocarbon Bulk Modulus",
    b"KINT": "Predicted Permeability",
    b"KMG": "Gemk-Mgintefer",
    b"KMN": "Gemk-Mnintefer",
    b"KN1": "2",
    b"KN2": "3",
    b"KN3": "4",
    b"KS": "Gemk-Sintefer",
    b"KSDR": "Permeability From Cmr - Sdr Model",
    b"KSI": "Gemk-Siintefer",
    b"KSIG": "23",
    b"KTAU": "10",
    b"KTH": "Potassium Plus Thorium",
    b"KTHC": "Stripped Potassium-Thorium, Borehole Corrected",
    b"KTI": "Gemk-Tiintefer",
    b"KTIM": "Permeability From Cmr - Timur Model",
    b"KTRA": "11",
    b"KUF1": "9",
    b"KUN1": "8",
    b"LA": "None",
    b"LAT": "Lateral",
    b"LAT1": "Lat1",
    b"LATR": "None",
    b"LAV": "Average Velocity Derived From Uncalibrated Sonic Log",
    b"LAVC": "Average Velocity Derived From Calibrated Sonic Log",
    b"LC01": "Lc01 Local Comp",
    b"LCAL": "Lds Caliper",
    b"LCCT": "None",
    b"LCOR": "Lithology Density Correction",
    b"LDEN": "Lithology Density",
    b"LDLS": "None",
    b"LDSS": "None",
    b"LEGS": "(Mifa-Nd) Live Fluid Aanalyzer Equivalent Green Shade, (Mifa-Nd) (0.3S) Live Fluid Aanalyzer Equivalent Green Shade",
    b"LGHX": "Lag Gas Hydrcbn Max",
    b"LGRD": "None",
    b"LHEW": "High Energy Window From Long Spacing",
    b"LHR": "Bc1 Intvl Gc Lhr",
    b"LHVD": "None",
    b"LIME": "Lithology",
    b"LITH": "Lithology Description From Lithology Cuttings Editor",
    b"LIV": "Interval Velocity Derived From Uncalibrated Sonic Log",
    b"LIVC": "Interval Velocity Derived From Calibrated Sonic Log",
    b"LKMX": "13",
    b"LL": "None",
    b"LL-3": "None",
    b"LL01": "Ll01",
    b"LL1": "Ll1",
    b"LL16": "Lateralog",
    b"LL3": "Laterolog 3",
    b"LL3R": "None",
    b"LL8": "None",
    b"LL8U": "Ll8U",
    b"LLD": "Laterolog Deep Resistivity",
    b"LLD1": "Latero-Log Deep (Resistivity)",
    b"LLDF": "Deep Laterolog (Filtered)",
    b"LLG": "Gronigen Laterolog Resistivity",
    b"LLG3": "None",
    b"LLGF": "Groningen Laterolog (Filtered)",
    b"LLL3": "Focussed Resistivity",
    b"LLS": "Shallow Laterolog",
    b"LLSF": "Shallow Laterolog (Filtered)",
    b"LLW1": "Litho Long Spaced Window 1",
    b"LLW2": "Litho Long Spaced Window 2",
    b"LLW3": "Litho Long Spaced Window 3",
    b"LLW4": "Litho Long Spaced Window 4",
    b"LLW5": "Litho Long Spaced Window 5",
    b"LLW6": "Litho Long Spaced Window 6",
    b"LLW7": "Litho Long Spaced Window 7",
    b"LLW8": "Litho Long Spaced Window 8",
    b"LM": "None",
    b"LMD": "Limestone Device",
    b"LMST": "Lithology (Resampled From 2 Ft Data Step)",
    b"LN": "Ln",
    b"LN16": "Long Normal 16, Long Normal 16\"",
    b"LNFG": "20",
    b"LONO": "Lo N (Ohmm)",
    b"LOOP": "Calibration Loop Amplitude",
    b"LPCT": "None",
    b"LRAW": "None",
    b"LRES": "None",
    b"LRV": "Rms Velocity Derived From Uncalibrated Sonic Log",
    b"LRVC": "Rms Velocity Derived From Calibrated Sonic Log",
    b"LS": "Hmi Cable Speed",
    b"LS01": "Ls01",
    b"LS1": "Ls1",
    b"LSAM": "18",
    b"LSD": "Cdl Long Spaced Counts",
    b"LSD1": "Hrdd Long-Spacing Pulse Processing Filter Coefficient",
    b"LSDC": "Lsd (Cps)",
    b"LSDP": "None",
    b"LSHV": "None",
    b"LSN": "Lsn",
    b"LSN1": "Lsn1",
    b"LSN2": "Lsn2",
    b"LSP1": "Line Speed",
    b"LSPD": "Line Speed",
    b"LSRH": "None",
    b"LSS": "6",
    b"LSW1": "Litho Short Spaced Window 1",
    b"LSW2": "Litho Short Spaced Window 2",
    b"LSW3": "Litho Short Spaced Window 3",
    b"LSW4": "Litho Short Spaced Window 4",
    b"LSW5": "Litho Short Spaced Window 5",
    b"LSW6": "Litho Short Spaced Window 6",
    b"LSW7": "Litho Short Spaced Window 7",
    b"LSW8": "Litho Short Spaced Window 8",
    b"LSWI": "Limit Switch",
    b"LTEN": "Surface Line Tension",
    b"LTT1": "Long Transit Time 1",
    b"LTT2": "Long Transit Time 2",
    b"LTT3": "Long Transit Time 2",
    b"LTT4": "Long Transit Time 4",
    b"LU": "None",
    b"LU1": "None",
    b"LU2": "None",
    b"LURH": "None",
    b"LWTO": "Window Total From Long Spacing",
    b"LXOM": "Multilaterolog Inversion Length Of Invasion",
    b"M": "None",
    b"M2R6": "None",
    b"M2RX": "Deep Induction",
    b"MAGQ": "Mag Qual",
    b"MAGX": "X Magnetometer",
    b"MAGY": "Y Magnetometer",
    b"MAGZ": "Z Magnetometer",
    b"MAL": "Gemaluminum-Unc",
    b"MARK": "None",
    b"MATC": "Mmr Caliper",
    b"MATF": "Matf",
    b"MBA": "Gembarium-Unc",
    b"MBC1": "Mrms 1 Bottle Valve Command Echo",
    b"MBHK": "Hngs (Hbhk - Sbhk)",
    b"MBS1": "Mrms 1 Bottle Valve Status",
    b"MBTC": "Mmr Caliper",
    b"MBVI": "Mr Irreducible Fluids",
    b"MCA": "Gemcalcium-Unc",
    b"MCA1": "Mca1",
    b"MCAL": "None",
    b"MCBW": "T2 Clay Bound Porosity",
    b"MCDT": "Compressional Delta T Rt",
    b"MCGR": "Hngs (Hcgr - Scgr)",
    b"MCHL": "Gemchlorine-Unc",
    b"MCNL": "Micronormal - 2\"",
    b"MCST": "Rmc Temperature",
    b"MD": "Depth",
    b"MDEP": "Measured Depth, 2",
    b"MDIA": "Mud Density In",
    b"MDM2": "None",
    b"MDM3": "Mdm3",
    b"MDOA": "Mud Density Out",
    b"MDT": "Monodeltat",
    b"MDT2": "Mdt Filtered",
    b"ME": "Micro Normal 2\"",
    b"MEB1": "Mrms 1 Error Band",
    b"MEGR": "Gamma Ray",
    b"MEL1": "Micro Inverse 1\"",
    b"MEL2": "Curve # 16, None, Micro Inverse Resistivity",
    b"MELC": "Melcal",
    b"META": "Lithology (Resampled From 2 Ft Data Step)",
    b"MFE": "Gemiron-Unc",
    b"MFI": "Flow In Pumps Average (Bhi)",
    b"MFII": "Flow In",
    b"MFIN": "Flow In",
    b"MFK": "Hngs (Hfk - Sfk)",
    b"MFOP": "Flow Out Percent",
    b"MFST": "Rmf Temperature",
    b"MGD": "Gemgadolini-Unc",
    b"MH": "Gemhydrogen-Unc",
    b"MHC": "Gemhybrcarb-Unc",
    b"MHO": "Gemhybroxy-Unc",
    b"MI": "None",
    b"MICA": "Geminelacal-Unc",
    b"MID1": "Mid1",
    b"MIDD": "Midd",
    b"MIFE": "Gemineliron-Unc",
    b"MIMA": "Normalized Minimum Map Amplitude",
    b"MIN": "Time In Minutes",
    b"MIN1": "Min1",
    b"MIN2": "Min2",
    b"MIN3": "Min3",
    b"MIN4": "Min4",
    b"MIND": "Medium Induction",
    b"MINM": "Minm",
    b"MINV": "Micro-Inverse",
    b"MISI": "Geminelasil-Unc",
    b"MK": "Gempotassiu-Unc",
    b"ML": "????????, Microlog - Microinverse 1.5\"",
    b"ML01": "????????",
    b"ML1": "Ml1",
    b"ML2": "Ml2",
    b"MLA1": "Mla1",
    b"MLAT": "Mlat",
    b"MLAV": "Mult-Lo (Beam Cur) Average",
    b"MLC1": "Rtex Shallow Resistivity 1, Adaptive Borehole Correction",
    b"MLC2": "Rtex Shallow Resistivity 2, Adaptive Borehole Correction",
    b"MLC3": "Rtex Medium Resistivity 3, Adaptive Borehole Correction",
    b"MLC4": "Rtex Deep Resistivity 4, Adaptive Borehole Correction",
    b"MLL": "None",
    b"MLP1": "Mrms 1 Lower Valve Position",
    b"MLR": "Mult-Lo (Beam Cur)",
    b"MLTC": "Mml Caliper",
    b"MMDC": "Depth Of Corrected Magnetic Marks",
    b"MMDD": "Distance Between Magnetic Marks",
    b"MMDR": "Mxmndiffavgrho",
    b"MMG": "Gemmagnesiu-Unc",
    b"MMK": "Minute Mark",
    b"MMN": "Gemmanganes-Unc",
    b"MMR1": "Mmr1",
    b"MMR2": "Mmr2",
    b"MMR3": "Mmr3",
    b"MMRK": "Minute Mark",
    b"MN": "None",
    b"MNA": "Gemsodium-Unc",
    b"MNI": "Minimum Inclination",
    b"MNID": "Minimum Inclination Depth",
    b"MNO": "None",
    b"MNO1": "Mno1",
    b"MNO3": "Mno3",
    b"MNO4": "Mno4",
    b"MNOR": "Microlognormal",
    b"MNRL": "Micro-Normal",
    b"MNZ": "Minimum Impedance",
    b"MP1": "Mineral Proportion, Min-1",
    b"MP2": "Mineral Proportion, Min-2",
    b"MP3": "Mineral Proportion, Min-3",
    b"MP4": "Mp4",
    b"MP5": "Mp5",
    b"MP6": "Mp6",
    b"MPHE": "Mr Effective Porosity",
    b"MPHS": "Mr Total Porosity",
    b"MPR": "Measured Pump Rate",
    b"MPRM": "Mr Permeability",
    b"MR1F": "Micro-Inverse 1\"",
    b"MR2F": "Micro-Normal 2\"",
    b"MRAT": "Measured Pretest Rate",
    b"MRE1": "22",
    b"MRE2": "Mud Resistivity, 30, 24, 2",
    b"MRES": "Mud Resistivity",
    b"MROD": "Momentary Rod Position",
    b"MRP": "(Cmrt-B) (7.5In) Magnetic Resonance Porosity",
    b"MRRS": "Microres Resistance (S)",
    b"MRS1": "Micro-Inverse 1\" Raw",
    b"MRS2": "Micro-Normal 2\" Raw",
    b"MRT": "Max Recorded Temperature",
    b"MSBP": "Msbp",
    b"MSF": "7, 9, Caliper",
    b"MSFC": "Borehole Corrected Msfl",
    b"MSFD": "Micro Focused Resistivity",
    b"MSFL": "Micro Spherically Focused Log",
    b"MSFU": "Msfl Unfiltered",
    b"MSGR": "Hngs (Hsgr - Ssgr)",
    b"MSI": "Gemsilicon-Unc",
    b"MSL1": "Mrms 1 Slew Rate",
    b"MSPD": "Logging Speed",
    b"MSPE": "14",
    b"MSS": "Source Of Sample",
    b"MSSN": "Mrms Sample Number",
    b"MSSS": "Mrms Seal Status",
    b"MST": "Rm Temperature",
    b"MST1": "Mrms 1 Set Point",
    b"MSTS": "Mrms Throttle Status",
    b"MSUL": "Gemsulfur-Unc",
    b"MTB": "Gemtoolbgnd-Unc",
    b"MTE1": "23",
    b"MTE2": "23",
    b"MTEM": "Measured Temperature",
    b"MTHO": "Hngs (Htho - Stho)",
    b"MTI": "Gemtitanium-Unc",
    b"MTIN": "Mud Temperature In",
    b"MUDR": "Mud Resistivity",
    b"MULT": "Multiple Reflection Coefficient (Primaries + Multiples)",
    b"MUON": "Multiple Reflection Coefficient (Multiples Only)",
    b"MUP1": "Mrms 1 Upper Valve Position",
    b"MURA": "Hngs (Hura - Sura)",
    b"MVS1": "Mrms 1 Valve Status",
    b"MWDG": "9",
    b"MWE1": "Mrms 1 Wrong Echo Count",
    b"MWFD": "Manometer Well Fluid Density",
    b"MWI": "Logging Dens Mud In Avg",
    b"MWIN": "Mud Weight In",
    b"MWIn": "Mud Weight In",
    b"MXI": "Maximum Inclination",
    b"MXID": "Maximum Inclination Depth",
    b"MXMA": "Normalized Maximum Map Amplitude",
    b"MXZ": "Maximum Impedance",
    b"Marl": "Lithology (Resampled From 2 Ft Data Step), % Lithology (Resampled From 2 Ft Data Step)",
    b"Mi": "Micro Inverse Resistivity",
    b"Mn": "Micro Normal Resistivity",
    b"MudR": "Mud Resistivity",
    b"N-SD": "N-S Departure (Metres)",
    b"N/S": "N/S Departure, Latitude North/South, N/S",
    b"N1": "Near 1",
    b"N16": "6",
    b"N5": "4",
    b"N64": "64In Normal",
    b"N9": "5",
    b"NATN": "(Mast-B) (6In) Near Attenuation",
    b"NB1": "Nb1",
    b"NB10": "Nb10",
    b"NB2": "Nb2",
    b"NB3": "Nb3",
    b"NB4": "Nb4",
    b"NB5": "Nb5",
    b"NB6": "Nb6",
    b"NB7": "Nb7",
    b"NB8": "Nb8",
    b"NB9": "Nb9",
    b"NB91": "Nb91",
    b"NB92": "Nb92",
    b"NB93": "Nb93",
    b"NB94": "Nb94",
    b"NB95": "Nb95",
    b"NB96": "Nb96",
    b"NBGR": "Pzig Gamma Ray",
    b"NBI": "(Mast-B) (6In) Bond Index From Near Attenuation",
    b"NBPS": "Nbps",
    b"NC4": "Normal-Butane From Gas Chromatograph (Bhi-Sdl Nc4)",
    b"NC5": "Normal-Pentane From Gas Chromatograph (Bhi-Sdl Nc5)",
    b"NCBL": "(Mast-B) (6In) Synthetic Cbl From Near Attenuation",
    b"NCNL": "None",
    b"NCNP": "Logged By Ha On 940812. Digitized By Ha On 940912., Logged By Ha On 920919. Digitized By Ha On 921009., Logged By Sc On 930221. Digitized By Sc On 930311., Logged By Sc On 920213. Digitized By Sc On 920304., Logged By Sc On 870216. Digitized By Sc On 870714., Logged By Sc On 930312. Digitized By Sc On 930415., Logged By Ha On 920908. Digitized By Ha On 930204., Logged By Ha On 921222. Digitized By Ha On 940118., Dcnp",
    b"NCNT": "North Count (Samples From Tbm To North In Tbm Mode)",
    b"NCPS": "Dsn Near Counts",
    b"NCYT": "Hrdd Nuclear Averaged Estimated Crystal Temperature",
    b"ND": "North Departure",
    b"NDEC": "Neardensitycorr",
    b"NDSN": "Dsn Near Counts",
    b"NEAR": "9",
    b"NEU": "Neutron",
    b"NEU1": "Neutrons",
    b"NEU2": "Neutrons",
    b"NEU3": "Neutrons",
    b"NEUT": "Neutrons",
    b"NFDC": "None",
    b"NFR": "Compensated Neutron Ratio (Near / Far)",
    b"NGAM": "Ngam (Api), Ngam (Cps), Ngam (Openhole), Ngam",
    b"NGPE": "None",
    b"NGR": "Neutron",
    b"NLI1": "Nli1",
    b"NLIC": "Nearlithcorr",
    b"NLIM": "Neutron Porosity (Limestone Matrix)",
    b"NLIT": "Neutron Lithology",
    b"NM1A": "Normalized Map 1 Amplitude",
    b"NM2A": "Normalized Map 2 Amplitude",
    b"NM3A": "Normalized Map 3 Amplitude",
    b"NM4A": "Normalized Map 4 Amplitude",
    b"NM5A": "Normalized Map 5 Amplitude",
    b"NM6A": "Normalized Map 6 Amplitude",
    b"NM7A": "Normalized Map 7 Amplitude",
    b"NM8A": "Normalized Map 8 Amplitude",
    b"NM_M": "10",
    b"NNOB": "Near Borehole Pop",
    b"NNOF": "Near Formation Pop",
    b"NOFF": "31, 43, None",
    b"NOIS": "Spectralnoise",
    b"NOMO": "Casing O.D.",
    b"NONE": "Intervals (Resampled From 2 Ft Data Step)",
    b"NORM": "Normal",
    b"NORT": "7, 19, None",
    b"NP": "Compensated Neutron Porosity (Napi)",
    b"NPE1": "Npe1",
    b"NPES": "Npes",
    b"NPH": "Neutron Porosity",
    b"NPH1": "Nph1",
    b"NPH2": "Nph2",
    b"NPHD": "Neutron Porosity Dolo",
    b"NPHI": "Neutron Porosity",
    b"NPHL": "Neu Por Lime",
    b"NPHS": "Neutron Porosity Sand",
    b"NPHY": "17",
    b"NPIM": "Neutron Data Point Indicator",
    b"NPK3": "Number Of Peaks For Stc For Measurement 3",
    b"NPK4": "Number Of Peaks For Stc For Measurement 4",
    b"NPK5": "Number Of Peaks For Stc For Measurement 5",
    b"NPK6": "Number Of Peaks For Stc For Measurement 6",
    b"NPKC": "Nearpeakcorr",
    b"NPL": "None",
    b"NPLS": "Compensated Neutron Porosity (Napi, Limestone Matrix)",
    b"NPLT": "Reconstructed Neu Por Lim",
    b"NPOR": "Neutron Porosity",
    b"NPRD": "Dolomite Neutron Por.",
    b"NPRL": "Limestone Neutron Por.",
    b"NPRS": "Sandstone Neutron Por.",
    b"NPSC": "None",
    b"NPSS": "Compensated Neutron Porosity (Napi, Sandstone Matrix)",
    b"NPUL": "Npul",
    b"NPX": "Compensated Neutron Porosity (Napi High Resolution)",
    b"NRAT": "Dsn Near To Far Ratio",
    b"NRHO": "Enhanced Bulk Density, Alpha Corrected",
    b"NS": "Latitude North/South",
    b"NS1": "Ns1",
    b"NS10": "Ns10",
    b"NS2": "Ns2",
    b"NS3": "Ns3",
    b"NS4": "Ns4",
    b"NS5": "Ns5",
    b"NS6": "Ns6",
    b"NS7": "Ns7",
    b"NS8": "Ns8",
    b"NS9": "Ns9",
    b"NS91": "Ns91",
    b"NS92": "Ns92",
    b"NS93": "Ns93",
    b"NS94": "Ns94",
    b"NS95": "Ns95",
    b"NS96": "Ns96",
    b"NSD1": "Nsd1",
    b"NSDL": "Nsdl",
    b"NSEQ": "None",
    b"NTDT": "20",
    b"NUCA": "None",
    b"NUCL": "Smoothed Neutron Projected Porosity - Limestone Matrix (Sperry)",
    b"NVD": "None",
    b"NVR": "None",
    b"NVU": "None",
    b"Neut": "Neutron-Neutron (Cps), Neutron (Cps)",
    b"None": "Oil Show (Resampled From 2 Ft Data Step)",
    b"O/PR": "4",
    b"OAZI": "None",
    b"OBTM": "(Dnmworkflow) Status Of The Drill Bit (On Bottom?)",
    b"OCFF": "Offsetcorfactor",
    b"OCQ": "Bc1 Intvl Gc Ocq",
    b"ODFW": "None",
    b"OFFS": "Min/Max Holesize Difference",
    b"OHPG": "4",
    b"OIA": "Injected Current Average Amplitude Pad A",
    b"OIB": "Injected Current Average Amplitude Pad B",
    b"OIC": "Injected Current Average Amplitude Pad C",
    b"OID": "Injected Current Average Amplitude Pad D",
    b"ONEW": "One-Way Check Level Time Log (Ms Below Srd)",
    b"OVAL": "Ovality",
    b"OWR": "Water Ratio",
    b"OZA": "Injection Impedance Pad A",
    b"OZB": "Injection Impedance Pad B",
    b"OZC": "Injection Impedance Pad C",
    b"OZD": "Injection Impedance Pad D",
    b"Offs": "Offset (Metres)",
    b"P1": "Pe",
    b"P10H": "Arc Phase-Shift Resistivity 10-In. At 2 Mhz",
    b"P16H": "Arc Phase-Shift Resistivity 16-In. At 2 Mhz",
    b"P16L": "Arc Phase-Shift Resistivity 16-In. At 400 Khz",
    b"P1AF": "A-Group_Bin#_1_Porosity_T2Bin_Time=4)",
    b"P1AZ": "Pad 1 Azimuth",
    b"P1B1": "Pad1Button1",
    b"P1NO": "Pad 1 Rotation Relative To North Azimuth",
    b"P1RT": "Time Sdl Fast Pump 1 Rate",
    b"P22H": "Arc Phase-Shift Resistivity 22-In. At 2 Mhz",
    b"P22L": "Arc Phase-Shift Resistivity 22-In. At 400 Khz",
    b"P28H": "Arc Phase-Shift Resistivity 28-In. At 2 Mhz",
    b"P28L": "Arc Phase-Shift Resistivity 28-In. At 400 Khz",
    b"P2AF": "A-Group_Bin#_2_Porosity_T2Bin_Time=8)",
    b"P2B1": "Pad2Button1",
    b"P2RT": "Time Sdl Fast Pump 2 Rate",
    b"P34H": "Arc Phase-Shift Resistivity 34-In. At 2 Mhz",
    b"P34L": "Arc Phase-Shift Resistivity 34-In. At 400 Khz",
    b"P3AF": "A-Group_Bin#_3_Porosity_T2Bin_Time=16)",
    b"P3B1": "Pad3Button1",
    b"P3RT": "Time Sdl Fast Pump 3 Rate",
    b"P40H": "Arc Phase-Shift Resistivity 40-In. At 2 Mhz",
    b"P40L": "Arc Phase-Shift Resistivity 40-In. At 400 Khz",
    b"P4AF": "A-Group_Bin#_4_Porosity_T2Bin_Time=32)",
    b"P4B1": "Pad4Button1",
    b"P5AF": "A-Group_Bin#_5_Porosity_T2Bin_Time=64)",
    b"P5B1": "Pad5Button1",
    b"P6AF": "A-Group_Bin#_6_Porosity_T2Bin_Time=128)",
    b"P6B1": "Pad6Button1",
    b"P7AF": "A-Group_Bin#_7_Porosity_T2Bin_Time=256)",
    b"P8AF": "A-Group_Bin#_8_Porosity_T2Bin_Time=512)",
    b"P9AF": "A-Group_Bin#_9_Porosity_T2Bin_Time=1024",
    b"PAAD": "Mrpa Autodeflate Valve Status",
    b"PABP": "Mrpa Quartz Gauge Nb_Prime Signal Component",
    b"PACP": "Mrpa Quartz Gauge Nc_Prime Signal Component",
    b"PADG": "Pad Gain Code",
    b"PADP": "Mrpa Differential Pressure",
    b"PADV": "Mrpa Dual Valve Motor Control Command Echo",
    b"PAE": "Annular Pressure While Drilling, Equivalent Mud Weight (Sperry)",
    b"PAED": "Mrpa Element Differential Pressure",
    b"PAEM": "Mrpa Element Minimum Pressure",
    b"PAEX": "Mrpa Element Maximum Pressure",
    b"PAFP": "Mrpa Inflate Valve Position",
    b"PAHP": "Mrpa Inflate Pressure",
    b"PAIV": "Mrpa Inflation Volume",
    b"PAL": "Gemaluminum+Unc",
    b"PAMB": "Mrpa Quartz Gauge Nb Signal Component",
    b"PAMC": "Mrpa Quartz Gauge Nc Signal Component",
    b"PAMH": "Mrpa Memorized Hydrostatic Pressure",
    b"PAML": "Mrpa Minimum Interval Pressure",
    b"PANB": "Mrpa New Board Echo",
    b"PAP": "Annular Pressure-Pwd",
    b"PAPC": "Mrpa Quartz Gauge Pressure Compensation",
    b"PAPD": "Mrpa Packer Depth",
    b"PAQ": "Ftwd Annularhrpressquartz",
    b"PAQP": "Mrpa Quartz Gauge Pressure",
    b"PAQT": "Mrpa Quartz Gauge Temperature",
    b"PARH": "Mrpa Raw Inflate Pressure",
    b"PARI": "None",
    b"PARM": "Mrpa Raw Minimum Interval Pressure",
    b"PARQ": "Mrpa Raw Quartz Gauge Pressure",
    b"PARS": "Mrpa Raw Strain Gauge Pressure",
    b"PARX": "Mrpa Raw Maximum Interval Pressure",
    b"PASF": "Mrpa Strain Gauge Frequency",
    b"PASG": "Mrpa Strain Gauge Pressure",
    b"PASO": "Mrpa Solenoid Status",
    b"PASP": "Mrpa Pump Sequence Status",
    b"PATG": "Mrpa Temperature Gauge Command Echo",
    b"PATV": "Mrpa Strain Gauge Temperature",
    b"PAVD": "Mrpa Dual Valve Diagnostic",
    b"PAVP": "Mrpa Interval Valve Position",
    b"PAXL": "Mrpa Maximum Interval Pressure",
    b"PBA": "Gembarium+Unc",
    b"PBFL": "Borehole Input Filter",
    b"PBGF": "Far Background",
    b"PBGN": "Near Background",
    b"PBHK": "Hngs (Hbhk + Sbhk)",
    b"PBSR": "Borehole Ratio",
    b"PC1": "Mrilt2Pbin1",
    b"PC10": "Mrilt2Pbin10",
    b"PC11": "Mrilt2Pbin11",
    b"PC12": "Mrilt2Pbin12",
    b"PC13": "Mrilt2Pbin13",
    b"PC2": "Mrilt2Pbin2",
    b"PC3": "Mrilt2Pbin3",
    b"PC4": "Mrilt2Pbin4",
    b"PC5": "Mrilt2Pbin5",
    b"PC6": "Mrilt2Pbin6",
    b"PC7": "Mrilt2Pbin7",
    b"PC8": "Mrilt2Pbin8",
    b"PC9": "Mrilt2Pbin9",
    b"PCA": "Gemcalcium+Unc",
    b"PCGR": "Hngs (Hcgr + Scgr)",
    b"PCHL": "Gemchlorine+Unc",
    b"PCOR": "20",
    b"PD": "None",
    b"PD10": "22",
    b"PD20": "23",
    b"PDD1": "Mrps 1 Pretest Drawdown Pressure Limit",
    b"PDDV": "Emi Relative Pad Voltage",
    b"PDP": "Pwd Differential Pressure (Sperry)",
    b"PDPE": "Pe",
    b"PE": "Pe",
    b"PE1": "Pe1",
    b"PE2": "Pe2",
    b"PEA": "Short Spacing Formation Photoelectric Factor",
    b"PEB": "Photoelectric Factor, Bottom",
    b"PECL": "Litho Corrected Long Spaced Photo Absorption Factor",
    b"PECS": "Litho Corrected Short Spaced Photo Absorption Factor",
    b"PEDF": "Far Photoelectric Factor, Photo Electric Factor, 7,",
    b"PEDN": "Near Pe Curve",
    b"PEF": "Photoelectric Factor",
    b"PEF1": "Pef1",
    b"PEF2": "Pef2",
    b"PEF8": "Hrdd High Resolution Formation Photoelectric Factor",
    b"PEFI": "Hrdd Very High Resolution Formation Photoelectric Factor",
    b"PEFL": "Lds Long-Spaced Corrected Photoelectric Effect",
    b"PEFZ": "Hrdd Standard Resolution Formation Photoelectric Factor",
    b"PEL": "Photoelectric Factor, Left",
    b"PELC": "Pelc",
    b"PELI": "Porosity Ept Limestone",
    b"PEM8": "High Resolution Mudcake Photoelectric Factor",
    b"PEMW": "Annular Pressure While Drilling, Equivalent Mud Weight (Sperry)",
    b"PEMZ": "Standard Resolution Mudcake Photoelectric Factor",
    b"PEN": "Photo-Electric Factor, Near Detector",
    b"PEPT": "Porosity From The Ept Tool",
    b"PER": "Photoelectric Factor, Right",
    b"PERM": "Permeability",
    b"PES": "Litho Short Spaced Photo Absorption Factor, None, Photoelectric Factor",
    b"PEU": "Photoelectric Factor, Up",
    b"PEX": "Litho (Ldp-Da) Corrected Long Spaced Photo Absorption Factor (High Resolution)",
    b"PFE": "Gemiron+Unc",
    b"PFK": "Hngs (Hfk + Sfk)",
    b"PFO1": "None",
    b"PFRA": "7",
    b"PG": "None",
    b"PGD": "Gemgadolini+Unc",
    b"PGGR": "Pcg Gamma Ray",
    b"PGVS": "Pcg Vertical Section",
    b"PGW": "Sum Prob Gw",
    b"PH": "Gemhydrogen+Unc",
    b"PH12": "Ph12",
    b"PH13": "Ph13",
    b"PH14": "Ph14",
    b"PH15": "Ph15",
    b"PH23": "Ph23",
    b"PH24": "Ph24",
    b"PHC": "Gemhybrcarb+Unc",
    b"PHDI": "(Mifa-Nd) Ph From Dye Indicator, (Mifa-Nd) (0.3S) Ph From Dye Indicator",
    b"PHIA": "Apparent Porosity (From Phicp, Phid, Phis, Phin Or Phimax)",
    b"PHIC": "10",
    b"PHID": "Density Porosity, Density Log Porosity For Given Rhoma, Curve # 10",
    b"PHIE": "20",
    b"PHIN": "Compensated Neutron Porosity (Napi)",
    b"PHIS": "Sonic Log Porosity For Given Tma, Curve # 14",
    b"PHIT": "Corrected Total Porosity",
    b"PHIX": "5, 4",
    b"PHN1": "Phn1",
    b"PHND": "Phnd",
    b"PHO": "Gemhybroxy+Unc",
    b"PHOR": "(Mifa-Nd) Ph Optical Density Ratio, (Mifa-Nd) (0.3S) Ph Optical Density Ratio",
    b"PHSW": "20",
    b"PHT1": "Pht1",
    b"PHTL": "Phtl",
    b"PHUN": "8",
    b"PHXN": "Compensated Neutron Porosity (Napi High Resolution)",
    b"PHXO": "21",
    b"PI1": "None",
    b"PI1A": "None",
    b"PI2": "None",
    b"PI2A": "None",
    b"PI3": "None",
    b"PI4": "None",
    b"PICA": "Geminelacal+Unc",
    b"PIFE": "Gemineliron+Unc",
    b"PIP": "Internal Pressure-Pwd",
    b"PIPR": "Pwd Internal Pressure While Drilling (Sperry)",
    b"PIPS": "None",
    b"PIRM": "Envir. Corr., Phased Ilm",
    b"PISI": "Geminelasil+Unc",
    b"PK": "Gempotassiu+Unc",
    b"PK21": "' Peak Amplitude",
    b"PKRP": "Sps Pack Press",
    b"PL": "Plot Channel Name",
    b"PLT1": "Plot Control",
    b"PLT2": "Plot Control",
    b"PLT3": "Plot Control",
    b"PLT4": "Plot Control",
    b"PLT5": "Plot Control",
    b"PLTC": "Plot Control",
    b"PMCU": "13",
    b"PMEA": "19",
    b"PMG": "Gemmagnesiu+Unc",
    b"PMN": "Gemmanganes+Unc",
    b"PNA": "Gemsodium+Unc",
    b"PO": "Probabilty Of Oil",
    b"POIS": "Poisson Ratio",
    b"PONE": "6",
    b"POPE": "None",
    b"POR": "None",
    b"POR1": "Por1",
    b"POR2": "Por2",
    b"POR3": "Por3",
    b"POR4": "Por4",
    b"PORA": "Porosity From Acoustilog",
    b"PORD": "None",
    b"PORL": "Lithology Density Porosity",
    b"PORN": "Neutron Limeston Porosity",
    b"PORO": "4",
    b"PORS": "Sonic Derived Porosity",
    b"PORV": "10",
    b"PORZ": "Porosity From Z-Densilog",
    b"POT2": "Pot2",
    b"POTA": "Potassium",
    b"PP": "Formation Pore Pressure = (Depth-Rkb-Wt)*Rhof*0.05192 + C",
    b"PPLW": "None",
    b"PPRE": "None",
    b"PPT": "Predicted Pipe Time",
    b"PPUW": "None",
    b"PPWR": "Pressure Transducer Power Voltage",
    b"PPr": "Pump Pressure (Psi)",
    b"PR": "Poisson'S Ratio",
    b"PR1": "Inflate Press.",
    b"PRES": "20",
    b"PRFS": "Wide (Servo) Prf",
    b"PRIM": "Primary Reflection Coefficient With Transmission Loss",
    b"PRIN": "Inlet Pressure",
    b"PROU": "Oulet Pressure",
    b"PROX": "Prox Resistivity",
    b"PRP1": "C3 Out",
    b"PRSA": "Annular Pressure",
    b"PR_H": "Poisson Ratio Horizontal",
    b"PR_V": "Poisson Ratio Vertical",
    b"PS": "None",
    b"PSD": "Psd",
    b"PSD3": "Psd3",
    b"PSDO": "None",
    b"PSFL": "Servo Input Filter",
    b"PSGR": "Hngs (Hsgr + Ssgr)",
    b"PSI": "Gemsilicon+Unc",
    b"PSR": "Compensated Phase Shift Resistivity",
    b"PSRD": "Phase Shift Resistivity Down",
    b"PSRU": "Phase Shift Resistivity Up",
    b"PSU": "Psu",
    b"PSU3": "Psu3",
    b"PSUL": "Gemsulfur+Unc",
    b"PSUP": "None",
    b"PSVL": "Piston Swept Volume",
    b"PTB": "Gemtoolbgnd+Unc",
    b"PTEM": "6",
    b"PTEN": "7",
    b"PTHO": "9",
    b"PTHR": "Hngs (Htho + Stho)",
    b"PTI": "Gemtitanium+Unc",
    b"PTNO": "Pretest Number",
    b"PTT": "(Mrpq-Xd) Pre-Test Type",
    b"PTT1": "Mrps 1 Pretest Type",
    b"PTV1": "Mrps 1 Pretest Volume",
    b"PULC": "Fphxul_C",
    b"PUMP": "Average Pump Pressure - Stand Pipe",
    b"PURA": "Hngs (Hura + Sura)",
    b"PV": "Plastic Viscosity",
    b"PVOL": "Pretest Volume",
    b"PVT": "Pit Volume",
    b"PVTT": "Pump Chamber Temperature",
    b"PW": "Probabilty Of Water",
    b"PWA": "Pwd Annular Pressure While Drilling (Sperry)",
    b"PWDA": "Pwd Annular Pressure While Drilling (Sperry)",
    b"PWDI": "Pwd Internal Pressure While Drilling (Sperry)",
    b"PWEA": "Pwd Annular Emw",
    b"PWM": "High Volt. Pwm",
    b"PWPA": "Pwd Annular Pressure",
    b"PWPD": "Pwd Differential Pressure",
    b"PWPI": "Pwd Internal Pressure",
    b"PWTB": "Pwd Temperature",
    b"PWXO": "Invaded Zone Water-Filled Porosity",
    b"PXAR": "Ann Press (Sperry)",
    b"PXND": "Neutron-Density Crossplot Porosity",
    b"PXRL": "Lithology Density Porosity (High Resolution)",
    b"PYRT": "Pyrite Volume",
    b"PZD": "Porosity For Dolomite Matrix",
    b"PZDC": "Corrected Porosity For Dolomite Matrix",
    b"PZL": "Porosity For Limestone Matrix",
    b"PZLC": "Corrected Porosity For Limestone Matrix",
    b"PZS": "Porosity For Sandstone Matrix",
    b"PZSC": "Corrected Porosity For Sandstone Matrix",
    b"Pe": "None",
    b"Q": "Quality",
    b"Q1": "Nearquality",
    b"Q2": "Farquality",
    b"QCAL": "Quality Curve",
    b"QCC": "Semblance - Dtc Qc",
    b"QCRH": "Hrdd Density Processing Quality Flag",
    b"QDPF": "Quartzdyne Pressure",
    b"QDT": "Qdt",
    b"QDT1": "Qdt1",
    b"QDTS": "Qdts",
    b"QF": "Farquality",
    b"QFM": "Qualitative Fluid Mobility Indicator",
    b"QFRC": "Quartzdyne Fraction",
    b"QGCP": "Qg Corr Press",
    b"QGNB": "(Mrsr-Na) Quartz Gauge Sensor Nb Signal Component, (Mrpq-Xd) Quartz Gauge Sensor Nb Signal Component",
    b"QGNC": "(Mrpq-Xd) Quartz Gauge Sensor Nc Signal Component, (Mrsr-Na) Quartz Gauge Sensor Nc Signal Component",
    b"QGTM": "Quartz Gauge Temperature",
    b"QL": "7",
    b"QL1": "Ql1",
    b"QLRA": "Rx0/Rt Quick Look Ratio",
    b"QLS": "None",
    b"QN": "Nearquality",
    b"QONE": "Quartzdyne 1'S",
    b"QPE": "Qpe",
    b"QPE1": "Qpe1",
    b"QRLS": "None",
    b"QRSS": "None",
    b"QRTT": "Quality Reflectance Traveltime",
    b"QRTZ": "Quartz Volume",
    b"QS": "8",
    b"QS1": "Qs1",
    b"QSHA": "Quality Of Shifted Data Of 1St T2",
    b"QSS": "None",
    b"QT1": "Qual Semblance",
    b"QTEM": "Quartzdyne Temperature",
    b"QUAF": "Dip Quality Factor",
    b"QUAL": "2",
    b"QUES": "Oil Show (Resampled From 2 Ft Data Step)",
    b"R": "None",
    b"R0": "Resistivity 100% Water Bearing",
    b"R09P": "In Phase Resistivity",
    b"R1": "R1.5",
    b"R15P": "In Phase Resistivity",
    b"R18P": "In Phase Resistivity",
    b"R2": "R2",
    b"R20F": "Array Ind. Four Res 20",
    b"R20H": "Array Ind Hi Res 20",
    b"R20O": "Array Ind. One Res 20",
    b"R20S": "Array Ind. Six Res 20",
    b"R20T": "Array Ind. Two Res 20",
    b"R24P": "In Phase Resistivity",
    b"R27P": "In Phase Resistivity",
    b"R30F": "Array Ind. Four Res 30",
    b"R30H": "Array Ind Hi Res 30",
    b"R30O": "Array Ind. One Res 30",
    b"R30P": "In Phase Resistivity",
    b"R30S": "Array Ind. Six Res 30",
    b"R30T": "Array Ind. Two Res 30",
    b"R39A": "In Atten Resistivity",
    b"R39P": "In Phase Resistivity",
    b"R3LG": "None",
    b"R40F": "Array Ind. Four Res 40",
    b"R40H": "Array Ind Hi Res 40",
    b"R40O": "Array Ind. One Res 40",
    b"R40S": "Array Ind. Six Res 40",
    b"R40T": "Array Ind. Two Res 40",
    b"R42P": "In Phase Resistivity",
    b"R60F": "Array Ind. Four Res 60",
    b"R60H": "Array Ind Hi Res 60",
    b"R60O": "Array Ind. One Res 60",
    b"R60S": "Array Ind. Six Res 60",
    b"R60T": "Array Ind. Two Res 60",
    b"R85F": "Array Ind. Four Res 85",
    b"R85H": "Array Ind Hi Res 85",
    b"R85O": "Array Ind. One Res 85",
    b"R85S": "Array Ind. Six Res 85",
    b"R85T": "Array Ind. Two Res 85",
    b"RAA1": "None",
    b"RAD1": "Radius1",
    b"RAD2": "Radius2",
    b"RAD3": "Radius3",
    b"RAD4": "Radius4",
    b"RAD5": "Radius5",
    b"RAD6": "Radius6",
    b"RAKT": "Th/K",
    b"RAKU": "U/K",
    b"RAL": "Reconstructed Alwf",
    b"RAT": "Running Speed (Sperry)",
    b"RATI": "7",
    b"RATO": "Ratio - One",
    b"RAUT": "Th/U",
    b"RAWS": "Integrated Raw Sonic",
    b"RAZ": "(Edtc-B) Raw Acceleration Z-Axis",
    b"RAZI": "Raw Azimuth",
    b"RB": "Relative Bearing",
    b"RB2": "Relative Bearing (Relative To Borehole High Side) (2Nd Tool)",
    b"RBAD": "Relative Bearing (Reeves, 180 Deg To Schlumberger Rb)",
    b"RBC": "Relative Bearing Corrected",
    b"RBD": "N/A",
    b"RBIT": "Borehole-Compensated Resistivity At The Bit",
    b"RBNF": "Rbnf",
    b"RBOD": "Relative Bearing (Relative To Borehole High Side)",
    b"RBR1": "None",
    b"RBSB": "Relative Bearing (Relative To Borehole Low Side) For Sbt",
    b"RBSG": "None",
    b"RBST": "Relative Bearing (Relative To Borehole High Side) For Star",
    b"RC": "Reflection Coefficient Sequence",
    b"RC1": "Raw Caliper 1",
    b"RC2": "Raw Caliper 2",
    b"RCA": "Reconstructed Cawf",
    b"RCA1": "None",
    b"RCAL": "None",
    b"RCAS": "None",
    b"RCAX": "Raw Accelerometer X Component",
    b"RCAY": "Raw Accelerometer Y Component",
    b"RCAZ": "Raw Accelerometer Z Component",
    b"RCCL": "Raw Casing Collar Locator",
    b"RCE": "Rectangular Co-Ordinates East",
    b"RCEF": "None",
    b"RCEN": "None",
    b"RCEW": "7",
    b"RCFT": "None",
    b"RCFX": "Raw Magnetometer X Component",
    b"RCFY": "Raw Magnetometer Y Component",
    b"RCFZ": "Raw Magnetometer Z Component",
    b"RCN": "Rectangular Co-Ordinates North",
    b"RCNS": "6",
    b"RCNT": "None",
    b"RCOR": "Cost Function Measurement",
    b"RCOS": "Cost Function",
    b"RD": "Deep Resistivity",
    b"RD1D": "N/A",
    b"RD1F": "N/A",
    b"RD2D": "N/A",
    b"RD2F": "N/A",
    b"RD3D": "N/A",
    b"RD3F": "N/A",
    b"RD4D": "N/A",
    b"RD4F": "N/A",
    b"RD5D": "N/A",
    b"RD5F": "N/A",
    b"RD6D": "N/A",
    b"RD6F": "N/A",
    b"RDAH": "Deep Attenuation Resistivity From 2 Mhz Freq",
    b"RDAL": "Deep Attenuation Resistivity From 500 Khz Freq",
    b"RDE1": "None",
    b"RDEP": "None",
    b"RDEV": "None",
    b"RDF1": "Detector 1 Resolution Degradation Factor",
    b"RDF2": "Detector 2 Resolution Degradation Factor",
    b"RDI0": "None",
    b"RDI9": "None",
    b"RDIH": "12",
    b"RDLI": "Deep Induction, None",
    b"RDPH": "Deep Phase Resistivity From 2 Mhz Freq",
    b"RDPL": "Deep Phase Resistivity From 500 Khz Freq",
    b"RDR1": "N/A",
    b"RDR2": "N/A",
    b"RDR3": "N/A",
    b"RDR4": "N/A",
    b"RDR5": "N/A",
    b"RDR6": "N/A",
    b"RDSW": "18",
    b"RDV0": "None",
    b"RDV9": "None",
    b"REFL": "Reflection Coefficient",
    b"REID": "8",
    b"REIM": "9",
    b"REMS": "(Borehole) Mud Resistivity, (Borehole) (1S) Mud Resistivity",
    b"RES": "None",
    b"RESD": "Residual Drift Calibration Curve Values (Ms), Deep Resistivity",
    b"RESM": "Medium Resistivity, Medium Resistivity (Slb-Lwd P28H)",
    b"RESS": "Shallow Resistivity (Slb-Lwd P22H), Shallow Resistivity (P22H)",
    b"RESX": "Extra Shallow Resistivity (Slb-Lwd P16H), Extra Shallow Resistivity (P16H)",
    b"RF1": "3",
    b"RF10": "In Resistivity 4Ft Res",
    b"RF11": "13",
    b"RF12": "14",
    b"RF13": "15",
    b"RF14": "16",
    b"RF15": "17",
    b"RF16": "18",
    b"RF2": "4",
    b"RF20": "In Resistivity 4Ft Res",
    b"RF21": "Raw Neutron Far Counts Bank 2 Tube 1",
    b"RF22": "Raw Neutron Far Counts Bank 2 Tube 2",
    b"RF23": "Raw Neutron Far Counts Bank 2 Tube 3",
    b"RF3": "5",
    b"RF30": "In Resistivity 4Ft Res",
    b"RF4": "6",
    b"RF5": "7",
    b"RF6": "8",
    b"RF60": "In Resistivity 4Ft Res",
    b"RF7": "9",
    b"RF8": "10",
    b"RF9": "11",
    b"RF90": "In Resistivity 4Ft Res",
    b"RFA": "Rfa",
    b"RFA1": "Rfa1",
    b"RFBC": "Rfbc",
    b"RFE": "Reconstructed Fewf",
    b"RFIC": "Far Inel. To Capt.",
    b"RFLS": "None",
    b"RFO1": "Rfo1",
    b"RFO2": "Rfo2",
    b"RFO3": "Rfo3",
    b"RFOC": "Resistivity From Cfoc",
    b"RFPD": "Probe Depth",
    b"RFSD": "22",
    b"RFSS": "None",
    b"RFTA": "20",
    b"RFTD": "22",
    b"RGC1": "Rgc1",
    b"RGCN": "Uncalibrated Gain Applied Near Thermal Counting Rate Sc",
    b"RGHN": "Hires Gain Applied Near Thermal Count Rate Sc",
    b"RGR": "Raw Gamma Ray",
    b"RHBA": "Hrdd Backscatter Apparent Density, Apparent Density From Back Scatter Monosensor Inversion",
    b"RHDT": "None",
    b"RHET": "Raw Electronic Temperature",
    b"RHFT": "Hires Uncalibrated Far Thermal Count Rate",
    b"RHG1": "Rhg1",
    b"RHGA": "None",
    b"RHGE": "Matrix Density From Elemental Concentrations",
    b"RHGR": "High Resolution Raw Gamma Ray",
    b"RHGX": "None",
    b"RHLA": "Hrdd Long-Spacing Apparent Density, (Hdrs-H) (2In) Long Spacing Apparent Density, Long Spacing Apparent Density",
    b"RHMA": "Apparent Matrix Density",
    b"RHNT": "Hires Uncalibrated Near Thermal Count Rate",
    b"RHO1": "Rho1",
    b"RHO2": "Rho2",
    b"RHO8": "Hrdd High Resolution Formation Density",
    b"RHOA": "Avg Resistivity",
    b"RHOB": "None",
    b"RHOC": "None",
    b"RHOF": "Fluid Density1",
    b"RHOG": "Est Rhog",
    b"RHOI": "Hrdd Very High Resolution Formation Density",
    b"RHOL": "Long Spacing Bulk Density",
    b"RHOM": "Lds Corrected Bulk Density",
    b"RHOS": "Short Spacing Bulk Density",
    b"RHOT": "Reconstructed Rhob",
    b"RHOW": "Est Rhow",
    b"RHOZ": "Hrdd Standard Resolution Formation Density",
    b"RHPP": "Raw Hydraulic Pump Pressure",
    b"RHPT": "12",
    b"RHSA": "Hrdd Short-Spacing Apparent Density, Short Spacing Apparent Density",
    b"RHTE": "10",
    b"RI0": "None",
    b"RI1": "None",
    b"RIL1": "Ril1",
    b"RIL2": "Ril2",
    b"RIL3": "Ril3",
    b"RIL4": "Ril4",
    b"RILD": "None",
    b"RILM": "None",
    b"RILS": "Dil Shallow Resistivity",
    b"RINC": "Reduced Incoherence",
    b"RING": "Borehole-Compensated Ring Resistivity",
    b"RIRD": "9",
    b"RIRM": "17",
    b"RITE": "11",
    b"RIXD": "13",
    b"RIXM": "21",
    b"RK": "Reconstructed Kwf",
    b"RL16": "Lateral Resistivity - 16\"",
    b"RLA": "None",
    b"RLA0": "Hrlt Borehole Corrected Resistivity 0",
    b"RLA1": "Hrlt Borehole Corrected Resistivity 1",
    b"RLA2": "Hrlt Borehole Corrected Resistivity 2",
    b"RLA3": "Hrlt Borehole Corrected Resistivity 3",
    b"RLA4": "Hrlt Borehole Corrected Resistivity 4",
    b"RLA5": "Hrlt Borehole Corrected Resistivity 5",
    b"RLIT": "None",
    b"RLL": "None",
    b"RLL3": "None",
    b"RLL8": "Raw Ll8 Conductivity",
    b"RLLD": "Raw Laterolog Deep Resistivity",
    b"RLLL": "None",
    b"RLLS": "Raw Laterolog Shallow Resistivity",
    b"RLLU": "None",
    b"RLM1": "Rlm1",
    b"RLM2": "Rlm2",
    b"RLM3": "Rlm3",
    b"RLML": "Resistivity Of 1\" Lateral",
    b"RLS": "None",
    b"RLU": "None",
    b"RLU1": "None",
    b"RLU2": "None",
    b"RLUL": "None",
    b"RLUU": "None",
    b"RM": "None",
    b"RMAH": "Medium Attenuation Resistivity From 2 Mhz Freq",
    b"RMAL": "Medium Attenuation Resistivity From 500 Khz Freq",
    b"RMAX": "Smoothed Ddsr-M5 Max Rpm (Sperry)",
    b"RMBH": "Rm At Bht",
    b"RMCS": "Mud Cake Resistivity",
    b"RMCZ": "Mudcake Resistivity Standard Resolution",
    b"RMED": "None",
    b"RMF1": "Rmf1",
    b"RMFA": "Rmfa",
    b"RMFS": "Mud Filtrate Resistivity",
    b"RMG": "Reconstructed Mgwf",
    b"RMI": "None",
    b"RMIN": "Smoothed Ddsr-M5 Min Rpm (Sperry)",
    b"RMLI": "None",
    b"RMLL": "Resistivity",
    b"RMN": "None",
    b"RMPH": "Medium Phase Resistivity From 2 Mhz Freq",
    b"RMPL": "Medium Phase Restivity From 500 Khz Freq",
    b"RMS": "Mud Resistivity",
    b"RMSF": "Rm Resistivity, 9, Micro Spherically Focussed Log",
    b"RMSV": "Root Mean Square Sonic Velocity (Seismic), Root Mean Square Velocity (Seismic)",
    b"RMU1": "Rmud",
    b"RMUD": "Rmud",
    b"RN1": "9",
    b"RN10": "18",
    b"RN11": "19",
    b"RN12": "20",
    b"RN13": "21",
    b"RN14": "22",
    b"RN15": "23",
    b"RN16": "Shallow Resistivity",
    b"RN18": "Inch Normal",
    b"RN2": "10",
    b"RN21": "Raw Neutron Far Counts Bank 2 Tube 1, Raw Neutron Near Counts Bank 2 Tube 1",
    b"RN3": "11",
    b"RN4": "12",
    b"RN5": "13",
    b"RN6": "14",
    b"RN64": "Am 64 Inch Normal, Normal Resistivity - 64\"",
    b"RN7": "15",
    b"RN8": "16",
    b"RN9": "17",
    b"RNBC": "Rnbc",
    b"RNM1": "Rnm1",
    b"RNM2": "Rnm2",
    b"RNM3": "Rnm3",
    b"RNML": "Resistivity Of 2\" Normal",
    b"RNRA": "None",
    b"RNTD": "21",
    b"RO": "Ro, 4",
    b"RO10": "In Resistivity 1Ft Res",
    b"RO20": "In Resistivity 1Ft Res",
    b"RO30": "In Resistivity 1Ft Res",
    b"RO60": "In Resistivity 1Ft Res",
    b"RO90": "In Resistivity 1Ft Res",
    b"ROAZ": "(Wlworkflow) Azimuth From Rotary Table To Target",
    b"ROBB": "Bulk Density, Bottom",
    b"ROBL": "Bulk Density, Left",
    b"ROBR": "Bulk Density, Right, Bulk Density, Left",
    b"ROBU": "Bulk Density, Up",
    b"ROFC": "None",
    b"ROFF": "Rho Far",
    b"ROFN": "Rho Near",
    b"ROM8": "High Resolution Mudcake Density",
    b"ROMA": "Apparent Matrix Density Gem",
    b"ROMZ": "Standard Resolution Mudcake Density",
    b"ROP": "Rate Of Penetration (Sperry)",
    b"ROP5": "(Rt) (Drilling_Surface) Rate Of Penetration Averaged Over The Last 5 Ft (1.5 M)",
    b"ROPA": "Avg Rate Of Penetration",
    b"ROPI": "Rate Of Penetration (Time Based), Inst Rate Of Penetration",
    b"ROPS": "Rate Of Penetration Average",
    b"ROT": "Bit Rotating Hours",
    b"RPAD": "Packer Retract Pressure",
    b"RPC": "Replenisher Current",
    b"RPHU": "4",
    b"RPL": "Ripple Avg",
    b"RPM": "Smoothed Surface Drillstring Revolutions Per Minute (Bhi)",
    b"RPMI": "Rpm",
    b"RPMS": "Revolution Per Minute (Bhi-Sdl Rpm)",
    b"RPON": "2",
    b"RPOS": "Rod Position",
    b"RPPR": "None",
    b"RPPV": "Kinematics Pressure",
    b"RPRE": "21",
    b"RPSD": "16",
    b"RPTE": "3",
    b"RPTH": "5",
    b"RRB": "None",
    b"RRL3": "None",
    b"RRPP": "Raw Kinematics Piston Pressure",
    b"RS": "Shallow Resistivity",
    b"RSA": "None",
    b"RSAH": "Shallow Attenuation Resistivity From 2 Mhz Freq",
    b"RSAL": "Shallow Attenuation Resistivity From 500 Khz Freq",
    b"RSAV": "Motor Revolution Speed",
    b"RSAX": "None",
    b"RSC": "Shallow Resistivity Corrected (Atlas)",
    b"RSCX": "None",
    b"RSFE": "Shallow Fe",
    b"RSFL": "None",
    b"RSFR": "Shallow Fe Raw",
    b"RSGP": "16",
    b"RSGR": "None",
    b"RSHA": "Shallow Resistivity",
    b"RSI": "Reconstructed Siwf",
    b"RSI0": "None",
    b"RSI9": "None",
    b"RSLL": "None",
    b"RSLU": "None",
    b"RSN": "None",
    b"RSO8": "Mcfl High Resolution Resistivity Standoff",
    b"RSOI": "(Hdrs-H) (1In) Resistivity Standoff Very High Resolution",
    b"RSOZ": "Mcfl Standard Resolution Resistivity Standoff",
    b"RSP": "Raw Spontaneous Potential",
    b"RSPA": "None",
    b"RSPD": "Running Speed (Sperry)",
    b"RSPH": "Shallow Phase Resistivity From 2 Mhz Freq",
    b"RSPL": "Shallow Phase Resistivity From 500 Mhz Freq",
    b"RSPR": "8",
    b"RSRC": "None",
    b"RSS1": "None",
    b"RSS2": "None",
    b"RSST": "19",
    b"RSU": "Reconstructed Suwf",
    b"RSUL": "None",
    b"RSUU": "None",
    b"RSV0": "None",
    b"RSV9": "None",
    b"RT": "Rt",
    b"RT06": "In Resistivity 2Ft Res",
    b"RT1": "Rt1",
    b"RT10": "In Resistivity 2Ft Res",
    b"RT2": "Rt2",
    b"RT20": "In Resistivity 2Ft Res",
    b"RT3": "Rt3",
    b"RT30": "In Resistivity 2Ft Res",
    b"RT60": "In Resistivity 2Ft Res",
    b"RT90": "In Resistivity 2Ft Res",
    b"RTAF": "Array Ind. Four Res Rt",
    b"RTAO": "Array Ind. One Res Rt",
    b"RTAS": "Array Ind. Six Res Rt",
    b"RTAT": "Array Ind. Two Res Rt",
    b"RTAU": "19",
    b"RTD": "None, 3",
    b"RTDC": "Ca Motor Temperature",
    b"RTES": "12",
    b"RTH": "Array Ind Hi Res Rt",
    b"RTHK": "Ratio Of Thorium To Potassium",
    b"RTHU": "Ratio Of Thorium To Uranium",
    b"RTI": "Reconstructed Tiwf",
    b"RTLS": "None",
    b"RTM": "Multilaterolog Inversion True Resistivity",
    b"RTNR": "None",
    b"RTO": "Array Ind One Res Rt",
    b"RTRA": "23",
    b"RTSS": "None",
    b"RTT": "Reconstructed True Resistivity",
    b"RT_2": "True Resistivity Of Formation 2Ft Vertical Resolution",
    b"RT_4": "True Resistivity Of Formation 4Ft Vertical Resolution",
    b"RULC": "Frul_C",
    b"RUN": "Run #",
    b"RVV": "Mcfl Vertical Voltage",
    b"RW1N": "None",
    b"RW2N": "None",
    b"RW3N": "None",
    b"RW4N": "None",
    b"RW5N": "None",
    b"RWA": "Apparent Formation Water Resistivity",
    b"RWA1": "Rwa1",
    b"RWA2": "None",
    b"RWXO": "Invaded Zone Water Resistivity",
    b"RXCL": "Caliper",
    b"RXGR": "Mcfl Global Current Based Resistivity",
    b"RXIG": "Mcfl Global (A0) Current",
    b"RXO": "Rxo",
    b"RXO8": "Mcfl High Resolution Invaded Zone Resistivity",
    b"RXOI": "Mcfl Very High Resolution Invaded Zone Resistivity",
    b"RXOM": "Multilaterolog Inversion Flushed Zone Resistivity",
    b"RXOZ": "Mcfl Standard Resolution Invaded Zone Resistivity",
    b"RXR1": "Rxrt",
    b"RXRT": "Rxrt",
    b"RXRU": "Mcfl Uncalibrated Raw B0 Resistivity",
    b"RXSP": "Spontaneous Potential",
    b"RXT1": "Rxt1",
    b"RXTD": "Ratio Rfoc/Rild",
    b"RXV": "Mcfl Rxo (A0) Voltage",
    b"ResD": "Array Induction 2 Foot Resistivity 90\" Doi",
    b"ResM": "Array Induction 2 Foot Resistivity 30\" Doi",
    b"ResS": "Array Induction 2 Foot Resistivity 20\" Doi",
    b"Rhob": "Bulk Density",
    b"Rot": "Bit Rotating Hours",
    b"Rwa": "Apparent Water Resistivity",
    b"S1": "None",
    b"S12": "15",
    b"S13A": "19",
    b"S1AT": "Detector 1 Spectrum Accumulation Time",
    b"S1DT": "Detector 1 Dead Time Count Rate",
    b"S1RH": "None",
    b"S1TM": "Hngs Detector 1 Temperature",
    b"S2": "None",
    b"S23A": "16",
    b"S2AT": "Detector 2 Spectrum Accumulation Time",
    b"S2DT": "Detector 2 Dead Time Count Rate",
    b"S2IV": "8",
    b"S2TM": "Hngs Detector 2 Temperature",
    b"S3": "None",
    b"S34A": "17",
    b"S4": "None",
    b"S4A1": "18",
    b"S5": "None",
    b"SA": "None",
    b"SAAX": "Smoothed X-Axis Average Acceleration (Sperry)",
    b"SAAY": "Smoothed Y-Axis Average Acceleration (Sperry)",
    b"SAAZ": "Smoothed Z-Axis Average Acceleration (Sperry)",
    b"SABG": "Smoothed At Bit Gamma Ray Combined (Sperry)",
    b"SAFA": "Smoothed Far Average Count Rates (Sperry)",
    b"SAFC": "Smoothed Far Average Count Rates (Sperry)",
    b"SALT": "Lithology (Resampled From 2 Ft Data Step)",
    b"SAMP": "3",
    b"SANA": "Smoothed Near Average Count Rates (Sperry)",
    b"SANC": "Smoothed Near Average Count Rates (Sperry)",
    b"SATC": "17",
    b"SATO": "Oil Saturation",
    b"SB1": "Calibrated Speed Button 1",
    b"SB11": "Ch 1 Bin 1",
    b"SB12": "Ch 1 Bin 2",
    b"SB13": "Ch 1 Bin 3",
    b"SB14": "Ch 1 Bin 4",
    b"SB15": "Ch 1 Bin 5",
    b"SB2": "Calibrated Speed Button 2",
    b"SB21": "Ch 2 Bin 1",
    b"SB22": "Ch 2 Bin 2",
    b"SB23": "Ch 2 Bin 3",
    b"SB24": "Ch 2 Bin 4",
    b"SB25": "Ch 2 Bin 5",
    b"SB31": "Ch 3 Bin 1",
    b"SB32": "Ch 3 Bin 2",
    b"SB33": "Ch 3 Bin 3",
    b"SB34": "Ch 3 Bin 4",
    b"SB35": "Ch 3 Bin 5",
    b"SB41": "Ch 4 Bin 1",
    b"SB42": "Ch 4 Bin 2",
    b"SB43": "Ch 4 Bin 3",
    b"SB44": "Ch 4 Bin 4",
    b"SB45": "Ch 4 Bin 5",
    b"SB4Q": "Sb4Q",
    b"SBCA": "None",
    b"SBD2": "Smoothed Bulk Density Compensated Best Bin (Sperry)",
    b"SBD3": "Smoothed Bulk Density Compensated Worst Bin (Sperry)",
    b"SBDC": "Smoothed Bulk Density Compensated (Sperry)",
    b"SBF": "Far Borehole Sigma",
    b"SBLK": "Block Position (Sperry)",
    b"SBN": "Near Borehole Sigma",
    b"SBVI": "Mrilt2Psbvi",
    b"SC": "20",
    b"SCAE": "Compressional Slowness Average Edited, Scae",
    b"SCAL": "Swn Caliper",
    b"SCAT": "None",
    b"SCBL": "None",
    b"SCD": "Speed Corrected Depth",
    b"SCE1": "Comp. Slowness ( Rec#1 - Rec#2 )",
    b"SCE2": "Comp. Slowness ( Rec#2 - Rec#3 )",
    b"SCE3": "Comp. Slowness ( Rec#3 - Rec#4 )",
    b"SCF1": "Scf1",
    b"SCF3": "Scf3",
    b"SCNL": "None",
    b"SCO2": "Smoothed Stand-Off Correction Best Bin (Sperry)",
    b"SCO3": "Smoothed Stand-Off Correction Worst Bin (Sperry)",
    b"SCOR": "Smoothed Stand-Off Correction (Sperry)",
    b"SCSN": "Mrsc Sample Number",
    b"SCSP": "Spontaneous Potential",
    b"SCSS": "Mrsc Seal Status",
    b"SCTS": "Mrsc Throttle Status",
    b"SD": "None",
    b"SDBS": "None",
    b"SDCS": "Sdcs",
    b"SDDE": "Smoothed Resistivity Data Density (Sperry)",
    b"SDDT": "Start Of Run Date",
    b"SDEP": "23",
    b"SDEV": "Sonde Deviation",
    b"SDS1": "Sds1",
    b"SDSO": "Sdso",
    b"SDSS": "Sdss",
    b"SDT2": "Delta T (2 Foot), N/A",
    b"SEAL": "19",
    b"SEC": "Time In Seconds",
    b"SECT": "Section",
    b"SEDA": "Smoothed Deep Attenuation Resistivity (Sperry)",
    b"SEDP": "Smoothed Deep Phase Shift Resistivity (Sperry)",
    b"SELF": "Self Potential",
    b"SEMA": "Smoothed Medium Attenuation Resistivity (Sperry)",
    b"SEMP": "Smoothed Medium Phase Shift Resistivity (Sperry)",
    b"SENS": "Tmdl Sensitivity",
    b"SEPT": "None",
    b"SESA": "Smoothed Shallow Attenuation Resistivity (Sperry)",
    b"SESP": "Smoothed Shallow Phase Shift Resistivity (Sperry)",
    b"SEXA": "Smoothed Extra-Shallow Attenuation Resistivity (Sperry)",
    b"SEXP": "Smoothed Extra-Shallow Phase Shift Resistivity (Sperry)",
    b"SFA1": "None",
    b"SFB2": "Smoothed Far Detector Bulk Density (Low Count Rate) (Sperry)",
    b"SFBD": "Smoothed Far Detector Bulk Density (Sperry)",
    b"SFF": "Far Formation Sigma",
    b"SFL": "Spherically Focused Resistivity, Environmentally Corrected",
    b"SFL1": "Sfl1",
    b"SFL2": "Sfl2",
    b"SFL3": "Sfl3",
    b"SFL4": "Sfl4",
    b"SFLA": "Sfl Resistivity Averaged Over 2.5 Ft",
    b"SFLB": "Sfl Borehole Corrected Resistivity",
    b"SFLF": "Smoothed Ls Porosity Far Detector (Sperry Drilling Services)",
    b"SFLU": "Spherically Focused Log Unaveraged",
    b"SFN": "Near Formation Sigma",
    b"SFN1": "Surface Pick 1St Arrival Time, T2R1",
    b"SFN2": "Surface Pick 1St Arrival Time, T2R2",
    b"SFN4": "Surface Pick 1St Arrival Time, T2R4",
    b"SFPE": "Smoothed Far Detector Pef (Sperry)",
    b"SFT2": "Sft2, Long Space Counts (100-140 Kev)",
    b"SFT3": "Sft3",
    b"SFXA": "Smoothed Density Formation Exposure Time (Sperry)",
    b"SFXB": "Smoothed Bi-Modal Acoustic Formation Exposure Time (Sperry)",
    b"SFXC": "Smoothed Neutron Porosity Formation Exposure Time (Sperry)",
    b"SFXE": "Smoothed Resistivity Formation Exposure Time (Sperry)",
    b"SFXG": "Smoothed Gamma Ray Formation Exposure Time(Sperry)",
    b"SG": "Saturation Of Gas In The Matrix As Determined By Phic",
    b"SGA": "14",
    b"SGAB": "Smoothed At Bit Gamma Ray Combined (Sperry)",
    b"SGB": "15",
    b"SGBQ": "Smoothed At Bit Gamma Bottom Quadrant (Sperry Drilling Services)",
    b"SGC": "16",
    b"SGIN": "None",
    b"SGLQ": "Smoothed At Bit Gamma Left Quadrant (Sperry Drilling Services)",
    b"SGOF": "23",
    b"SGP": "15",
    b"SGPF": "21",
    b"SGR": "Spectral Gamma-Ray",
    b"SGR1": "Sgr1",
    b"SGR2": "Sgr2",
    b"SGRA": "Smoothed Gamma Ray Bank A (Sperry)",
    b"SGRB": "Smoothed Gamma Ray Bank B (Sperry)",
    b"SGRC": "Smoothed Gamma Ray Combined (Sperry)",
    b"SGRD": "Sgrd",
    b"SGRQ": "Smoothed At Bit Gamma Right Quadrant (Sperry Drilling Services)",
    b"SGRU": "Sgru",
    b"SGTQ": "Smoothed At Bit Gamma Top Quadrant (Sperry Drilling Services)",
    b"SHAL": "Shale",
    b"SHEA": "Bat Processed_Shear Flag_Insite Read",
    b"SHGD": "Short Guard, None",
    b"SHGY": "Lithology (Resampled From 2 Ft Data Step)",
    b"SHKA": "(Rt) (Rab6) Axial Shock Frequency",
    b"SHKL": "(Rm) (Arc[1]) (6In) Tool Shock Level",
    b"SHKR": "(Rm) (Spulse-Spsa) Shock Rate",
    b"SHKT": "(Rt) (Rab[1]) (6In) Radial Or Transverse Shock Frequency, (Rt) (Rab6) Radial Or Transverse Shock Frequency",
    b"SHNO": "Sh N (Ohmm)",
    b"SHR": "Shr, Sft2/Hrd2 Ratio",
    b"SHR1": "Shr1",
    b"SHRL": "Limestone H-R Sonic Por.",
    b"SHSI": "Smoothed Hole Diameter (Hole Size Indicator) (Sperry)",
    b"SHVD": "None",
    b"SI0": "None",
    b"SI90": "None",
    b"SIFA": "Sigma Formation, Average",
    b"SIGC": "8",
    b"SIGF": "Aps Formation Capture Cross-Section",
    b"SIGM": "16",
    b"SIGN": "Sigma Near",
    b"SIGW": "Sigwchar - Thermal Decay Time Capture Units",
    b"SILT": "Lithology",
    b"SL1": "Mrsc 1 Slew Rate",
    b"SL2": "Mrsc 2 Slew Rate",
    b"SL3": "Mrsc 3 Slew Rate",
    b"SLDT": "None",
    b"SLTM": "Delta Elapsed Time",
    b"SLTT": "None",
    b"SMG": "(Mast-B) (6In) Shear Modulus",
    b"SMIN": "Synthetic Micro Inverse Resistivity",
    b"SMNO": "Synthetic Micro Normal Resistivity",
    b"SMOB": "Spherical Mobility",
    b"SMON": "Solenoid Monitor",
    b"SMPT": "Sampling Points",
    b"SMTD": "Dst Downhole Tension",
    b"SMTU": "Dst Uphole Tension",
    b"SMUL": "Synthetic Seismogram 25 Hz Zero Phase Ricker (Convolved Primaries + Multiples), Synthetic Seismogram 35 Hz Zero Phase Ricker (Convolved Primaries + Multiples), Synthetic Seismogram 45 Hz Zero Phase Ricker (Convolved Primaries + Multiples)",
    b"SMUO": "Synthetic Seismogram 25 Hz Zero Phase Ricker (Convolved Multiples Only), Synthetic Seismogram 45 Hz Zero Phase Ricker (Convolved Multiples Only), Synthetic Seismogram 35 Hz Zero Phase Ricker (Convolved Multiples Only)",
    b"SN": "Short Normal",
    b"SN01": "Sn01",
    b"SNB2": "Smoothed Near Detector Bulk Density (Low Count Rate) (Sperry)",
    b"SNBD": "Smoothed Near Detector Bulk Density (Sperry)",
    b"SNC": "5",
    b"SNCO": "10, 3",
    b"SNFA": "Smoothed Far Average Count Rates (Sperry)",
    b"SNGT": "None",
    b"SNLF": "Smoothed Ls Porosity Near Detector (Sperry Drilling Services)",
    b"SNNA": "Smoothed Near Average Count Rates (Sperry)",
    b"SNP2": "Smoothed Near Detector Pe Factor (Low Count Rate) (Sperry)",
    b"SNPE": "Smoothed Near Photoelectric Effect Factor (Sperry)",
    b"SNR": "None",
    b"SNRA": "11, 10",
    b"SNUM": "None",
    b"SOBS": "Label Borehole Size For Bias Correction",
    b"SOLV": "Solenoid Dc Voltage",
    b"SON": "None",
    b"SONI": "Sonic (�S/Ft)",
    b"SP": "Spontaneous Potential",
    b"SP02": "Sp02",
    b"SP1": "Sp1",
    b"SP2": "None",
    b"SP3": "Sp3, None",
    b"SPA": "16",
    b"SPAP": "10",
    b"SPAR": "Sp Armor Return",
    b"SPAX": "Smoothed X-Axis Peak Acceleration (Sperry)",
    b"SPAY": "Smoothed Y-Axis Peak Acceleration (Sperry)",
    b"SPAZ": "Smoothed Z-Axis Peak Acceleration (Sperry)",
    b"SPC": "9",
    b"SPCD": "None",
    b"SPCF": "Speed Correction Factor",
    b"SPCG": "Spontaneous Potential",
    b"SPD": "Speed",
    b"SPD1": "Spd1",
    b"SPD2": "Spd2",
    b"SPD3": "Spd3",
    b"SPD4": "Spd4",
    b"SPDL": "Spontaneous Potential",
    b"SPE": "5",
    b"SPF": "9",
    b"SPH1": "Sph1",
    b"SPH2": "Acou Por Sand, Sph2",
    b"SPH3": "Acou Por Lime",
    b"SPH4": "Acou Por Dolo",
    b"SPHC": "Acoustic Porosity Modchap",
    b"SPHD": "Acou Por Dolo",
    b"SPHI": "Acou Porosity",
    b"SPHL": "Acou Por Lime",
    b"SPHR": "Acoustic Porosity Rhg",
    b"SPHS": "Acou Por Sand",
    b"SPHW": "Acouporwylie",
    b"SPLF": "Smoothed Limestone Porosity Real Time Compensated Neutron (Sperry)",
    b"SPM1": "Spm 1",
    b"SPM2": "Spm 2",
    b"SPMV": "None",
    b"SPOF": "Sp Offset",
    b"SPOR": "None",
    b"SPP": "Stand Pipe Pressure (Bhi)",
    b"SPPA": "Srf Pumprs 2Hz",
    b"SPPI": "Standpipe Pressure",
    b"SPPR": "Stand Pipe Pressure, Standpipe Pressure",
    b"SPR": "Sp Raw",
    b"SPRL": "Wyllie Lime. Sonic Por.",
    b"SPRM": "Synthetic Seismogram 35 Hz Zero Phase Ricker (Convolved Primaries), Synthetic Seismogram 45 Hz Zero Phase Ricker (Convolved Primaries), Synthetic Seismogram 25 Hz Zero Phase Ricker (Convolved Primaries)",
    b"SPRO": "Spr (Ohmm)",
    b"SPRS": "Wyllie Sand. Sonic Por.",
    b"SPUL": "Wide (Servo) Pulses",
    b"SPW": "Electrode Sub Processed At Surface",
    b"SPWR": "Sensor Power Voltage",
    b"SP_1": "14",
    b"SP_2": "15",
    b"SQSW": "Sequence Status Word",
    b"SRAD": "Mrsr Autodeflate Valve Status",
    b"SRAT": "Slowness Ratio(M)",
    b"SRBP": "Mrsr Quartz Gauge Nb_Prime Signal Component",
    b"SRC": "None",
    b"SRCP": "Mrsr Quartz Gauge Nc_Prime Signal Component",
    b"SRDP": "Mrsr Differential Pressure",
    b"SRDS": "None",
    b"SRDV": "Mrsr Dual Valve Motor Control Command Echo",
    b"SREF": "Synthetic Seismogram 35 Hz Zero Phase Ricker (Convolved Reflection Data), Synthetic Seismogram 25 Hz Zero Phase Ricker (Convolved Reflection Data), Synthetic Seismogram 45 Hz Zero Phase Ricker (Convolved Reflection Data)",
    b"SREM": "Mrsr Element Minimum Pressure",
    b"SRES": "None",
    b"SREX": "Mrsr Element Maximum Pressure",
    b"SRFP": "Mrsr Inflate Valve Position",
    b"SRHP": "Mrsr Inflate Pressure",
    b"SRIV": "Mrsr Inflation Volume",
    b"SRMB": "Mrsr Quartz Gauge Nb Signal Component",
    b"SRMC": "Mrsr Quartz Gauge Nc Signal Component",
    b"SRMH": "Mrsr Memorized Hydrostatic Pressure",
    b"SRNB": "Mrsr New Board Echo",
    b"SROP": "Smoothed Rate Of Penetration (Sperry)",
    b"SRPC": "Mrsr Quartz Gauge Pressure Compensation",
    b"SRPD": "Mrsr Srcker Depth",
    b"SRPM": "Smoothed Surface Rpm (Bhi)",
    b"SRQP": "Mrsr Quartz Gauge Pressure",
    b"SRQT": "Mrsr Quartz Gauge Temperature",
    b"SRRH": "Mrsr Raw Inflate Pressure",
    b"SRRM": "Mrsr Raw Minimum Interval Pressure",
    b"SRRQ": "Mrsr Raw Quartz Gauge Pressure",
    b"SRRS": "Mrsr Raw Strain Gauge Pressure",
    b"SRRX": "Mrsr Raw Maximum Interval Pressure",
    b"SRSF": "Mrsr Strain Gauge Frequency",
    b"SRSG": "Mrsr Strain Gauge Pressure",
    b"SRSO": "Mrsr Solenoid Status",
    b"SRSP": "Mrsr Pump Sequence Status",
    b"SRSS": "None",
    b"SRTG": "Mrsr Temperature Gauge Command Echo",
    b"SRTS": "None",
    b"SRTV": "Mrsr Strain Gauge Temperature",
    b"SRVD": "Mrsr Dual Valve Diagnostic",
    b"SRVP": "Mrsr Interval Valve Position",
    b"SS": "Lithology (Resampled From 2 Ft Data Step)",
    b"SS1": "None",
    b"SS11": "Servo Ch 1 Bin 1",
    b"SS12": "Servo Ch 1 Bin 2",
    b"SS13": "Servo Ch 1 Bin 3",
    b"SS14": "Servo Ch 1 Bin 4",
    b"SS15": "Servo Ch 1 Bin 5",
    b"SS2": "None",
    b"SS21": "Servo Ch 2 Bin 1",
    b"SS22": "Servo Ch 2 Bin 2",
    b"SS23": "Servo Ch 2 Bin 3",
    b"SS24": "Servo Ch 2 Bin 4",
    b"SS25": "Servo Ch 2 Bin 5",
    b"SS2A": "None",
    b"SS2D": "None",
    b"SS2O": "None",
    b"SS31": "Servo Ch 3 Bin 1",
    b"SS32": "Servo Ch 3 Bin 2",
    b"SS33": "Servo Ch 3 Bin 3",
    b"SS34": "Servo Ch 3 Bin 4",
    b"SS35": "Servo Ch 3 Bin 5",
    b"SS3A": "None",
    b"SS3D": "None",
    b"SS3O": "None",
    b"SS41": "Servo Ch 4 Bin 1",
    b"SS42": "Servo Ch 4 Bin 2",
    b"SS43": "Servo Ch 4 Bin 3",
    b"SS44": "Servo Ch 4 Bin 4",
    b"SS45": "Servo Ch 4 Bin 5",
    b"SS4A": "None",
    b"SS4D": "None",
    b"SS4O": "None",
    b"SS5A": "None",
    b"SS5D": "None",
    b"SS5O": "None",
    b"SS6A": "None",
    b"SS6D": "None",
    b"SS6O": "None",
    b"SS7A": "None",
    b"SS7D": "None",
    b"SS7O": "None",
    b"SS8A": "None",
    b"SS8D": "None",
    b"SS8O": "None",
    b"SSAT": "None",
    b"SSCO": "None",
    b"SSD": "Cdl Short Spaced Counts",
    b"SSD1": "Ssd1",
    b"SSDP": "None",
    b"SSG1": "None",
    b"SSG2": "None",
    b"SSG3": "None",
    b"SSGA": "None",
    b"SSHV": "None",
    b"SSLT": "None",
    b"SSN": "Ssn",
    b"SSN1": "Ssn1",
    b"SSVE": "(Mast-B) (6In) Sonic Shear Velocity",
    b"ST1": "Mrsc 1 Set Point",
    b"ST2": "Mrsc 2 Throttling Set Point",
    b"ST3": "Mrsc 3 Throttling Set Point",
    b"STA1": "None",
    b"STAB": "Csng Stabilizer",
    b"STD": "None",
    b"STDC": "Comp. Standard Deviation",
    b"STDT": "2",
    b"STEM": "Smoothed Temperature From Resistivity Tool (Sperry)",
    b"STH": "None",
    b"STI1": "Sti1",
    b"STI2": "Sti2",
    b"STI3": "Sti3",
    b"STI4": "Sti4",
    b"STI5": "Sti5",
    b"STI6": "Sti6",
    b"STIA": "Stia",
    b"STIT": "Stuck Tool Indicator, Total",
    b"STM": "None",
    b"STOF": "Aps Effective Standoff In Limestone",
    b"STOR": "(Rt) (Drilling_Surface) Surface Torque",
    b"STRR": "Shallow True Resolution Resistivity",
    b"STS": "None",
    b"STSG": "None",
    b"STT": "None",
    b"SUB1": "None",
    b"SUIT": "None",
    b"SV": "Total Vertical Stress",
    b"SV0": "None",
    b"SV90": "None",
    b"SVC": "N/A",
    b"SVE1": "Sve1",
    b"SVEL": "Sonic Velocity",
    b"SVHM": "Semblance Value High Frequency - Memory",
    b"SVHX": "Semblance Value High Frequency",
    b"SVLM": "Semblance Value Low Frequency - Memory",
    b"SVLX": "Semblance Value Low Frequency",
    b"SVPM": "Semblance - Dt Compresional Qc, Semblance Value - Compressional",
    b"SW": "None",
    b"SW0": "14",
    b"SW1": "15, Water Saturation",
    b"SW2": "16",
    b"SW3": "17",
    b"SW5": "None",
    b"SW6": "None",
    b"SW7": "None",
    b"SWB": "None",
    b"SWDL": "None",
    b"SWE": "Calculated By Multimin.",
    b"SWI": "Irreducible Water Saturation",
    b"SWLS": "None",
    b"SWN": "None",
    b"SWNC": "None",
    b"SWOB": "Surface Weight On Bit 2Hz",
    b"SWOH": "19",
    b"SWPN": "21",
    b"SWSS": "None",
    b"SWT": "Calculated By Multimin.",
    b"SWTU": "Sw",
    b"SWU": "None",
    b"SXO": "Water Saturation In Flushed Zone",
    b"SXOE": "Calculated By Multimin.",
    b"SXOT": "Calculated By Multimin.",
    b"SXOU": "Sxo",
    b"S_K": "Potassium (Calibrated)",
    b"S_TH": "Thorium",
    b"S_U": "Uranium (Calibrated)",
    b"Sand": "Sand",
    b"T/D": "Bat Processed_T/D Activity_Insite Read",
    b"T0": "None",
    b"T1": "None",
    b"T12R": "Computed T1/T2",
    b"T1G": "Estimated T1 Of Gas",
    b"T1LM": "T1 Log Mean",
    b"T1PC": "Mrilt1Pmic",
    b"T1PM": "Mrilt1Pirrmx",
    b"T1W": "Estimated T1 Of Water",
    b"T2": "T2 Amplitude Distribution Array",
    b"T2BS": "Mrilt2Kbens",
    b"T2KC": "Mrilt2Kcoat",
    b"T2L1": "Mrilt2Logm",
    b"T2LM": "T2 Logarithmic Mean",
    b"T2PC": "Mrilt2Pmic",
    b"T2PM": "Mrilt2Pirrmx",
    b"T2PT": "Mrilt2Ptot",
    b"T3": "None",
    b"T4": "None",
    b"TAAV": "Logging Torque Abs Avg",
    b"TALP": "None",
    b"TAU": "13",
    b"TAUS": "Ta (Usec)",
    b"TAZI": "None",
    b"TB": "Gemtoolbackgrnd",
    b"TBHV": "Borehole Volume",
    b"TBR": "Total Bit Revolutions",
    b"TBUS": "Tb (Usec)",
    b"TCDM": "Downhole Temperature",
    b"TCDX": "11, 23, None",
    b"TCMR": "Total Cmr Porosity",
    b"TCUS": "Tc (Usec)",
    b"TDA": "T/D Activity",
    b"TDD": "End Depth - Driller",
    b"TDEP": "-Inch Frame Depth",
    b"TDIC": "Trans. Time Integ.--Millisecs., Tdic",
    b"TDIS": "Tdis",
    b"TDL": "End Depth - Logger",
    b"TDSP": "(Wlworkflow) Total Displacement (Of Survey Measure Point From Vertical)",
    b"TDT": "None",
    b"TEM2": "Temperature, Bore Hole Temperature",
    b"TEMP": "Temperature",
    b"TEMS": "4",
    b"TEN": "Differential Tension",
    b"TENF": "None",
    b"TENS": "Tension",
    b"TETA": "Hals Angle Electrode #1 / Max Az So",
    b"TEXD": "Dis Borehole Temperature",
    b"TFA": "Bit Tfa",
    b"TFBA": "Wob Avg",
    b"TFHA": "Hookload Avg",
    b"TFLO": "(Rt) (Drilling_Surface) Total Flow Rate Of All Active Pumps",
    b"TG": "None",
    b"TGAI": "12",
    b"TGAS": "None",
    b"TH": "Thorium Concentration",
    b"THAV": "Thickness Average Value",
    b"THC": "Thorium Concentration, Borehole Corrected",
    b"THMC": "Mudcake Thickness",
    b"THMN": "Thickness Minimum Value",
    b"THMX": "Thickness Maximum Value",
    b"THO1": "Tho1",
    b"THO2": "Tho2",
    b"THOR": "Thorium",
    b"THPG": "5",
    b"TICO": "Compressional Integrated Transit Time Channel",
    b"TILD": "Borehole Tilt",
    b"TILL": "Lithology (Resampled From 2 Ft Data Step)",
    b"TIM": "Survey Time & Date",
    b"TIME": "Time",
    b"TISH": "Shear Integrated Transit Time Channel",
    b"TIV": "Formation Tops Based Interval Velocityy",
    b"TKRT": "Ratiothorpota",
    b"TL": "15",
    b"TLI": "Start Depth",
    b"TLTC": "Tl-Tc Calibration Curve Values (Ms)",
    b"TLTS": "Tool Temperature Static",
    b"TNFA": "Ctn Far Avg Count Rate",
    b"TNNA": "Ctn Near Avg Count Rate",
    b"TNPH": "Thermal Neutron Porosity",
    b"TNPL": "Smoothed Thermal Neutron Porosity - Limestone Matrix (Sperry)",
    b"TNRA": "Thermal Neutron Ratio",
    b"TOD": "None",
    b"TOFD": "None",
    b"TOFF": "13",
    b"TOFS": "None",
    b"TORQ": "Surface Torque (Bhi)",
    b"TOT": "Total Gas Or H.W.",
    b"TOTG": "Total G",
    b"TPDI": "None",
    b"TPDS": "Tension Of Cable",
    b"TPH1": "Mrilt1Ptot",
    b"TPHI": "Mrilt2Ptot",
    b"TPL": "Electromagnetic Propagation Time",
    b"TPL3": "Tpl3",
    b"TPL4": "Tpl4",
    b"TPLW": "None",
    b"TPPW": "Time Of Propagation Plane Wave Equivalent",
    b"TPRA": "(Hngs-Ba) (6In) Thorium/Potassium Ratio",
    b"TPRE": "Pretest Time",
    b"TPUL": "Tension Pull",
    b"TPUW": "None",
    b"TQA": "Srf Stor 2Hz",
    b"TQAA": "Logging Torque Abs Avg",
    b"TQCA": "Kf Accelerometer Control",
    b"TQCK": "Kalman Filter Control",
    b"TQHI": "Torque Hydraulic",
    b"TQI": "Torque",
    b"TR11": "' Transit Time",
    b"TR12": "' Transit Time",
    b"TR21": "' Transit Time",
    b"TR22": "' Transit Time",
    b"TRAT": "18",
    b"TRPM": "Tool Rotation Rpm.",
    b"TSAT": "None",
    b"TSCV": "Kf Speed Corrected Velocity",
    b"TSDG": "Kf Delta Depth",
    b"TSHK": "(Rt) (Tele675) Total Shocks Over Some Threshold This Run, (Rt) (M10825) Total Shocks Over Some Threshold This Run",
    b"TSS1": "Tension Of Cable",
    b"TSTI": "Kf Stuck Tool",
    b"TSTR": "Tstr1",
    b"TSUM": "Summation Of Tt --Millisecs., Tsum",
    b"TT": "Transit Time Image Array",
    b"TT1": "Transit Time 1",
    b"TT1C": "Travel Time (Calibrated Pick) (Transmitter 1 - Receiver 1)",
    b"TT1W": "Transit Time (Tx1-Rx1)",
    b"TT2": "Transit Time 2",
    b"TT2C": "Travel Time (Calibrated Pick) (Transmitter 2 - Receiver 2)",
    b"TT2W": "Transit Time (Tx2-Rx2)",
    b"TT3": "Travel Time (Filtered Heavier) (Transmitter 1 - Receiver 2)",
    b"TT3C": "Travel Time (Calibrated Pick) (Transmitter 1 - Receiver 2)",
    b"TT3F": "Travel Time 3Ft",
    b"TT3W": "Transit Time (Tx1-Rx2)",
    b"TT4": "Transit Time 4",
    b"TT4C": "Travel Time (Calibrated Pick) (Transmitter 2 - Receiver 1)",
    b"TT4W": "Transit Time (Tx2-Rx1)",
    b"TT5": "Cbl 5' Travel Time",
    b"TT5F": "Travel Time 5Ft",
    b"TTAV": "Transit Time Average",
    b"TTC": "Compressional Traveltime",
    b"TTEM": "(Rm) (Rab[1]) (6In) Tool Temperature",
    b"TTEN": "Total Tension",
    b"TTI": "Integrated Transit Time",
    b"TTIM": "None",
    b"TTMN": "Transit Time Minimum Value",
    b"TTMX": "Transit Time Maximum Value",
    b"TTS1": "S1 Travel Time",
    b"TTS2": "S2 Travel Time",
    b"TTS3": "S3 Travel Time",
    b"TTS4": "S4 Travel Time",
    b"TTS5": "S5 Travel Time",
    b"TTS6": "S6 Travel Time",
    b"TTS7": "S7 Travel Time",
    b"TTS8": "S8 Travel Time",
    b"TTSL": "None",
    b"TTTR": "Msg Tt Tracker",
    b"TURA": "(Hngs-Ba) (6In) Thorium/Uranium Ratio",
    b"TURT": "Ratiothoruran",
    b"TVD": "True Vertical Depth",
    b"TVD2": "3, 9, 13",
    b"TVDD": "Total Vertical Depth (Sperry)",
    b"TVDE": "Svy Tvd_Extr 2Hz",
    b"TVDP": "None",
    b"TVT1": "Active Pvt",
    b"TW": "None,",
    b"TWOW": "Two-Way Check Level Time Log (Ms Below Srd)",
    b"TWT": "1, Two Way Time (Ms)",
    b"Temp": "Pwd Temperature",
    b"Th/U": "Thorium/Uranium Ratio",
    b"Time": "Index",
    b"Torq": "Absolute Torque Average (Bhi)",
    b"U": "Matrix Volumetric Pef",
    b"U8": "High Resolution Volumetric Photoelectric Factor",
    b"UC": "Uranium Content, Borehole Corrected",
    b"UCAV": "Ultrasonic Caliper Average Diameter",
    b"UCAZ": "Ultrasonic Azimuth",
    b"UCHO": "Ultrasonic Caliper, Horizontal Diameter",
    b"UCS": "Ucs1",
    b"UCVE": "Ultrasonic Caliper, Vertical Diameter",
    b"UD6": "Pason Nor Butane",
    b"UD8": "Pason Nor Pentane",
    b"UFRM": "U Of The Formation",
    b"UKRT": "Ratiouranpota",
    b"UMA": "None",
    b"UMV": "14",
    b"UNGR": "None",
    b"UPRA": "(Hngs-Ba) (6In) Uranium/Potassium Ratio",
    b"UR": "None",
    b"URAN": "Uranium",
    b"USAM": "17",
    b"USBI": "Usit Bond Index",
    b"USFC": "None",
    b"USGI": "Usit Gas Index",
    b"UT": "Reconstructed U",
    b"UZ": "Hrdd Standard Resolution Volumetric Photoelectric Factor",
    b"V0DC": "2",
    b"V1M3": "None",
    b"V1M4": "V1M4",
    b"V2M3": "None",
    b"V2M4": "V2M4",
    b"V3M3": "None",
    b"V3M4": "V3M4",
    b"V5": "Volume Of Additional Mineral 5",
    b"VAZT": "Borehole Azimuth (True)",
    b"VBF1": "Detector 1 Variable Barite Factor",
    b"VBF2": "Detector 2 Variable Barite Factor",
    b"VCBW": "Clay-Bound Water Volume",
    b"VCL": "Volume Of Clay, 7, None",
    b"VCLN": "Vcl",
    b"VCVS": "Vcvs",
    b"VDCL": "Vcldry",
    b"VELC": "4, Interval Velocity (M/S)",
    b"VERD": "Vertical Hole Diameter",
    b"VGas": "Vol Water + Oil + Gas",
    b"VHC": "Hydrocarbon Volume",
    b"VIBC": "Vibration Count",
    b"VIBZ": "Abs Vibration Z",
    b"VIL1": "Vil1",
    b"VIL2": "Vil2",
    b"VILD": "Raw Output Of Deep Induction",
    b"VILM": "Raw Output Of Medium Induction",
    b"VL35": "-5' Compensated Sonic",
    b"VMHI": "19",
    b"VOD": "None",
    b"VOIL": "Oil Volume",
    b"VOS": "None",
    b"VOil": "Vol Water + Oil",
    b"VP": "Compressional Velocity",
    b"VP/V": "Bat Processed_Vp/Vs_Insite Read",
    b"VP1": "Mrsc 1 Valve Position",
    b"VP2": "Mrsc 2 Valve Position",
    b"VP3": "Mrsc 3 Valve Position",
    b"VPSX": "Vpvsx, Wl Fe Velocity Ratio X",
    b"VPSY": "Wl Fe Velocity Ratio Y",
    b"VPVS": "Compressional To Shear Velocity Ratio",
    b"VRAT": "8",
    b"VS": "Survey Vertical Sec",
    b"VS1": "Mrsc 1 Valve Status",
    b"VS2": "Mrsc 2 Valve Status",
    b"VS3": "Mrsc 3 Valve Status",
    b"VSD": "N/A",
    b"VSEC": "Vertical Section",
    b"VSH": "15",
    b"VSHA": "Vsh Apparent",
    b"VSPS": "Corridor Stack",
    b"VSec": "Pcg Vertical Section",
    b"VTLT": "Borehole Tilt, Borehole Tilt (Measured From Vertical)",
    b"VWCL": "Vcl",
    b"VWF": "Water Volume",
    b"VWT": "Total Water Volume",
    b"VXGA": "Volume Of Gas In Flushed Zone",
    b"VXWA": "Volume Of Water In Flushed Zone",
    b"Velo": "Velocity (M/Ms)",
    b"W08G": "Photomultiplier Gain Of Tool In Channel 0 (Subset 0)",
    b"W1NG": "None",
    b"W2NG": "None",
    b"W3NG": "None",
    b"W42F": "Electronics Temperature (1826Eb)",
    b"W4NG": "None",
    b"W5NG": "None",
    b"W64C": "Checksum",
    b"W64S": "Tool Status",
    b"W80F": "Wts Comr Flask Temperature",
    b"WAL": "Wetrockalwf",
    b"WANH": "Normalized Weight Fraction Of Anhydrite In Dry Rock",
    b"WATF": "(Mifa-Nd) (0.3S) Water Fraction, (Mifa-Nd) Water Fraction",
    b"WBC": "37, 49",
    b"WBCS": "None",
    b"WCA": "Wetrockcawf",
    b"WF1": "Mda Sonic Waveform",
    b"WF1D": "None",
    b"WF1N": "None",
    b"WF2": "Mda Sonic Waveform",
    b"WF2D": "None",
    b"WF2N": "None",
    b"WF3": "Mda Sonic Waveform",
    b"WF3D": "None",
    b"WF3N": "None",
    b"WF4": "Mda Sonic Waveform",
    b"WF4D": "None",
    b"WF4N": "None",
    b"WFAL": "Weight Fraction Of Aluminum In Dry Rock, Weight Fraction Of Aluminum Derived From Thorium In Dry Rock",
    b"WFC": "Weight Fraction Of Carbon In Whole Rock",
    b"WFCA": "Weight Fraction Of Calcium In Dry Rock",
    b"WFE": "Wetrockfewf",
    b"WFFE": "Weight Fraction Of Iron In Dry Rock",
    b"WFGD": "Weight Fraction Of Gadolinium In Dry Rock",
    b"WFS": "Weight Fraction Of Sulfur In Dry Rock",
    b"WFSI": "Weight Fraction Of Silicon In Dry Rock",
    b"WFTI": "Weight Fraction Of Titanium In Dry Rock",
    b"WGD": "Wetrockgdwf",
    b"WIN": "9",
    b"WITN": "Witness",
    b"WK": "Wetrockkwf",
    b"WLKN": "None",
    b"WMG": "Wetrockmgwf",
    b"WMN": "Wetrockmnwf",
    b"WOB": "Smoothed Weight On Bit (Bhi)",
    b"WOBI": "Wob",
    b"WOH": "Woh",
    b"WOUT": "10",
    b"WPRE": "Well Pressure",
    b"WPYR": "Normalized Weight Fraction Of Pyrite In Dry Rock",
    b"WQFM": "Normalized Weight Fraction Sum Of Q-F-M In Dry Rock",
    b"WRM": "Mud Resistivity",
    b"WSI": "Wetrocksiwf",
    b"WSID": "Normalized Weight Fraction Of Siderite In Dry Rock",
    b"WSUL": "Wetrocksuwf",
    b"WTBH": "Temperature Of Borehole",
    b"WTEP": "Well Temperature",
    b"WTI": "Wetrocktiwf",
    b"XCAL": "Xcal Caliper Diameter",
    b"XCOO": "53",
    b"XDT2": "Xdt Filtered",
    b"XOFF": "54",
    b"XPHI": "Crossplotphi",
    b"XPOR": "Crossplot Porosity",
    b"XPSD": "18",
    b"XSBP": "Xsbp",
    b"YCAL": "15, 4",
    b"YCOO": "55",
    b"YDT2": "Ydt Filtered",
    b"YMDY": "Mult-Line Formulae Output Curve",
    b"YME": "(Mast-B) (6In) Young S Modulus (E)",
    b"YMOD": "Young'S Modulus",
    b"YM_H": "Youngs Modulus Horizontal",
    b"YM_V": "Youngs Modulus Vertical",
    b"YOFF": "56",
    b"YP": "Yield Point",
    b"YSBP": "Ysbp",
    b"ZACC": "Accelerometer Z (Plotable)",
    b"ZCO1": "Zco1",
    b"ZCO2": "Zco2",
    b"ZCOR": "Z-Densilog Bulk Density Correction",
    b"ZDE1": "Zde1",
    b"ZDE2": "Zde2",
    b"ZDEN": "Z-Densilog Bulk Density",
    b"ZDNC": "Borehole Size/Mud Weight Corrected Density",
    b"ZIT1": "Hals Total Current Mode 1 (P) Sc",
    b"ZMAT": "N/A",
    b"ZMEA": "17",
    b"ZMIN": "N/A",
    b"ZTEM": "5",
    b"ZVB1": "Hals Bridle Voltage Mode 1 (P) Sc",
    b"ZVBQ": "Hals Bridle Voltage Mode 1 (Q) Sc",
    b"ZVT1": "Hals Torpedo Voltage Mode 1 (P) Sc",
    b"ZVTQ": "Hals Torpedo Voltage Mode 1 (Q) Sc",
    b"^B": "None",
    b"dga": "Curve # 19",
    b"iC4": "Average Chrom 1 Iso Butane",
    b"iC5": "Average Chrom 1 Iso Pentane",
    b"lgrd": "None",
    b"nC4": "Average Chrom 1 Normal Butane",
    b"nC5": "Average Chrom 1 Normal Pentane",
    b"pe": "None",
    b"rhob": "Bulk Density",
}

#: A mapping of LgFormat mnemonics to typical LAS mnemonics
LGFORMAT_OUTP_UNIQUEID = {
    b"A22H": ['A22H_ARC'],
    b"A34H": ['A34H_ARC'],
    b"AAI": ['AAI'],
    b"AHF10": ['AHF10_6'],
    b"AHF20": ['AHF20_5'],
    b"AHF30": ['AHF30_7'],
    b"AHF60": ['AHF60_8'],
    b"AHF90": ['AHF90_9'],
    b"AHO10": ['AHO10_6'],
    b"AHO20": ['AHO20_5'],
    b"AHO30": ['AHO30_7'],
    b"AHO60": ['AHO60_8'],
    b"AHO90": ['AHO90_9'],
    b"AHT10": ['AHT10_6', 'AIT-H_10_InchInvestigation'],
    b"AHT20": ['AIT-H_20_InchInvestigation', 'AHT20_5'],
    b"AHT30": ['AIT-H_30_InchInvestigation', 'AHT30_7'],
    b"AHT60": ['AHT60_8', 'AIT-H_60_InchInvestigation'],
    b"AHT90": ['AIT-H_90_InchInvestigation', 'AHT90_9'],
    b"APDC": ['APS_CorrectedDolomitePorosity'],
    b"APLC": ['APS_CorrectedLimestinePorosity'],
    b"APSC": ['APS_CorrectedSandstonePorosity'],
    b"ATR": ['ATR'],
    b"B1TR": ['MRPS1_Temp'],
    b"BFR1": ['MRPS1_Resis'],
    b"BMIN": ['MicroInverseB'],
    b"BMNO": ['MicroNormalB'],
    b"BQP1": ['BQP1', 'BQP1_tens'],
    b"BS": ['BitSize', 'BS_7', 'BS'],
    b"BSG1": ['BSG1'],
    b"BTAB": ['BTAB'],
    b"C1": ['C1', 'C1Caliper'],
    b"C1_OBMT": ['C1_OBMT-11'],
    b"C2": ['C2', 'C2Caliper'],
    b"C2_OBMT": ['C2_OBMT-12'],
    b"CALI": ['Cali', 'Caliper', 'CALI_8', 'CALI'],
    b"CALI_CDN": ['CALI_CDN'],
    b"CATR": ['CATR'],
    b"CGR": ['CGR_2'],
    b"CILD": ['CILD'],
    b"CLLD": ['CLLD'],
    b"CMFF": ['CMR_FreeFluidPorosity'],
    b"CMRP": ['CMR_POROSITY'],
    b"DCAL": ['DCAL'],
    b"DEVI": ['DEVI'],
    b"DPHB": ['DPHB'],
    b"DPHI": ['DensityPorosity'],
    b"DPHZ": ['StdResDensityPorosity'],
    b"DPOR_CDN": ['DPOR_CDN'],
    b"DRHB": ['DRHB'],
    b"DRHL": ['DRHL'],
    b"DRHO": ['DRHO'],
    b"DRHR": ['DRHR'],
    b"DRHU": ['DRHU'],
    b"DSOZ": ['DensityStandoff'],
    b"DT": ['DT'],
    b"DT0S": ['Delta-T_Shear2'],
    b"DT1": ['Delta-T_Shear_LDipole', 'Delta-T_Shear1'],
    b"DT1R": ['Delta-T_Shear4'],
    b"DT2": ['Delta-T_Shear6', 'Delta-T_Shear2', 'Delta-T_Shear_UDipole'],
    b"DT2R": ['MonopoleStoneley2'],
    b"DT3R": ['Delta-T_Stonley'],
    b"DT4S": ['Delta-T_Shear5'],
    b"DTAB": ['DTAB'],
    b"DTBC": ['DTBoreholeComp'],
    b"DTCO": ['Delta-T_Comp', 'DTCompressionalSDT'],
    b"DTCU": ['DTComputedUphole'],
    b"DTL": ['DTL_DDBHC'],
    b"DTLF": ['DTLF_DDBHC'],
    b"DTLN": ['DTLN_DDBHC'],
    b"DTR2": ['SlownessUpperDipoleMode'],
    b"DTR5": ['SlownessFirstMotionMode'],
    b"DTRA": ['DTReceiverArray'],
    b"DTRP": ['Delta-T_PS_Comp'],
    b"DTRS": ['Delta-T_Shear3', 'Delta-T_PS_Shear'],
    b"DTSH": ['Delta-T_Shear7'],
    b"DTSM": ['Delta-T_ShearMonoPole', 'Delta-T_Shear'],
    b"DTST": ['MonopoleStoneley', 'Delta-T_Stonely'],
    b"DTTA": ['DTTransArray'],
    b"ENPH": ['EpithermalPorosity'],
    b"GR": ['GR_2', 'GammaRay', 'GR_9'],
    b"GRDN_RAB": ['GRDN_RAB'],
    b"GRLT_RAB": ['GRLT_RAB'],
    b"GRRT_RAB": ['GRRT_RAB'],
    b"GRUP_RAB": ['GRUP_RAB'],
    b"GR_RAB": ['GammaRay', 'GammaRayRAB'],
    b"GR_SL": ['GR_2'],
    b"HAZI": ['HAZI'],
    b"HAZIM": ['HoleAzimuth'],
    b"HCAL": ['HILTCaliper', 'HiltCaliper'],
    b"HDIA": ['HDIA'],
    b"HMIN": ['ComputedMicroInverse'],
    b"HMNO": ['ComputedMicroNormal'],
    b"ILD": ['ILD'],
    b"ILM": ['ILM'],
    b"INFD": ['INFD_17'],
    b"INFD_SL": ['INFD_17'],
    b"LLD": ['LLD'],
    b"LLM": ['LLM'],
    b"MINV": ['MicroInverse'],
    b"MLL": ['MicroLaterolog'],
    b"MNOR": ['MicroNormal'],
    b"MSFL": ['MicroSFL', 'MSFL'],
    b"NPHI": ['OLDESTNeutronPorosity'],
    b"NPOR": ['OLDNeutronPorosity'],
    b"OBRA3": ['OBRA3-14'],
    b"OBRB3": ['OBRB3-15'],
    b"OBRC3": ['OBRC3-16'],
    b"OBRD3": ['OBRD3-17'],
    b"P16H_RT": ['P16H_ARC'],
    b"P1AZ": ['Pad1Azimuth'],
    b"P1NO_OBMT": ['P1NO_OBMT-13'],
    b"P28H_RT": ['P28H_ARC'],
    b"P34H_RT": ['P34H_ARC'],
    b"PCAL": ['PCAL'],
    b"PEB": ['PEB'],
    b"PEF": ['PEF'],
    b"PEFZ": ['StdResFormationPe'],
    b"PEL": ['PEL'],
    b"PER": ['PER'],
    b"PEU": ['PEU'],
    b"POHP": ['POHP'],
    b"POTA": ['POTA'],
    b"PROX": ['Provimity'],
    b"PSR": ['PSR'],
    b"RDBD": ['RDBD'],
    b"RDBL": ['RDBL'],
    b"RDBR": ['RDBR'],
    b"RDBU": ['RDBU'],
    b"RES_BD": ['RES_BD'],
    b"RES_BM": ['RES_BM'],
    b"RES_BS": ['RES_BS'],
    b"RES_RING": ['RES_RING'],
    b"RHOB": ['RHOB'],
    b"RHOZ": ['RHOZ'],
    b"RLA0": ['RLA0_ALAT', 'RLA0'],
    b"RLA1": ['RLA1', 'RLA1_ALAT'],
    b"RLA2": ['RLA2', 'RLA2_ALAT'],
    b"RLA3": ['RLA3', 'RLA3_ALAT'],
    b"RLA4": ['RLA4_ALAT', 'RLA4'],
    b"RLA5": ['RLA5', 'RLA5_ALAT'],
    b"RMBD": ['RMBD'],
    b"RMBL": ['RMBL'],
    b"RMBR": ['RMBR'],
    b"RMBU": ['RMBU'],
    b"ROBB": ['ROBB'],
    b"ROBL": ['ROBL'],
    b"ROBR": ['ROBR'],
    b"ROBU": ['ROBU'],
    b"ROP5": ['ROP5'],
    b"RPM": ['RPM'],
    b"RSBD": ['RSBD'],
    b"RSBL": ['RSBL'],
    b"RSBR": ['RSBR'],
    b"RSBU": ['RSBU'],
    b"RSOZ": ['ResistivityStandoff'],
    b"RTAB": ['RTAB'],
    b"RXO": ['RXO', 'ResistivityFlushedZone'],
    b"RXOZ": ['StdResInvadedZoneResistivity'],
    b"SCN2": ['SCN2'],
    b"SFL": ['SFL'],
    b"SGR": ['SGR_1'],
    b"SIGM": ['SIGM_14'],
    b"SIGM_SL": ['SIGM_14'],
    b"SNP": ['SIDEWALLNEUTRONPorosity'],
    b"SOAB": ['SOAB'],
    b"SOAL": ['SOAL'],
    b"SOAR": ['SOAR'],
    b"SOAU": ['SOAU'],
    b"SONB": ['SONB'],
    b"SOXB": ['SOXB'],
    b"SP": ['SP_10', 'SP'],
    b"SPHI": ['SonicPorosity'],
    b"TAU": ['TAU'],
    b"TAU_SL": ['TAU'],
    b"TCAF": ['TCAF_13'],
    b"TCAF_SL": ['TCAF_13'],
    b"TENS": ['Tension', 'TENSION', 'TENS_16', 'TENS_6'],
    b"TENS_SL": ['TENS_16'],
    b"THOR": ['THOR'],
    b"TNPB": ['TNPB'],
    b"TNPH": ['NeutronPorosity', 'TNPH'],
    b"TNPH_CDN": ['TNPH_CDN'],
    b"TPHI": ['TPHI_15'],
    b"TPHI_SL": ['TPHI_15'],
    b"TSCF": ['TSCF_12'],
    b"TSCF_SL": ['TSCF_12'],
    b"TSCN": ['TSCN_13'],
    b"TSCN_SL": ['TSCN_13'],
    b"URAN": ['URAN'],
    b"VDIA": ['VDIA'],
}

#: This is a map of LgFormat <ChannelName/> to correspondingly appropriate LAS menmonics
#: It's a best guess...
LGFORMAT_LAS: typing.Dict[str, str] = {
    'BS': ['BIT', ],
    'C1': ['C13', 'CAL1', ],
    'C2': ['C24', 'CAL2', ],
    'CALI': ['CAL', 'DLCL', ],
    'CGR': ['ACGR', 'GCGR', ],
    'DEVI': ['TILT', ],
    'DRHO': ['DLDC', ],
    'GR': ['DLGR', 'DLGRH', 'GRDI', 'GRPD', 'GRSG', 'GSGR', 'IDGR', 'MEGR', 'RXGR', 'RXGR01', ],
    'HAZI': ['AZID', ],
    'POTA': ['GRPO', ],
    'SFL': ['SFLU', ],
    'THOR': ['GSTH', 'GRTH', ],
    'URAN': ['GSUR', 'GRUR', ],
}

#: Reverse map to LAS mnemonics to LgFormat <ChannelName/> values.
LAS_LGFORMAT = {}
for __k in LGFORMAT_LAS:
    for __v in LGFORMAT_LAS[__k]:
        assert (__v not in LAS_LGFORMAT)
        LAS_LGFORMAT[__v] = __k

# Add from standard: NULL, COMP, WELL, FLD, LOC, PROV | (CNTY, STAT, CTRY), SRVC, DATE, UWI | API
WELL_SITE_STANDARD_MNEM_DESCRIPTIONS = {
    b'NULL': 'NULL VALUE',
    b'COMP': 'COMPANY',
    b'WELL': 'WELL',
    b'FLD': 'FIELD',
    b'LOC': 'LOCATION',
    b'PROV': 'PROVINCE',
    b'CNTY': 'COUNTY',
    b'STAT': 'STATE',
    b'CTRY': 'COUNTRY',
    b'SRVC': 'SERVICE COMPANY',
    b'DATE': 'DATE',
    b'UWI': 'UNIQUE WELL ID',
    b'API': 'API NUMBER',
}

#: Analysis based on 22,563 LAS 1.2/2.0 files with their frequency as a count and percentage.
#: Edited to remove:
#: - >4 character mnemonics.
#: - infrequent values (typically < 5%).
#: - Parameter that do not belong in this section.
WELL_SITE_MNEMONIC_DESCRIPTIONS = {
    b"APD": "Elevation Of Depth Reference (Lmf) Above Permanent Datum",  # 2512   11.13%
    b"API": "Api Number",  # 19703   87.32%
    b"APIN": "Api Serial Number",  # 42    0.19%
    b"CNTY": "County",  # 17643   78.19%
    b"COMP": "Company",  # 22421   99.37%
    b"COUN": "County",  # 3439   15.24%
    b"CTRY": "Country",  # 10516   46.61%
    b"DATE": "Log Date",  # 22437   99.44%
    b"DMF": "Drilling Measured From",  # 9407   41.69%
    b"EGL": "Gl",  # 10415   46.16%
    b"EKB": "Kb",  # 9779   43.34%
    b"FL1": "Locationline1",  # 1566    6.94%
    b"FL2": "Field Locn. Line 2",  # 1065    4.72%
    b"FL3": "Locationline3",  # 188    0.83%
    b"FL4": "Locationline4",  # 163    0.72%
    b"FL5": "Locationline5",  # 127    0.56%
    b"FL6": "Locationline6",  # 6    0.03%
    b"FLD": "Field",  # 22463   99.56%
    b"FTE": "Feet East From Reference Section Corner",  # 1603    7.10%
    b"FTG": "Location Footage Description",  # 7    0.03%
    b"FTN": "Feet North From Reference Section Corner",  # 1603    7.10%
    b"LATI": "Latitude",  # 2371   10.51%
    b"LEAS": "Lease Name",  # 4910   21.76%
    b"LIC": "License Number",  # 1570    6.96%
    b"LMF": "Log Measured From",  # 10279   45.56%
    b"LOC": "Location",  # 21779   96.53%
    b"LONG": "Longitude",  # 2389   10.59%
    b"NULL": "Null Value",  # 22482   99.64%
    b"PROV": "Province",  # 3285   14.56%
    b"RANG": "Range",  # 16562   73.40%
    b"RIG": "Rig Name",  # 850    3.77%
    b"SECT": "Section",  # 14053   62.28%
    b"SRVC": "Service Company",  # 20471   90.73%
    b"STAT": "State",  # 21479   95.20%
    b"STEP": "Step",  # 22482   99.64%
    b"STOP": "Stop Depth",  # 22482   99.64%
    b"STRT": "Start Depth",  # 22482   99.64%
    b"TOWN": "Township",  # 14058   62.31%
    b"UWI": "Unique Well Id",  # 17432   77.26%
    b"WELL": "Well",  # 22470   99.59%
}

#: Overwrite with standard descriptions.
WELL_SITE_MNEMONIC_DESCRIPTIONS.update(WELL_SITE_STANDARD_MNEM_DESCRIPTIONS)
