from concurrent import futures
from concurrent.futures import as_completed

from easytradetesting.BackTestExecutor import BackTestExecutor


class BackTestEngine:

    def __init__(self, multiProcess=False):
        self.__dataSourceConfig = None
        self.__dataFetcherConfig = None
        self.__backTestConfigs = []
        self.__multiProcess = multiProcess

    def configDataSource(self, host="127.0.0.1", port=3306, user=None, password=None, database=None):

        """
        配置数据源
        :param host:
        :param port:
        :param user:
        :param password:
        :param database:
        :return:
        """
        if host is None or port is None or user is None or password is None or database is None:
            raise Exception("invalid data source config")
        self.__dataSourceConfig = {"host": host, "port": port, "user": user, "password": password, "database": database}
        return self

    def configDataFetcher(self, serverAddress, apiKey, secret, https=True):

        """
        配置行情数据 Api
        :param serverAddress:
        :param apiKey:
        :param secret:
        :param https:
        :return:
        """

        if serverAddress is None or apiKey is None or secret is None:
            raise Exception("invalid data fetcher config")
        self.__dataFetcherConfig = {"serverAddress": serverAddress, "apiKey": apiKey, "secret": secret, "https": https}
        return self

    def buildBackTestConfig(self, backTestConfig):

        """
        添加回测配置
        :param backTestConfig:
        :return:
        """

        if backTestConfig.dataSourceConfig is None:
            if self.__dataSourceConfig is None:
                raise Exception("please config data source first")
            else:
                backTestConfig.configDataSource(self.__dataSourceConfig)

        if backTestConfig.dataFetcherConfig is None:
            if self.__dataFetcherConfig is None:
                raise Exception("please config data fetcher first")
            else:
                backTestConfig.configDataFetcher(self.__dataFetcherConfig)

        if backTestConfig.backTestCode is None:
            backTestConfig.configBackTestCode()

        self.__backTestConfigs.append(backTestConfig)
        return self

    def buildBackTestConfigs(self, backTestConfigs):

        """
        添加回测配置
        :param backTestConfigs:
        :return:
        """

        for backTestConfig in backTestConfigs:
            self.buildBackTestConfig(backTestConfig)
        return self

    def execute(self):
        _backTestResults = []
        if self.__multiProcess:
            _executor = futures.ProcessPoolExecutor(max_workers=len(self.__backTestConfigs))
            _futures = [_executor.submit(BackTestExecutor().execute, _backTestConfig.__dict__) for _backTestConfig in self.__backTestConfigs]
            for _future in as_completed(_futures):
                if _future.done():
                    _backTestResults.append(_future.result())
        else:
            for _backTestConfig in self.__backTestConfigs:
                _backTestExecutor = BackTestExecutor()
                _result = _backTestExecutor.execute(_backTestConfig.__dict__)
                _backTestResults.append(_result)

        return _backTestResults
