# Generated by Django 3.1.7 on 2021-03-19 18:08

import uuid

from django.db import migrations, models

import marion.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="DocumentRequest",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="Primary key for the document request as UUID",
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_on",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time at which a document request was created",
                        verbose_name="Created on",
                    ),
                ),
                (
                    "updated_on",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time at which a document request was last updated",
                        verbose_name="Updated on",
                    ),
                ),
                (
                    "document_id",
                    models.UUIDField(
                        help_text="Generated document identifier",
                        null=True,
                        unique=True,
                        verbose_name="Document ID",
                    ),
                ),
                (
                    "issuer",
                    models.CharField(
                        choices=[
                            ("howard.issuers.RealisationCertificate", "Realisation")
                        ],
                        help_text="The issuer of the document among allowed ones",
                        max_length=200,
                        verbose_name="Issuer",
                    ),
                ),
                (
                    "context",
                    marion.models.PydanticModelField(
                        blank=True,
                        editable=False,
                        help_text="Context used to render the document's template",
                        null=True,
                        verbose_name="Collected context",
                    ),
                ),
                (
                    "context_query",
                    marion.models.PydanticModelField(
                        help_text="Context will be fetched from those parameters",
                        verbose_name="Context query parameters",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_on"],
            },
        ),
    ]
