import pytest
import configparser
import testit_pytest
from testit_pytest.api import Api
from testit_pytest.json_fixture import JSONFixture
from testit_pytest.utils import step
import os
from datetime import datetime
import inspect


class TestITListener(object):

    def __init__(self):
        path = os.path.abspath('')
        root = path[:path.index(os.sep)]
        while not os.path.isfile(f'{path}{os.sep}connection_config.ini') and path != root:
            path = path[:path.rindex(os.sep)]
        path = f'{path}{os.sep}connection_config.ini'
        if os.path.isfile(path):
            self.parser = configparser.RawConfigParser()
            self.parser.read(path)
        else:
            raise Exception('File connection_config.ini was not found!')

    @pytest.hookimpl
    def pytest_sessionstart(self):
        self.requests = Api(self.parser.get('testit', 'url'), self.parser.get('testit', 'privatetoken'))
        self.testrun_id = self.requests.create_testrun(JSONFixture.create_testrun(self.parser.get('testit', 'projectID'), f'LocalRun {datetime.today().strftime("%d %b %Y %H:%M:%S")}'))
        self.requests.testrun_activity(self.testrun_id, 'start')

    @pytest.hookimpl
    def pytest_runtest_protocol(self, item):
        if hasattr(item.function, 'test_externalID'):
            if not hasattr(item.function, 'test_displayName') and not item.function.__doc__:
                self.item = None
                raise Exception(f'{item.originalname} must have @testit.displayName or documentation!')
            self.item = item
        else:
            self.item = None

    @pytest.hookimpl(hookwrapper=True)
    def pytest_fixture_setup(self, fixturedef):
        yield
        if self.item:
            steps_data, results_steps_data = step.get_steps_data()
            if fixturedef.scope != 'function':
                if not hasattr(self.item, f'test_{fixturedef.scope}_setup_steps'):
                    setattr(self.item, f'test_{fixturedef.scope}_setup_steps', [] + steps_data)
                    setattr(self.item, f'test_{fixturedef.scope}_setup_results_steps', [] + results_steps_data)
                    setattr(self.item, f'{fixturedef.scope}_setup_number', 1)
                else:
                    setattr(self.item, f'test_{fixturedef.scope}_setup_steps', getattr(self.item, f'test_{fixturedef.scope}_setup_steps') + steps_data)
                    setattr(self.item, f'test_{fixturedef.scope}_setup_results_steps', getattr(self.item, f'test_{fixturedef.scope}_setup_results_steps') + results_steps_data)
                    setattr(self.item, f'{fixturedef.scope}_setup_number', getattr(self.item, f'{fixturedef.scope}_setup_number') + 1)
            else:
                if not hasattr(self.item, 'test_method_setup_steps'):
                    self.item.test_method_setup_steps = []
                    self.item.test_method_setup_results_steps = []
                self.item.test_method_setup_steps += steps_data
                self.item.test_method_setup_results_steps += results_steps_data

    @pytest.hookimpl(hookwrapper=True, trylast=True)
    def pytest_runtest_call(self):
        yield
        if self.item:
            test_steps, test_results_steps = step.get_steps_data()
            self.item.test_steps = test_steps
            self.item.test_results_steps = test_results_steps

    @pytest.hookimpl
    def pytest_fixture_post_finalizer(self, fixturedef, request):
        if self.item:
            teardown_steps, teardown_results_steps = step.get_steps_data()
            if fixturedef.scope != 'function':
                item_id = request.session.items.index(self.item)
                while not hasattr(request.session.items[item_id], f'{fixturedef.scope}_setup_number'):
                    if not hasattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps'):
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps', [] + teardown_steps)
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps', [] + teardown_results_steps)
                    else:
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps', getattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps') + teardown_steps)
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps', getattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps') + teardown_results_steps)
                    item_id -= 1
                if hasattr(request.session.items[item_id], f'{fixturedef.scope}_setup_number') and getattr(request.session.items[item_id], f'{fixturedef.scope}_setup_number') != 0:
                    if not hasattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps'):
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps', [] + teardown_steps)
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps', [] + teardown_results_steps)
                    else:
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps', getattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_steps') + teardown_steps)
                        setattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps', getattr(request.session.items[item_id], f'test_{fixturedef.scope}_teardown_results_steps') + teardown_results_steps)
                    setattr(request.session.items[item_id], f'{fixturedef.scope}_setup_number', getattr(request.session.items[item_id], f'{fixturedef.scope}_setup_number') - 1)
            else:
                if not hasattr(self.item, 'test_method_teardown_steps'):
                    self.item.test_method_teardown_steps = []
                    self.item.test_method_teardown_results_steps = []
                self.item.test_method_teardown_steps += teardown_steps
                self.item.test_method_teardown_results_steps += teardown_results_steps

    @pytest.hookimpl
    def pytest_runtest_logreport(self, report):
        if self.item:
            if report.failed:
                self.item.test_traces = report.longreprtext
            if not hasattr(self.item, 'test_duration'):
                self.item.test_duration = 0
            self.item.test_duration += report.duration * 1000

    @classmethod
    def attribute_collector(cls, item, nextitem, tree_setup_steps, tree_teardown_steps, index):
        if hasattr(item.function, 'test_externalID'):
            data = {}

            parametrize_id = []
            if item.own_markers:
                for mark in item.own_markers:
                    if mark.name == 'parametrize':
                        parametrize_id.append(item.own_markers.index(mark))

            data['externalID'] = cls.param_attribute_collector(item.function.test_externalID, item.own_markers, parametrize_id, index) if parametrize_id else item.function.test_externalID
            data['steps'] = item.test_steps if hasattr(item, 'test_steps') else []
            data['stepResults'] = item.test_results_steps if hasattr(item, 'test_results_steps') else []

            if hasattr(item, 'test_session_setup_steps'):
                tree_setup_steps['session'] = item.test_session_setup_steps
                tree_setup_steps['session_results'] = item.test_session_setup_results_steps
            elif 'session' not in tree_setup_steps:
                tree_setup_steps['session'] = []
                tree_setup_steps['session_results'] = []
            if hasattr(item, 'test_module_setup_steps'):
                tree_setup_steps['module'] = item.test_module_setup_steps
                tree_setup_steps['module_results'] = item.test_module_setup_results_steps
            elif 'module' not in tree_setup_steps:
                tree_setup_steps['module'] = []
                tree_setup_steps['module_results'] = []
            if hasattr(item, 'test_class_setup_steps'):
                tree_setup_steps['class'] = item.test_class_setup_steps
                tree_setup_steps['class_results'] = item.test_class_setup_results_steps
            elif 'class' not in tree_setup_steps:
                tree_setup_steps['class'] = []
                tree_setup_steps['class_results'] = []
            if hasattr(item, 'test_method_setup_steps'):
                tree_setup_steps['method'] = item.test_method_setup_steps
                tree_setup_steps['method_results'] = item.test_method_setup_results_steps
            elif 'method' not in tree_setup_steps:
                tree_setup_steps['method'] = []
                tree_setup_steps['method_results'] = []
            data['setUp'] = tree_setup_steps['session'] + tree_setup_steps['module'] + tree_setup_steps['class'] + tree_setup_steps['method']
            data['setUpResults'] = tree_setup_steps['session_results'] + tree_setup_steps['module_results'] + tree_setup_steps['class_results'] + tree_setup_steps['method_results']

            if hasattr(item, 'test_session_teardown_steps'):
                tree_teardown_steps['session'] = item.test_session_teardown_steps
                tree_teardown_steps['session_results'] = item.test_session_teardown_results_steps
            elif 'session' not in tree_teardown_steps:
                tree_teardown_steps['session'] = []
                tree_teardown_steps['session_results'] = []
            if hasattr(item, 'test_module_teardown_steps'):
                tree_teardown_steps['module'] = item.test_module_teardown_steps
                tree_teardown_steps['module_results'] = item.test_module_teardown_results_steps
            elif 'module' not in tree_teardown_steps:
                tree_teardown_steps['module'] = []
                tree_teardown_steps['module_results'] = []
            if hasattr(item, 'test_class_teardown_steps'):
                tree_teardown_steps['class'] = item.test_class_teardown_steps
                tree_teardown_steps['class_results'] = item.test_class_teardown_results_steps
            elif 'class' not in tree_teardown_steps:
                tree_teardown_steps['class'] = []
                tree_teardown_steps['class_results'] = []
            if hasattr(item, 'test_method_teardown_steps'):
                tree_teardown_steps['method'] = item.test_method_teardown_steps
                tree_teardown_steps['method_results'] = item.test_method_teardown_results_steps
            elif 'method' not in tree_teardown_steps:
                tree_teardown_steps['method'] = []
                tree_teardown_steps['method_results'] = []
            data['tearDown'] = tree_teardown_steps['method'] + tree_teardown_steps['class'] + tree_teardown_steps['module'] + tree_teardown_steps['session']
            data['tearDownResults'] = tree_teardown_steps['method_results'] + tree_teardown_steps['class_results'] + tree_teardown_steps['module_results'] + tree_teardown_steps['session_results']

            data['resultLinks'] = item.result_links if hasattr(item, 'result_links') else []
            data['duration'] = item.test_duration
            data['traces'] = item.test_traces if hasattr(item, 'test_traces') else None
            data['namespace'] = item.function.__module__

            i = item.function.__qualname__.find('.')
            if i != -1:
                data['classname'] = item.function.__qualname__[:i]
            else:
                data['classname'] = None

            data['links'] = []
            if hasattr(item.function, 'test_links'):
                if parametrize_id:
                    for ID in parametrize_id:
                        mark = item.own_markers[ID]
                        for link in item.function.test_links:
                            data['links'].append({})
                            if link['url'][link['url'].find('{') + 1:link['url'].rfind('}')] in item.own_markers[ID].args[0]:
                                data['links'][-1]['url'] = link['url'].split('{')[0] + mark.args[1][index][mark.args[0].split(', ').index(link['url'][link['url'].find('{') + 1:link['url'].rfind('}')])] + link['url'].split('}')[1]
                            else:
                                data['links'][-1]['url'] = link['url']
                            if link['title'] and link['title'][link['title'].find('{') + 1:link['title'].rfind('}')] in mark.args[0]:
                                data['links'][-1]['title'] = link['title'].split('{')[0] + mark.args[1][index][mark.args[0].split(', ').index(link['title'][link['title'].find('{') + 1:link['title'].rfind('}')])] + link['title'].split('}')[1]
                            else:
                                data['links'][-1]['title'] = link['title']
                            if link['type'] and link['type'][link['type'].find('{') + 1:link['type'].rfind('}')] in mark.args[0]:
                                data['links'][-1]['type'] = link['type'].split('{')[0] + mark.args[1][index][mark.args[0].split(', ').index(link['type'][link['type'].find('{') + 1:link['type'].rfind('}')])] + link['type'].split('}')[1]
                            else:
                                data['links'][-1]['type'] = link['type']
                            if link['description'] and link['description'][link['description'].find('{') + 1:link['description'].rfind('}')] in mark.args[0]:
                                data['links'][-1]['description'] = link['description'].split('{')[0] + mark.args[1][index][mark.args[0].split(', ').index(link['description'][link['description'].find('{') + 1:link['description'].rfind('}')])] + link['description'].split('}')[1]
                            else:
                                data['links'][-1]['description'] = link['description']
                else:
                    data['links'] = item.function.test_links

            data['title'] = (cls.param_attribute_collector(item.function.test_title, item.own_markers, parametrize_id, index) if parametrize_id else item.function.test_title) if hasattr(item.function, 'test_title') else None
            data['description'] = (cls.param_attribute_collector(item.function.test_description, item.own_markers, parametrize_id, index) if parametrize_id else item.function.test_description) if hasattr(item.function, 'test_description') else None

            data['labels'] = []
            if hasattr(item.function, 'test_labels'):
                if parametrize_id:
                    result, param_id = cls.mass_param_attribute_collector(item.function.test_labels[0], item.own_markers, parametrize_id, index)
                    if param_id and item.function.test_labels[0][1:-1] in item.name[item.name.find('[') + 1:item.name.rfind(']')].split('-')[param_id]:
                        for label in result:
                            data['labels'].append({'name': label})
                    else:
                        data['labels'].append({'name': result})
                else:
                    for label in item.function.test_labels:
                        data['labels'].append({'name': label})

            data['workItemsID'] = []
            if hasattr(item.function, 'test_workItemsID'):
                if parametrize_id:
                    result, param_id = cls.mass_param_attribute_collector(item.function.test_workItemsID[0], item.own_markers, parametrize_id, index)
                    if param_id and item.function.test_workItemsID[0][1:-1] in item.name[item.name.find('[') + 1:item.name.rfind(']')].split('-')[param_id]:
                        data['workItemsID'] = result
                    else:
                        data['workItemsID'] = [result]
                else:
                    data['workItemsID'] = item.function.test_workItemsID

            data['testResult'] = 'Failed' if hasattr(item, 'test_traces') else 'Passed'
            data['failureReasonName'] = 'TestDefect' if hasattr(item, 'test_traces') else 'NoDefect'
            data['message'] = None
            if item.own_markers:
                for mark in item.own_markers:
                    if mark.name == 'skip' or mark.name == 'skipif' and mark.args[0]:
                        data['testResult'] = 'Skipped'
                        data['failureReasonName'] = None
                        if mark.kwargs:
                            data['message'] = mark.kwargs['reason']

            if hasattr(item, 'test_message'):
                data['message'] = item.test_message

            if hasattr(item.function, 'test_displayName'):
                if parametrize_id:
                    data['autoTestName'] = cls.param_attribute_collector(item.function.test_displayName, item.own_markers, parametrize_id, index)
                else:
                    data['autoTestName'] = item.function.test_displayName
            elif item.function.__doc__:
                data['autoTestName'] = item.function.__doc__
            else:
                data['testResult'] = 'Failed'
                data['failureReasonName'] = 'TestDefect'
                data['traces'] = f'>\n{inspect.getsource(item.function)}\nE {item.originalname} must have @testit.displayName or documentation!\n{item.location[0]}:{item.location[1]}: Exception'

            return data, tree_setup_steps, tree_teardown_steps, index + 1 if nextitem and item.originalname == nextitem.originalname else 0
        return None, tree_setup_steps, tree_teardown_steps, 0

    @staticmethod
    def param_attribute_collector(attribute, marks, parametrize_id, index):
        for ID in parametrize_id:
            if attribute[attribute.find('{') + 1:attribute.rfind('}')] in marks[ID].args[0]:
                return attribute.split('{')[0] + marks[ID].args[1][index][marks[ID].args[0].split(', ').index(attribute[attribute.find('{') + 1:attribute.rfind('}')])] + attribute.split('}')[1]
        return attribute

    @staticmethod
    def mass_param_attribute_collector(attribute, marks, parametrize_id, index):
        for ID in parametrize_id:
            if attribute[1:-1] != '' and attribute[1:-1] in marks[ID].args[0]:
                param_id = marks[ID].args[0].split(', ').index(attribute[1:-1])
                return marks[ID].args[1][index][param_id], param_id
        return attribute, None

    @pytest.hookimpl
    def pytest_sessionfinish(self, session):
        index = 0
        tree_setup_steps = {}
        tree_teardown_steps = {}
        tests_results_data = []
        data_attachments = []
        for item_id in range(len(session.items)):
            data_item, tree_setup_steps, tree_teardown_steps, index = self.attribute_collector(session.items[item_id], session.items[item_id + 1] if item_id + 1 < len(session.items) else None, tree_setup_steps, tree_teardown_steps, index)
            if data_item:
                autotest = self.requests.get_autotest(data_item['externalID'], self.parser.get('testit', 'projectID')).json()
                if not autotest:
                    autotest_id = self.requests.create_autotest(
                        JSONFixture.create_autotest(
                            data_item['externalID'],
                            self.parser.get('testit', 'projectID'),
                            data_item['autoTestName'],
                            data_item['namespace'],
                            data_item['classname'],
                            data_item['links'],
                            data_item['steps'],
                            data_item['setUp'],
                            data_item['tearDown'],
                            data_item['title'],
                            data_item['description'],
                            data_item['labels']
                        )
                    )
                else:
                    autotest_id = autotest[0]['id']
                    if data_item['testResult'] == 'Passed':
                        self.requests.update_autotest(
                            JSONFixture.update_autotest(
                                data_item['externalID'],
                                self.parser.get('testit', 'projectID'),
                                data_item['autoTestName'],
                                data_item['namespace'],
                                data_item['classname'],
                                data_item['links'],
                                data_item['steps'],
                                data_item['setUp'],
                                data_item['tearDown'],
                                data_item['title'],
                                data_item['description'],
                                data_item['labels'],
                                autotest_id
                            )
                        )
                    else:
                        self.requests.update_autotest(
                            JSONFixture.update_autotest(
                                data_item['externalID'],
                                self.parser.get('testit', 'projectID'),
                                autotest[0]['name'],
                                autotest[0]['namespace'],
                                autotest[0]['classname'],
                                data_item['links'],
                                autotest[0]['steps'],
                                autotest[0]['setup'],
                                autotest[0]['teardown'],
                                autotest[0]['title'],
                                autotest[0]['description'],
                                autotest[0]['labels'],
                                autotest_id
                            )
                        )
                for workitem_id in data_item['workItemsID']:
                    self.requests.link_autotest(autotest_id, workitem_id)

                data_attachments.append(session.items[item_id].test_attachments if hasattr(session.items[item_id], 'test_attachments') else [])

                tests_results_data.append(
                    JSONFixture.set_results_for_testrun(
                        data_item['externalID'],
                        self.parser.get('testit', 'configurationID'),
                        data_item['testResult'],
                        data_item['stepResults'],
                        data_item['setUpResults'],
                        data_item['tearDownResults'],
                        data_item['traces'],
                        data_item['resultLinks'],
                        data_item['duration'],
                        data_item['failureReasonName'],
                        data_item['message']
                    )
                )
        if tests_results_data:
            test_results_id = self.requests.set_results_for_testrun(
                self.testrun_id,
                tests_results_data
            )
            for result_id in range(len(test_results_id)):
                for attachment in data_attachments[result_id]:
                    self.requests.link_attachment(
                        test_results_id[result_id],
                        attachment
                    )

    @testit_pytest.hookimpl
    def add_link(self, link_url, link_title, link_type, link_description):
        if not hasattr(self.item, 'result_links'):
            self.item.result_links = []
        self.item.result_links.append({'url': link_url, 'title': link_title, 'type': link_type, 'description': link_description})

    @testit_pytest.hookimpl
    def add_message(self, test_message):
        self.item.test_message = str(test_message)

    @testit_pytest.hookimpl
    def add_attachments(self, attach_paths):
        if not hasattr(self.item, 'test_attachments'):
            self.item.test_attachments = []
        for path in attach_paths:
            if os.path.isfile(path):
                self.item.test_attachments.append(open(path, "rb"))
            else:
                print(f'File ({path}) not found!')
