# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['subfinder', 'subfinder.subsearcher', 'subfinder.tools']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2',
 'gevent>=1.4.0,<2.0.0',
 'lxml',
 'rarfile',
 'requests',
 'six']

entry_points = \
{'console_scripts': ['subfinder = subfinder.run_gevent:run',
                     'subutils = subfinder.utils:main']}

setup_kwargs = {
    'name': 'subfinder',
    'version': '2.0.0',
    'description': 'subfinder -- a general finder for subtitles',
    'long_description': '# subfinder 字幕查找器\n\nsubfinder 是一个通用字幕查找器，可以查找字幕并下载。\n\n---\n\n[![PyPi](https://img.shields.io/pypi/v/subfinder.svg)](https://pypi.org/project/subfinder/)\n[![PyPi - Python Version](https://img.shields.io/pypi/pyversions/subfinder.svg)](https://pypi.org/project/subfinder/)\n[![PyPI - License](https://img.shields.io/pypi/l/subfinder.svg)](https://pypi.org/project/subfinder/)\n![GitHub last commit](https://img.shields.io/github/last-commit/ausaki/subfinder.svg)\n\n---\n\nTable of Contents\n=================\n\n  - [特性](#特性)\n  - [安装](#安装)\n  - [更新](#更新)\n  - [使用方法](#使用方法)\n    - [命令行](#命令行)\n    - [配置文件](#配置文件)\n    - [Windows 右键菜单](#windows-右键菜单)\n    - [macOS 右键菜单](#macos-右键菜单)\n  - [图形界面](#图形界面)\n  - [注意事项](#注意事项)\n    - [shooter 字幕搜索器](#shooter-字幕搜索器)\n    - [zimuku 字幕搜索器](#zimuku-字幕搜索器)\n  - [贡献](#贡献)\n  - [参考](#参考)\n  - [License](#license)\n  - [更新历史](#更新历史)\n    - [v2.0.0](#v200)\n    - [v1.1.4](#v114)\n    - [v1.1.3](#v113)\n    - [v1.1.2](#v112)\n    - [v1.1.1](#v111)\n    - [v1.1.0](#v110)\n    - [v1.0.9](#v109)\n    - [v1.0.8](#v108)\n    - [v1.0.7](#v107)\n    - [v1.0.6](#v106)\n    - [v1.0.5](#v105)\n    - [v1.0.4](#v104)\n    - [v1.0.3](#v103)\n    - [v1.0.2](#v102)\n    - [v1.0.1](#v101)\n\n---\n\n## 特性\n\n- 支持提供的 API，可以精确匹配字幕。\n\n- 支持 [射手字幕网](https://www.shooter.cn/), [字幕库](https://www.zimuku.cn/), [字幕组](http://www.zimuzu.io/), [SubHD](https://subhd.tv)。\n\n## 安装\n\n如果你是 Linux 和 macOS 用户，由于系统自带 Python，推荐使用下面的方法安装 subfinder：\n\n`pip install subfinder`\n\n安装完成之后，会在 Python 的 scripts 目录下添加一个叫做 subfinder 的可执行文件。\n\n> 在 unix-like 系统中，scripts 目录一般是 `/usr/local/bin`，在 Windows 系统中，scripts 目录一般是 `C:\\python\\scripts\\`。在 Windows 系统中需要将 `C:\\python\\scripts\\` 加入到 `PATH` 中（一般安装 Python 时已经添加了）。\n\n接下来你就可以在命令行中使用 subfinder 命令了。\n\n为了方便没有安装 Python 的用户，这里也有已经打包好的可执行文件。[戳这里下载](https://github.com/ausaki/subfinder/releases)。\n\n## 更新\n\n如果 subfinder 是使用 pip 安装的，那么使用 pip 更新，\n\n`pip install subfinder --upgrade`\n\n如果 subfinder 是下载的打包好的可执行文件，那么请重新下载最新的可执行文件并覆盖旧的文件。\n\n## 使用方法\n\n### 命令行\n\n- 使用默认字幕查找器（shooter）查找单个视频的字幕：\n\n  `subfinder /path/to/videofile`\n\n- 使用默认字幕查找器（shooter）查找目录下（递归所有子目录）所有视频的字幕：\n\n  `subfinder /path/to/directory_contains_video`\n\n- 使用指定的字幕查找器查找字幕，例如 zimuku：\n\n  `subfinder /path/to/videofile -m zimuku`\n\n- 同时使用多个字幕查找器查找字幕\n\n  `subfinder /path/to/videofile -m shooter zimuku`\n\n  当指定多个字幕查找器时，subfinder 会依次尝试每个字幕查找器去查找字幕，只要有一个字幕查找器返回字幕信息，则不再使用后面的字幕查找器查找字幕。\n\n  ** 注意：** 如果指定了多个字幕查找器，请不要指定 `languages` 参数，否则可能会出现 `LanguageError` 错误（因为每个 `SubSearcher` 支持的语言可能不相同）。\n\n常用参数说明（详细的参数信息请查看 `subfinder -h`）：\n\n| 参数              | 含义                                                                                               | 必需                                               |\n| ----------------- | -------------------------------------------------------------------------------------------------- | -------------------------------------------------- |\n| `-l, --languages` | 指定字幕语言，可同时指定多个。每个字幕查找器支持的语言不相同。具体支持的语言请看下文。             | 否，subfinder 默认会下载字幕查找器找到的所有字幕。 |\n| `-e, --exts`      | 指定字幕文件格式，可同时指定多个。每个字幕查找器支持的文件格式不相同。具体支持的文件格式请看下文。 | 否，subfinder 默认会下载字幕查找器找到的所有字幕。 |\n| `-m,--method`     | 指定字幕查找器，可同时指定多个。                                                                   | 否，subfinder 默认使用 shooter 查找字幕。          |\n| `-k, --keyword`   | 手动搜索关键字. 当 SubFinder 使用本身的关键字无法搜索到字幕时, 可以通过这个参数手动指定关键字.     | 否                                                 |\n| `--video_exts`    | 视频文件的后缀名（包括.，例如. mp4）                                                               | 否                                                 |\n| `--ignore`        | 忽略本地已有的字幕强行查找字幕. 注意: 这可能会覆盖本地已有的字幕. 默认 False。                     | 否                                                 |\n| `--exclude`       | 排除文件或目录，支持类似于 shell 的文件匹配模式。详情见下文                                        | 否                                                 |\n| `--api_urls`      | 指定字幕搜索器的 API URL。详情见下文                                                               | 否                                                 |\n| `-c, --conf`      | 配置文件                                                                                           | 否，SubFinder 默认从~/.subfinder.json 读取。       |\n| `-s,--silence`    | 静默运行，不输出日志                                                                               | 否                                                 |\n| `--debug`         | 调试模式，输出调试日志                                                                             | 否                                                 |\n| `-h,--help`       | 显示帮助信息                                                                                       | 否                                                 |\n\n- `--exclude`, 支持的匹配模式类似于 shell，`*` 匹配任意长度的字符串，`?` 匹配一个字符，`[CHARS]` 匹配 CHARS 中的任一字符。例如：\n\n   - 排除包含 `abc` 的目录：`--exclude \'*abc*/\'`。注意添加单引号，防止 shell 对其进行扩展。\n\n   - 排除包含 `abc` 的文件：`--exclude \'*abc*\'`。注意和上个例子的区别，匹配目录时结尾有 `/` 目录分隔符，匹配文件则没有。\n\n\n- `--api_urls`\n\n  [字幕库](http://www.zimuku.la) 的链接不太稳定，有时候会更换域名，因此提供 `--api_urls` 选项自定义 API URL，以防域名或链接变动。\n\n  `--api_urls` 只接收 JSON 格式的字符串。\n\n  获取正确的 API URL 的方法：\n\n  - 字幕库的 API 一般形如 http://www.zimuku.la/search， 这个 URL 就是网页端 “搜索” 功能的 URL。\n\n  - 字幕组的 API 一般形如 http://www.zmz2019.com/search， 这个 URL 同样是网页端 “搜索” 功能的 URL。\n\n  - SubHD 的 API 一般形如 https://subhd.tv/search. \n\n  - 射手网的 API 比较稳定，一般不会变动。\n\n  **如果发现字幕网站的 API URL 发生改变, 欢迎提交 issue.**\n\n  配置示例：\n\n  ```\n  {\n    // 设置字幕库的搜索 API\n    "zimuku": "http://www.zimuku.la/search",\n    // 设置字幕组的搜索 API\n    "zimuzu": "http://www.zmz2019.com/search",\n    // 设置字幕组获取字幕下载链接的 API, 注意不包含域名\n    "zimuzu_api_subtitle_download": "/api/v1/static/subtitle/detail",\n    // 设置 SubHD 的搜索 API\n    "subhd": "https://subhd.tv/search",\n    // 设置 SubHD 获取字幕下载链接的 API, 注意不包含域名\n    "subhd_api_subtitle_download": "/ajax/down_ajax",\n    // 设置 SubHD 获取字幕预览的 API, 注意不包含域名\n    "subhd_api_subtitle_preview": "/ajax/file_ajax"\n  }\n  ```\n\n支持的语言和文件格式：\n\n| 字幕查找器 | 语言                                | 文件格式       |\n| ---------- | ----------------------------------- | -------------- |\n| shooter    | [\'zh\', \'en\']                        | [\'ass\', \'srt\'] |\n| zimuku     | [\'zh_chs\', \'zh_cht\', \'en\', \'zh_en\'] | [\'ass\', \'srt\'] |\n| zimuzu     | [\'zh_chs\', \'zh_cht\', \'en\', \'zh_en\'] | [\'ass\', \'srt\'] |\n| subhd      | [\'zh_chs\', \'zh_cht\', \'en\', \'zh_en\'] | [\'ass\', \'srt\'] |\n\n语言代码：\n\n| 代码   | 含义               |\n| ------ | ------------------ |\n| zh     | 中文，简体或者繁体 |\n| en     | 英文               |\n| zh_chs | 简体中文           |\n| zh_cht | 繁体中文           |\n| zh_en  | 双语               |\n\n### 配置文件\n\n配置文件是 JSON 格式的，支持命令行中的所有选项。命令行中指定的选项优先级高于配置文件的。\n\n配置文件中的 key 一一对应于命令行选项，例如 `-m，--method` 对应的 key 为 `method`。\n\n示例：\n\n```json\n{\n  "languages": ["zh", "en", "zh_chs"],\n  "exts": ["ass", "srt"],\n  "method": ["shooter", "zimuzu", "zimuku"],\n  "video_exts": [".mp4", ".mkv", ".iso"],\n  "exclude": ["excluded_path/", "*abc.mp4"],\n  "api_urls": {\n    // 设置字幕库的搜索 API\n    "zimuku": "http://www.zimuku.la/search",\n    // 设置字幕组的搜索 API\n    "zimuzu": "http://www.zmz2019.com/search",\n    // 设置字幕组获取字幕下载链接的 API, 注意不包含域名\n    "zimuzu_api_subtitle_download": "/api/v1/static/subtitle/detail",\n    // 设置 SubHD 的搜索 API\n    "subhd": "https://subhd.tv/search",\n    // 设置 SubHD 获取字幕下载链接的 API, 注意不包含域名\n    "subhd_api_subtitle_download": "/ajax/down_ajax",\n    // 设置 SubHD 获取字幕预览的 API, 注意不包含域名\n    "subhd_api_subtitle_preview": "/ajax/file_ajax"\n  }\n}\n```\n\n### Windows 右键菜单\n\n使用命令行下载字幕还是有一点不方便，特别是需要输入路径。\n\n在 widnows 中，可以通过注册表将 subfinder 添加到右键菜单，使用时右键选中视频文件或者文件夹，然后点击右键菜单中的 “查找字幕”。\n\n![win_menu](assets/subfinder_menu.win.gif)\n\n** 如何添加注册表：**\n\n- 下载 [注册表文件](https://raw.githubusercontent.com/ausaki/subfinder/master/assets/subfinder.reg)，\n\n- 双击注册表文件 subfinder.reg 即可添加注册表到系统中。\n\n### macOS 右键菜单\n\n在 macOS 中，通过 Automator 的 Service 实现类似于 Windows 中的右键菜单功能。\n\n![subfinder_workflow_service.macos](assets/subfinder_workflow_service.macos.png)\n\n使用方法：\n\n- [下载 workflow](https://raw.githubusercontent.com/ausaki/subfinder/master/assets/subfinder.workflow.tar.gz)。\n- 解压 subfinder.workflow.tar.gz。\n- 将解压出的 subfinder.workflow 复制到 / Users/YourName/Library/Services。\n- 选中视频文件或目录，右键弹出菜单，选择 “服务（Services）” -> “查找字幕”。\n\n** 注意：在 workflow 中，subfinder 的路径是 `/usr/local/bin/subfinder`。**\n\n如果想要了解如何配置 workerflow，可以参考:\n\n- [macOS Automator 帮助](https://support.apple.com/zh-cn/guide/automator/welcome/mac)\n- [stackexchange 的这篇回答](https://apple.stackexchange.com/questions/238948/osx-how-to-add-a-right-click-option-in-folder-to-open-the-folder-with-an-applic?utm_medium=organic&utm_source=google_rich_qa&utm_campaign=google_rich_qa)\n\n## 图形界面\n\n打包好的可执行文件其实是一个 GUI app，不带任何参数运行的话，会打开一个图形界面。\n\n![subfinder_gui.win](assets/subfinder_gui.win.png)\n\n** 注意 **\n\n- GUI app 默认同时使用 shooter 和 zimuku 两个字幕搜索器。\n\n- GUI app 同样支持命令行参数。\n\n[下载页面](https://github.com/ausaki/subfinder/releases)\n\n## 注意事项\n\n### shooter 字幕搜索器\n\n- 由于射手字幕网爬虫的实时性，可能无法查找到最新发布视频的字幕。\n- 射手字幕网 API 返回的字幕可能出现 “语言不一致” 问题（指定查找英文字幕却返回中文字幕）。\n\n### zimuku 字幕搜索器\n\n- zimuku 网站明明有字幕可供下载，subfinder 却提示找不到字幕。可能的原因有：\n\n  - zimuku 字幕搜索器从视频文件名中提取的关键词不够准确，导致搜索结果为空。\n\n  - zimuku 网站修改了 HTML 代码，导致 HTML 解析失败。\n\n- 从 zimuku 网站上下载的字幕一般都是压缩包（zip, rar）。Python 自带的 zipfile 标准库可以解压 zip 压缩包，不过解压 rar 压缩包需要操作系统安装有 unrar 工具。由于 windows 系统安装和配置 unrar 比较麻烦，subfinder 已经內建 unrar.exe 了。对于 Linux 和 macOS 系统的用户，需要自己手动使用系统包管理工具安装 unrar。\n\n## 贡献\n\n在使用过程中遇到任何问题，请提交 issue。\n\n如果你希望分享你自己的字幕搜索器，欢迎提交 PR。\n\n## 参考\n\n- [射手字幕网 API 使用文档](https://docs.google.com/document/d/1ufdzy6jbornkXxsD-OGl3kgWa4P9WO5NZb6_QYZiGI0/preview)\n\n- [射手字幕网 API](https://www.shooter.cn/api/subapi.php)\n\n## License\n\n[MIT License](LICENSE)\n\n## 更新历史\n\n### v2.0.0\n\n- 优化部分代码\n\n- 不再支持 Python2.\n\n### v1.1.4\n\n- hotfix\n\n### v1.1.3\n\n- 将参数 `--repeat` 修改为 `--ignore`.\n\n- 添加新参数 `-k, --keyword`.\n\n- 支持 SubHD. SubHD 在下载字幕时经常弹出验证码, 无法通过正常的API获取到字幕的下载链接, 目前的做法是通过 SubHD 的字幕预览功能获取字幕.\n\n- 修复一些 bug.\n\n- 注意: 配置文件中的一些配置项修改了名字, 具体查看文档.\n  \n### v1.1.2\n\n- 修复 zimuzu 无法正常解析网页的问题 (因为 zimuzu 的网页结构发生了改变).\n\n### v1.1.1\n\n- 修复 subsearcher 的一个 bug.\n\n### v1.1.0\n\n- 使用 poetry 包管理器.\n\n- 修复若干 bug.\n\n### v1.0.9\n\n[issue 27](https://github.com/ausaki/subfinder/issues/27)\n\n- 支持用户配置文件\n\n- 支持用户自定义字幕组和字幕库的 API URL。\n\n- 支持用户自定义视频文件的后缀。\n\n- 支持忽略文件或文件夹。\n\n### v1.0.8\n\n- 修复 zimuku 搜索器的 bug。\n\n### v1.0.7\n\n- 升级 requests 至 2.20.0，修复 requests [安全问题](https://nvd.nist.gov/vuln/detail/CVE-2018-18074)，\n\n### v1.0.6\n\n- 优化了 subsearcher。\n\n- 添加 --debug 选项，方便显示调试信息。\n\n### v1.0.5\n\n- 修复命令行参数 `-l`，`-e` 的问题。\n\n### v1.0.4\n\n- 新增 zimuzu 字幕搜索器。\n\n- 优化代码。\n\n### v1.0.3\n\n- 优化 zimuku 字幕搜索器。\n\n- 內建 unrar.exe，windows 用户不用安装 unrara 了。\n\n### v1.0.2\n\n- GUI app 同时使用 shooter 和 zimuku 两个字幕搜索器搜索字幕。\n\n- GUI app 支持命令行运行。\n\n- 完善打包 GUI app 的流程。\n\n### v1.0.1\n\n- 完善 ZimukuSubsearcher。\n\n  - 解压字幕压缩包文件时，只解压字幕文件。字幕组上传的字幕压缩包文件中可能包含其它非字幕文件。\n\n  - 完善搜索功能。\n\n- 完善打包方式。\n\n- 修复一些 bug。\n',
    'author': 'ausaki',
    'author_email': 'ljm51689@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ausaki/subfinder/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*',
}


setup(**setup_kwargs)
