# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2017- 2023.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class PipelineVersionOutputEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, content_href=None, parent=None):
        """
        PipelineVersionOutputEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_href': 'str',
            'parent': 'PipelineVersionOutputEntityParent'
        }

        self.attribute_map = {
            'content_href': 'contentHref',
            'parent': 'parent'
        }

        self._content_href = content_href
        self._parent = parent

    @property
    def content_href(self):
        """
        Gets the content_href of this PipelineVersionOutputEntity.
        Href to the binary content of the pipeline. Make GET on it to download this file

        :return: The content_href of this PipelineVersionOutputEntity.
        :rtype: str
        """
        return self._content_href

    @content_href.setter
    def content_href(self, content_href):
        """
        Sets the content_href of this PipelineVersionOutputEntity.
        Href to the binary content of the pipeline. Make GET on it to download this file

        :param content_href: The content_href of this PipelineVersionOutputEntity.
        :type: str
        """

        self._content_href = content_href

    @property
    def parent(self):
        """
        Gets the parent of this PipelineVersionOutputEntity.


        :return: The parent of this PipelineVersionOutputEntity.
        :rtype: PipelineVersionOutputEntityParent
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        Sets the parent of this PipelineVersionOutputEntity.


        :param parent: The parent of this PipelineVersionOutputEntity.
        :type: PipelineVersionOutputEntityParent
        """

        self._parent = parent

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
