# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2017- 2023.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class PipelineOutputEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, description=None, author=None, type=None, runtime_environment=None, latest_version=None):
        """
        PipelineOutputEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'author': 'ArtifactAuthor',
            'type': 'str',
            'runtime_environment': 'str',
            'latest_version': 'ArtifactVersionMetadata'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'author': 'author',
            'type': 'type',
            'runtime_environment': 'runtimeEnvironment',
            'latest_version': 'latestVersion'
        }

        self._name = name
        self._description = description
        self._author = author
        self._type = type
        self._runtime_environment = runtime_environment
        self._latest_version = latest_version

    @property
    def name(self):
        """
        Gets the name of this PipelineOutputEntity.
        Name of the pipeline

        :return: The name of this PipelineOutputEntity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PipelineOutputEntity.
        Name of the pipeline

        :param name: The name of this PipelineOutputEntity.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this PipelineOutputEntity.
        Description of the pipeline

        :return: The description of this PipelineOutputEntity.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PipelineOutputEntity.
        Description of the pipeline

        :param description: The description of this PipelineOutputEntity.
        :type: str
        """

        self._description = description

    @property
    def author(self):
        """
        Gets the author of this PipelineOutputEntity.
        Author of the pipeline

        :return: The author of this PipelineOutputEntity.
        :rtype: ArtifactAuthor
        """
        return self._author

    @author.setter
    def author(self, author):
        """
        Sets the author of this PipelineOutputEntity.
        Author of the pipeline

        :param author: The author of this PipelineOutputEntity.
        :type: ArtifactAuthor
        """

        self._author = author

    @property
    def type(self):
        """
        Gets the type of this PipelineOutputEntity.
        Type of the pipeline

        :return: The type of this PipelineOutputEntity.
        :rtype: PipelineType
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PipelineOutputEntity.
        Type of the pipeline

        :param type: The type of this PipelineOutputEntity.
        :type: PipelineType
        """

        self._type = type

    @property
    def runtime_environment(self):
        """
        Gets the runtime_environment of this PipelineOutputEntity.
        runtime environment of caller

        :return: The runtime_environment of this PipelineOutputEntity.
        :rtype: RuntimeEnvironment
        """
        return self._runtime_environment

    @runtime_environment.setter
    def runtime_environment(self, runtime_environment):
        """
        Sets the runtime_environment of this PipelineOutputEntity.
        runtime environment of caller

        :param runtime_environment: The runtime_environment of this PipelineOutputEntity.
        :type: RuntimeEnvironment
        """

        self._runtime_environment = runtime_environment

    @property
    def latest_version(self):
        """
        Gets the latest_version of this PipelineOutputEntity.
        the latest artifact version metadata

        :return: The latest_version of this PipelineOutputEntity.
        :rtype: ArtifactVersionMetadata
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """
        Sets the latest_version of this PipelineOutputEntity.
        the latest artifact version metadata

        :param latest_version: The latest_version of this PipelineOutputEntity.
        :type: ArtifactVersionMetadata
        """

        self._latest_version = latest_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
