# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mdai', 'mdai.utils']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'arrow',
 'dicom2nifti',
 'matplotlib',
 'nibabel',
 'numpy',
 'opencv-python',
 'pandas',
 'pillow',
 'pydicom',
 'requests',
 'retrying',
 'scikit-image',
 'tqdm']

setup_kwargs = {
    'name': 'mdai',
    'version': '0.12.3',
    'description': 'MD.ai Python client library',
    'long_description': '# MD.ai Python Client Library\n\n**Currently pre-alpha -- API may change significantly in future releases.**\n\nThe python client library is designed to work with the datasets and annotations generated by the [MD.ai](https://www.md.ai/) Medical AI platform.\n\nYou can download datasets consisting of images and annotations (i.e., JSON file), create train/validation/test datasets, integrate with various machine learing libraries (e.g., TensorFlow/Keras, Fast.ai) for developing machine learning algorithms.\n\nTo get started, check out the examples in the [notebooks section](notebooks), or our [intro to deep learning for medical imaging lessons](https://github.com/mdai/ml-lessons/).\n\n## Installation\n\nRequires Python 3.6+. Install and update using [pip](https://pip.pypa.io/en/stable/quickstart/):\n\n```sh\npip install --upgrade mdai\n```\n\n## Documentation\n\nOverview Documentation: https://docs.md.ai/libraries/python/\nAPI Documentation coming soon.\n\n## The MD.ai Annotator\n\nThe MD.ai annotator is a powerful web based application, to store and view anonymized medical images (e.g, DICOM) on the cloud, create annotations collaboratively, in real-time, and export annotations, images and labels for training. The MD.ai python client library can be used to download images and annotations, prepare the datasets, and then used to train and evaluate deep learning models.\n\n- MD.ai Documentation and Videos URL: https://docs.md.ai/\n- MD.ai Annotator Example Project URL: https://public.md.ai/annotator/project/aGq4k6NW/workspace\n\n![MD.ai Annotator](https://docs.md.ai/img/annotator-homepage.png)\n\n## MD.ai Annotation JSON Format\n\nMore detailed information regarding the annotation JSON export format, see: https://docs.md.ai/data/json/\n\n## Example Notebooks\n\n- [HelloWorld Keras Notebook](notebooks/hello-world-keras.ipynb)\n- [HelloWorld TFRecords Notebook](notebooks/hello-world-tfrecords-VGG16.ipynb)\n- [HelloWorld Fast.ai](notebooks/hello-world-fastai.ipynb)\n\n## Introductory lessons to Deep Learning for medical imaging by [MD.ai](https://www.md.ai)\n\nThe following are several Jupyter notebooks covering the basics of downloading and parsing annotation data, and training and evaluating different deep learning models for classification, semantic and instance segmentation and object detection problems in the medical imaging domain. The notebooks can be run on Google\'s colab with GPU (see instruction below).\n\n- Lesson 1. Classification of chest vs. adominal X-rays using TensorFlow/Keras [Github](https://github.com/mdai/ml-lessons/blob/master/lesson1-xray-images-classification.ipynb) | [Annotator](https://public.md.ai/annotator/project/PVq9raBJ)\n- Lesson 2. Lung X-Rays Semantic Segmentation using UNets. [Github](https://github.com/mdai/ml-lessons/blob/master/lesson2-lung-xrays-segmentation.ipynb) |\n  [Annotator](https://public.md.ai/annotator/project/aGq4k6NW/workspace)\n- Lesson 3. RSNA Pneumonia detection using Kaggle data format [Github](https://github.com/mdai/ml-lessons/blob/master/lesson3-rsna-pneumonia-detection-kaggle.ipynb) | [Annotator](https://public.md.ai/annotator/project/LxR6zdR2/workspace)\n- Lesson 3. RSNA Pneumonia detection using MD.ai python client library [Github](https://github.com/mdai/ml-lessons/blob/master/lesson3-rsna-pneumonia-detection-mdai-client-lib.ipynb) | [Annotator](https://public.md.ai/annotator/project/LxR6zdR2/workspace)\n\n## Contributing\n\nSee [contributing guidelines](CONTRIBUTING.md) to set up a development environemnt and how to make contributions to mdai.\n\n## Running Jupyter notebooks Colab\n\nIt’s easy to run a Jupyter notebook on Google\'s Colab with free GPU use (time limited).\nFor example, you can add the Github jupyter notebook path to https://colab.research.google.com/notebook:\nSelect the "GITHUB" tab, and add the Lesson 1 URL: https://github.com/mdai/ml-lessons/blob/master/lesson1-xray-images-classification.ipynb\n\nTo use the GPU, in the notebook menu, go to Runtime -> Change runtime type -> switch to Python 3, and turn on GPU. See more [colab tips.](https://www.kdnuggets.com/2018/02/essential-google-colaboratory-tips-tricks.html)\n\n## Advanced: How to run on Google Cloud Platform with Deep Learning Images\n\nYou can also run the notebook with powerful GPUs on the Google Cloud Platform. In this case, you need to authenticate to the Google Cloug Platform, create a private virtual machine instance running a Google\'s Deep Learning image, and import the lessons. See instructions below.\n\n[GCP Deep Learnings Images How To](running_on_gcp.md)\n\n---\n\n&copy; 2023 MD.ai, Inc.\n',
    'author': 'MD.ai',
    'author_email': 'github@md.ai',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mdai/mdai-client-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
