# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class IpAttachment(pulumi.CustomResource):
    address: pulumi.Output[str]
    address_family: pulumi.Output[float]
    """
    Address family as integer (4 or 6)
    """
    cidr: pulumi.Output[float]
    """
    length of CIDR prefix of the subnet as integer
    """
    cidr_notation: pulumi.Output[str]
    """
    CIDR notation of subnet from block reserved in the same
    project and facility as the device
    """
    device_id: pulumi.Output[str]
    """
    ID of device to which to assign the subnet
    """
    gateway: pulumi.Output[str]
    """
    IP address of gateway for the subnet
    """
    global_: pulumi.Output[bool]
    manageable: pulumi.Output[bool]
    management: pulumi.Output[bool]
    netmask: pulumi.Output[str]
    """
    Subnet mask in decimal notation, e.g. "255.255.255.0"
    """
    network: pulumi.Output[str]
    """
    Subnet network address
    """
    public: pulumi.Output[bool]
    """
    boolean flag whether subnet is reachable from the Internet
    """
    def __init__(__self__, resource_name, opts=None, cidr_notation=None, device_id=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a resource to attach elastic IP subnets to devices.
        
        To attach an IP subnet from a reserved block to a provisioned device, you must derive a subnet CIDR belonging to
        one of your reserved blocks in the same project and facility as the target device.
        
        For example, you have reserved IPv4 address block 147.229.10.152/30, you can choose to assign either the whole
        block as one subnet to a device; or 2 subnets with CIDRs 147.229.10.152/31' and 147.229.10.154/31; or 4 subnets
        with mask prefix length 32. More about the elastic IP subnets is [here](https://support.packet.com/kb/articles/elastic-ips).
        
        Device and reserved block must be in the same facility.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_notation: CIDR notation of subnet from block reserved in the same
               project and facility as the device
        :param pulumi.Input[str] device_id: ID of device to which to assign the subnet

        > This content is derived from https://github.com/terraform-providers/terraform-provider-packet/blob/master/website/docs/r/ip_attachment.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if cidr_notation is None:
                raise TypeError("Missing required property 'cidr_notation'")
            __props__['cidr_notation'] = cidr_notation
            if device_id is None:
                raise TypeError("Missing required property 'device_id'")
            __props__['device_id'] = device_id
            __props__['address'] = None
            __props__['address_family'] = None
            __props__['cidr'] = None
            __props__['gateway'] = None
            __props__['global_'] = None
            __props__['manageable'] = None
            __props__['management'] = None
            __props__['netmask'] = None
            __props__['network'] = None
            __props__['public'] = None
        super(IpAttachment, __self__).__init__(
            'packet:index/ipAttachment:IpAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, address=None, address_family=None, cidr=None, cidr_notation=None, device_id=None, gateway=None, global_=None, manageable=None, management=None, netmask=None, network=None, public=None):
        """
        Get an existing IpAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] address_family: Address family as integer (4 or 6)
        :param pulumi.Input[float] cidr: length of CIDR prefix of the subnet as integer
        :param pulumi.Input[str] cidr_notation: CIDR notation of subnet from block reserved in the same
               project and facility as the device
        :param pulumi.Input[str] device_id: ID of device to which to assign the subnet
        :param pulumi.Input[str] gateway: IP address of gateway for the subnet
        :param pulumi.Input[str] netmask: Subnet mask in decimal notation, e.g. "255.255.255.0"
        :param pulumi.Input[str] network: Subnet network address
        :param pulumi.Input[bool] public: boolean flag whether subnet is reachable from the Internet

        > This content is derived from https://github.com/terraform-providers/terraform-provider-packet/blob/master/website/docs/r/ip_attachment.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["address"] = address
        __props__["address_family"] = address_family
        __props__["cidr"] = cidr
        __props__["cidr_notation"] = cidr_notation
        __props__["device_id"] = device_id
        __props__["gateway"] = gateway
        __props__["global_"] = global_
        __props__["manageable"] = manageable
        __props__["management"] = management
        __props__["netmask"] = netmask
        __props__["network"] = network
        __props__["public"] = public
        return IpAttachment(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

