# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Connect(pulumi.CustomResource):
    facility: pulumi.Output[str]
    """
    Facility where to create the VLAN
    """
    name: pulumi.Output[str]
    """
    Name for the Connect resource
    """
    port_speed: pulumi.Output[float]
    """
    Port speed in Mbps
    """
    project_id: pulumi.Output[str]
    """
    ID of parent project
    """
    provider_id: pulumi.Output[str]
    """
    ID of Connect Provider. Provider IDs are
    * Azure ExpressRoute - "ed5de8e0-77a9-4d3b-9de0-65281d3aa831"
    """
    provider_payload: pulumi.Output[str]
    """
    Authorization key for the Connect provider
    """
    status: pulumi.Output[str]
    """
    Status of the Connect resource, one of PROVISIONING, PROVISIONED, DEPROVISIONING, DEPROVISIONED
    """
    vxlan: pulumi.Output[float]
    """
    VXLAN Network identifier of the linked Packet VLAN
    """
    def __init__(__self__, resource_name, opts=None, facility=None, name=None, port_speed=None, project_id=None, provider_id=None, provider_payload=None, vxlan=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a resource for [Packet Connect](https://www.packet.com/cloud/all-features/packet-connect/), a link between Packet VLANs and VLANs in other cloud providers.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] facility: Facility where to create the VLAN
        :param pulumi.Input[str] name: Name for the Connect resource
        :param pulumi.Input[float] port_speed: Port speed in Mbps
        :param pulumi.Input[str] project_id: ID of parent project
        :param pulumi.Input[str] provider_id: ID of Connect Provider. Provider IDs are
               * Azure ExpressRoute - "ed5de8e0-77a9-4d3b-9de0-65281d3aa831"
        :param pulumi.Input[str] provider_payload: Authorization key for the Connect provider
        :param pulumi.Input[float] vxlan: VXLAN Network identifier of the linked Packet VLAN

        > This content is derived from https://github.com/terraform-providers/terraform-provider-packet/blob/master/website/docs/r/connect.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if facility is None:
                raise TypeError("Missing required property 'facility'")
            __props__['facility'] = facility
            if name is None:
                raise TypeError("Missing required property 'name'")
            __props__['name'] = name
            if port_speed is None:
                raise TypeError("Missing required property 'port_speed'")
            __props__['port_speed'] = port_speed
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            if provider_id is None:
                raise TypeError("Missing required property 'provider_id'")
            __props__['provider_id'] = provider_id
            if provider_payload is None:
                raise TypeError("Missing required property 'provider_payload'")
            __props__['provider_payload'] = provider_payload
            if vxlan is None:
                raise TypeError("Missing required property 'vxlan'")
            __props__['vxlan'] = vxlan
            __props__['status'] = None
        super(Connect, __self__).__init__(
            'packet:index/connect:Connect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, facility=None, name=None, port_speed=None, project_id=None, provider_id=None, provider_payload=None, status=None, vxlan=None):
        """
        Get an existing Connect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] facility: Facility where to create the VLAN
        :param pulumi.Input[str] name: Name for the Connect resource
        :param pulumi.Input[float] port_speed: Port speed in Mbps
        :param pulumi.Input[str] project_id: ID of parent project
        :param pulumi.Input[str] provider_id: ID of Connect Provider. Provider IDs are
               * Azure ExpressRoute - "ed5de8e0-77a9-4d3b-9de0-65281d3aa831"
        :param pulumi.Input[str] provider_payload: Authorization key for the Connect provider
        :param pulumi.Input[str] status: Status of the Connect resource, one of PROVISIONING, PROVISIONED, DEPROVISIONING, DEPROVISIONED
        :param pulumi.Input[float] vxlan: VXLAN Network identifier of the linked Packet VLAN

        > This content is derived from https://github.com/terraform-providers/terraform-provider-packet/blob/master/website/docs/r/connect.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["facility"] = facility
        __props__["name"] = name
        __props__["port_speed"] = port_speed
        __props__["project_id"] = project_id
        __props__["provider_id"] = provider_id
        __props__["provider_payload"] = provider_payload
        __props__["status"] = status
        __props__["vxlan"] = vxlan
        return Connect(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

