"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchSetAlarmStateAction);
            }
            throw error;
        }
    }
    bind(topicRule) {
        const role = this.props.role ?? role_1.singletonActionRole(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: this.props.reason ?? `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchSetAlarmStateAction", version: "2.31.2-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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