# Generated by Django 3.0.3 on 2021-03-25 15:59
from concurrent.futures import ThreadPoolExecutor

import core.fields
import datetime
from django.db import migrations, models
import django.db.models.deletion
import uuid

from claim_batch.models import BatchRun
from claim_batch.services import ProcessBatchSubmit, ProcessBatchService


def add_previous_batch_run_catpitaion_payment_entries(apps, schema_editor):
    service = ProcessBatchService(None)
    batch_runs = BatchRun.objects.filter(validity_to=None).values('location', 'run_year', 'run_month').all()
    with ThreadPoolExecutor(max_workers=30) as executor:
        for run in batch_runs:
            submit = ProcessBatchSubmit(
                location_id=run['location'],
                year=run['run_year'],
                month=run['run_month'],
            )
            executor.submit(service.capitation_report_data_for_summit, submit)


class Migration(migrations.Migration):

    dependencies = [
        ('claim_batch', '0002_capitationpayment'),
    ]

    operations = [
        migrations.RunPython(add_previous_batch_run_catpitaion_payment_entries, reverse_code=migrations.RunPython.noop)
    ]
