/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.CompositeMFileFilter;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.inventory.filter.WildcardMatchOnPath;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;

@ThreadSafe
public class MFileCollectionManager
extends CollectionManagerAbstract {
    private static MController controller;
    private final List<CollectionConfig> scanList = new ArrayList<CollectionConfig>();
    private final long olderThanInMsecs;
    protected FeatureCollectionConfig config;
    @GuardedBy(value="this")
    private Map<String, MFile> map;
    @GuardedBy(value="this")
    private long lastScanned;
    @GuardedBy(value="this")
    private AtomicLong lastChanged = new AtomicLong();
    protected CollectionManager.ChangeChecker changeChecker = null;

    public static void setController(MController _controller) {
        controller = _controller;
    }

    public static MController getController() {
        if (null == controller) {
            controller = new ControllerOS();
        }
        return controller;
    }

    public static MFileCollectionManager open(String collectionName, String collectionSpec, String olderThan, Formatter errlog) throws IOException {
        return new MFileCollectionManager(collectionName, collectionSpec, olderThan, errlog);
    }

    public static MFileCollectionManager openWithRecheck(String collectionName, String recheckS) {
        return new MFileCollectionManager(collectionName, recheckS);
    }

    private MFileCollectionManager(String collectionName, String collectionSpec, String olderThan, Formatter errlog) {
        super(collectionName, null);
        CollectionSpecParser sp = new CollectionSpecParser(collectionSpec, errlog);
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.root = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(2);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanInMsecs = this.parseOlderThanFilter(olderThan);
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), true);
        this.scanList.add(new CollectionConfig(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
    }

    public MFileCollectionManager(FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        super(config.collectionName != null ? config.collectionName : config.spec, logger);
        this.config = config;
        CollectionSpecParser sp = config.getCollectionSpecParser(errlog);
        this.root = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanInMsecs = this.parseOlderThanFilter(config.olderThan);
        this.dateExtractor = config.dateFormatMark != null ? new DateExtractorFromName(config.dateFormatMark, false) : (sp.getDateFormatMark() != null ? new DateExtractorFromName(sp.getDateFormatMark(), true) : new DateExtractorNone());
        this.scanList.add(new CollectionConfig(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        if (config.protoConfig != null) {
            this.protoChoice = config.protoConfig.choice;
        }
        if (config.updateConfig != null) {
            this.recheck = this.makeRecheck(config.updateConfig.recheckAfter);
            if (config.updateConfig.recheckAfter == null && config.updateConfig.rescan == null && config.updateConfig.deleteAfter == null) {
                this.setStatic(true);
            }
        }
        if (this.auxInfo == null) {
            this.auxInfo = new HashMap(10);
        }
        this.auxInfo.put("fcConfig", config);
    }

    private long parseOlderThanFilter(String olderThan) {
        if (olderThan != null) {
            try {
                TimeDuration tu = new TimeDuration(olderThan);
                return (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderThan);
            }
        }
        return -1L;
    }

    private TimeDuration makeRecheck(String recheckS) {
        if (recheckS != null) {
            try {
                return new TimeDuration(recheckS);
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
        return null;
    }

    protected MFileCollectionManager(String name, Logger logger) {
        super(name, logger);
        this.recheck = null;
        this.olderThanInMsecs = -1L;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
    }

    public MFileCollectionManager(String name, String spec, Formatter errlog, Logger logger) {
        super(name, logger);
        CollectionSpecParser sp = new CollectionSpecParser(spec, errlog);
        this.root = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), true);
        this.scanList.add(new CollectionConfig(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanInMsecs = -1L;
    }

    public MFileCollectionManager(String name, CollectionConfig mc, CalendarDate startPartition, Logger logger) {
        super(name, logger);
        this.startCollection = startPartition;
        this.scanList.add(mc);
        this.root = mc.getDirectoryName();
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanInMsecs = -1L;
    }

    private MFileCollectionManager(String collectionName, String recheckS) {
        super(collectionName, null);
        this.recheck = this.makeRecheck(recheckS);
        this.olderThanInMsecs = -1L;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, Object auxInfo) {
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != regexpPatternString) {
            filters.add(new RegExpMatchOnName(regexpPatternString));
        } else if (suffix != null) {
            filters.add(new WildcardMatchOnPath("*" + suffix + "$"));
        }
        if (olderS != null) {
            try {
                TimeDuration tu = new TimeDuration(olderS);
                filters.add(new LastModifiedLimit((long)(1000.0 * tu.getValueInSeconds())));
            }
            catch (Exception e) {
                this.logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        boolean wantSubdirs = true;
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            wantSubdirs = false;
        }
        CompositeMFileFilter filter = filters.size() == 0 ? null : (filters.size() == 1 ? (MFileFilter)filters.get(0) : new CompositeMFileFilter(filters));
        CollectionConfig mc = new CollectionConfig(dirName, dirName, wantSubdirs, filter, auxInfo);
        StringBuilder sb = new StringBuilder(dirName);
        if (wantSubdirs) {
            sb.append("**/");
        }
        if (null != regexpPatternString) {
            sb.append(regexpPatternString);
        } else if (suffix != null) {
            sb.append(suffix);
        } else {
            sb.append("noFilter");
        }
        this.collectionName = sb.toString();
        this.scanList.add(mc);
    }

    public long getOlderThanFilterInMSecs() {
        return this.olderThanInMsecs;
    }

    @Override
    public synchronized long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public synchronized long getLastChanged() {
        return this.lastChanged.get();
    }

    protected boolean hasScans() {
        return !this.scanList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanNeeded() {
        if (this.recheck == null) {
            this.logger.debug("{}: scan not needed, recheck null", (Object)this.collectionName);
            return false;
        }
        if (!this.hasScans()) {
            this.logger.debug("{}: scan not needed, no scanners", (Object)this.collectionName);
            return false;
        }
        MFileCollectionManager mFileCollectionManager = this;
        synchronized (mFileCollectionManager) {
            if (this.map == null && !this.isStatic()) {
                this.logger.debug("{}: scan needed, never scanned", (Object)this.collectionName);
                return true;
            }
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.getLastScanned());
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            this.logger.debug("{}: scan not needed, last scanned={}, now={}", this.collectionName, lastCheckedDate, now);
            return false;
        }
        return true;
    }

    public synchronized void setChangeChecker(CollectionManager.ChangeChecker strat) {
        this.changeChecker = strat;
    }

    @Override
    public synchronized boolean scan(boolean sendEvent) throws IOException {
        boolean changed;
        if (this.map == null) {
            boolean changed2 = this.scanFirstTime();
            if (changed2 && sendEvent) {
                this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionUpdateType.always));
            }
            return changed2;
        }
        long olderThan = this.olderThanInMsecs <= 0L ? -1L : System.currentTimeMillis() - this.olderThanInMsecs;
        Map<String, MFile> oldMap = this.map;
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.reallyScan(newMap);
        int nnew = 0;
        int nchange = 0;
        Iterator iter = newMap.values().iterator();
        while (iter.hasNext()) {
            MFile newFile = (MFile)iter.next();
            String path = newFile.getPath();
            MFile oldFile = oldMap.get(path);
            if (oldFile != null) {
                if (newFile.getLastModified() > oldFile.getLastModified()) {
                    ++nchange;
                    this.logger.debug("{}: scan found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                    continue;
                }
                if (this.changeChecker == null || !this.changeChecker.hasntChangedSince(newFile, oldFile.getLastModified())) continue;
                ++nchange;
                this.logger.debug("{}: scan changeChecker found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                continue;
            }
            if (olderThan > 0L && newFile.getLastModified() > olderThan) {
                iter.remove();
                this.logger.debug("{}: scan found new Dataset but its too recently modified = {}", (Object)this.collectionName, (Object)path);
                continue;
            }
            ++nnew;
            this.logger.debug("{}: scan found new Dataset= {} ", (Object)this.collectionName, (Object)path);
        }
        int ndelete = 0;
        for (MFile oldDataset : oldMap.values()) {
            String path = oldDataset.getPath();
            MFile newDataset = (MFile)newMap.get(path);
            if (newDataset != null) continue;
            ++ndelete;
            this.logger.debug("{}: scan found deleted Dataset={}", (Object)this.collectionName, (Object)path);
        }
        boolean bl = changed = nnew > 0 || ndelete > 0 || nchange > 0;
        if (changed) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{}: scan found changes {}: nnew={}, nchange={}, ndelete={}", this.collectionName, new Date(), nnew, nchange, ndelete);
            }
            this.map = newMap;
            this.lastScanned = System.currentTimeMillis();
            this.lastChanged.set(this.lastScanned);
        } else {
            this.lastScanned = System.currentTimeMillis();
        }
        if (changed && sendEvent) {
            this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionUpdateType.always));
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiles(Iterable<MFile> files) {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        for (MFile file2 : files) {
            newMap.put(file2.getPath(), file2);
        }
        MFileCollectionManager mFileCollectionManager = this;
        synchronized (mFileCollectionManager) {
            this.map = newMap;
            this.lastScanned = System.currentTimeMillis();
            this.lastChanged.set(this.lastScanned);
        }
    }

    @Override
    public synchronized Iterable<MFile> getFilesSorted() {
        if (this.map == null) {
            try {
                this.scanFirstTime();
            }
            catch (IOException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        ArrayList<MFile> result = new ArrayList<MFile>(this.map.values());
        if (this.hasDateExtractor()) {
            Collections.sort(result, new CollectionAbstract.DateSorter());
        } else {
            Collections.sort(result);
        }
        return result;
    }

    @Override
    public boolean hasDateExtractor() {
        return this.dateExtractor != null && !(this.dateExtractor instanceof DateExtractorNone);
    }

    private boolean scanFirstTime() throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        if (!this.hasScans()) {
            this.map = newMap;
            return false;
        }
        this.reallyScan(newMap);
        if (this.olderThanInMsecs > 0L) {
            long olderThan = System.currentTimeMillis() - this.olderThanInMsecs;
            Iterator iter = newMap.values().iterator();
            while (iter.hasNext()) {
                MFile newFile = (MFile)iter.next();
                String path = newFile.getPath();
                if (newFile.getLastModified() <= olderThan) continue;
                iter.remove();
                this.logger.debug("{}: scan found new Dataset but its too recently modified = {}", (Object)this.collectionName, (Object)path);
            }
        }
        this.map = newMap;
        this.lastScanned = System.currentTimeMillis();
        this.lastChanged.set(this.lastScanned);
        this.logger.debug("{} : initial scan found n datasets = {} ", (Object)this.collectionName, (Object)this.map.keySet().size());
        return this.map.keySet().size() > 0;
    }

    protected void reallyScan(Map<String, MFile> map) throws IOException {
        MFileCollectionManager.getController();
        int count = 0;
        for (CollectionConfig mc : this.scanList) {
            Iterator<MFile> iter;
            long start = System.currentTimeMillis();
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventoryAll(mc, true) : controller.getInventoryTop(mc, true);
            if (iter == null) {
                this.logger.error(this.collectionName + ": Invalid collection= " + mc);
                continue;
            }
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                map.put(mfile.getPath(), mfile);
                ++count;
            }
            long took = (System.currentTimeMillis() - start) / 1000L;
            if (!this.logger.isDebugEnabled()) continue;
            long took2 = (System.currentTimeMillis() - start) / 1000L;
            this.logger.debug("{} : was scanned nfiles= {} took={} secs", this.collectionName, count, took2);
        }
        if (map.size() == 0) {
            this.logger.warn("MFileCollectionManager: No files found for {}", (Object)this.collectionName);
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetCollectionManager{ collectionName='%s' recheck=%s ", this.collectionName, this.recheck);
        for (CollectionConfig mc : this.scanList) {
            f.format("%n dir=%s filter=%s", mc.getDirectoryName(), mc.getFileFilter());
        }
        return f.toString();
    }
}

