/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Arc
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Arc.class);
    private ArcType type;

    public Arc() {
    }

    public Arc(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Arc(Arc orig) {
        super(orig);
        this.type = orig.type;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Type")) {
            this.setType(ArcType.fromString(element.getAttribute("Type")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public ArcType getType() {
        return this.type;
    }

    public void setType(ArcType type) {
        this.type = type;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Arc_element) {
        if (Arc_element == null) {
            Arc_element = document.createElementNS(NAMESPACE, "Arc");
        }
        super.asXMLElement(document, Arc_element);
        if (this.type != null) {
            Arc_element.setAttribute("Type", this.type.toString());
        }
        return Arc_element;
    }
}

