/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.lang.reflect.Array;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class ArrayDescriptor {
    static String theType = "";
    static Class<? extends Object> theClass = null;
    static int[] dimlen = null;
    static int[] dimstart = null;
    static int[] currentindex = null;
    static int[] bytetoindex = null;
    static int totalSize = 0;
    static Object[] objs = null;
    static char NT = (char)32;
    static int NTsize = 0;
    static int dims = 0;
    static String className;

    public ArrayDescriptor(Object anArray) throws HDF5Exception {
        Object o;
        String ss;
        Class<?> tc = anArray.getClass();
        if (!tc.isArray()) {
            HDF5JavaException ex = new HDF5JavaException("ArrayDescriptor: not an array?: ");
            throw ex;
        }
        theClass = tc;
        theType = ss = tc.toString();
        int n = 6;
        dims = 0;
        int c = 32;
        while (n < ss.length()) {
            c = ss.charAt(n);
            ++n;
            if (c != 91) continue;
            ++dims;
        }
        String css = ss.substring(ss.lastIndexOf(91) + 1);
        NT = (char)c;
        if (NT == 'B') {
            NTsize = 1;
        } else if (NT == 'S') {
            NTsize = 2;
        } else if (NT == 'I' || NT == 'F') {
            NTsize = 4;
        } else if (NT == 'J' || NT == 'D') {
            NTsize = 8;
        } else if (css.startsWith("Ljava.lang.Byte")) {
            NT = (char)76;
            className = "java.lang.Byte";
            NTsize = 1;
        } else if (css.startsWith("Ljava.lang.Short")) {
            NT = (char)76;
            className = "java.lang.Short";
            NTsize = 2;
        } else if (css.startsWith("Ljava.lang.Integer")) {
            NT = (char)76;
            className = "java.lang.Integer";
            NTsize = 4;
        } else if (css.startsWith("Ljava.lang.Float")) {
            NT = (char)76;
            className = "java.lang.Float";
            NTsize = 4;
        } else if (css.startsWith("Ljava.lang.Double")) {
            NT = (char)76;
            className = "java.lang.Double";
            NTsize = 8;
        } else if (css.startsWith("Ljava.lang.Long")) {
            NT = (char)76;
            className = "java.lang.Long";
            NTsize = 8;
        } else {
            if (css.startsWith("Ljava.lang.String")) {
                throw new HDF5JavaException(new String("ArrayDesciptor: Error:  String array not supported yet"));
            }
            throw new HDF5JavaException(new String("ArrayDesciptor: Error:  array is not numeric (type is " + css + ") ?"));
        }
        dimlen = new int[dims + 1];
        dimstart = new int[dims + 1];
        currentindex = new int[dims + 1];
        bytetoindex = new int[dims + 1];
        objs = new Object[dims + 1];
        ArrayDescriptor.objs[0] = o = anArray;
        ArrayDescriptor.dimlen[0] = 1;
        ArrayDescriptor.dimstart[0] = 0;
        ArrayDescriptor.currentindex[0] = 0;
        int i = 1;
        while (i <= dims) {
            ArrayDescriptor.dimlen[i] = Array.getLength(o);
            ArrayDescriptor.objs[i] = o = Array.get(o, 0);
            ArrayDescriptor.dimstart[i] = 0;
            ArrayDescriptor.currentindex[i] = 0;
            ++i;
        }
        ArrayDescriptor.bytetoindex[ArrayDescriptor.dims] = NTsize;
        i = dims;
        while (i >= 0) {
            int dd = NTsize;
            int j = i;
            while (j < dims) {
                dd *= dimlen[j + 1];
                ++j;
            }
            ArrayDescriptor.bytetoindex[i] = dd;
            --i;
        }
        totalSize = bytetoindex[0];
    }

    public void dumpInfo() {
        System.out.println("Type: " + theType);
        System.out.println("Class: " + theClass);
        System.out.println("NT: " + NT + " NTsize: " + NTsize);
        System.out.println("Array has " + dims + " dimensions (" + totalSize + " bytes)");
        int i = 0;
        while (i <= dims) {
            Class<?> tc = objs[i].getClass();
            String ss = tc.toString();
            System.out.println(String.valueOf(i) + ":  start " + dimstart[i] + ": len " + dimlen[i] + " current " + currentindex[i] + " bytetoindex " + bytetoindex[i] + " object " + objs[i] + " otype " + ss);
            ++i;
        }
    }
}

