/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.meta.MetadataStore;

public class ChannelFiller
extends ReaderWrapper {
    protected Boolean filled = null;
    protected int lutLength;

    public static ChannelFiller makeChannelFiller(IFormatReader r) {
        if (r instanceof ChannelFiller) {
            return (ChannelFiller)r;
        }
        return new ChannelFiller(r);
    }

    public ChannelFiller() {
    }

    public ChannelFiller(IFormatReader r) {
        super(r);
    }

    public boolean isFilled() {
        if (!this.reader.isIndexed()) {
            return false;
        }
        if (this.lutLength < 1) {
            return false;
        }
        return this.filled == null ? !this.reader.isFalseColor() : this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    @Override
    public int getSizeC() {
        if (!this.isFilled()) {
            return this.reader.getSizeC();
        }
        return this.reader.getSizeC() * this.lutLength;
    }

    @Override
    public boolean isRGB() {
        if (!this.isFilled()) {
            return this.reader.isRGB();
        }
        return this.getRGBChannelCount() > 1;
    }

    @Override
    public boolean isIndexed() {
        if (!this.isFilled()) {
            return this.reader.isIndexed();
        }
        return false;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (!this.isFilled()) {
            return this.reader.get8BitLookupTable();
        }
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (!this.isFilled()) {
            return this.reader.get16BitLookupTable();
        }
        return null;
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        byte[] buf = DataTools.allocate(w, h2, this.getRGBChannelCount(), FormatTools.getBytesPerPixel(this.getPixelType()));
        return this.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        if (!this.isFilled()) {
            return this.reader.openBytes(no, buf, x, y, w, h2);
        }
        byte[] pix = this.reader.openBytes(no, x, y, w, h2);
        if (this.getPixelType() == 1) {
            byte[][] b = ImageTools.indexedToRGB(this.reader.get8BitLookupTable(), pix);
            if (this.isInterleaved()) {
                int pt = 0;
                for (int i = 0; i < b[0].length; ++i) {
                    for (int j = 0; j < b.length; ++j) {
                        buf[pt++] = b[j][i];
                    }
                }
            } else {
                for (int i = 0; i < b.length; ++i) {
                    System.arraycopy(b[i], 0, buf, i * b[i].length, b[i].length);
                }
            }
            return buf;
        }
        short[][] s2 = ImageTools.indexedToRGB(this.reader.get16BitLookupTable(), pix, this.isLittleEndian());
        if (this.isInterleaved()) {
            int pt = 0;
            for (int i = 0; i < s2[0].length; ++i) {
                for (int j = 0; j < s2.length; ++j) {
                    buf[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] & 0xFF : s2[j][i] >> 8);
                    buf[pt++] = (byte)(this.isLittleEndian() ? s2[j][i] >> 8 : s2[j][i] & 0xFF);
                }
            }
        } else {
            int pt = 0;
            for (int i = 0; i < s2.length; ++i) {
                for (int j = 0; j < s2[i].length; ++j) {
                    buf[pt++] = (byte)(this.isLittleEndian() ? s2[i][j] & 0xFF : s2[i][j] >> 8);
                    buf[pt++] = (byte)(this.isLittleEndian() ? s2[i][j] >> 8 : s2[i][j] & 0xFF);
                }
            }
        }
        return buf;
    }

    @Override
    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        this.lutLength = this.getLookupTableComponentCount();
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixelsOnly(store, this);
    }

    private int getLookupTableComponentCount() throws FormatException, IOException {
        byte[][] lut8 = this.reader.get8BitLookupTable();
        if (lut8 != null) {
            return lut8.length;
        }
        short[][] lut16 = this.reader.get16BitLookupTable();
        if (lut16 != null) {
            return lut16.length;
        }
        lut8 = this.reader.get8BitLookupTable();
        if (lut8 != null) {
            return lut8.length;
        }
        lut16 = this.reader.get16BitLookupTable();
        if (lut16 != null) {
            return lut16.length;
        }
        return 0;
    }
}

