/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.HDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.hdf5lib.H5F;
import java.io.File;

public final class HDF5FactoryProvider {
    private static IHDF5Factory factory = new HDF5Factory();

    private HDF5FactoryProvider() {
    }

    public static synchronized IHDF5Factory get() {
        return factory;
    }

    public static synchronized void set(IHDF5Factory factory) {
        HDF5FactoryProvider.factory = factory;
    }

    private static class HDF5Factory
    implements IHDF5Factory {
        private HDF5Factory() {
        }

        @Override
        public IHDF5WriterConfigurator configure(File file2) {
            return new HDF5WriterConfigurator(file2);
        }

        @Override
        public IHDF5ReaderConfigurator configureForReading(File file2) {
            return new HDF5ReaderConfigurator(file2);
        }

        @Override
        public IHDF5Writer open(File file2) {
            return new HDF5WriterConfigurator(file2).writer();
        }

        @Override
        public IHDF5Reader openForReading(File file2) {
            return new HDF5ReaderConfigurator(file2).reader();
        }

        @Override
        public boolean isHDF5File(File file2) {
            return H5F.H5Fis_hdf5(file2.getPath());
        }
    }
}

