# wom.py

An asynchronous wrapper for the [Wise Old Man API](https://docs.wiseoldman.net/).

The library aims to make is easy to interact with the Wise Old Man API by
providing service methods for all available endpoints and model classes
for data consistency.

## Disclaimer

The library is in early development, and as such features or public interfaces
may change at any time. Thanks for following our progress!

## Documentation

- [Stable](https://jonxslays.github.io/wom.py/)
- [Development](https://jonxslays.github.io/wom.py/dev/)

## Installation

### Stable

```sh
pip install -U wom.py
```

### Development

```sh
pip install -U git+https://github.com/Jonxslays/wom.py
```

For more information on using `pip`, check out the [pip documentation](https://pip.pypa.io/en/stable/).

## What is Wise Old Man

Wise Old Man is an open source Oldschool Runescape player progress tracker.

If you're interested in learning more about the Wise Old Man project, consider checking out any of these links:

- [Website](https://wiseoldman.net/)
- [API documentation](https://docs.wiseoldman.net/)
- [Github repository](https://wiseoldman.net/github)
- [Discord community](https://wiseoldman.net/discord)
- [Support the developers on Patreon](https://wiseoldman.net/patreon)

Some of the popular features include:

- Experience tracking
- Boss killcounts
- Player achievements
- Group competitions
- Global leaderboards
- A discord bot for interacting with the API

## Problems

If you're experiencing a problem with the library, please open an issue
[here](https://github.com/Jonxslays/wom.py/issues), after first confirming
a similar issue was not already created.

## Contributing

wom.py is open to contributions.

Come back soon™ once I've written the contributing guide.

## License

wom.py is licensed under the
[MIT License](https://github.com/Jonxslays/wom.py/blob/master/LICENSE).
