# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### KongEks <a name="KongEks" id="kong-data-plane.KongEks"></a>

#### Initializers <a name="Initializers" id="kong-data-plane.KongEks.Initializer"></a>

```typescript
import { KongEks } from 'kong-data-plane'

new KongEks(scope: Construct, id: string, props: KongEksDataPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | - represents the scope for all the resources. |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.id">id</a></code> | <code>string</code> | - this is a a scope-unique id. |
| <code><a href="#kong-data-plane.KongEks.Initializer.parameter.props">props</a></code> | <code>kong-core.KongEksDataPlaneProps</code> | - user provided props for the construct. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-data-plane.KongEks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

represents the scope for all the resources.

---

##### `id`<sup>Required</sup> <a name="id" id="kong-data-plane.KongEks.Initializer.parameter.id"></a>

- *Type:* string

this is a a scope-unique id.

---

##### `props`<sup>Required</sup> <a name="props" id="kong-data-plane.KongEks.Initializer.parameter.props"></a>

- *Type:* kong-core.KongEksDataPlaneProps

user provided props for the construct.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEks.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-data-plane.KongEks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-data-plane.KongEks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-data-plane.KongEks.isConstruct"></a>

```typescript
import { KongEks } from 'kong-data-plane'

KongEks.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-data-plane.KongEks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-data-plane.KongEks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-data-plane.KongEks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---





