![Pyot](banner.jpg)
# Pyot
![Python](https://img.shields.io/badge/python-3670A0?style=for-the-badge&logo=python&logoColor=ffdd54)
[![Licence](https://img.shields.io/github/license/Ileriayo/markdown-badges?style=for-the-badge)](https://github.com/paaksing/pyot/blob/master/LICENSE)
[![GitHub](https://img.shields.io/badge/github-%23121011.svg?style=for-the-badge&logo=github&logoColor=white)](https://github.com/paaksing/pyot)

Pyot is an asyncIO based high-level Python Riot Games API framework which encourages rapid development and clean, pragmatic design. Takes care much of the hassle of the Riot Games API, so developers can focus on writing apps without needing to reinvent the wheel. It’s free and open source.

| Index | Version |
| ---- | ------- |
| PyPI | `6.0.6` |
| master | `6.0.6` |

If you're migrating your project to a newer version of Pyot, please refer to **Changelog** section of the [documentation](https://pyot.paaksing.com).

## Features

Features that Pyot can provide for your projects.

- **_AsyncIO Based_**: Performing 60x faster with AsyncIO, highly configurable settings and wide range of tools to speed I/O tasks.
- **_Community Projects Integrations_**: Includes support for CDragon, MerakiCDN. DDragon for LoL is Forbidden due to incompatible APIs.
- **_Caches Integrated_**: A wide range of Caches Stores is available out of the box, currently supports Omnistone(Runtime), RedisCache(RAM), DiskCache(Disk) and MongoDB(NoSQL).
- **_Multiple Models_**: Available models of League of Legends, Teamfight Tactics, Legends of Runeterra and VALORANT.
- **_Code Autocompletion_**: Access data through attributes and properties, maximize code efficiency with code autocompletion.
- **_Perfect Rate Limiter_**: Pyot's Rate Limiter is production tested in all asynchronous, multithreaded and even multiprocessed environments.
- **_User Friendly Docs_**: Human redable documentation that covers guides and all the available high-level and low-level APIs in Pyot.

If this framework is useful, consider giving a **star** to the repo.

## Documentation

Portal: <https://pyot.paaksing.com>

The documentation covers:

- Installation.
- Configuration.
- Base Objects.
- Concurrency Basics.
- Models API.
- Stores.
- Limiters.
- Utilities.
- Integrations.
- Issues.
- Changelog.

Due to the complexity of the framework, there is no quick-start guide, it is recommended to start with:

- Reading and understanding the **Cores** section of the documentation.
- Reading and understanding the example projects at **Examples** section to get familiar.
- If your project requires a specific integration, check out **Integrations** section.
