# coding: utf-8

"""
    OriginStamp Client

    OpenAPI spec version: 3.0
    OriginStamp Documentation: https://docs.originstamp.com
    Contact: mail@originstamp.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from originstamp_client.api_client import ApiClient


class TimestampApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_timestamp(self, authorization, timestamp_request, **kwargs):  # noqa: E501
        """Submission  # noqa: E501

        With this interface you can submit your hash. If your API key is valid, your hash is added  seeds and scheduled for timestamping. You are also able to submit additional information, such as a comment or notification target. If the hash already exists, the 'created' field in the response is set to 'false' and any notification(s) for this hash will be ignored. To later query the status of the hash for a certain blockchain you can use the 'seed_id' field of its inner timestamp structure. This field can be used to query the timestamping status of the selected seed. This is recommended if a large number of hashes were transmitted in a certain time frame. Once a hash is successfully created for a certain crypto currency, we can notify your desired target with the timestamp information (via POST Request). A webhook is triggered as soon as the tamper-proof timestamp with the selected crypto currency has been created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_timestamp(authorization, timestamp_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param TimestampRequest timestamp_request: DTO for the hash submission. Add all relevant information concerning your hash submission. (required)
        :return: DefaultOfTimestampResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_timestamp_with_http_info(authorization, timestamp_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_timestamp_with_http_info(authorization, timestamp_request, **kwargs)  # noqa: E501
            return data

    def create_timestamp_with_http_info(self, authorization, timestamp_request, **kwargs):  # noqa: E501
        """Submission  # noqa: E501

        With this interface you can submit your hash. If your API key is valid, your hash is added  seeds and scheduled for timestamping. You are also able to submit additional information, such as a comment or notification target. If the hash already exists, the 'created' field in the response is set to 'false' and any notification(s) for this hash will be ignored. To later query the status of the hash for a certain blockchain you can use the 'seed_id' field of its inner timestamp structure. This field can be used to query the timestamping status of the selected seed. This is recommended if a large number of hashes were transmitted in a certain time frame. Once a hash is successfully created for a certain crypto currency, we can notify your desired target with the timestamp information (via POST Request). A webhook is triggered as soon as the tamper-proof timestamp with the selected crypto currency has been created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_timestamp_with_http_info(authorization, timestamp_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param TimestampRequest timestamp_request: DTO for the hash submission. Add all relevant information concerning your hash submission. (required)
        :return: DefaultOfTimestampResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'timestamp_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_timestamp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `create_timestamp`")  # noqa: E501
        # verify the required parameter 'timestamp_request' is set
        if ('timestamp_request' not in params or
                params['timestamp_request'] is None):
            raise ValueError("Missing the required parameter `timestamp_request` when calling `create_timestamp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'timestamp_request' in params:
            body_params = params['timestamp_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v4/timestamp/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfTimestampResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hash_status(self, authorization, hash_string, **kwargs):  # noqa: E501
        """Status  # noqa: E501

        This interface returns information of a certain hash read from the URL path. If the status of several hashes is to be checked, it is preferable to use the seed status interface. This reduces the required requests and can be tailored to a desired blockchain. All 'created' fields are always set to false for a status request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hash_status(authorization, hash_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str hash_string: The hash in string representation. (required)
        :return: DefaultOfTimestampResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hash_status_with_http_info(authorization, hash_string, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hash_status_with_http_info(authorization, hash_string, **kwargs)  # noqa: E501
            return data

    def get_hash_status_with_http_info(self, authorization, hash_string, **kwargs):  # noqa: E501
        """Status  # noqa: E501

        This interface returns information of a certain hash read from the URL path. If the status of several hashes is to be checked, it is preferable to use the seed status interface. This reduces the required requests and can be tailored to a desired blockchain. All 'created' fields are always set to false for a status request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hash_status_with_http_info(authorization, hash_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str hash_string: The hash in string representation. (required)
        :return: DefaultOfTimestampResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'hash_string']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hash_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_hash_status`")  # noqa: E501
        # verify the required parameter 'hash_string' is set
        if ('hash_string' not in params or
                params['hash_string'] is None):
            raise ValueError("Missing the required parameter `hash_string` when calling `get_hash_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hash_string' in params:
            path_params['hash_string'] = params['hash_string']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v4/timestamp/{hash_string}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfTimestampResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_seed_status(self, authorization, seed_id, **kwargs):  # noqa: E501
        """Seed Status  # noqa: E501

        With this interface you can request the status for a certain seed. This is used when checking the status of previously submitted hashes and avoids sending individual status requests for each hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_seed_status(authorization, seed_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str seed_id: ID of the timestamp seed (required)
        :return: DefaultOfTimestampData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_seed_status_with_http_info(authorization, seed_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_seed_status_with_http_info(authorization, seed_id, **kwargs)  # noqa: E501
            return data

    def get_seed_status_with_http_info(self, authorization, seed_id, **kwargs):  # noqa: E501
        """Seed Status  # noqa: E501

        With this interface you can request the status for a certain seed. This is used when checking the status of previously submitted hashes and avoids sending individual status requests for each hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_seed_status_with_http_info(authorization, seed_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str seed_id: ID of the timestamp seed (required)
        :return: DefaultOfTimestampData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'seed_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_seed_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_seed_status`")  # noqa: E501
        # verify the required parameter 'seed_id' is set
        if ('seed_id' not in params or
                params['seed_id'] is None):
            raise ValueError("Missing the required parameter `seed_id` when calling `get_seed_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'seed_id' in params:
            path_params['seed_id'] = params['seed_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v4/timestamp/status/seed/{seed_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfTimestampData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
