# coding: utf-8

"""
    OriginStamp Client

    OpenAPI spec version: 3.0
    OriginStamp Documentation: https://docs.originstamp.com
    Contact: mail@originstamp.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from originstamp_client.api_client import ApiClient


class BulkApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_bulk_timestamp(self, authorization, timestamp_bulk_request, **kwargs):  # noqa: E501
        """Bulk Submission  # noqa: E501

        With this interface you can submit multiple hashes at once. If your API key is valid, your hashes are added to seeds and scheduled for timestamping. You are also able to submit additional information with every hash, such as a comment or notification target. If the hash already exists, the 'created' field in the response is set to 'false' and the notification(s) of the corresponding hash will be ignored. To later query the status of any hash for a certain blockchain you can use the 'seed_id' field of its inner timestamp structure. This field can be used to query the timestamping status of the selected seed. This is recommended if a large number of hashes were transmitted in a certain time frame. Once a hash is successfully created for a certain crypto currency, we can notify your desired target with the timestamp information (via POST Request). A webhook for a submitted hash is triggered as soon as the tamper-proof timestamp with the selected crypto currency has been created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bulk_timestamp(authorization, timestamp_bulk_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param TimestampBulkRequest timestamp_bulk_request: DTO for the bulk hash submission. Add all relevant information concerning your hash submissions. (required)
        :return: list[DefaultOfTimestampResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bulk_timestamp_with_http_info(authorization, timestamp_bulk_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bulk_timestamp_with_http_info(authorization, timestamp_bulk_request, **kwargs)  # noqa: E501
            return data

    def create_bulk_timestamp_with_http_info(self, authorization, timestamp_bulk_request, **kwargs):  # noqa: E501
        """Bulk Submission  # noqa: E501

        With this interface you can submit multiple hashes at once. If your API key is valid, your hashes are added to seeds and scheduled for timestamping. You are also able to submit additional information with every hash, such as a comment or notification target. If the hash already exists, the 'created' field in the response is set to 'false' and the notification(s) of the corresponding hash will be ignored. To later query the status of any hash for a certain blockchain you can use the 'seed_id' field of its inner timestamp structure. This field can be used to query the timestamping status of the selected seed. This is recommended if a large number of hashes were transmitted in a certain time frame. Once a hash is successfully created for a certain crypto currency, we can notify your desired target with the timestamp information (via POST Request). A webhook for a submitted hash is triggered as soon as the tamper-proof timestamp with the selected crypto currency has been created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bulk_timestamp_with_http_info(authorization, timestamp_bulk_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param TimestampBulkRequest timestamp_bulk_request: DTO for the bulk hash submission. Add all relevant information concerning your hash submissions. (required)
        :return: list[DefaultOfTimestampResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'timestamp_bulk_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_timestamp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `create_bulk_timestamp`")  # noqa: E501
        # verify the required parameter 'timestamp_bulk_request' is set
        if ('timestamp_bulk_request' not in params or
                params['timestamp_bulk_request'] is None):
            raise ValueError("Missing the required parameter `timestamp_bulk_request` when calling `create_bulk_timestamp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'timestamp_bulk_request' in params:
            body_params = params['timestamp_bulk_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v4/timestamp/bulk/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DefaultOfTimestampResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_seed_status(self, authorization, seed_id, **kwargs):  # noqa: E501
        """Seed Status  # noqa: E501

        With this interface you can request the status for a certain seed. This is used when checking the status of previously submitted hashes and avoids sending individual status requests for each hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_seed_status(authorization, seed_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str seed_id: ID of the timestamp seed (required)
        :return: DefaultOfTimestampData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_seed_status_with_http_info(authorization, seed_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_seed_status_with_http_info(authorization, seed_id, **kwargs)  # noqa: E501
            return data

    def get_seed_status_with_http_info(self, authorization, seed_id, **kwargs):  # noqa: E501
        """Seed Status  # noqa: E501

        With this interface you can request the status for a certain seed. This is used when checking the status of previously submitted hashes and avoids sending individual status requests for each hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_seed_status_with_http_info(authorization, seed_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param str seed_id: ID of the timestamp seed (required)
        :return: DefaultOfTimestampData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'seed_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_seed_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_seed_status`")  # noqa: E501
        # verify the required parameter 'seed_id' is set
        if ('seed_id' not in params or
                params['seed_id'] is None):
            raise ValueError("Missing the required parameter `seed_id` when calling `get_seed_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'seed_id' in params:
            path_params['seed_id'] = params['seed_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v4/timestamp/status/seed/{seed_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfTimestampData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
