import { IUserPool } from '../user-pool';
/**
 * An attribute available from a third party identity provider.
 *
 * @stability stable
 */
export declare class ProviderAttribute {
    /**
     * The email attribute provided by Apple.
     *
     * @stability stable
     */
    static readonly APPLE_EMAIL: ProviderAttribute;
    /**
     * The name attribute provided by Apple.
     *
     * @stability stable
     */
    static readonly APPLE_NAME: ProviderAttribute;
    /**
     * The first name attribute provided by Apple.
     *
     * @stability stable
     */
    static readonly APPLE_FIRST_NAME: ProviderAttribute;
    /**
     * The last name attribute provided by Apple.
     *
     * @stability stable
     */
    static readonly APPLE_LAST_NAME: ProviderAttribute;
    /**
     * The user id attribute provided by Amazon.
     *
     * @stability stable
     */
    static readonly AMAZON_USER_ID: ProviderAttribute;
    /**
     * The email attribute provided by Amazon.
     *
     * @stability stable
     */
    static readonly AMAZON_EMAIL: ProviderAttribute;
    /**
     * The name attribute provided by Amazon.
     *
     * @stability stable
     */
    static readonly AMAZON_NAME: ProviderAttribute;
    /**
     * The postal code attribute provided by Amazon.
     *
     * @stability stable
     */
    static readonly AMAZON_POSTAL_CODE: ProviderAttribute;
    /**
     * The user id attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_ID: ProviderAttribute;
    /**
     * The birthday attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_BIRTHDAY: ProviderAttribute;
    /**
     * The email attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_EMAIL: ProviderAttribute;
    /**
     * The name attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_NAME: ProviderAttribute;
    /**
     * The first name attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_FIRST_NAME: ProviderAttribute;
    /**
     * The last name attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_LAST_NAME: ProviderAttribute;
    /**
     * The middle name attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_MIDDLE_NAME: ProviderAttribute;
    /**
     * The gender attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_GENDER: ProviderAttribute;
    /**
     * The locale attribute provided by Facebook.
     *
     * @stability stable
     */
    static readonly FACEBOOK_LOCALE: ProviderAttribute;
    /**
     * The name attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_NAMES: ProviderAttribute;
    /**
     * The gender attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_GENDER: ProviderAttribute;
    /**
     * The birthday attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_BIRTHDAYS: ProviderAttribute;
    /**
     * The phone number attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_PHONE_NUMBERS: ProviderAttribute;
    /**
     * The email attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_EMAIL: ProviderAttribute;
    /**
     * The name attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_NAME: ProviderAttribute;
    /**
     * The picture attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_PICTURE: ProviderAttribute;
    /**
     * The given name attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_GIVEN_NAME: ProviderAttribute;
    /**
     * The family name attribute provided by Google.
     *
     * @stability stable
     */
    static readonly GOOGLE_FAMILY_NAME: ProviderAttribute;
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @stability stable
     */
    static other(attributeName: string): ProviderAttribute;
    /**
     * The attribute value string as recognized by the provider.
     *
     * @stability stable
     */
    readonly attributeName: string;
    private constructor();
}
/**
 * The mapping of user pool attributes to the attributes provided by the identity providers.
 *
 * @stability stable
 */
export interface AttributeMapping {
    /**
     * The user's postal address is a required attribute.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly address?: ProviderAttribute;
    /**
     * The user's birthday.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly birthdate?: ProviderAttribute;
    /**
     * The user's e-mail address.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly email?: ProviderAttribute;
    /**
     * The surname or last name of user.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly familyName?: ProviderAttribute;
    /**
     * The user's gender.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly gender?: ProviderAttribute;
    /**
     * The user's first name or give name.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly givenName?: ProviderAttribute;
    /**
     * The user's locale.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly locale?: ProviderAttribute;
    /**
     * The user's middle name.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly middleName?: ProviderAttribute;
    /**
     * The user's full name in displayable form.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly fullname?: ProviderAttribute;
    /**
     * The user's nickname or casual name.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly nickname?: ProviderAttribute;
    /**
     * The user's telephone number.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly phoneNumber?: ProviderAttribute;
    /**
     * The URL to the user's profile picture.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly profilePicture?: ProviderAttribute;
    /**
     * The user's preferred username.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly preferredUsername?: ProviderAttribute;
    /**
     * The URL to the user's profile page.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly profilePage?: ProviderAttribute;
    /**
     * The user's time zone.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly timezone?: ProviderAttribute;
    /**
     * Time, the user's information was last updated.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly lastUpdateTime?: ProviderAttribute;
    /**
     * The URL to the user's web page or blog.
     *
     * @default - not mapped
     * @stability stable
     */
    readonly website?: ProviderAttribute;
    /**
     * Specify custom attribute mapping here and mapping for any standard attributes not supported yet.
     *
     * @default - no custom attribute mapping
     * @stability stable
     */
    readonly custom?: {
        [key: string]: ProviderAttribute;
    };
}
/**
 * Properties to create a new instance of UserPoolIdentityProvider.
 *
 * @stability stable
 */
export interface UserPoolIdentityProviderProps {
    /**
     * The user pool to which this construct provides identities.
     *
     * @stability stable
     */
    readonly userPool: IUserPool;
    /**
     * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
     *
     * @default - no attribute mapping
     * @stability stable
     */
    readonly attributeMapping?: AttributeMapping;
}
