import { IResource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Represents a UserPoolIdentityProvider.
 *
 * @stability stable
 */
export interface IUserPoolIdentityProvider extends IResource {
    /**
     * The primary identifier of this identity provider.
     *
     * @stability stable
     * @attribute true
     */
    readonly providerName: string;
}
/**
 * User pool third-party identity providers.
 *
 * @stability stable
 */
export declare class UserPoolIdentityProvider {
    /**
     * Import an existing UserPoolIdentityProvider.
     *
     * @stability stable
     */
    static fromProviderName(scope: Construct, id: string, providerName: string): IUserPoolIdentityProvider;
    private constructor();
}
