PEP: 8100 Title: January 2019 steering council election Version:
\$Revision\$ Last-Modified: \$Date\$ Author: Nathaniel J. Smith
\<<njs@pobox.com>\>, Ernest W. Durbin III \<<ewdurbin@gmail.com>\>
Status: Active Type: Informational Content-Type: text/x-rst Created:
3-Jan-2019

Abstract
========

This document describes the schedule and other details of the January
2019 election for the Python steering council, as specified in PEP 13.
This is the first steering council election.

Returns officer
===============

In future elections, the returns officer will be appointed by the
outgoing steering council. Since this is the first election, we have no
outgoing steering council, and PEP 13 says that the returns officer is
instead appointed by the PSF Executive Director, Ewa Jodlowska. [She
appointed Ernest W. Durbin
III](https://discuss.python.org/t/officially-appointing-the-returns-officer-for-the-steering-council-election/603).

Schedule
========

There will be a two-week nomination period, followed by a two-week vote.

The nomination period is: January 7, 2019 through January 20, 2019

The voting period is: January 21, 2019 12:00 UTC through February 4,
2019 12:00 UTC (The end of February 3, 2019 [Anywhere on
Earth](http://www.ieee802.org/16/aoe.html))

Candidates
==========

Candidates must be nominated by a core team member. If the candidate is
a core team member, they may nominate themselves.

Once the nomination period opens, candidates will be listed here:

1.  [Brett
    Cannon](https://discuss.python.org/t/steering-council-nomination-brett-cannon/620)
2.  [Nick
    Coghlan](https://discuss.python.org/t/steering-council-nomination-nick-coghlan/624)
3.  [Barry
    Warsaw](https://discuss.python.org/t/steering-council-nomination-barry-warsaw/629)
4.  [Guido van
    Rossum](https://discuss.python.org/t/steering-council-nomination-guido-van-rossum/628)
5.  [Victor
    Stinner](https://discuss.python.org/t/steering-council-nomination-victor-stinner/635)
6.  [Yury
    Selivanov](https://discuss.python.org/t/steering-council-nomination-yury-selivanov/645)
7.  [David
    Mertz](https://discuss.python.org/t/steering-council-nomination-david-mertz/647)
8.  [Łukasz
    Langa](https://discuss.python.org/t/steering-council-nomination-lukasz-langa/660)
9.  [Benjamin
    Peterson](https://discuss.python.org/t/steering-council-nomination-benjamin-peterson/665)
10. [Mariatta](https://discuss.python.org/t/steering-council-nomination-mariatta/670)
11. [Carol
    Willing](https://discuss.python.org/t/steering-council-nomination-carol-willing/674)
12. [Emily
    Morehouse](https://discuss.python.org/t/steering-council-nomination-emily-morehouse/686)
13. [Peter
    Wang](https://discuss.python.org/t/steering-council-nomination-peter-wang/694)
14. [Donald
    Stufft](https://discuss.python.org/t/steering-council-nomination-donald-stufft/700)
15. [Travis
    Oliphant](https://discuss.python.org/t/steering-council-nomination-travis-oliphant/705)
16. [Kushal
    Das](https://discuss.python.org/t/steering-council-nomination-kushal-das/702)
17. [Gregory P.
    Smith](https://discuss.python.org/t/steering-council-nomination-gregory-p-smith/737)

Voter Roll
==========

All active Python core team members are eligible to vote.

Ballots will be distributed based on the [The Python Voter Roll for this
election](https://github.com/python/voters/blob/master/2019-01-21-2019-python-steering-committee-election-election.csv)
[^1].

While this file is not public as it contains private email addresses,
the [Complete Voter Roll](#complete-voter-roll) by name is available.

Election Implementation
=======================

The election will be conducted using the [Helios Voting
Service](https://heliosvoting.org).

Configuration
-------------

Short name: `2019-python-steering-committee`

Name: `2019 Python Steering Committee Election`

Description:
`Election for the Python steering council, as specified in PEP 13. This is the first steering council election.`

type: `Election`

Use voter aliases: `[X]`

Randomize answer order: `[X]`

Private: `[X]`

Help Email Address: `ernest@python.org`

Voting starts at: `January 21, 2019 12:00 UTC`

Voting ends at: `February 4, 2019 12:00 UTC`

This will create an election in which:

-   Voting is not open to the public, only those on the [Voter
    Roll](#voter-roll) may participate. Ballots will be emailed when
    voting starts.
-   Candidates are presented in random order, to help avoid bias.
-   Voter identities and ballots are protected against cryptographic
    advances.

Questions
---------

### Question 1

Select between `0` and `5` answers. Result Type: `absolute`

Question: `Select candidates for the Python Steering Council`

Answer \#1 - \#N: `Candidates from Candidates_ Section`

Results
=======

Of the 96 eligible voters, 69 cast ballots.

The top five vote-getters are:

-   Barry Warsaw
-   Brett Cannon
-   Carol Willing
-   Guido van Rossum
-   Nick Coghlan

No conflict of interest as defined in PEP 13 were observed.

The full vote counts are as follows:

  ------------------------------------
  Candidate           Votes Received
  ------------------- ----------------
  Guido van Rossum    45

  Brett Cannon        44

  Carol Willing       33

  Barry Warsaw        31

  Nick Coghlan        25

  Benjamin Peterson   22

  Łukasz Langa        21

  Victor Stinner      21

  Mariatta            20

  Emily Morehouse     18

  Yury Selivanov      15

  Donald Stufft       11

  Peter Wang          10

  Travis Oliphant     8

  Kushal Das          7

  Gregory P. Smith    6

  David Mertz         3
  ------------------------------------

Copyright
=========

This document has been placed in the public domain.

Complete Voter Roll
===================

Active Python core developers
-----------------------------

    Alex Gaynor
    Alex Martelli
    Alexander Belopolsky
    Alexandre Vassalotti
    Amaury Forgeot d'Arc
    Andrew Kuchling
    Andrew Svetlov
    Antoine Pitrou
    Armin Ronacher
    Barry Warsaw
    Benjamin Peterson
    Berker Peksag
    Brett Cannon
    Brian Curtin
    Carol Willing
    Chris Jerdonek
    Chris Withers
    Christian Heimes
    David Malcolm
    David Wolever
    Davin Potts
    Dino Viehland
    Donald Stufft
    Doug Hellmann
    Eli Bendersky
    Emily Morehouse
    Éric Araujo
    Eric Snow
    Eric V. Smith
    Ethan Furman
    Ezio Melotti
    Facundo Batista
    Fred Drake
    Georg Brandl
    Giampaolo Rodola'
    Gregory P. Smith
    Guido van Rossum
    Hyeshik Chang
    Hynek Schlawack
    INADA Naoki
    Ivan Levkivskyi
    Jack Diederich
    Jack Jansen
    Jason R. Coombs
    Jeff Hardy
    Jeremy Hylton
    Jesús Cea
    Julien Palard
    Kurt B. Kaiser
    Kushal Das
    Larry Hastings
    Lars Gustäbel
    Lisa Roach
    Łukasz Langa
    Marc-Andre Lemburg
    Mariatta
    Mark Dickinson
    Mark Hammond
    Mark Shannon
    Martin Panter
    Matthias Klose
    Meador Inge
    Michael Hudson-Doyle
    Nathaniel J. Smith
    Ned Deily
    Neil Schemenauer
    Nick Coghlan
    Pablo Galindo
    Paul Moore
    Petr Viktorin
    Petri Lehtinen
    Philip Jenvey
    R. David Murray
    Raymond Hettinger
    Robert Collins
    Ronald Oussoren
    Sandro Tosi
    Senthil Kumaran
    Serhiy Storchaka
    Sjoerd Mullender
    Stefan Krah
    Steve Dower
    Steven Daprano
    T. Wouters
    Tal Einat
    Terry Jan Reedy
    Thomas Heller
    Tim Golden
    Tim Peters
    Trent Nelson
    Victor Stinner
    Vinay Sajip
    Walter Dörwald
    Xiang Zhang
    Yury Selivanov
    Zachary Ware

#### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

[^1]: This repository is private and accessible only to Python Core
    Developers, administrators, and Python Software Foundation Staff as
    it contains personal email addresses.
