PEP: 3001 Title: Procedure for reviewing and improving standard library
modules Version: $Revision$ Last-Modified: $Date$ Author: Georg Brandl
<georg@python.org> Status: Withdrawn Type: Process Content-Type:
text/x-rst Created: 05-Apr-2006 Post-History:

Abstract
========

This PEP describes a procedure for reviewing and improving standard
library modules, especially those written in Python, making them ready
for Python 3000. There can be different steps of refurbishing, each of
which is described in a section below. Of course, not every step has to
be performed for every module.

Removal of obsolete modules
===========================

All modules marked as deprecated in 2.x versions should be removed for
Python 3000. The same applies to modules which are seen as obsolete
today, but are too widely used to be deprecated or removed. Python 3000
is the big occasion to get rid of them.

There will have to be a document listing all removed modules, together
with information on possible substitutes or alternatives. This infor-
mation will also have to be provided by the python3warn.py porting
helper script mentioned in PEP XXX.

Renaming modules
================

There are proposals for a "great stdlib renaming" introducing a
hierarchic library namespace or a top-level package from which to import
standard modules. That possibility aside, some modules' names are known
to have been chosen unwisely, a mistake which could never be corrected
in the 2.x series. Examples are names like "StringIO" or "Cookie". For
Python 3000, there will be the possibility to give those modules less
confusing and more conforming names.

Of course, each rename will have to be stated in the documentation of
the respective module and perhaps in the global document of Step 1.
Additionally, the python3warn.py script will recognize the old module
names and notify the user accordingly.

If the name change is made in time for another release of the Python 2.x
series, it is worth considering to introduce the new name in the 2.x
branch to ease transition.

Code cleanup
============

As most library modules written in Python have not been touched except
for bug fixes, following the policy of never changing a running system,
many of them may contain code that is not up to the newest language
features and could be rewritten in a more concise, modern Python.

PyChecker should run cleanly over the library. With a carefully tuned
configuration file, PyLint should also emit as few warnings as possible.

As long as these changes don't change the module's interface and
behavior, no documentation updates are necessary.

Enhancement of test and documentation coverage
==============================================

Code coverage by unit tests varies greatly between modules. Each test
suite should be checked for completeness, and the remaining classic
tests should be converted to PyUnit (or whatever new shiny testing
framework comes with Python 3000, perhaps py.test?).

It should also be verified that each publicly visible function has a
meaningful docstring which ideally contains several doctests.

No documentation changes are necessary for enhancing test coverage.

Unification of module metadata
==============================

This is a small and probably not very important step. There have been
various attempts at providing author, version and similar metadata in
modules (such as a "**version**" global). Those could be standardized
and used throughout the library.

No documentation changes are necessary for this step, too.

Backwards incompatible bug fixes
================================

Over the years, many bug reports have been filed which complained about
bugs in standard library modules, but have subsequently been closed as
"Won't fix" since a fix would have introduced a major incompatibility
which was not acceptable in the Python 2.x series. In Python 3000, the
fix can be applied if the interface per se is still acceptable.

Each slight behavioral change caused by such fixes must be mentioned in
the documentation, perhaps in a "Changed in Version 3.0" paragraph.

Interface changes
=================

The last and most disruptive change is the overhaul of a module's public
interface. If a module's interface is to be changed, a justification
should be made beforehand, or a PEP should be written.

The change must be fully documented as "New in Version 3.0", and the
python3warn.py script must know about it.

References
==========

None yet.

Copyright
=========

This document has been placed in the public domain.
