PEP: 639 Title: Metadata for Python Software Packages 2.2 Version:
\$Revision\$ Last-Modified: \$Date\$ Author: Philippe Ombredanne
\<pombredanne at nexb.com\> Sponsor: Paul Moore \<p.f.moore at
gmail.com\> BDFL-Delegate: Paul Moore \<p.f.moore at gmail.com\>
Discussions-To: <https://discuss.python.org/t/2154> Status: Draft Type:
Standards Track Content-Type: text/x-rst Created: 15-Aug-2018
Python-Version: 3.x Post-History: Replaces: 566 Resolution:

Abstract
========

This PEP describes the changes between versions 2.1 and 2.2 of the [Core
Metadata Specification]{.title-ref}[^1] for Python packages. Version 2.1
is specified in PEP 566.

The primary change introduced in this PEP updates how licenses are
documented in core metadata via the `License` field with license
expression strings using SPDX license identifiers[^2] such that license
documentation is simpler and less ambiguous:

-   for package authors to create,
-   for package users to read and understand, and,
-   for tools to process package license information mechanically.

The other changes include:

-   specifying a `License-File` field which is already used by `wheel`
    and `setuptools` to include license files in built distributions.
-   defining how tools can validate license expressions and report
    warnings to users for invalid expressions (but still accept any
    string as `License`).

Goals
=====

This PEP\'s scope is limited strictly to how we document the license of
a distribution:

-   with an improved and structured way to document a license
    expression, and,
-   by including license texts in a built package.

The core metadata specification updates that are part of this PEP, have
been designed to have minimal impact and to be backward compatible with
v2.1. These changes utilize emerging new ways to document licenses that
are already in use in some tools (e.g. by adding the `Licence-File`
field already used in `wheel` and `setuptools`) or by some package
authors (e.g. storing an SPDX license expression in the existing
`License` field).

In addition to an update to the metadata specification, this PEP
contains:

-   recommendations for publishing tools on how to validate the
    `License` and `Classifier` fields and report informational warnings
    when a package uses an older, non-structured style of license
    documentation conventions.
-   informational appendixes that contain surveys of how we document
    licenses today in Python packages and elsewhere, and a reference
    Python library to parse, validate and build correct license
    expressions.

It is the intent of the PEP authors to work closely with tool authors to
implement to recommendations for validation and warnings specified in
this PEP.

Non-Goals
=========

This PEP is neutral regarding the choice of various licenses.

In particular, the SPDX license expression syntax proposed in this PEP
provides simpler and more expressive conventions to document more
accurately any kind of license that applies to a Python package, whether
under an open source, free or libre software license or a proprietary
license.

This PEP makes no recommendation for certain licenses and does not
require the use of specific license documentation conventions. This PEP
also does not impose any restrictions when uploading to PyPI.

Instead, this PEP is intended to document common practices already in
use, and recommends that publishing tools should encourage users via
informational warnings when they do not follow this PEP\'s
recommendations.

This PEP is not about documenting license in code files, even though
this is a surveyed topic in the appendix.

Possible future PEPs
--------------------

It is the intention of the authors of this PEP to consider the
submission of related but separate PEPs in the future such as:

-   make `License` and new `License-File` fields mandatory including
    stricter enforcement in tools and PyPI publishing.
-   require uploads to PyPI to use only FOSS (Free and Open Source
    software) licenses.

Motivation
==========

Software is licensed and providing accurate licensing information to
Python packages users is an important matter. Today, there are multiple
places where license is documented in package metadata and there are
limitations to what can be documented. This is often leading to
confusion or a lack of clarity both for package authors and package
users.

Several package authors have expressed difficulty and/or frustrations
with the possibilities to express licensing in package metadata. This
also applies to Linux and BSD\* distribution packagers. This has
triggered several license-related discussions and issues and in
particular:

-   <https://github.com/pypa/trove-classifiers/issues/17>
-   <https://github.com/pypa/interoperability-peps/issues/46>
-   <https://github.com/pypa/packaging-problems/issues/41>
-   <https://github.com/pypa/wheel/issues/138>
-   <https://github.com/pombredanne/spdx-pypi-pep/issues/1>

On average, Python packages tend to have more ambiguous or missing
license information than other common application package formats (such
as npm, Maven or Gem) as can be seen in the statistics[^3] page of the
ClearlyDefined [^4] project that cover all packages from PyPI, Maven,
npm and Rubygems. ClearlyDefined is an open source project to help
improve clarity of other open source projects that is incubating at the
OSI (Open Source Initiative)[^5].

Rationale
=========

A mini survey of existing license metadata definitions in use in the
Python ecosystem today and documented in several other system/distro and
application package formats is provided in Appendix 2 of this PEP.

There are a few takeaways from the survey:

-   Most package formats use a single `License` field.
-   Many modern package formats use some form of license expression
    syntax to optionally combine more than one license identifiers
    together. SPDX and SPDX-like syntaxes are the most popular in use.
-   SPDX license identifiers are becoming a de-facto way to reference
    common licenses everywhere, whether or not a license expression
    syntax is used.
-   Several package formats support documenting both a license
    expression and the paths of the corresponding files that contain the
    license text. Most free and open source software licenses require to
    include their full text in a distribution.

These considerations have guided the design and recommendations of this
PEP.

The reuse of the `License` field with license expressions will provide
an intuitive and more structured way to express the license of a
distribution using a well-defined syntax and well-known license
identifiers.

Over time, recommending the usage of these expressions will help Python
package publishers improve the clarity of their license documentation to
the benefit of packages authors, consumers and redistributors.

Core Metadata Specification updates
===================================

The canonical source for the names and semantics of each of the
supported metadata fields is the Core Metadata Specification[^6]
document.

The details of the updates considered to the Core Metadata
Specification[^7] document as part of this PEP are detailed here and
will be added to the canonical source once this PEP is approved.

Added in Version 2.2
--------------------

### License-File (multiple use)

The License-File is a string that is a `.dist-info` relative path to a
license file. The license file content MUST be UTF-8 encoded text.

Build tools SHOULD honor this field and include the corresponding
license file(s) in the built package.

Changed in Version 2.2
----------------------

### License (optional)

Text indicating the license covering the distribution. This text can be
either a valid license expression as defined here or any free text.

Publishing tools SHOULD issue an informational warning if this field is
empty, missing, or is not a valid license expression as defined here.
Build tools MAY issue a similar warning.

#### License Expression syntax

A license expression is a string using the SPDX license expression
syntax as documented in the SPDX specification[^8] using either Version
2.2 [^9] or a later compatible version. SPDX is a working group at the
Linux Foundation that defines a standard way to exchange package
information.

When used in the `License` field and as a specialization of the SPDX
license expression definition, a license expression can use the
following license identifiers:

-   any SPDX-listed license short-form identifiers that are published in
    the SPDX License List[^10] using either Version 3.10 of this list or
    any later compatible version. Note that the SPDX working group never
    removes any license identifiers: instead they may only mark an
    identifier as \"obsolete\".
-   the `LicenseRef-Public-Domain` and `LicenseRef-Proprietary` strings
    to support generic identifiers that are not available in the SPDX
    license list.

When processing the `License` field to determine if it contains a valid
license expression, tools:

-   MUST ignore the case of the `License` field
-   SHOULD report an informational warning if one or more of the
    following applies:
    -   the field does not contain a license expression,
    -   the license expression syntax is invalid,
    -   the license expression syntax is valid but some license
        identifiers are unknown as defined here or the license
        identifiers have been marked as deprecated in the SPDX License
        List[^11]
-   SHOULD store a case-normalized version of the `License` field using
    the reference case for each SPDX license identifier and uppercase
    for the AND, OR and WITH keywords. And SHOULD report an
    informational warning if the reference case is not used.

License expression examples:

    License: MIT

    License: BSD-3-Clause

    License: MIT OR GPL-2.0-or-later OR (FSFUL AND BSD-2-Clause)

    License: GPL-3.0-only WITH Classpath-Exception-2.0 OR BSD-3-Clause

    License: This software may only be obtained by sending the
            author a postcard, and then the user promises not
            to redistribute it.

    License: LicenseRef-Proprietary AND LicenseRef-Public-Domain

### Classifier (multiple use)

Each entry is a string giving a single classification value for the
distribution. Classifiers are described in PEP 301.

Examples:

    Classifier: Development Status :: 4 - Beta
    Classifier: Environment :: Console (Text Based)

Tools SHOULD issue an informational warning if this field contains a
licensing related classifier string starting with the `License ::`
prefix and SHOULD suggest the use of a license expression in the
`License` field instead.

If the `License` field is present and contains a valid license
expression, publishing tools MUST NOT also provide any licensing related
classifier entries [^12].

However, for compatibility with existing publishing and installation
processes, licensing-related classifier entries SHOULD continue to be
accepted if the `License` field is absent or does not contain a valid
license expression.

Publishing tools MAY infer a license expression from the provided
classifier entries if they are able to do so unambiguously.

However, no new licensing related classifiers will be added, with anyone
requesting them being directed to use a license expression in the
`License` field instead. Note that the licensing related classifiers may
be deprecated in a future PEP.

#### Mapping Legacy Classifiers to New License Expressions

Publishing tools MAY infer or suggest an equivalent license expression
from the provided `License` or `Classifier` information if they are able
to do so unambiguously. For instance, if a package only has this license
classifier:

    Classifier: License :: OSI Approved :: MIT License

Then the corresponding value for a `License` field using a valid license
expression to suggest would be:

    License: MIT

Here are mappings guidelines for the legacy classifiers:

-   Classifier `License :: Other/Proprietary License` becomes License:
    `LicenseRef-Proprietary` expression.
-   Classifier `License :: Public Domain` becomes License:
    `LicenseRef-Public-Domain` expression, though tools should encourage
    the use of more explicit and legally portable licenses identifiers
    such as `CC0-1.0`[^13], the `Unlicense` [^14]: the meaning
    associated with the term \"public domain\" is thoroughly dependent
    on the specific legal jurisdiction involved and some jurisdictions
    have no concept of Public Domain as it exists in the USA.
-   The generic and ambiguous classifiers `License :: OSI Approved` and
    `License :: DFSG approved` do not have an equivalent license
    expression.
-   The generic and sometimes ambiguous classifiers
    `License :: Free For Educational Use`,
    `License :: Free For Home Use`,
    `License :: Free for non-commercial use`,
    `License :: Freely Distributable`,
    `License :: Free To Use But Restricted`, and `License :: Freeware`
    are mapped to the generic License: `LicenseRef-Proprietary`
    expression.
-   Classifiers `License :: GUST*` have no mapping to SPDX license
    identifierss for now and no package uses them in PyPI as of the
    writing of this PEP.

The remainder of the classifiers using a `License ::` prefix map to a
simple single license expression using the corresponding SPDX license
identifiers.

When multiple license-related classifiers are used, their relation is
ambiguous and it is typically not possible to determine if all the
licenses apply or if there is a choice that is possible among the
licenses. In this case, tools cannot infer reliably a license expression
to suggest using only the legacy classifier usage.

Summary of Differences From PEP 566
===================================

-   Metadata-Version is now 2.2.
-   Added one new field: `License-File`
-   Updated the documentation of two fields: `License` and `Classifier`

Backwards Compatibility
=======================

The reuse of the `License` field means that we keep backward
compatibility. The specification of the `License-File` field is only
writing down the practices of the `wheel` and `setuptools` tools and is
backward compatible with their support for that field.

The \"soft\" validation of the `License` field when it does not contain
a valid license expression and when the `Classifier` field is used with
legacy license-related classifiers means that we can gently prepare
users for a possible strict and incompatible validation of these fields
in the future.

Security Implications
=====================

This PEP has no foreseen security implications: the License field is a
plain string and the License-File(s) are file paths. None of them
introduces any new security concern.

How to Teach Users to Use License Expressions
=============================================

The simple cases are simple: a single license id is a valid license
expression and a large majority of packages use a single license.

The plan to teach users of packaging tools how to use the license with a
valid license expressions is to have tool issue warning messages when
they detect an incorrect license expressions or when a license-related
classifier is used in the `Classifier` field.

With a warning message that does not terminate processing, publishing
tools will gently teach users on how to provide correct license
expressions over time.

Tools may also help with the conversion and suggest a license expression
in some cases:

1.  The section [Mapping Legacy Classifiers to New License
    expressions]{.title-ref} provides tools authors with guidelines on
    how to suggest a license expression from legacy classifiers.
2.  Tools may also be able to infer and suggest how to update an
    existing incorrect `License` value and convert that to a correct
    license expression. For instance a tool may suggest to correct a
    `License` field from `Apache2` (which is not a valid license
    expression as defined in this PEP) to `Apache-2.0` (which is a valid
    license expression using an SPDX license id as defined in this PEP).

Reference Implementation
========================

Tools will need to support parsing and validating license expressions in
the `License` field.

The `license-expression` library[^15] is a reference Python
implementation for a library that handles license expressions including
parsing, validating and formatting license expressions using flexible
lists of license symbols (including SPDX license identifiers and any
extra identifiers referenced here). It is licensed under the Apache-2.0
license and is used in a few projects such as the SPDX Python
tools[^16], the ScanCode toolkit [^17] and the Free Software Foundation
Europe (FSFE) Reuse project [^18].

Rejected ideas
==============

1.  use a new `License-Expression` field and deprecate the `License`
    field.

Adding a new field would introduce backward incompatible changes when
the `License` field would be retired later and require to have a more
complex validation. The use of such a field would further introduce a
new concept that is not seen anywhere else in any other package metadata
(e.g. a new a field only for license expression) and possibly be a
source of confusion. Also, users are less likely to start using a new
field than make small adjustments to their use of existing fields.

2.  mapping licenses used in the license expression to specific files in
    the license files (or vice versa).

This would require using a mapping (two parallel lists would be too
prone to alignment errors) and a mapping would bring extra complication
to how license are documented by adding an additional nesting level.

A mapping would be needed as you cannot guarantee that all expressions
(e.g. a GPL with an exception may be in a single file) or all the
license keys have a single license file and that any expression does not
have more than one. (e.g. an Apache license `LICENSE` and its `NOTICE`
file for instance are tow distinct file). Yet in most cases, there is a
simpler [one license]{.title-ref}, [one or more license
files]{.title-ref}. In the rarer and more complex cases where there are
many licenses involved you can still use the proposed conventions at the
cost of a slight loss of clarity by not specifying which text file is
for which license id, but you are not forcing the more complex data
model (e.g. a mapping) on everyone that may not need it.

We could of course have data field with multiple possible value types
(it's a string, it's a list, it's a mapping!) but this could be a source
of confusion. This is what has been done for instance in npm
(historically) and in Rubygems (still today) and as result you need to
test the type of the metadata field before using it in code and users
are confused about when to use a list or a string.

3.  mapping licenses to specific source files and/or directories of
    source files (or vice versa).

File-level notices are not considered as part of the scope of this PEP
and the existing the `SPDX-License-Identifier`[^19] convention can be
used and may not need further specification as a PEP.

Appendix 1. License Expression example
======================================

The current version of `setuptools` metadata[^20] does not use the
`License` field. It uses instead this license-related information in
`setup.cfg`:

    license_file = LICENSE
    classifiers =
        License :: OSI Approved :: MIT License

The simplest migration to this PEP would consist of using this instead:

    license = MIT
    license_files =
        LICENSE

Another possibility would be to include the licenses of the third-party
packages bundled in that are vendored in the `setuptools/_vendor/` and
`pkg_resources/_vendor` directories:

    appdirs==1.4.3
    packaging==20.4
    pyparsing==2.2.1
    ordered-set==3.1.1

These are using these license expressions:

    appdirs: MIT
    packaging: Apache-2.0 OR BSD-2-Clause
    pyparsing: MIT
    ordered-set: MIT

Therefore, a comprehensive license documentation covering both
`setuptools` proper and its vendored packages could contain these
metadata, combining all the license expressions in one expression:

    license = MIT AND (Apache-2.0 OR BSD-2-Clause)
    license_files =
        LICENSE.MIT
        LICENSE.packaging

Here we would assume that the `LICENSE.MIT` file contains the text of
the MIT license and the copyrights used by `setuptools`, `appdirs`,
`pyparsing` and `ordered-set`, and that the `LICENSE.packaging` file
contains the texts of the Apache and BSD license, its copyrights and its
license choice notice[^21].

Appendix 2. Surveying how we document licenses today in Python
==============================================================

There are multiple ways used or recommended to document Python package
licenses today:

In Core metadata
----------------

There are two overlapping core metadata fields to document a license:
the license-related `Classifier` strings[^22] prefixed with `License ::`
and the `License` field as free text[^23].

The core metadata documentation `License` field documentation is
currently:

    License (optional)
    ::::::::::::::::::

    Text indicating the license covering the distribution where the license
    is not a selection from the "License" Trove classifiers. See
    "Classifier" below.  This field may also be used to specify a
    particular version of a license which is named via the ``Classifier``
    field, or to indicate a variation or exception to such a license.

    Examples::

        License: This software may only be obtained by sending the
                author a postcard, and then the user promises not
                to redistribute it.

        License: GPL version 3, excluding DRM provisions

Even though there are two fields, it is at times difficult to convey
anything but simpler licensing. For instance some classifiers lack
accuracy (GPL without a version) and when you have multiple
License-related classifiers it is not clear if this is a choice or all
these apply and which ones. Furthermore, the list of available
license-related classifiers is often out-of-date.

In the PyPA `sampleproject`
---------------------------

The latest PyPA `sampleproject` recommends only to use classifiers in
`setup.py` and does not list the `license` field in its example
`setup.py`[^24].

The License Files in wheels and setuptools
------------------------------------------

Beyond a license code or qualifier, license text files are documented
and included in a built package either implicitly or explicitly and this
is another possible source of confusion:

-   In wheels[^25] license files are automatically added to the
    `.dist-info` directory if they match one of a few common license
    file name patterns (such as LICENSE\*, COPYING\*). Alternatively a
    package author can specify a list of license files paths to include
    in the built wheel using in the `license_files` field in the
    `[metadata]` section of the project\'s `setup.cfg`. Previously this
    was a (singular) `license_file` file attribute that is now
    deprecated but is still in common use. See[^26] for instance.
-   In `setuptools`[^27], a `license_file` attribute is used to add a
    single license file to a source distribution. This singular version
    is still honored by `wheels` for backward compatibility.
-   Using a LICENSE.txt file is encouraged in the packaging guide[^28]
    paired with a `MANIFEST.in` entry to ensure that the license file is
    included in a built source distribution (sdist).

Note: the License-File field proposed in this PEP already exists in
`wheel` and `setuptools` with the same behaviour as explained above.
This PEP is only recognizing and documenting the existing practice as
used in `wheel` (with the `license_file` and `license_files` `setup.cfg`
`[metadata]` entries) and in `setuptools` `license_file` `setup()`
argument.

In Python code files
--------------------

(Note: Documenting licenses in source code is not in the scope of this
PEP)

Beside using comments and/or `SPDX-License-Identifier` conventions, the
license is sometimes documented in Python code file using
[dunder]{.title-ref} variables typically named after one of the lower
cased Core metadata field such as `__license__` [^29].

This convention (dunder global variables) is recognized by the built-in
`help()` function and the standard `pydoc` module. The dunder
variable(s) will show up in the `help()` DATA section for a module.

In some other Python packaging tools
------------------------------------

-   [Conda package manifest]{.title-ref}[^30] has support for `license`
    and `license_file` fields as well as a `license_family` license
    grouping field.
-   `flit`[^31] recommends to use classifiers instead of License (as per
    the current metadata spec).
-   `pbr`[^32] uses similar data as setuptools but always stored
    setup.cfg.
-   `poetry`[^33] specifies the use of the `license` field in
    `pyproject.toml` with SPDX license identifiers.

Appendix 3. Surveying how other package formats document licenses
=================================================================

Here is a survey of how things are done elsewhere.

License in Linux distribution packages
--------------------------------------

Note: in most cases the license texts of the most common licenses are
included globally once in a shared documentation directory (e.g.
/usr/share/doc).

-   Debian document package licenses with machine readable copyright
    files [^34]. This specification defines its own license expression
    syntax that is very similar to the SDPX syntax and use its own list
    of license identifiers for common licenses also closely related to
    SPDX identifiers.
-   Fedora RPM packages[^35] specifies how to include `License Texts`
    [^36] and how use a `License` field[^37] that must be filled with an
    appropriate license Short License identifier(s) from an extensive
    list of \"Good Licenses\" identifiers[^38]. Fedora also defines ist
    own license expression syntax very similar to the SDPX syntax.
-   OpenSuse RPMs packages[^39] use SPDX license expressions with a
    either SPDX license identifiers and a list of extra license
    identifiers [^40].
-   Gentoo ebuild use a `LICENSE` variable[^41]. This field is specified
    in GLEP-0023[^42] and in the Gentoo development manual[^43]. Gentoo
    also defines a license expressions syntax and a list of allowed
    licenses. The expression syntax is rather different from SPDX.
-   FreeBSD package Makefile[^44] provide a `LICENSE` and a
    `LICENSE_FILE` field with a list of custom license symbols. For
    non-standard licenses, FreeBSD recommend to use `LICENSE=UNKNOWN`
    and add `LICENSE_NAME` and `LICENSE_TEXT` fields, as well as
    sophisticated `LICENSE_PERMS` to qualify the license permissions and
    `LICENSE_GROUPS` to document a license grouping. The `LICENSE_COMB`
    allows to document more than one license and how they apply
    together, forming a custom license expression syntax. FreeBSD also
    recommends the use of `SPDX-License-Identifier` in source code
    files.
-   Archlinux PKGBUILD[^45] define its own license identifiers [^46].
    The value `'unknown'` can be used if the license is not defined.
-   OpenWRT ipk packages[^47] use the `PKG_LICENSE` and
    `PKG_LICENSE_FILES` variables and recommend the use of SPDX License
    identifiers.
-   NixOS uses SPDX identifiers[^48] and some extras license identifiers
    in its license field.
-   GNU Guix (based on NixOS) has a single License field, uses its own
    license symbols list[^49] and specifies to use one license or a list
    of licenses [^50].
-   Alpine Linux apk packages[^51] recommend using SPDX identifiers in
    its license field.

License in Language and Application packages
--------------------------------------------

-   In Java, Maven POM[^52] defines a licenses XML tag with a list of
    license items each with a name, URL, comments and \"distribution\"
    type. This is not mandatory and the content of each field is not
    specified.
-   JavaScript npm package.json[^53] use a single license field with
    SPDX license expression or the `UNLICENSED` id if no license is
    specified. A license file can be referenced as an alternative using
    \"SEE LICENSE IN \<filename\>\" in the single `license` field.
-   Rubygems gemspec[^54] specifies either a singular license string for
    a list of licenses strings. The relationship between multiple
    licenses in a list is not specified. They recommend using SPDX
    license identifiers.
-   CPAN Perl modules[^55] use a single license field which is either a
    single string or a list of strings. The relationship between the
    licenses in a list is not specified. There is a list of support own
    license identifiers plus these generic identifiers: `open_source`,
    `restricted`, `unrestricted`, `unknown`.
-   Rust Cargo[^56] specifies the use of an SPDX license expression
    (v2.1) in the `license` field. It also supports an alternative
    expression syntax using slash-separated SPDX license identifiers.
    There is also a `license_file` field. The crates.io package
    registry[^57] requires that either `license` or `license_file`
    fields are set when you upload a package.
-   PHP Composer composer.json[^58] uses a `license` field with an SPDX
    License id or \"proprietary\". The `license` field is either a
    single string that can use something which resemble the SPDX license
    expression syntax with \"and\" and \"or\" keywords; or this is a
    list of strings if there is a choice of licenses (aka. a
    \"disjunctive\" choice of license).
-   NuGet packages[^59] were using only a simple license URL and are now
    specifying to use an SPDX License expression and/or the path to a
    license file within the package. The NuGet.org repository states
    that they only accepts license expressions that are [approved by the
    Open Source Initiative or the Free Software Foundation.]{.title-ref}
-   Go language modules `go.mod` have no provision for any metadata
    beyond dependencies. Licensing information is left for code authors
    and other community package managers to document.
-   Dart/Flutter spec[^60] recommends to use a single `LICENSE` file
    that should contain all the license texts each separated by a line
    with 80 hyphens.
-   JavaScript Bower[^61] `license` field is either a single string or a
    list of strings using either SPDX license identifiers, a path or a
    URL to a license file.
-   Cocoapods podspec[^62] `license` field is either a single string or
    a mapping with attributes of type, file and text keys. This is
    mandatory unless there is a LICENSE or LICENCE file provided.
-   Haskell Cabal[^63] accepts an SPDX license expression since version
    2.2. The version of the SPDX license list used is a function of the
    `cabal` version. The specification also provides a mapping between
    pre-SPDX Legacy license Identifiers and SPDX identifiers. Cabal also
    specifies a `license-file(s)` field that lists license files that
    will be installed with the package.
-   Erlang/Elixir mix/hex package[^64] specifies a `licenses` field as a
    required list of license strings and recommends to use SPDX License
    identifiers.
-   D lang dub package[^65] defines its own list of license identifiers
    and its own license expression syntax and both are similar to SPDX
    the conventions.
-   R Package DESCRIPTION[^66] defines its own sophisticated license
    expression syntax and list of licenses identifiers. R has a unique
    way to support specifiers for license versions such as
    `LGPL (>= 2.0, < 3)` in its license expression syntax.

Conventions used by other ecosystems
------------------------------------

-   `SPDX-License-Identifier`[^67] is a simple convention to document
    the license inside a code file.
-   The Free Software Foundation (FSF) promotes using SPDX license
    identifiers for clarity in the GPL and other versioned free software
    licenses[^68] [^69].
-   The Free Software Foundation Europe (FSFE) REUSE project[^70]
    promotes using `SPDX-License-Identifier`.
-   The Linux kernel uses `SPDX-License-Identifier` and parts of the
    FSFE REUSE conventions to document its licenses[^71].
-   U-Boot spearheaded using `SPDX-License-Identifier` in code and now
    follows the Linux ways[^72].
-   The Apache Software Foundation projects use RDF DOAP[^73] with a
    single license field pointing to SPDX license identifiers.
-   The Eclipse Foundation promotes using
    `SPDX-license-Identifiers`[^74]
-   The ClearlyDefined project[^75] promotes using SPDX license
    identifiers and expressions to improve license clarity.
-   The Android Open Source Project[^76] use `MODULE_LICENSE_XXX` empty
    tag files where `XXX` is a license code such as BSD, APACHE, GPL,
    etc. And side-by-side with this `MODULE_LICENSE` file there is a
    `NOTICE` file that contains license and notices texts.

References
==========

This document specifies version 2.2 of the metadata format.

-   Version 1.0 is specified in PEP 241.
-   Version 1.1 is specified in PEP 314.
-   Version 1.2 is specified in PEP 345.
-   Version 2.0, while not formally accepted, was specified in PEP 426.
-   Version 2.1 is specified in PEP 566.

Copyright
=========

This document is placed in the public domain or under the
CC0-1.0-Universal license[^77], whichever is more permissive.

Acknowledgements
================

-   Nick Coghlan
-   Kevin P. Fleming
-   Pradyun Gedam
-   Oleg Grenrus
-   Dustin Ingram
-   Chris Jerdonek
-   Cyril Roelandt
-   Luis Villa

##### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 80 End:

[^1]: <https://packaging.python.org/specifications/core-metadata>

[^2]: <https://spdx.org/licenses>

[^3]: <https://clearlydefined.io/stats>

[^4]: <https://clearlydefined.io>

[^5]: <http://opensource.org>

[^6]: <https://packaging.python.org/specifications/core-metadata>

[^7]: <https://packaging.python.org/specifications/core-metadata>

[^8]: <https://spdx.org>

[^9]: <https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/>

[^10]: <https://spdx.org/licenses>

[^11]: <https://spdx.org/licenses>

[^12]: <https://pypi.org/classifiers>

[^13]: <https://creativecommons.org/publicdomain/zero/1.0/>

[^14]: <https://unlicense.org/>

[^15]: <https://github.com/nexB/license-expression/>

[^16]: <https://github.com/spdx/tools-python/>

[^17]: <https://github.com/nexB/scancode-toolkit>

[^18]: <https://reuse.software/>

[^19]: <https://spdx.org/using-spdx-license-identifier>

[^20]: <https://github.com/pypa/setuptools/blob/v50.3.0/setup.cfg#L17>

[^21]: <https://github.com/pypa/packaging/blob/19.1/LICENSE>

[^22]: <https://pypi.org/classifiers>

[^23]: <https://packaging.python.org/guides/distributing-packages-using-setuptools/?highlight=MANIFEST.in#license>

[^24]: <https://github.com/pypa/sampleproject/blob/52966defd6a61e97295b0bb82cd3474ac3e11c7a/setup.py#L98>

[^25]: <https://github.com/pypa/wheel/blob/b8b21a5720df98703716d3cd981d8886393228fa/docs/user_guide.rst#including-license-files-in-the-generated-wheel-file>

[^26]: <https://github.com/pypa/pip/blob/476606425a08c66b9c9d326994ff5cf3f770926a/setup.cfg#L40>

[^27]: <https://github.com/pypa/setuptools/blob/97e8ad4f5ff7793729e9c8be38e0901e3ad8d09e/setuptools/command/sdist.py#L202>

[^28]: <https://packaging.python.org/guides/distributing-packages-using-setuptools/?highlight=MANIFEST.in#license-txt>

[^29]: <https://github.com/search?l=Python&q=%22__license__%22&type=Code>

[^30]: <https://docs.conda.io/projects/conda-build/en/latest/resources/define-metadata.html#about-section>

[^31]: <https://github.com/takluyver/flit>

[^32]: <https://docs.openstack.org/pbr/latest/user/features.html>

[^33]: <https://poetry.eustace.io/docs/pyproject/#license>

[^34]: <https://dep-team.pages.debian.net/deps/dep5/>

[^35]: <https://docs.fedoraproject.org/en-US/packaging-guidelines/LicensingGuidelines/>

[^36]: <https://docs.fedoraproject.org/en-US/packaging-guidelines/LicensingGuidelines/#_license_text>

[^37]: <https://docs.fedoraproject.org/en-US/packaging-guidelines/LicensingGuidelines/#_valid_license_short_names>

[^38]: <https://fedoraproject.org/wiki/Licensing:Main?rd=Licensing#Good_Licenses>

[^39]: <https://en.opensuse.org/openSUSE:Packaging_guidelines#Licensing>

[^40]: <https://docs.google.com/spreadsheets/d/14AdaJ6cmU0kvQ4ulq9pWpjdZL5tkR03exRSYJmPGdfs/pub>

[^41]: <https://devmanual.gentoo.org/ebuild-writing/variables/index.html#license>

[^42]: <https://www.gentoo.org/glep/glep-0023.html>

[^43]: <https://devmanual.gentoo.org/general-concepts/licenses/index.html>

[^44]: <https://www.freebsd.org/doc/en_US.ISO8859-1/books/porters-handbook/licenses.html>

[^45]: <https://wiki.archlinux.org/index.php/PKGBUILD#license>

[^46]: <https://wiki.archlinux.org/index.php/PKGBUILD#license>

[^47]: <https://openwrt.org/docs/guide-developer/packages#buildpackage_variables>

[^48]: <https://github.com/NixOS/nixpkgs/blob/master/lib/licenses.nix>

[^49]: <http://git.savannah.gnu.org/cgit/guix.git/tree/guix/licenses.scm>

[^50]: <https://guix.gnu.org/manual/en/html_node/package-Reference.html#index-license_002c-of-packages>

[^51]: <https://wiki.alpinelinux.org/wiki/Creating_an_Alpine_package#license>

[^52]: <https://maven.apache.org/pom.html#Licenses>

[^53]: <https://docs.npmjs.com/files/package.json#license>

[^54]: <https://guides.rubygems.org/specification-reference/#license=>

[^55]: <https://metacpan.org/pod/CPAN>::Meta::Spec\#license

[^56]: <https://doc.rust-lang.org/cargo/reference/manifest.html#package-metadata>

[^57]: <https://doc.rust-lang.org/cargo/reference/registries.html#publish>

[^58]: <https://getcomposer.org/doc/04-schema.md#license>

[^59]: <https://docs.microsoft.com/en-us/nuget/reference/nuspec#licenseurl>

[^60]: <https://flutter.dev/docs/development/packages-and-plugins/developing-packages#adding-licenses-to-the-license-file>

[^61]: <https://github.com/bower/spec/blob/master/json.md#license>

[^62]: <https://guides.cocoapods.org/syntax/podspec.html#license>

[^63]: <https://cabal.readthedocs.io/en/latest/developing-packages.html#pkg-field-license>

[^64]: <https://hex.pm/docs/publish>

[^65]: <https://dub.pm/package-format-json.html#licenses>

[^66]: <https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Licensing>

[^67]: <https://spdx.org/using-spdx-license-identifier>

[^68]: <https://www.gnu.org/licenses/identify-licenses-clearly.html>

[^69]: <https://www.fsf.org/blogs/rms/rms-article-for-claritys-sake-please-dont-say-licensed-under-gnu-gpl-2>

[^70]: <https://reuse.software/>

[^71]: <https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/Documentation/process/license-rules.rst>

[^72]: <https://www.denx.de/wiki/U-Boot/Licensing>

[^73]: <https://svn.apache.org/repos/asf/allura/doap_Allura.rdf>

[^74]: <https://www.eclipse.org/legal/epl-2.0/faq.php>

[^75]: <https://clearlydefined.io>

[^76]: <https://github.com/aosp-mirror/platform_external_tcpdump/blob/master/MODULE_LICENSE_BSD>

[^77]: <https://creativecommons.org/publicdomain/zero/1.0/>
