PEP: 609 Title: PyPA Governance Version: \$Revision\$ Last-Modified:
\$Date\$ Author: Dustin Ingram \<<di@python.org>\>, Pradyun Gedam
\<<pradyunsg@gmail.com>\> Sumana Harihareswara \<<sh@changeset.nyc>\>
Sponsor: Paul Ganssle \<<paul@ganssle.io>\> BDFL-Delegate: TBD
Discussions-To: <https://discuss.python.org/t/pep-609-pypa-governance/>
Status: Active Type: Process Content-Type: text/x-rst Created:
05-Nov-2019 Post-History: 05-Nov-2019

Abstract
========

This document describes a governance model for the Python Packaging
Authority (PyPA). The model is closely based on existing informal
practices, with the intent of providing clarity into the functioning of
the PyPA and formalizing transparent processes for the PyPA.

Rationale
=========

The Python Packaging Authority (PyPA) is a collaborative community that
maintains and advances many of the relevant projects in Python
packaging. The software and standards developed through the PyPA are
used to package, share, and install Python software and to interact with
indexes of downloadable Python software such as
[PyPI](https://pypi.org), the Python Package Index.

Currently, the PyPA is an informal and loosely defined organization that
lacks true authority, and the inclusion of a given project under the
PyPA umbrella or the creation of new projects has been done in an
ad-hoc, one-off manner. Similarly, individual membership in the PyPA is
not well-defined.

While this model has more or less worked for the PyPA in the past, it
results in an organization which is missing certain features of a stable
ecosystem, namely a clear and transparent decision-making process. This
PEP seeks to rectify this by defining a governance model for the PyPA.

Terminology
===========

Relevant terms for groups of individual contributors used in this PEP:

**PyPA members**:

:   Anyone with the triage bit or commit bit, on at least one project in
    the [PyPA organization](https://github.com/pypa).

**PyPA committers**:

:   Anyone with the commit bit on at least one project in the PyPA
    organization, which should correspond to everyone on the
    [PyPA-Committers](https://mail.python.org/mm3/mailman3/lists/pypa-committers.python.org/)
    mailing list.

**PyPA community**:

:   Anyone who is interested in PyPA activity and wants to follow along,
    contribute or make proposals.

**Packaging-WG members**:

:   As described in the [Packaging-WG Wiki
    page](https://wiki.python.org/psf/PackagingWG). For clarity: there
    is no formal relationship between the Packaging-WG and PyPA. This
    group is only included in this list to disambiguate it from PyPA.

Goals
=====

The following section formalizes the goals (and non-goals) of the PyPA
and this governance model.

Goals of the PyPA
-----------------

These goals are the primary motivation for the existence of the PyPA.
These goals are largely already being carried out, even though most have
not been explicitly defined.

### Provide support for existing projects under the PyPA

In the event that a given project needs additional support, or no longer
has active maintainers, the PyPA will ensure that the given project will
continue to be supported for users to the extent necessary.

### Foster the creation and acceptance of standards for PyPA projects

The PyPA should, as much as possible, strive for standardization and
coordination across PyPA projects, primarily though the governance
process outlined below. PyPA projects are expected to abide by
applicable specifications maintained by the PyPA.

### Guide decisions which affect multiple PyPA projects

The PyPA community (especially PyPA members) should be expected to
provide opinions, insight and experience when ecosystem-wide changes are
being proposed.

### Determine which projects should be under the guidance of the PyPA

For example: accepting new projects from the community, organically
creating projects within the PyPA, etc.

### Enforce adherence to a Code of Conduct across all projects

Generally this means leading by example, but occasionally it may mean
more explicit moderation.

Non-goals of the PyPA
---------------------

These are specific items that are explicitly \_[not]() goals of the
PyPA.

### Determine who is and isn\'t a PyPA member

This is for members of individual projects to decide, as they add new
members to their projects. Maintainership of a project that is under the
PyPA organization automatically transfers membership in the PyPA.

### Micromanage individual projects

As long as the project is adhering to the Code of Conduct and following
specifications supported by the PyPA, the PyPA should only concerned
with large, ecosystem-wide changes.

### Develop and maintain standalone Code of Conduct

PyPA projects follow [the PSF Code of
Conduct](https://www.python.org/psf/conduct/).

Goals of the PyPA\'s Governance Model
-------------------------------------

These are new goals which the governance model seeks to make possible.

### Transparency in PyPA membership

Provide a transparent process for decisions taken, regarding project
membership in the PyPA.

### Document PyPA\'s use of PEPs

Formally document how the PyPA uses Python Enhancement Proposals (PEPs),
for maintaining interoperability specifications defined by the PyPA.

Processes
=========

The processes for the PyPA\'s activities are outlined below:

Specifications
--------------

The PyPA will use PEPs for defining, and making changes to, the
interoperability specifications maintained by the PyPA. Thus, the Python
Steering Council has the final say in the acceptance of these
interoperability specifications.

It is expected (but not required) that the Python Steering Council would
delegate authority to sponsor and/or approve/reject PEPs related to
packaging interoperability specifications, to individuals within the
PyPA community. At the time of writing (June 2020), the Python Steering
Council has [standing
delegations](https://github.com/python/steering-council/blob/master/process/standing-delegations.md#pypa-delegations)
for currently active packaging interoperability specifications.

The details of the process of proposing and updating the
interoperability specifications are described in the [PyPA
Specifications](https://www.pypa.io/en/latest/specifications) document.

Governance
----------

### PyPA Committer Votes

A PyPA member can put forward a proposal and call for a vote on a public
PyPA communication channel. A PyPA committer vote is triggered when a
PyPA committer (not the proposer) seconds the proposal.

The proposal will be put to a vote on the
[PyPA-Committers](https://mail.python.org/mm3/mailman3/lists/pypa-committers.python.org/)
mailing list, over a 7 day period. Each PyPA committer can vote once,
and can choose one of `+1` and `-1`. If at least two thirds of recorded
votes are `+1`, then the vote succeeds.

PyPA committer votes are required for, and limited to, the following
kinds of proposals:

#### Addition of a project to the PyPA

Proposing the acceptance of a project into the PyPA organization. This
proposal must not be opposed by the existing maintainers of the project.

#### Creation of a new project in the PyPA

Proposing the creation of a new tools / project in the PyPA
organization.

#### Removal of a project from PyPA

Proposing the removal of a project in the PyPA organization.

#### Updates to the Governance/Specification Processes

Proposing changes to how the PyPA operates, including but not limited to
changes to its specification and governance processes, and this PEP.

### Leaving PyPA

A project that is a part of the PyPA organization, can request to leave
PyPA.

Such requests can made by a committer of the project, on the
[PyPA-Committers](https://mail.python.org/mm3/mailman3/lists/pypa-committers.python.org/)
mailing list and must clearly state the GitHub user/organization to
transfer the repository to.

If the request is not opposed by another committer of the same project
over a 7 day period, the project would leave the PyPA and be transferred
out of the PyPA organization as per the request.

### Code of Conduct enforcement

Each project that is a part of the PyPA organization follows [the PSF
Code of Conduct](https://www.python.org/psf/conduct/), including its
incident reporting guidelines and enforcement procedures.

PyPA members are responsible for leading by example. PyPA members
occasionally may need to more explicitly moderate behavior in their
projects, and each project that is a part of the PyPA organization must
designate at least one PyPA member as available to contact in case of a
Code of Conduct incident. If told of any Code of Conduct incidents
involving their projects, PyPA members are expected to report those
incidents up to [the PSF Conduct
WG](https://wiki.python.org/psf/ConductWG/Charter), for recording
purposes and for potential assistance.

References
==========

Copyright
=========

This document is placed in the public domain or under the
CC0-1.0-Universal license, whichever is more permissive.

##### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
