PEP: 588 Title: GitHub Issues Migration Plan Author: Mariatta
\<<mariatta@python.org>\> BDFL-Delegate: Barry Warsaw
\<<barry@python.org>\> Discussions-To: Core-Workflow Category on
Discourse Status: Draft Type: Informational Content-Type: text/x-rst
Created: 27-Mar-2019

Abstract
========

This PEP describes the detailed plan for migrating from Python\'s issue
tracker on Roundup to GitHub issues. See PEP 581 for rationale and
background. PEP 588 also describes the detailed timeline for the
migration.

Migration Plan
==============

Here we outline the tasks, steps, and core decisions we need to make in
order to migrate bug tracking to GitHub, with the least impact on
CPython developer productivity.

Hire a professional project manager
-----------------------------------

Having a professional project manager to handle the migration, similar
to how the Warehouse project was managed, would help ensure the success
of this project.

Create a playground CPython issue tracker on GitHub
---------------------------------------------------

We should create a playground issue tracker on GitHub where we can
experiment and test out the new workflow.

Backup of GitHub data
---------------------

This effort has been started and is being tracked as an issue in
core-workflow[^1]. We\'re using GitHub\'s Migrations API[^2] to download
GitHub data for CPython on a daily basis. The archives will be dropped
in a S3 bucket.

Thanks to Ernest W. Durbin III for working on this.

Update the CLA host
-------------------

At the moment, the CLA is hosted within bpo. It needs to be updated such
that signing the CLA does not require a bpo account, and it should be
hosted outside of the bpo.

The current CLA process itself is not ideal. Currently, contributors to
devguide, peps, and core-workflow need to sign a CLA, and it requires a
bpo account. A bpo account should not be required for those projects.

There is an ongoing effort to start using our own instance of CLA
assistant instead of the current CLA process in place. Discussion about
this has been started in [core-workflow mailing
list](https://mail.python.org/archives/list/core-workflow@python.org/thread/JBV3XJVD2DLDX5DY7TZEA6CO5YPNHJ2C/)
as well as on
[Discourse](https://discuss.python.org/t/using-cla-assistant-for-python/990).

This effort [is currently
stalled](https://discuss.python.org/t/cla-assistant-is-no-go/2066/)
because cla-assistant does not yet support CLA signed on behalf of
organization.

Create \"Python Triage\" team on GitHub
---------------------------------------

The bug triagers on bpo are valuable to the core Python workflow, and we
definitely would need even more help with triaging issues on GitHub.

It has been [proposed on
Discourse](https://discuss.python.org/t/proposal-create-bug-triage-team-on-github/992/5)
for us to create a \"bug triage\" team on GitHub to help with closing
issues, notifying the appropriate parties, as well as applying labels to
issues and pull requests.

The new Triage role on GitHub is currently in beta, and the Python
organization has been granted access to this role, and we can begin
taking advantage of it.

The \"Python Triage\" team has been created. A description and
expectations of the triage role [have been added to
Devguide](https://devguide.python.org/triaging/#python-triage-team).

Progress of this project can be tracked in [\"Adding Triagers\" project
board](https://github.com/python/core-workflow/projects/3).

Create labels for issue triage
------------------------------

In bpo, we currently have the following fields for each issue:

Types: `behavior`, `crash`, `compile error`, `resource usage`,
`security`, `performance`, `enhancement`.

Components: `2to3`, `Argument Clinic`, `asyncio`, `Build`,
`Cross-build`, `ctypes`, \...

Priority: `release blocker`, `deferred blocker`, `critical`, `high`,
`normal`, `low`

We will create the corresponding labels:

    type-behavior, type-crash, type-compile error, type-resource usage, ...

    components-2to3, components-argument clinic, components-asyncio, ...

    priority-release blocker, priority-deferred blocker, priority-critical, ...

In addition, we\'ll create a `needs triage` label.

The final \"labels\" to be created can be decided at a later time when
it is time to start switching to GitHub issues.

A test repository containing all possible labels and color schema has
been created by Carol Willing and can be reviewed at
<https://github.com/willingc/test-581/labels>.

Create issue templates
----------------------

We will create an issue template and add the following headers:

    ---
    Type: behavior | crash | compile error | resource usage (choose one)
    Components: 2to3 | Argument Clinic | asyncio | Build | ... (can select more than one)
    Priority: release blocker | deferred blocker | critical | ...
    Needs backport to: 2.7 | 3.6 | 3.7
    ---

The idea is to allow the issue creator to help us triage the issue. The
above values are pre-filled in the template. The issue creator will
remove texts that do not apply to their issue.

Based on the above headers, bedevere-bot can apply the necessary labels
to the issue. If the issue creator did not supply the above headers, the
bot will apply the `needs triage` label. At that point, it will require
a core developer to properly label the issue.

We can also take advantage of GitHub\'s multiple issue template feature,
and the ability to automatically set issue assignee and labels by using
issue templates.

Updates to bedevere
-------------------

Bedevere-bot will need to be updated to recognize the issue headers
described above and apply the proper labels.

Bedevere-bot can also copy over the labels to pull requests that
correspond to the issue.

Update the devguide
-------------------

Devguide should be updated with information about the new workflow of
using GitHub issues. It can be done as a separate branch, and it should
be done ahead of the migration, not after.

Add a button in bpo to migrate the issue to GitHub
--------------------------------------------------

This will require the bpo to be updated. But I believe the effort needed
for this is much less than a complete overhaul.

We will create a button in bpo, that will copy over the issue
description and associated comments into a GitHub issue.

We need to add a new status: \"moved\" with the url of the GitHub issue.

We should not be moving all open issues to GitHub. Only when someone is
interested in continuing work or discussion about the issue, that the
issue should be \"moved\" to GitHub.

Migrated issues
---------------

When an issue is marked as \"moved\", this issue should be in read-only
mode. bpo should forbid the edition of the issue.

Make bpo read-only
------------------

This should be the final step. Once we start using GitHub issues, make
bpo read-only, instead of shutting it down. Do not accept new
registrations. Do not allow comments or issues to be created.

Mapping between issues from bpo and GitHub
------------------------------------------

Usually when we reference an issue from bpo, we use bpo-XYZ but with
Github, we will have a new reference with this format
`https://github.com/python/cpython/issue/XYZ`.

Because we will migrate the issues from bpo to GitHub, we need to have a
new field on bpo for the reference to the issues on GitHub, and the same
thing on Github for the \'eventual\' reference from bpo.

For GitHub, we need to add `origin: https://bugs.python.org/issueXYZ`.
For bpo, add a new field
`moved to: https://github.com/python/cpython/issue/XYZ`.

Nosy-ing the expert
-------------------

A current functionality in bpo is to automatically nosy people who are
listed as an expert of certain area. Several Python core developers have
expressed that they prefer not having to subscribe to everything on
GitHub, but only getting notified for issues related to their area of
interest and expertise.

To help with this situation, we can develop a bot that can notify people
whenever an issue has been categorized using labels. For example, when
an issue was labeled with `area-windows`, the windows experts can be
notified. The notification can be in the form of email notification, or
@-mention on GitHub.

Open issues
===========

A GitHub account should not be a requirement
--------------------------------------------

Back when moving the CPython codebase from Mercurial to GitHub was being
discussed[^3][^4], it was brought up that we still needed to allow
uploading of patches on bpo, and that a GitHub account should not be a
requirement in order to contribute to Python.

If bpo is made read-only, we\'ll need to come up with a different
solution to allow people to contribute when they don\'t have a GitHub
account.

One solution is to create a new \"python-issues\" mailing list, similar
to the <docs@python.org>[^5] mailing list, to allow people to submit
their issues there.

Related to this, since the migration to GitHub in 2017, I recall one
case[^6] where there was a contributor, who submitted a patch to
Mercurial and refused to create a GitHub account. Because of this, our
bot was unable to detect whether they had signed the CLA. Another person
had volunteered to upload their patch to GitHub. But it was still
required that both people sign the CLA.

That particular situation was complicated. It took up five core
developers\' time to investigate and manually check the CLA, causing
confusion.

Trim off the \"Components\" list
--------------------------------

Is the current \"components\" list still making sense and relevant? Can
the list be shortened?

Priority list
-------------

Is the current \"priority\" list useful? Nick Coghlan noted that perhaps
only `release blocker` and `deferred blocker` are useful.

Further questions and discussions
=================================

You can post questions on Discourse under the
[Core-Workflow](https://discuss.python.org/c/core-workflow) category.

Acknowledgements
================

Thanks to Guido van Rossum, Brett Cannon, and Nick Coghlan, who were
consulted in the early stage and research of this PEP. Their feedback,
concerns, input, and ideas have been valuable.

References
==========

Copyright
=========

This document has been placed in the public domain.

[^1]: Backup GitHub information
    (<https://github.com/python/core-workflow/issues/20>)

[^2]: GitHub\'s Migrations API
    (<https://developer.github.com/v3/migrations/orgs/>)

[^3]: Python-committers email
    (<https://mail.python.org/pipermail/python-committers/2015-December/003642.html>)

[^4]: Python-committers email
    (<https://mail.python.org/pipermail/python-committers/2015-December/003645.html>)

[^5]: docs mailing list
    (<https://mail.python.org/mailman/listinfo/docs>)

[^6]: CPython GitHub pull request 1505
    (<https://github.com/python/cpython/pull/1505>)
