PEP: 407 Title: New release cycle and introducing long-term support
versions Version: $Revision$ Last-Modified: $Date$ Author: Antoine
Pitrou <solipsis@pitrou.net>, Georg Brandl <georg@python.org>, Barry
Warsaw <barry@python.org> Status: Deferred Type: Process Content-Type:
text/x-rst Created: 2012-01-12 Post-History: 17-Jan-2012 Resolution: TBD

Abstract
========

Finding a release cycle for an open-source project is a delicate
exercise in managing mutually contradicting constraints: developer
manpower, availability of release management volunteers, ease of
maintenance for users and third-party packagers, quick availability of
new features (and behavioural changes), availability of bug fixes
without pulling in new features or behavioural changes.

The current release cycle errs on the conservative side. It is adequate
for people who value stability over reactivity. This PEP is an attempt
to keep the stability that has become a Python trademark, while offering
a more fluid release of features, by introducing the notion of long-term
support versions.

Scope
=====

This PEP doesn't try to change the maintenance period or release scheme
for the 2.7 branch. Only 3.x versions are considered.

Proposal
========

Under the proposed scheme, there would be two kinds of feature versions
(sometimes dubbed "minor versions", for example 3.2 or 3.3): normal
feature versions and long-term support (LTS) versions.

Normal feature versions would get either zero or at most one bugfix
release; the latter only if needed to fix critical issues. Security fix
handling for these branches needs to be decided.

LTS versions would get regular bugfix releases until the next LTS
version is out. They then would go into security fixes mode, up to a
termination date at the release manager's discretion.

Periodicity
-----------

A new feature version would be released every X months. We tentatively
propose X = 6 months.

LTS versions would be one out of N feature versions. We tentatively
propose N = 4.

With these figures, a new LTS version would be out every 24 months, and
remain supported until the next LTS version 24 months later. This is
mildly similar to today's 18 months bugfix cycle for every feature
version.

Pre-release versions
--------------------

More frequent feature releases imply a smaller number of disruptive
changes per release. Therefore, the number of pre-release builds (alphas
and betas) can be brought down considerably. Two alpha builds and a
single beta build would probably be enough in the regular case. The
number of release candidates depends, as usual, on the number of
last-minute fixes before final release.

Effects
=======

Effect on development cycle
---------------------------

More feature releases might mean more stress on the development and
release management teams. This is quantitatively alleviated by the
smaller number of pre-release versions; and qualitatively by the lesser
amount of disruptive changes (meaning less potential for breakage). The
shorter feature freeze period (after the first beta build until the
final release) is easier to accept. The rush for adding features just
before feature freeze should also be much smaller.

Effect on bugfix cycle
----------------------

The effect on fixing bugs should be minimal with the proposed figures.
The same number of branches would be simultaneously open for bugfix
maintenance (two until 2.x is terminated, then one).

Effect on workflow
------------------

The workflow for new features would be the same: developers would only
commit them on the `default` branch.

The workflow for bug fixes would be slightly updated: developers would
commit bug fixes to the current LTS branch (for example `3.3`) and then
merge them into `default`.

If some critical fixes are needed to a non-LTS version, they can be
grafted from the current LTS branch to the non-LTS branch, just like
fixes are ported from 3.x to 2.7 today.

Effect on the community
-----------------------

People who value stability can just synchronize on the LTS releases
which, with the proposed figures, would give a similar support cycle
(both in duration and in stability).

People who value reactivity and access to new features (without taking
the risk to install alpha versions or Mercurial snapshots) would get
much more value from the new release cycle than currently.

People who want to contribute new features or improvements would be more
motivated to do so, knowing that their contributions will be more
quickly available to normal users. Also, a smaller feature freeze period
makes it less cumbersome to interact with contributors of features.

Discussion
==========

These are open issues that should be worked out during discussion:

-   Decide on X (months between feature releases) and N (feature
    releases per LTS release) as defined above.

-   For given values of X and N, is the no-bugfix-releases policy for
    non-LTS versions feasible?

-   What is the policy for security fixes?

-   Restrict new syntax and similar changes (i.e. everything that was
    prohibited by PEP 3003) to LTS versions?

-   What is the effect on packagers such as Linux distributions?

-   How will release version numbers or other identifying and marketing
    material make it clear to users which versions are normal feature
    releases and which are LTS releases? How do we manage user
    expectations?

-   Does the faster release cycle mean we could some day reach 3.10 and
    above? Some people expressed a tacit expectation that version
    numbers always fit in one decimal digit.

A community poll or survey to collect opinions from the greater Python
community would be valuable before making a final decision.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
