PEP: 314 Title: Metadata for Python Software Packages v1.1 Version:
$Revision$ Last-Modified: $Date$ Author: A.M. Kuchling, Richard Jones
Status: Final Type: Standards Track Content-Type: text/x-rst Created:
12-Apr-2003 Python-Version: 2.5 Post-History: 29-Apr-2003 Replaces: 241

Introduction
============

This PEP describes a mechanism for adding metadata to Python packages.
It includes specifics of the field names, and their semantics and usage.

This document specifies version 1.1 of the metadata format. Version 1.0
is specified in PEP 241.

Including Metadata in Packages
==============================

The Distutils `sdist` command will extract the metadata fields from the
arguments and write them to a file in the generated zipfile or tarball.
This file will be named PKG-INFO and will be placed in the top directory
of the source distribution (where the README, INSTALL, and other files
usually go).

Developers may not provide their own PKG-INFO file. The `sdist` command
will, if it detects an existing PKG-INFO file, terminate with an
appropriate error message. This should prevent confusion caused by the
PKG-INFO and setup.py files being out of sync.

The PKG-INFO file format is a single set of RFC-822 headers parseable by
the rfc822.py module. The field names listed in the following section
are used as the header names.

Fields
======

This section specifies the names and semantics of each of the supported
metadata fields.

Fields marked with "(Multiple use)" may be specified multiple times in a
single PKG-INFO file. Other fields may only occur once in a PKG-INFO
file. Fields marked with "(optional)" are not required to appear in a
valid PKG-INFO file; all other fields must be present.

Metadata-Version
----------------

Version of the file format; currently "1.0" and "1.1" are the only legal
values here.

Example::

Metadata-Version: 1.1

Name
----

The name of the package.

Example::

Name: BeagleVote

Version
-------

A string containing the package's version number. This field should be
parseable by one of the Version classes (StrictVersion or LooseVersion)
in the distutils.version module.

Example::

Version: 1.0a2

Platform (multiple use)
-----------------------

A comma-separated list of platform specifications, summarizing the
operating systems supported by the package which are not listed in the
"Operating System" Trove classifiers. See "Classifier" below.

Example::

Platform: ObscureUnix, RareDOS

Supported-Platform (multiple use)
---------------------------------

Binary distributions containing a PKG-INFO file will use the
Supported-Platform field in their metadata to specify the OS and CPU for
which the binary package was compiled. The semantics of the
Supported-Platform field are not specified in this PEP.

Example::

Supported-Platform: RedHat 7.2 Supported-Platform: i386-win32-2791

Summary
-------

A one-line summary of what the package does.

Example::

Summary: A module for collecting votes from beagles.

Description (optional)
----------------------

A longer description of the package that can run to several paragraphs.
Software that deals with metadata should not assume any maximum size for
this field, though people shouldn't include their instruction manual as
the description.

The contents of this field can be written using reStructuredText markup
\[1\]\_. For programs that work with the metadata, supporting markup is
optional; programs can also display the contents of the field as-is.
This means that authors should be conservative in the markup they use.

Example::

Description: This module collects votes from beagles in order to
determine their electoral wishes. Do *not* try to use this module with
basset hounds; it makes them grumpy.

Keywords (optional)
-------------------

A list of additional keywords to be used to assist searching for the
package in a larger catalog.

Example::

Keywords: dog puppy voting election

Home-page (optional)
--------------------

A string containing the URL for the package's home page.

Example::

Home-page: http://www.example.com/\~cschultz/bvote/

Download-URL
------------

A string containing the URL from which this version of the package can
be downloaded. (This means that the URL can't be something like
".../package-latest.tgz", but instead must be "../package-0.45.tgz".)

Author (optional)
-----------------

A string containing the author's name at a minimum; additional contact
information may be provided.

Example::

Author: C. Schultz, Universal Features Syndicate, Los Angeles, CA
<cschultz@peanuts.example.com>

Author-email
------------

A string containing the author's e-mail address. It can contain a name
and e-mail address in the legal forms for a RFC-822 'From:' header. It's
not optional because cataloging systems can use the e-mail portion of
this field as a unique key representing the author. A catalog might
provide authors the ability to store their GPG key, personal home page,
and other additional metadata *about the author*, and optionally the
ability to associate several e-mail addresses with the same person.
Author-related metadata fields are not covered by this PEP.

Example::

Author-email: "C. Schultz" <cschultz@example.com>

License
-------

Text indicating the license covering the package where the license is
not a selection from the "License" Trove classifiers. See "Classifier"
below.

Example::

License: This software may only be obtained by sending the author a
postcard, and then the user promises not to redistribute it.

Classifier (multiple use)
-------------------------

Each entry is a string giving a single classification value for the
package. Classifiers are described in PEP 301 \[2\]\_.

Examples::

Classifier: Development Status :: 4 - Beta Classifier: Environment ::
Console (Text Based)

Requires (multiple use)
-----------------------

Each entry contains a string describing some other module or package
required by this package.

The format of a requirement string is identical to that of a module or
package name usable with the 'import' statement, optionally followed by
a version declaration within parentheses.

A version declaration is a series of conditional operators and version
numbers, separated by commas. Conditional operators must be one of "\<",
"\>", "\<=", "\>=", "==", and "!=". Version numbers must be in the
format accepted by the distutils.version.StrictVersion class: two or
three dot-separated numeric components, with an optional "pre-release"
tag on the end consisting of the letter 'a' or 'b' followed by a number.
Example version numbers are "1.0", "2.3a2", "1.3.99",

Any number of conditional operators can be specified, e.g. the string
"\>1.0, !=1.3.4, \<2.0" is a legal version declaration.

All of the following are possible requirement strings: "rfc822", "zlib
(\>=1.1.4)", "zope".

There's no canonical list of what strings should be used; the Python
community is left to choose its own standards.

Example::

Requires: re Requires: sys Requires: zlib Requires: xml.parsers.expat
(\>1.0) Requires: psycopg

Provides (multiple use)
-----------------------

Each entry contains a string describing a package or module that will be
provided by this package once it is installed. These strings should
match the ones used in Requirements fields. A version declaration may be
supplied (without a comparison operator); the package's version number
will be implied if none is specified.

Example::

Provides: xml Provides: xml.utils Provides: xml.utils.iso8601 Provides:
xml.dom Provides: xmltools (1.3)

Obsoletes (multiple use)
------------------------

Each entry contains a string describing a package or module that this
package renders obsolete, meaning that the two packages should not be
installed at the same time. Version declarations can be supplied.

The most common use of this field will be in case a package name
changes, e.g. Gorgon 2.3 gets subsumed into Torqued Python 1.0. When you
install Torqued Python, the Gorgon package should be removed.

Example::

Obsoletes: Gorgon

Summary of Differences From PEP 241
===================================

-   Metadata-Version is now 1.1.

-   Added the Classifiers field from PEP 301.

-   The License and Platform files should now only be used if the
    platform or license can't be handled by an appropriate Classifier
    value.

-   Added fields: Download-URL, Requires, Provides, Obsoletes.

Open issues
===========

None.

Acknowledgements
================

None.

References
==========

.. \[1\] reStructuredText http://docutils.sourceforge.net/

.. \[2\] PEP 301 http://www.python.org/dev/peps/pep-0301/

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
