PEP: 291 Title: Backward Compatibility for the Python 2 Standard Library
Version: $Revision$ Last-Modified: $Date$ Author: nnorwitz\@gmail.com
(Neal Norwitz) Status: Final Type: Informational Content-Type:
text/x-rst Created: 06-Jun-2002 Python-Version: 2.3 Post-History:

Abstract
========

This PEP describes the packages and modules in the Python 2 standard
library which should remain backward compatible with previous versions
of Python. If a package is not listed here, then it need only remain
compatible with the version of Python it is distributed with.

This PEP has no bearing on the Python 3 standard library.

Rationale
=========

Authors have various reasons why packages and modules should continue to
work with previous versions of Python. In order to maintain backward
compatibility for these modules while moving the rest of the standard
library forward, it is necessary to know which modules can be modified
and which should use old and possibly deprecated features.

Generally, authors should attempt to keep changes backward compatible
with the previous released version of Python in order to make bug fixes
easier to backport.

In addition to a package or module being listed in this PEP, authors
must add a comment at the top of each file documenting the compatibility
requirement.

When a major version of Python is released, a Subversion branch is
created for continued maintenance and bug fix releases. A package
version on a branch may have a different compatibility requirement than
the same package on the trunk (i.e. current bleeding-edge development).
Where appropriate, these branch compatibilities are listed below.

Features to Avoid
=================

The following list contains common features to avoid in order to
maintain backward compatibility with each version of Python. This list
is not complete! It is only meant as a general guide.

Note that the features below were implemented in the version following
the one listed. For example, features listed next to 1.5.2 were
implemented in 2.0.

======= ====================================================== Version
Features to Avoid =======
====================================================== 1.5.2 string
methods, Unicode, list comprehensions, augmented assignment (eg, +=),
zip(), import x as y, dict.setdefault(), print \>\> f, calling f(\*args,
\*\*kw), plus all features below

2.0 nested scopes, rich comparisons, function attributes, plus all
features below

2.1 use of object or new-style classes, iterators, using generators,
nested scopes, or // without from **future** import ... statement,
isinstance(X, TYP) where TYP is a tuple of types, plus all features
below

2.2 bool, True, False, basestring, enumerate(), {}.pop(),
PendingDeprecationWarning, Universal Newlines, plus all features below
plus all features below

2.3 generator expressions, multi-line imports, decorators, int/long
unification, set/frozenset, reversed(), sorted(), \"\".rsplit(), plus
all features below

2.4 with statement, conditional expressions, combined
try/except/finally, relative imports, yield expressions or
generator.throw/send/close(), plus all features below

2.5 with statement without from **future** import, io module,
str.format(), except as, bytes, b'' literals, property.setter/deleter
======= ======================================================

Backward Compatible Packages, Modules, and Tools
================================================

============== ================== ============== ===== Package/Module
Maintainer(s) Python Version Notes ============== ==================
============== ===== 2to3 Benjamin Peterson 2.5 bsddb - Greg Smith 2.1 -
Barry Warsaw compiler Jeremy Hylton 2.1 decimal Raymond Hettinger 2.3
\[2\] distutils Tarek Ziade 2.3 email Barry Warsaw 2.1 / 2.3 \[1\]
pkgutil Phillip Eby 2.3 platform Marc-Andre Lemburg 1.5.2 pybench
Marc-Andre Lemburg 1.5.2 \[3\] sre Fredrik Lundh 2.1 subprocess Peter
Astrand 2.2 wsgiref Phillip J. Eby 2.1 xml (PyXML) Martin v. Loewis 2.0
xmlrpclib Fredrik Lundh 2.1 ============== ==================
============== =====

==== ============= ============== Tool Maintainer(s) Python Version ====
============= ============== None ==== ============= ==============

Notes
-----

1.  The email package version 2 was distributed with Python up to Python
    2.3, and this must remain Python 2.1 compatible. email package
    version 3 will be distributed with Python 2.4 and will need to
    remain compatible only with Python 2.3.

2.  Specification updates will be treated as bugfixes and backported.
    Python 2.3 compatibility will be kept for at least Python 2.4. The
    decision will be revisited for Python 2.5 and not changed unless
    compelling advantages arise.

3.  pybench lives under the Tools/ directory. Compatibility with older
    Python versions is needed in order to be able to compare performance
    between Python versions. New features may still be used in new
    tests, which may then be configured to fail gracefully on import by
    the tool in older Python versions.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
