PEP: 244 Title: The `directive` statement Version: $Revision$
Last-Modified: $Date$ Author: martin\@v.loewis.de (Martin von Löwis)
Status: Rejected Type: Standards Track Content-Type: text/x-rst Created:
20-Mar-2001 Python-Version: 2.1 Post-History:

Motivation
==========

From time to time, Python makes an incompatible change to the advertised
semantics of core language constructs, or changes their accidental
(implementation-dependent) behavior in some way. While this is never
done capriciously, and is always done with the aim of improving the
language over the long term, over the short term it's contentious and
disrupting.

PEP 1, Guidelines for Language Evolution \[1\]\_ suggests ways to ease
the pain, and this PEP introduces some machinery in support of that.

PEP 2, Statically Nested Scopes \[2\]\_ is the first application, and
will be used as an example here.

When a new, potentially incompatible language feature is added, some
modules and libraries may chose to use it, while others may not. This
specification introduces a syntax where a module author can denote
whether a certain language feature is used in the module or not.

In discussion of this PEP, readers commented that there are two kinds of
"settable" language features:

-   those that are designed to eventually become the only option, at
    which time specifying use of them is not necessary anymore. The
    features for which the syntax of the "Back to the `__future__`" PEP
    236, Back to the `__future__` \[3\]\_ was proposed fall into this
    category. This PEP supports declaring such features, and supports
    phasing out the "old" meaning of constructs whose semantics has
    changed under the new feature. However, it defines no policy as to
    what features must be phased out eventually.

-   those which are designed to stay optional forever, e.g. if they
    change some default setting in the interpreter. An example for such
    settings might be the request to always emit line-number
    instructions for a certain module; no specific flags of that kind
    are proposed in this specification.

Since a primary goal of this PEP is to support new language constructs
without immediately breaking old libraries, special care was taken not
to break old libraries by introducing the new syntax.

Syntax
======

A directive\_statement is a statement of the form::

directive\_statement: 'directive' `NAME` \[atom\] \[';'\] NEWLINE

The name in the directive indicates the kind of the directive; it
defines whether the optional atom can be present, and whether there are
further syntactical or semantical restrictions to the atom. In addition,
depending on the name of the directive, certain additional syntactical
or semantical restrictions may be placed on the directive
(e.g. placement of the directive in the module may be restricted to the
top of the module).

In the directive\_statement, `directive` is a new keyword. According to
\[1\]\_, this keyword is initially considered as a keyword only when
used in a directive statement, see "Backwards Compatibility" below.

Semantics
=========

A directive statement instructs the Python interpreter to process a
source file in a different way; the specific details of that processing
depend on the directive name. The optional atom is typically interpreted
when the source code is processed; details of that interpretation depend
on the directive.

Specific Directives: transitional
=================================

If a syntactical or semantical change is added to Python which is
incompatible, \[1\]\_ mandates a transitional evolution of the language,
where the new feature is initially available alongside with the old one.
Such a transition is possible by means of the transitional directive.

In a transitional directive, the `NAME` is 'transitional'. The atom MUST
be present, and it MUST be a `NAME`. The possible values for that name
are defined when the language change is defined. One example for such a
directive is::

directive transitional nested\_scopes

The transitional directive MUST occur at before any other statement in a
module, except for the documentation string (i.e. it may appear as the
second statement of a module only if the first statement is a
`STRING+`).

Backwards Compatibility
=======================

Introducing `directive` as a new keyword might cause incompatibilities
with existing code. Following the guideline in \[1\]\_, in the initial
implementation of this specification, directive is a new keyword only if
it was used in a valid directive\_statement (i.e. if it appeared as the
first non-string token in a module).

Unresolved Problems: directive as the first identifier
======================================================

Using directive in a module as::

    directive = 1

(i.e. the name directive appears as the first thing in a module) will
treat it as keyword, not as identifier. It would be possible to classify
it as a `NAME` with an additional look-ahead token, but such look-ahead
is not available in the Python tokenizer.

Questions and Answers
=====================

**Q:** It looks like this PEP was written to allow definition of source
code character sets. Is that true?

**A:** No. Even though the directive facility can be extended to allow
source code encodings, no specific directive is proposed.

**Q:** Then why was this PEP written at all?

**A:** It acts as a counter-proposal to \[3\]\_, which proposes to
overload the import statement with a new meaning. This PEP allows to
solve the problem in a more general way.

**Q:** But isn't mixing source encodings and language changes like
mixing apples and oranges?

**A:** Perhaps. To address the difference, the predefined "transitional"
directive has been defined.

References and Footnotes
========================

.. \[1\] PEP 5, Guidelines for Language Evolution, Prescod
http://www.python.org/dev/peps/pep-0005/

.. \[2\] PEP 227, Statically Nested Scopes, Hylton
http://www.python.org/dev/peps/pep-0227/

.. \[3\] PEP 236, Back to the `__future__`, Peters
http://www.python.org/dev/peps/pep-0236/

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
