PEP: 240 Title: Adding a Rational Literal to Python Version: $Revision$
Last-Modified: $Date$ Author: Christopher A. Craig
<python-pep@ccraig.org>, Moshe Zadka <moshez@zadka.site.co.il> Status:
Rejected Type: Standards Track Content-Type: text/x-rst Created:
11-Mar-2001 Python-Version: 2.2 Post-History: 16-Mar-2001

Abstract
========

A different PEP \[1\]\_ suggests adding a builtin rational type to
Python. This PEP suggests changing the ddd.ddd float literal to a
rational in Python, and modifying non-integer division to return it.

BDFL Pronouncement
==================

This PEP is rejected. The needs outlined in the rationale section have
been addressed to some extent by the acceptance of PEP 327 for decimal
arithmetic. Guido also noted, "Rational arithmetic was the default
'exact' arithmetic in ABC and it did not work out as expected". See the
python-dev discussion on 17 June 2005 \[2\]\_.

Rationale
=========

Rational numbers are useful for exact and unsurprising arithmetic. They
give the correct results people have been taught in various math
classes. Making the "obvious" non-integer type one with more predictable
semantics will surprise new programmers less than using floating point
numbers. As quite a few posts on c.l.py and on tutor\@python.org have
shown, people often get bit by strange semantics of floating point
numbers: for example, `round(0.98, 2)` still gives 0.97999999999999998.

Proposal
========

Literals conforming to the regular expression `'\d*.\d*'` will be
rational numbers.

Backwards Compatibility
=======================

The only backwards compatible issue is the type of literals mentioned
above. The following migration is suggested:

1.  The next Python after approval will allow
    `from __future__ import rational_literals` to cause all such
    literals to be treated as rational numbers.

2.  Python 3.0 will have a warning, turned on by default, about such
    literals in the absence of a `__future__` statement. The warning
    message will contain information about the `__future__` statement,
    and indicate that to get floating point literals, they should be
    suffixed with "e0".

3.  Python 3.1 will have the warning turned off by default. This warning
    will stay in place for 24 months, at which time the literals will be
    rationals and the warning will be removed.

Common Objections
=================

Rationals are slow and memory intensive! (Relax, I'm not taking floats
away, I'm just adding two more characters. `1e0` will still be a float)

Rationals must present themselves as a decimal float or they will be
horrible for users expecting decimals (i.e. `str(.5)` should return
`'.5'` and not `'1/2'`). This means that many rationals must be
truncated at some point, which gives us a new loss of precision.

References
==========

.. \[1\] PEP 239, Adding a Rational Type to Python, Zadka,
http://www.python.org/dev/peps/pep-0239/ .. \[2\] Raymond Hettinger,
Propose rejection of PEPs 239 and 240 -- a builtin rational type and
rational literals
https://mail.python.org/pipermail/python-dev/2005-June/054281.html

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
