# gmx_ffconv
A semi-automated force field converter for GROMACS  

Usage:

usage: gmx_ffconv ffmap [-h] -itp1 ITP1 -itp2 ITP2 -name NAME [--duplicate]  
                        [--all_mappings] [--validate]  

optional arguments:
  -h, --help      show this help message and exit  
  -itp1 ITP1      First ITP file (path), corresponding to force field used in
                  .gro file  
  -itp2 ITP2      Second ITP file (path)  
  -name NAME      Name of the molecule, does not need to match itp files  
  --duplicate     Skip graph matching, create a mapping where everything is  
                  kept in same order. Useful for proteins, solvent,ions  
  --all_mappings  Obtain all mappings, not recommended  
  --validate      Carry out conversion in both directions  


usage: gmx_ffconv groconv [-h] -name NAME [NAME ...] -nmol NMOL [NMOL ...]  
                          -coordfile COORDFILE [-mapping_dir MAPPING_DIR]  
                          -output OUTPUT [--validate]  

optional arguments:  
  -h, --help            show this help message and exit  
  -name NAME [NAME ...]
                        Molecule names separated by spaces  
  -nmol NMOL [NMOL ...]
                        Molecule counts separated by spaces  
  -coordfile COORDFILE  Input .gro file  
  -mapping_dir MAPPING_DIR
                        Directory containing mapping CSV files  
  -output OUTPUT        Output .gro file name  
  --validate            Generate back-converted structure  


# Installation instructions:

The easiest way to install gmx_ffconv is to clone the github, cd in gmx_ffconv and running pip install .
Note, it is considered good practice to perform this in a virtual environment.

Possible issues:

If the installation contains a message about installing an UNKNOWN package, please update your pip version. 

# *Example:*

The files are provided in “Tutorial” in folder Example1 

Example 1: Small membrane 
 
A membrane containing 24 DOPE,24 DPPC,24 CHL, 6 K+, 6 Cl- and 2709 TIP3P molecules was generated by CHARMM-GUI’s Membrane builder using CHARMM36m. The target force field is AMBER (Lipid21) . The water model is kept as TIP3, and the ions are standard for the water model.  

First, mappings for each molecule must be found. These commands can be run at the same time by the use of &. 

DPPC

gmx_ffconv ffmap -itp1 toppar_CHARMM/DPPC.itp -itp2 toppar_AMBER/PPPC.itp -name DPPC

Cholesterol

gmx_ffconv ffmap -itp1 toppar_CHARMM/CHL1.itp -itp2 toppar_AMBER/CHL.itp -name CHL

DOPE

gmx_ffconv ffmap -itp1 toppar_CHARMM/DOPE.itp -itp2 toppar_AMBER/OOPE.itp -name DOPE

TIP3

gmx_ffconv ffmap -itp1 toppar_CHARMM/TIP3.itp -itp2 None -name TIP3P --duplicate

Potassium 

gmx_ffconv ffmap -itp1 toppar_CHARMM/POT.itp -itp2 None -name POT --duplicate

Chloride

gmx_ffconv ffmap -itp1 toppar_CHARMM/CLA.itp -itp2 None -name CLA --duplicate


These should have generated multiple mapping files, a mapping file per molecule type named mapping_{NAME}.csv.

Now, that all mappings are obtained, the new coordinate file can be obtained via groconv

gmx_ffconv groconv -coordfile CHARMM_MEMB.gro -name DOPE DPPC CHL POT CLA TIP3P -nmol 24 24 24 6 6 2709 -output AMBER_MEMB_from_CHARMM.gro

We can now compare the AMBER_MEMB_from_CHARMM.gro to AMBER_MEMB_FF.gro, which will match in energy values if the conversion has been successful. This file is provided in the AMBER_REF folder with the necessary files.

If you find my tool useful, please cite:
