from setuptools import setup, find_packages

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    dependency_links=[],
    name="vimms",
    version="2.0.1",
    author="Joe Wandy, Vinny Davies, Justin J.J. van der Hooft, Stefan Weidt, Ronan Daly, Simon Rogers",
    author_email="joe.wandy@glasgow.ac.uk",
    description="ViMMS is an LC-MS/MS simulator.",
    long_description="ViMMS is a modular LC-MS/MS simulator framework for metabolomics that allows for real-time scan-level control of the MS2 acquisition process in-silico. ViMMS allows users to simulate and test different fragmentation strategies and obtain fragmentation files in .mzML format as output from the simulation (the entire state of the simulator can also be saved for inspection later).",
    long_description_content_type="text/markdown",
    url="https://github.com/sdrogers/vimms",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.6",
    packages=find_packages(),
    install_requires=[
        "anyio==3.3.0; python_full_version >= '3.6.2'",
        "appdirs==1.4.4",
        "argon2-cffi==20.1.0",
        "async-generator==1.10; python_full_version >= '3.5.0'",
        "atomicwrites==1.4.0; sys_platform == 'win32'",
        "attrs==21.2.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "babel==2.9.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "backcall==0.2.0",
        "black==19.10b0; python_version >= '3.6'",
        "bleach==4.0.0; python_version >= '3.6'",
        "cached-property==1.5.2",
        "cerberus==1.3.4",
        "certifi==2021.5.30",
        "cffi==1.14.6",
        "charset-normalizer==2.0.4; python_version >= '3'",
        "click==8.0.1; python_version >= '3.6'",
        "colorama==0.4.4; sys_platform == 'win32' and platform_system == 'Windows' and sys_platform == 'win32' and sys_platform == 'win32' and platform_system == 'Windows'",
        "cycler==0.10.0",
        "cython==0.29.24; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2'",
        "debugpy==1.4.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "decorator==5.0.9; python_full_version >= '3.5.0'",
        "defusedxml==0.7.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "distlib==0.3.2",
        "entrypoints==0.3; python_version >= '2.7'",
        "events==0.4",
        "flake8==3.9.2",
        "gpy==1.10.0",
        "greenlet==1.1.1; python_version >= '3'",
        "idna==3.2; python_version >= '3'",
        "importlib-metadata==3.10.1; python_version < '3.8' and python_version < '3.8'",
        "iniconfig==1.1.1",
        "intervaltree==3.1.0",
        "ipykernel==6.0.3; python_version >= '3.7'",
        "ipyparallel==6.3.0",
        "ipython==7.26.0; python_version >= '3.7'",
        "ipython-genutils==0.2.0",
        "jedi==0.18.0; python_version >= '3.6'",
        "jinja2==3.0.1; python_version >= '3.6'",
        "joblib==1.0.1",
        "json5==0.9.6",
        "jsonpickle==2.0.0",
        "jsonschema==3.2.0",
        "jupyter-client==6.1.12; python_full_version >= '3.5.0'",
        "jupyter-core==4.7.1; python_version >= '3.6'",
        "jupyter-server==1.10.2; python_version >= '3.6'",
        "jupyterlab==3.1.4",
        "jupyterlab-pygments==0.1.2",
        "jupyterlab-server==2.6.2; python_version >= '3.6'",
        "kiwisolver==1.3.1; python_version >= '3.6'",
        "loguru==0.5.3",
        "lxml==4.6.3; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "markupsafe==2.0.1; python_version >= '3.6'",
        "mass-spec-utils==0.0.12",
        "matplotlib==3.4.2",
        "matplotlib-inline==0.1.2; python_full_version >= '3.5.0'",
        "mccabe==0.6.1",
        "mistune==0.8.4",
        "molmass==2021.6.18; python_version >= '3.7'",
        "nbclassic==0.3.1; python_version >= '3.6'",
        "nbclient==0.5.3; python_full_version >= '3.6.1'",
        "nbconvert==6.1.0; python_version >= '3.7'",
        "nbformat==5.1.3; python_full_version >= '3.5.0'",
        "nest-asyncio==1.5.1; python_full_version >= '3.5.0'",
        "networkx==2.6.2",
        "notebook==6.4.3; python_version >= '3.6'",
        "numpy==1.21.1",
        "orderedmultidict==1.0.1",
        "packaging==20.9; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pandas==1.3.1",
        "pandocfilters==1.4.3",
        "paramz==0.9.5",
        "parso==0.8.2; python_version >= '3.6'",
        "pathspec==0.9.0",
        "patsy==0.5.1",
        "pbr==5.6.0; python_version >= '2.6'",
        "pep517==0.11.0",
        "pickleshare==0.7.5",
        "pillow==8.3.1; python_version >= '3.6'",
        "pip-shims==0.5.3; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "pipenv-setup==3.1.1",
        "pipfile==0.0.2",
        "plette[validation]==0.2.3; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pluggy==0.13.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "prometheus-client==0.11.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "prompt-toolkit==3.0.19; python_full_version >= '3.6.1'",
        "psims==0.1.43",
        "py==1.10.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pycodestyle==2.7.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pycparser==2.20; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pyflakes==2.3.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pygments==2.9.0; python_full_version >= '3.5.0'",
        "pymzml==2.4.7",
        "pyparsing==2.4.7; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2'",
        "pyrsistent==0.18.0; python_version >= '3.6'",
        "pysmiles==1.0.1",
        "pytest==6.2.4",
        "python-dateutil==2.8.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "pytz==2021.1",
        "pywin32==301; sys_platform == 'win32'",
        "pywinpty==1.1.3",
        "pyzmq==22.2.1; python_version >= '3.6'",
        "regex==2021.8.3",
        "requests==2.26.0",
        "requests-unixsocket==0.2.0",
        "requirementslib==1.5.16; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "scikit-learn==0.24.2",
        "scipy==1.7.1",
        "seaborn==0.11.1",
        "send2trash==1.8.0",
        "six==1.16.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "sniffio==1.2.0; python_full_version >= '3.5.0'",
        "sortedcontainers==2.4.0",
        "sqlalchemy==1.4.22; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4, 3.5'",
        "statsmodels==0.12.2",
        "tabulate==0.8.9",
        "terminado==0.10.1; python_version >= '3.6'",
        "testpath==0.5.0; python_full_version >= '3.5.0'",
        "threadpoolctl==2.2.0; python_version >= '3.6'",
        "toml==0.10.2; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2'",
        "tomli==1.2.1; python_version >= '3.6'",
        "tomlkit==0.7.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "tornado==6.1; python_full_version >= '3.5.0'",
        "tqdm==4.62.0",
        "traitlets==5.0.5; python_version >= '3.7'",
        "typed-ast==1.4.3",
        "typing-extensions==3.10.0.0; python_version < '3.8' and python_version < '3.8'",
        "urllib3==1.26.6; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
        "vistir==0.5.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "wcwidth==0.2.5",
        "webencodings==0.5.1",
        "websocket-client==1.2.0; python_version >= '3.6'",
        "wheel==0.37.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "win32-setctime==1.0.3; sys_platform == 'win32'",
        "zipp==3.5.0; python_version < '3.8'",
    ],
)
