/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ColumnMap;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.ParserOutput;

public class DefaultContext
implements Context {
    protected boolean stopped = false;
    final ParserOutput output;
    final ColumnMap columnMap;
    final int errorContentLength;

    public DefaultContext(int errorContentLength) {
        this(null, errorContentLength);
    }

    public DefaultContext(ParserOutput output, int errorContentLength) {
        this.output = output;
        this.errorContentLength = errorContentLength;
        this.columnMap = new ColumnMap(this, output);
    }

    @Override
    public String[] headers() {
        if (this.output == null) {
            return ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        return this.output.getHeaders();
    }

    @Override
    public String[] selectedHeaders() {
        int[] extractedFieldIndexes = this.extractedFieldIndexes();
        if (extractedFieldIndexes != null) {
            String[] extractedFields = new String[extractedFieldIndexes.length];
            String[] headers = this.headers();
            for (int i2 = 0; i2 < extractedFieldIndexes.length; ++i2) {
                extractedFields[i2] = headers[extractedFieldIndexes[i2]];
            }
            return extractedFields;
        }
        return this.headers();
    }

    @Override
    public int[] extractedFieldIndexes() {
        if (this.output == null) {
            return null;
        }
        return this.output.getSelectedIndexes();
    }

    @Override
    public boolean columnsReordered() {
        if (this.output == null) {
            return false;
        }
        return this.output.isColumnReorderingEnabled();
    }

    @Override
    public int indexOf(String header) {
        return this.columnMap.indexOf(header);
    }

    @Override
    public int indexOf(Enum<?> header) {
        return this.columnMap.indexOf(header);
    }

    void reset() {
        if (this.output != null) {
            this.output.reset();
        }
        this.columnMap.reset();
    }

    @Override
    public int currentColumn() {
        if (this.output == null) {
            return -1;
        }
        return this.output.getCurrentColumn();
    }

    @Override
    public long currentRecord() {
        if (this.output == null) {
            return -1L;
        }
        return this.output.getCurrentRecord();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public int errorContentLength() {
        return this.errorContentLength;
    }
}

