/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import greenlab.org.ebugslocator.utils.Reporter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberIgnoringMethodDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Class<? extends Detector> DETECTOR_CLASS = MemberIgnoringMethodDetector.class;
    private static final EnumSet<Scope> DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
    private static final Implementation IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
    private static final String ISSUE_ID = "MemberIgnoringMethod";
    private static final String ISSUE_DESCRIPTION = "non-static method that can be made static";
    private static final String ISSUE_EXPLANATION = "Methods that do not have a static modifier, yet never access a field or a non-static method, can be converted to static.";
    private static final Category ISSUE_CATEGORY = Category.PERFORMANCE;
    private static final int ISSUE_PRIORITY = 5;
    private static final Severity ISSUE_SEVERITY = Severity.WARNING;
    public static final Issue ISSUE = Issue.create((String)"MemberIgnoringMethod", (String)"non-static method that can be made static", (String)"Methods that do not have a static modifier, yet never access a field or a non-static method, can be converted to static.", (Category)ISSUE_CATEGORY, (int)5, (Severity)ISSUE_SEVERITY, (Implementation)IMPLEMENTATION);
    private static Map<String, Boolean> fields;
    private static Map<String, Set<String>> methods;
    private static Map<String, Boolean> methodsStatus;

    public MemberIgnoringMethodDetector() {
        fields = new HashMap<String, Boolean>();
        methods = new HashMap<String, Set<String>>();
        methodsStatus = new HashMap<String, Boolean>();
    }

    public static String getMethodQualifiedName(PsiMethod method) {
        PsiClass parent = method.getContainingClass();
        if (parent != null) {
            return parent.getQualifiedName() + "." + method.getName();
        }
        return null;
    }

    private static void isMIM(String methodName) {
        methodsStatus.put(methodName, true);
    }

    private static void notMIM(String methodName) {
        methodsStatus.put(methodName, false);
    }

    private static boolean isField(String qualifiedName) {
        if (fields.containsKey(qualifiedName)) {
            return fields.get(qualifiedName);
        }
        return false;
    }

    private void classifyMIM(String methodName) {
        if (methodsStatus.containsKey(methodName)) {
            return;
        }
        if (!methods.containsKey(methodName)) {
            MemberIgnoringMethodDetector.notMIM(methodName);
            return;
        }
        for (String depend : methods.get(methodName)) {
            if (MemberIgnoringMethodDetector.isField(depend)) {
                MemberIgnoringMethodDetector.notMIM(methodName);
                return;
            }
            this.classifyMIM(depend);
            if (!methodsStatus.containsKey(depend) || methodsStatus.get(depend).booleanValue()) continue;
            MemberIgnoringMethodDetector.notMIM(methodName);
            return;
        }
        MemberIgnoringMethodDetector.isMIM(methodName);
    }

    private void checkDependencies() {
        for (String method : methods.keySet()) {
            this.classifyMIM(method);
        }
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiField.class, PsiReferenceExpression.class, PsiThisExpression.class, PsiMethod.class);
    }

    public void afterCheckProject(Context context) {
        if (context.getDriver().getPhase() < 2) {
            this.checkDependencies();
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        }
        super.afterCheckProject(context);
    }

    public void debug() {
        System.out.println("\t << FIELDS >>");
        for (String f : fields.keySet()) {
            System.out.println("\t\t>> " + f + " [" + fields.get(f) + "]");
        }
        System.out.println("\t ** METHODS **");
        for (String m : methods.keySet()) {
            System.out.print("\t\t** " + m + " => [ ");
            for (String d : methods.get(m)) {
                System.out.print(d + ", ");
            }
            System.out.println(" ]");
        }
        System.out.println("\t ## STATUS ##");
        for (String s : methodsStatus.keySet()) {
            System.out.println("\t\t## " + s + " [" + methodsStatus.get(s) + "]");
        }
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            return new MemberIgnoringChecker(context);
        }
        return new MethodChecker(context);
    }

    private static class MethodChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public MethodChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitMethod(PsiMethod method) {
            PsiMethod[] supers;
            boolean ignorable;
            PsiModifierList modifiers = method.getModifierList();
            PsiAnnotation override = modifiers.findAnnotation("java.lang.Override");
            boolean isInterface = method.getContainingClass() != null && method.getContainingClass().isInterface();
            boolean emptyBody = method.getBody() == null || method.getBody().getStatements() == null || method.getBody().getStatements().length == 0;
            boolean bl = ignorable = method.isConstructor() || modifiers.hasModifierProperty("static") || override != null || isInterface || method.getContainingClass() instanceof PsiAnonymousClass || emptyBody;
            if (ignorable) {
                super.visitMethod(method);
                return;
            }
            for (PsiMethod s : supers = method.findSuperMethods()) {
                if (s == null) continue;
                ignorable = true;
                break;
            }
            if (ignorable) {
                super.visitMethod(method);
                return;
            }
            String methodName = MemberIgnoringMethodDetector.getMethodQualifiedName(method);
            if (!methodsStatus.containsKey(methodName) || ((Boolean)methodsStatus.get(methodName)).booleanValue()) {
                Reporter.reportIssue(this.mContext, ISSUE, method);
            }
            super.visitMethod(method);
        }
    }

    private static class MemberIgnoringChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public MemberIgnoringChecker(JavaContext context) {
            this.mContext = context;
        }

        private void addField(PsiField field, PsiClass containingClass, boolean isNonStatic) {
            String fullName = containingClass.getQualifiedName() + "." + field.getName();
            fields.put(fullName, isNonStatic);
        }

        private void addDependency(PsiMethod parentMethod, String reference) {
            String methodName = MemberIgnoringMethodDetector.getMethodQualifiedName(parentMethod);
            if (!methodName.equals(reference)) {
                if (methods.containsKey(methodName)) {
                    ((Set)methods.get(methodName)).add(reference);
                } else {
                    HashSet<String> refs = new HashSet<String>();
                    refs.add(reference);
                    methods.put(methodName, refs);
                }
            }
        }

        private PsiMethod getParentMethod(PsiElement node) {
            if (node == null) {
                return null;
            }
            PsiElement parent = node.getParent();
            if (parent == null) {
                return null;
            }
            if (parent instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
            return this.getParentMethod(parent);
        }

        public void visitField(PsiField field) {
            PsiModifierList modifiers = field.getModifierList();
            boolean isNonStatic = modifiers != null && !modifiers.hasModifierProperty("static");
            this.addField(field, field.getContainingClass(), isNonStatic);
            super.visitField(field);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiMethod parent = this.getParentMethod((PsiElement)expression);
            if (parent != null) {
                PsiElement elem = expression.getOriginalElement();
                if (elem != null) {
                    String qualifiedName = expression.getQualifiedName();
                    String originalText = elem.getText().replace("this.", "");
                    if (!originalText.contains(".") && qualifiedName.contains(".")) {
                        this.addDependency(parent, qualifiedName);
                    }
                } else {
                    MemberIgnoringMethodDetector.notMIM(MemberIgnoringMethodDetector.getMethodQualifiedName(parent));
                }
            }
            super.visitReferenceExpression(expression);
        }

        public void visitMethod(PsiMethod method) {
            boolean ignorable;
            String qualifiedName = MemberIgnoringMethodDetector.getMethodQualifiedName(method);
            PsiModifierList modifiers = method.getModifierList();
            PsiAnnotation override = modifiers.findAnnotation("java.lang.Override");
            boolean isInterface = method.getContainingClass() != null && method.getContainingClass().isInterface();
            boolean emptyBody = method.getBody() == null || method.getBody().getStatements() == null || method.getBody().getStatements().length == 0;
            boolean bl = ignorable = method.isConstructor() || isInterface || method.getContainingClass() instanceof PsiAnonymousClass;
            if (ignorable) {
                return;
            }
            if (!methods.containsKey(qualifiedName)) {
                methods.put(qualifiedName, new HashSet());
            }
            boolean cannotBeMIM = override != null || emptyBody || method.getContainingClass().getModifierList().hasModifierProperty("abstract");
            PsiMethod[] supers = method.findSuperMethods();
            if (modifiers.hasModifierProperty("static")) {
                MemberIgnoringMethodDetector.isMIM(qualifiedName);
            } else if (cannotBeMIM) {
                MemberIgnoringMethodDetector.notMIM(qualifiedName);
            } else if (supers != null && supers.length > 0) {
                MemberIgnoringMethodDetector.notMIM(qualifiedName);
                for (PsiMethod s : supers) {
                    if (s == null) continue;
                    String superMethod = MemberIgnoringMethodDetector.getMethodQualifiedName(s);
                    if (!methods.containsKey(superMethod)) {
                        methods.put(superMethod, new HashSet());
                    }
                    this.addDependency(method, superMethod);
                    MemberIgnoringMethodDetector.notMIM(superMethod);
                }
            }
        }

        public void visitThisExpression(PsiThisExpression expression) {
            PsiMethod parent = this.getParentMethod((PsiElement)expression);
            if (parent != null) {
                MemberIgnoringMethodDetector.notMIM(MemberIgnoringMethodDetector.getMethodQualifiedName(parent));
            }
            super.visitThisExpression(expression);
        }
    }
}

