/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.coroutines.EventLoopBase;
import org.jetbrains.kotlin.kotlinx.coroutines.TimeSourceKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/ThreadEventLoop;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/EventLoopBase;", "thread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "isCorrectThread", "", "shutdown", "", "unpark", "kotlinx-coroutines-core"})
public abstract class ThreadEventLoop
extends EventLoopBase {
    private final Thread thread;

    @Override
    protected boolean isCorrectThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    protected void unpark() {
        if (Thread.currentThread() != this.thread) {
            TimeSourceKt.getTimeSource().unpark(this.thread);
        }
    }

    public final void shutdown() {
        this.closeQueue();
        boolean bl = this.isCorrectThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        while (this.processNextEvent() <= 0L) {
        }
        this.rescheduleAllDelayed();
    }

    public ThreadEventLoop(@NotNull Thread thread2) {
        Intrinsics.checkParameterIsNotNull(thread2, "thread");
        this.thread = thread2;
    }
}

